{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Unions.VarNumT
    ( 

-- * Exported types
    VarNumT(..)                             ,
    newZeroVarNumT                          ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveVarNumTMethod                    ,
#endif



 -- * Properties


-- ** f #attr:f#
-- | /No description available in the introspection data./

    getVarNumTF                             ,
    setVarNumTF                             ,
#if defined(ENABLE_OVERLOADING)
    varNumT_f                               ,
#endif


-- ** i32 #attr:i32#
-- | /No description available in the introspection data./

    getVarNumTI32                           ,
    setVarNumTI32                           ,
#if defined(ENABLE_OVERLOADING)
    varNumT_i32                             ,
#endif


-- ** u32 #attr:u32#
-- | /No description available in the introspection data./

    getVarNumTU32                           ,
    setVarNumTU32                           ,
#if defined(ENABLE_OVERLOADING)
    varNumT_u32                             ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype VarNumT = VarNumT (SP.ManagedPtr VarNumT)
    deriving (Eq)

instance SP.ManagedPtrNewtype VarNumT where
    toManagedPtr (VarNumT p) = p

instance BoxedPtr VarNumT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 4 >=> B.ManagedPtr.wrapPtr VarNumT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr VarNumT where
    boxedPtrCalloc = callocBytes 4


-- | Construct a t'VarNumT' struct initialized to zero.
newZeroVarNumT :: MonadIO m => m VarNumT
newZeroVarNumT = liftIO $ boxedPtrCalloc >>= wrapPtr VarNumT

instance tag ~ 'AttrSet => Constructible VarNumT tag where
    new _ attrs = do
        o <- newZeroVarNumT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@f@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' varNumT #f
-- @
getVarNumTF :: MonadIO m => VarNumT -> m Float
getVarNumTF s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@f@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' varNumT [ #f 'Data.GI.Base.Attributes.:=' value ]
-- @
setVarNumTF :: MonadIO m => VarNumT -> Float -> m ()
setVarNumTF s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data VarNumTFFieldInfo
instance AttrInfo VarNumTFFieldInfo where
    type AttrBaseTypeConstraint VarNumTFFieldInfo = (~) VarNumT
    type AttrAllowedOps VarNumTFFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint VarNumTFFieldInfo = (~) Float
    type AttrTransferTypeConstraint VarNumTFFieldInfo = (~)Float
    type AttrTransferType VarNumTFFieldInfo = Float
    type AttrGetType VarNumTFFieldInfo = Float
    type AttrLabel VarNumTFFieldInfo = "f"
    type AttrOrigin VarNumTFFieldInfo = VarNumT
    attrGet = getVarNumTF
    attrSet = setVarNumTF
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Unions.VarNumT.f"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Unions-VarNumT.html#g:attr:f"
        })

varNumT_f :: AttrLabelProxy "f"
varNumT_f = AttrLabelProxy

#endif


-- | Get the value of the “@u32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' varNumT #u32
-- @
getVarNumTU32 :: MonadIO m => VarNumT -> m Word32
getVarNumTU32 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@u32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' varNumT [ #u32 'Data.GI.Base.Attributes.:=' value ]
-- @
setVarNumTU32 :: MonadIO m => VarNumT -> Word32 -> m ()
setVarNumTU32 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data VarNumTU32FieldInfo
instance AttrInfo VarNumTU32FieldInfo where
    type AttrBaseTypeConstraint VarNumTU32FieldInfo = (~) VarNumT
    type AttrAllowedOps VarNumTU32FieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint VarNumTU32FieldInfo = (~) Word32
    type AttrTransferTypeConstraint VarNumTU32FieldInfo = (~)Word32
    type AttrTransferType VarNumTU32FieldInfo = Word32
    type AttrGetType VarNumTU32FieldInfo = Word32
    type AttrLabel VarNumTU32FieldInfo = "u32"
    type AttrOrigin VarNumTU32FieldInfo = VarNumT
    attrGet = getVarNumTU32
    attrSet = setVarNumTU32
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Unions.VarNumT.u32"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Unions-VarNumT.html#g:attr:u32"
        })

varNumT_u32 :: AttrLabelProxy "u32"
varNumT_u32 = AttrLabelProxy

#endif


-- | Get the value of the “@i32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' varNumT #i32
-- @
getVarNumTI32 :: MonadIO m => VarNumT -> m Int32
getVarNumTI32 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@i32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' varNumT [ #i32 'Data.GI.Base.Attributes.:=' value ]
-- @
setVarNumTI32 :: MonadIO m => VarNumT -> Int32 -> m ()
setVarNumTI32 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data VarNumTI32FieldInfo
instance AttrInfo VarNumTI32FieldInfo where
    type AttrBaseTypeConstraint VarNumTI32FieldInfo = (~) VarNumT
    type AttrAllowedOps VarNumTI32FieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint VarNumTI32FieldInfo = (~) Int32
    type AttrTransferTypeConstraint VarNumTI32FieldInfo = (~)Int32
    type AttrTransferType VarNumTI32FieldInfo = Int32
    type AttrGetType VarNumTI32FieldInfo = Int32
    type AttrLabel VarNumTI32FieldInfo = "i32"
    type AttrOrigin VarNumTI32FieldInfo = VarNumT
    attrGet = getVarNumTI32
    attrSet = setVarNumTI32
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Unions.VarNumT.i32"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Unions-VarNumT.html#g:attr:i32"
        })

varNumT_i32 :: AttrLabelProxy "i32"
varNumT_i32 = AttrLabelProxy

#endif


-- XXX Skipped attribute for "VarNumT:u16"
-- Not implemented: Don't know how to unpack C array of type TCArray False 2 (-1) (TBasicType TUInt16)
-- XXX Skipped attribute for "VarNumT:i16"
-- Not implemented: Don't know how to unpack C array of type TCArray False 2 (-1) (TBasicType TInt16)
-- XXX Skipped attribute for "VarNumT:u8"
-- Not implemented: Don't know how to unpack C array of type TCArray False 4 (-1) (TBasicType TUInt8)
-- XXX Skipped attribute for "VarNumT:i8"
-- Not implemented: Don't know how to unpack C array of type TCArray False 4 (-1) (TBasicType TInt8)

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList VarNumT
type instance O.AttributeList VarNumT = VarNumTAttributeList
type VarNumTAttributeList = ('[ '("f", VarNumTFFieldInfo), '("u32", VarNumTU32FieldInfo), '("i32", VarNumTI32FieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveVarNumTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVarNumTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVarNumTMethod t VarNumT, O.OverloadedMethod info VarNumT p) => OL.IsLabel t (VarNumT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVarNumTMethod t VarNumT, O.OverloadedMethod info VarNumT p, R.HasField t VarNumT p) => R.HasField t VarNumT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVarNumTMethod t VarNumT, O.OverloadedMethodInfo info VarNumT) => OL.IsLabel t (O.MethodProxy info VarNumT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


