/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g
 *     -                            On : 2023-09-01 16:54:52
 *     -                for the parser : Smt2ParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2016 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "Smt2Parser.h"


#include <set>
#include <sstream>
#include <string>
#include <unordered_set>
#include <vector>

#include "api/cvc4cpp.h"
#include "base/output.h"
#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "options/set_language.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"
#include "parser/smt2/smt2.h"
#include "util/floatingpoint.h"
#include "util/hash.h"
#include "util/integer.h"
#include "util/rational.h"
// \todo Review the need for this header
#include "math.h"

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which
 * will be defined by ANTLR *after* this section. (If they were functions,
 * PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Smt2*)PARSER->super)
#undef SOLVER
#define SOLVER PARSER_STATE->getSolver()
#undef MK_TERM
#define MK_TERM SOLVER->mkTerm
#define UNSUPPORTED PARSER_STATE->unimplementedFeature


/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pSmt2Parser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pSmt2Parser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pSmt2Parser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pSmt2Parser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   Smt2ParserTokenNames[103+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "AS_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_INST_LEVEL",
        (pANTLR3_UINT8) "ATTRIBUTE_NAMED_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_NO_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_TOK",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BLOCK_MODEL_TOK",
        (pANTLR3_UINT8) "BLOCK_MODEL_VALUES_TOK",
        (pANTLR3_UINT8) "CHAR_TOK",
        (pANTLR3_UINT8) "CHECK_SAT_ASSUMING_TOK",
        (pANTLR3_UINT8) "CHECK_SAT_TOK",
        (pANTLR3_UINT8) "CHECK_SYNTH_TOK",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "COMPREHENSION_TOK",
        (pANTLR3_UINT8) "CONSTRAINT_TOK",
        (pANTLR3_UINT8) "CONST_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DECLARE_CODATATYPES_2_5_TOK",
        (pANTLR3_UINT8) "DECLARE_CODATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_CODATATYPE_TOK",
        (pANTLR3_UINT8) "DECLARE_CONST_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPES_2_5_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPE_TOK",
        (pANTLR3_UINT8) "DECLARE_FUNS_TOK",
        (pANTLR3_UINT8) "DECLARE_FUN_TOK",
        (pANTLR3_UINT8) "DECLARE_HEAP",
        (pANTLR3_UINT8) "DECLARE_PREDS_TOK",
        (pANTLR3_UINT8) "DECLARE_PRIMED_VAR_TOK",
        (pANTLR3_UINT8) "DECLARE_SORTS_TOK",
        (pANTLR3_UINT8) "DECLARE_SORT_TOK",
        (pANTLR3_UINT8) "DECLARE_VAR_TOK",
        (pANTLR3_UINT8) "DEFINE_CONST_TOK",
        (pANTLR3_UINT8) "DEFINE_FUNS_REC_TOK",
        (pANTLR3_UINT8) "DEFINE_FUN_REC_TOK",
        (pANTLR3_UINT8) "DEFINE_FUN_TOK",
        (pANTLR3_UINT8) "DEFINE_SORT_TOK",
        (pANTLR3_UINT8) "DEFINE_TOK",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "EMP_TOK",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "GET_ABDUCT_TOK",
        (pANTLR3_UINT8) "GET_ASSERTIONS_TOK",
        (pANTLR3_UINT8) "GET_ASSIGNMENT_TOK",
        (pANTLR3_UINT8) "GET_INFO_TOK",
        (pANTLR3_UINT8) "GET_MODEL_TOK",
        (pANTLR3_UINT8) "GET_OPTION_TOK",
        (pANTLR3_UINT8) "GET_PROOF_TOK",
        (pANTLR3_UINT8) "GET_QE_DISJUNCT_TOK",
        (pANTLR3_UINT8) "GET_QE_TOK",
        (pANTLR3_UINT8) "GET_UNSAT_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "GET_UNSAT_CORE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "HO_ARROW_TOK",
        (pANTLR3_UINT8) "HO_LAMBDA_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INDEX_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INV_CONSTRAINT_TOK",
        (pANTLR3_UINT8) "KEYWORD",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN_TOK",
        (pANTLR3_UINT8) "MATCH_TOK",
        (pANTLR3_UINT8) "NUMERAL",
        (pANTLR3_UINT8) "PAR_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUOTED_SYMBOL",
        (pANTLR3_UINT8) "RESET_ASSERTIONS_TOK",
        (pANTLR3_UINT8) "RESET_TOK",
        (pANTLR3_UINT8) "RPAREN_TOK",
        (pANTLR3_UINT8) "SET_INFO_TOK",
        (pANTLR3_UINT8) "SET_LOGIC_TOK",
        (pANTLR3_UINT8) "SET_OPTIONS_TOK",
        (pANTLR3_UINT8) "SET_OPTION_TOK",
        (pANTLR3_UINT8) "SIMPLE_SYMBOL",
        (pANTLR3_UINT8) "SIMPLIFY_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL",
        (pANTLR3_UINT8) "SYGUS_CONSTANT_TOK",
        (pANTLR3_UINT8) "SYGUS_INPUT_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYGUS_LET_TOK",
        (pANTLR3_UINT8) "SYGUS_LOCAL_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYGUS_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYMBOL_CHAR",
        (pANTLR3_UINT8) "SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE",
        (pANTLR3_UINT8) "SYNTH_FUN_TOK",
        (pANTLR3_UINT8) "SYNTH_FUN_V1_TOK",
        (pANTLR3_UINT8) "SYNTH_INV_TOK",
        (pANTLR3_UINT8) "SYNTH_INV_V1_TOK",
        (pANTLR3_UINT8) "TESTER_TOK",
        (pANTLR3_UINT8) "TUPLE_CONST_TOK",
        (pANTLR3_UINT8) "TUPLE_SEL_TOK",
        (pANTLR3_UINT8) "UNTERMINATED_QUOTED_SYMBOL",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "'\\\\'"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::parser::smt2::myExpr
	parseExpr    (pSmt2Parser ctx);
static 
 CVC4::Command*
	parseCommand    (pSmt2Parser ctx);
static 
 CVC4::Command*
	parseSygus    (pSmt2Parser ctx);
static 
 void
	command    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 std::unique_ptr<CVC4::Command>
	sygusCommand    (pSmt2Parser ctx);
static 
 void
	sygusGrammarV1    (pSmt2Parser ctx, CVC4::api::Sort & ret, const std::vector<CVC4::api::Term>& sygus_vars, const std::string& fun);
static 
 void
	sygusGTerm    (pSmt2Parser ctx, CVC4::SygusGTerm& sgt, const std::string& fun);
static 
 void
	sygusGrammar    (pSmt2Parser ctx, CVC4::api::Sort & ret, const std::vector<CVC4::api::Term>& sygusVars, const std::string& fun);
static 
 void
	setInfoInternal    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	setOptionInternal    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	smt25Command    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	extendedCommand    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypes_2_5_DefCommand    (pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypeDefCommand    (pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypesDefCommand    (pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypesDef    (pSmt2Parser ctx, bool isCo, const std::vector<std::string>& dnames, const std::vector<int>& arities, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	simpleSymbolicExprNoKeyword    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	keyword    (pSmt2Parser ctx, std::string& s);
static 
 void
	simpleSymbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	term    (pSmt2Parser ctx, CVC4::api::Term& expr, CVC4::api::Term& expr2);
static 
 void
	termNonVariable    (pSmt2Parser ctx, CVC4::api::Term& expr, CVC4::api::Term& expr2);
static 
 void
	qualIdentifier    (pSmt2Parser ctx, CVC4::ParseOp& p);
static 
 void
	identifier    (pSmt2Parser ctx, CVC4::ParseOp& p);
static 
 void
	termAtomic    (pSmt2Parser ctx, CVC4::api::Term& atomTerm);
static 
 void
	attribute    (pSmt2Parser ctx, CVC4::api::Term& expr, CVC4::api::Term& retExpr, std::string& attr);
static 
 void
	termList    (pSmt2Parser ctx, std::vector<CVC4::api::Term>& formulas, CVC4::api::Term& expr);
static 
 void
	str    (pSmt2Parser ctx, std::string& s, bool fsmtlib);
static 
 void
	quantOp    (pSmt2Parser ctx, CVC4::api::Kind& kind);
static 
 void
	functionName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortList    (pSmt2Parser ctx, std::vector<CVC4::api::Sort>& sorts);
static 
 void
	nonemptySortList    (pSmt2Parser ctx, std::vector<CVC4::api::Sort>& sorts);
static 
 void
	sortedVarList    (pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::api::Sort> >& sortedVars);
static 
 void
	boundVarList    (pSmt2Parser ctx, CVC4::api::Term& expr);
static 
 void
	sortName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortSymbol    (pSmt2Parser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check);
static 
 void
	symbolList    (pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	symbol    (pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	nonemptyNumeralList    (pSmt2Parser ctx, std::vector<uint64_t>& numerals);
static 
 void
	datatypeDef    (pSmt2Parser ctx, bool isCo, std::vector<CVC4::api::DatatypeDecl>& datatypes, std::vector< CVC4::api::Sort >& params);
static 
 void
	constructorDef    (pSmt2Parser ctx, CVC4::api::DatatypeDecl& type);
static 
 void
	selector    (pSmt2Parser ctx, CVC4::api::DatatypeConstructorDecl& ctor);
static void	Smt2ParserFree(pSmt2Parser ctx);
static void     Smt2ParserReset (pSmt2Parser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "/build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return Smt2ParserNewSSD(instream, NULL);
}

/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pSmt2Parser ctx;	    /* Context structure we will build and return   */

    ctx	= (pSmt2Parser) ANTLR3_CALLOC(1, sizeof(Smt2Parser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in Smt2Parser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our Smt2Parser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->parseSygus	= parseSygus;
    ctx->command	= command;
    ctx->sygusCommand	= sygusCommand;
    ctx->sygusGrammarV1	= sygusGrammarV1;
    ctx->sygusGTerm	= sygusGTerm;
    ctx->sygusGrammar	= sygusGrammar;
    ctx->setInfoInternal	= setInfoInternal;
    ctx->setOptionInternal	= setOptionInternal;
    ctx->smt25Command	= smt25Command;
    ctx->extendedCommand	= extendedCommand;
    ctx->datatypes_2_5_DefCommand	= datatypes_2_5_DefCommand;
    ctx->datatypeDefCommand	= datatypeDefCommand;
    ctx->datatypesDefCommand	= datatypesDefCommand;
    ctx->datatypesDef	= datatypesDef;
    ctx->simpleSymbolicExprNoKeyword	= simpleSymbolicExprNoKeyword;
    ctx->keyword	= keyword;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->term	= term;
    ctx->termNonVariable	= termNonVariable;
    ctx->qualIdentifier	= qualIdentifier;
    ctx->identifier	= identifier;
    ctx->termAtomic	= termAtomic;
    ctx->attribute	= attribute;
    ctx->termList	= termList;
    ctx->str	= str;
    ctx->quantOp	= quantOp;
    ctx->functionName	= functionName;
    ctx->sortList	= sortList;
    ctx->nonemptySortList	= nonemptySortList;
    ctx->sortedVarList	= sortedVarList;
    ctx->boundVarList	= boundVarList;
    ctx->sortName	= sortName;
    ctx->sortSymbol	= sortSymbol;
    ctx->symbolList	= symbolList;
    ctx->symbol	= symbol;
    ctx->nonemptyNumeralList	= nonemptyNumeralList;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->free			= Smt2ParserFree;
    ctx->reset			= Smt2ParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = Smt2ParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
Smt2ParserReset (pSmt2Parser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 Smt2ParserFree(pSmt2Parser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return Smt2ParserTokenNames;
}


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_parseExpr119  */
static	ANTLR3_BITWORD FOLLOW_term_in_parseExpr119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_parseExpr119	= { FOLLOW_term_in_parseExpr119_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr126  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr126_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr126	= { FOLLOW_EOF_in_parseExpr126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand155  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand155_bits[]	= { ANTLR3_UINT64_LIT(0x7FFA5FB7FF036020), ANTLR3_UINT64_LIT(0x0000000001DB6000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand155	= { FOLLOW_LPAREN_TOK_in_parseCommand155_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand157  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand157	= { FOLLOW_command_in_parseCommand157_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand160  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand160	= { FOLLOW_RPAREN_TOK_in_parseCommand160_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand173  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand173	= { FOLLOW_LPAREN_TOK_in_parseCommand173_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_parseCommand175  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_parseCommand175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_parseCommand175	= { FOLLOW_INCLUDE_TOK_in_parseCommand175_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_parseCommand177  */
static	ANTLR3_BITWORD FOLLOW_str_in_parseCommand177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_parseCommand177	= { FOLLOW_str_in_parseCommand177_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand180  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand180	= { FOLLOW_RPAREN_TOK_in_parseCommand180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand193  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand193	= { FOLLOW_EOF_in_parseCommand193_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseSygus222  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseSygus222_bits[]	= { ANTLR3_UINT64_LIT(0x7FFA5FFFFF276020), ANTLR3_UINT64_LIT(0x0000001E01DB6040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseSygus222	= { FOLLOW_LPAREN_TOK_in_parseSygus222_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusCommand_in_parseSygus226  */
static	ANTLR3_BITWORD FOLLOW_sygusCommand_in_parseSygus226_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusCommand_in_parseSygus226	= { FOLLOW_sygusCommand_in_parseSygus226_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseSygus228  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseSygus228_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseSygus228	= { FOLLOW_RPAREN_TOK_in_parseSygus228_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseSygus234  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseSygus234_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseSygus234	= { FOLLOW_EOF_in_parseSygus234_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_LOGIC_TOK_in_command262  */
static	ANTLR3_BITWORD FOLLOW_SET_LOGIC_TOK_in_command262_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_LOGIC_TOK_in_command262	= { FOLLOW_SET_LOGIC_TOK_in_command262_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command264  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command264_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command264	= { FOLLOW_symbol_in_command264_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_INFO_TOK_in_command283  */
static	ANTLR3_BITWORD FOLLOW_SET_INFO_TOK_in_command283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_INFO_TOK_in_command283	= { FOLLOW_SET_INFO_TOK_in_command283_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setInfoInternal_in_command285  */
static	ANTLR3_BITWORD FOLLOW_setInfoInternal_in_command285_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setInfoInternal_in_command285	= { FOLLOW_setInfoInternal_in_command285_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_INFO_TOK_in_command298  */
static	ANTLR3_BITWORD FOLLOW_GET_INFO_TOK_in_command298_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_INFO_TOK_in_command298	= { FOLLOW_GET_INFO_TOK_in_command298_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command300  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command300_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command300	= { FOLLOW_KEYWORD_in_command300_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_OPTION_TOK_in_command318  */
static	ANTLR3_BITWORD FOLLOW_SET_OPTION_TOK_in_command318_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_OPTION_TOK_in_command318	= { FOLLOW_SET_OPTION_TOK_in_command318_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setOptionInternal_in_command320  */
static	ANTLR3_BITWORD FOLLOW_setOptionInternal_in_command320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setOptionInternal_in_command320	= { FOLLOW_setOptionInternal_in_command320_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OPTION_TOK_in_command333  */
static	ANTLR3_BITWORD FOLLOW_GET_OPTION_TOK_in_command333_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OPTION_TOK_in_command333	= { FOLLOW_GET_OPTION_TOK_in_command333_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command335  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command335_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command335	= { FOLLOW_KEYWORD_in_command335_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORT_TOK_in_command353  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORT_TOK_in_command353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORT_TOK_in_command353	= { FOLLOW_DECLARE_SORT_TOK_in_command353_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command365  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command365_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command365	= { FOLLOW_symbol_in_command365_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command380  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command380_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command380	= { FOLLOW_INTEGER_LITERAL_in_command380_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_SORT_TOK_in_command398  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_SORT_TOK_in_command398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_SORT_TOK_in_command398	= { FOLLOW_DEFINE_SORT_TOK_in_command398_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command406  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command406_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command406	= { FOLLOW_symbol_in_command406_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command419  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command419_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command419	= { FOLLOW_LPAREN_TOK_in_command419_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolList_in_command421  */
static	ANTLR3_BITWORD FOLLOW_symbolList_in_command421_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolList_in_command421	= { FOLLOW_symbolList_in_command421_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command424  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command424_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command424	= { FOLLOW_RPAREN_TOK_in_command424_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command436  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command436_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command436	= { FOLLOW_sortSymbol_in_command436_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUN_TOK_in_command455  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUN_TOK_in_command455_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUN_TOK_in_command455	= { FOLLOW_DECLARE_FUN_TOK_in_command455_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command463  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command463_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command463	= { FOLLOW_symbol_in_command463_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command476  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command476_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command476	= { FOLLOW_LPAREN_TOK_in_command476_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_command478  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_command478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_command478	= { FOLLOW_sortList_in_command478_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command481  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command481	= { FOLLOW_RPAREN_TOK_in_command481_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command487  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command487_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command487	= { FOLLOW_sortSymbol_in_command487_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUN_TOK_in_command506  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUN_TOK_in_command506_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUN_TOK_in_command506	= { FOLLOW_DEFINE_FUN_TOK_in_command506_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command514  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command514_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command514	= { FOLLOW_symbol_in_command514_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command527  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command527_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command527	= { FOLLOW_LPAREN_TOK_in_command527_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_command529  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_command529_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_command529	= { FOLLOW_sortedVarList_in_command529_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command532  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command532_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command532	= { FOLLOW_RPAREN_TOK_in_command532_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command538  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command538	= { FOLLOW_sortSymbol_in_command538_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command551  */
static	ANTLR3_BITWORD FOLLOW_term_in_command551_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command551	= { FOLLOW_term_in_command551_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPE_TOK_in_command564  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPE_TOK_in_command564_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPE_TOK_in_command564	= { FOLLOW_DECLARE_DATATYPE_TOK_in_command564_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDefCommand_in_command566  */
static	ANTLR3_BITWORD FOLLOW_datatypeDefCommand_in_command566_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDefCommand_in_command566	= { FOLLOW_datatypeDefCommand_in_command566_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPES_TOK_in_command573  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPES_TOK_in_command573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPES_TOK_in_command573	= { FOLLOW_DECLARE_DATATYPES_TOK_in_command573_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_command575  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_command575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_command575	= { FOLLOW_datatypesDefCommand_in_command575_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_command588  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_command588_bits[]	= { ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFF0), ANTLR3_UINT64_LIT(0x000007FFFFFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_command588	= { FOLLOW_GET_VALUE_TOK_in_command588_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command598  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command598_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command598	= { FOLLOW_LPAREN_TOK_in_command598_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_command600  */
static	ANTLR3_BITWORD FOLLOW_termList_in_command600_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_command600	= { FOLLOW_termList_in_command600_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command603  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command603_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command603	= { FOLLOW_RPAREN_TOK_in_command603_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_command619  */
static	ANTLR3_BITWORD FOLLOW_set_in_command619_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_command619	= { FOLLOW_set_in_command619_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSIGNMENT_TOK_in_command646  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSIGNMENT_TOK_in_command646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSIGNMENT_TOK_in_command646	= { FOLLOW_GET_ASSIGNMENT_TOK_in_command646_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_command666  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_command666_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_command666	= { FOLLOW_ASSERT_TOK_in_command666_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command680  */
static	ANTLR3_BITWORD FOLLOW_term_in_command680_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command680	= { FOLLOW_term_in_command680_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SAT_TOK_in_command699  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SAT_TOK_in_command699_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801002), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SAT_TOK_in_command699	= { FOLLOW_CHECK_SAT_TOK_in_command699_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command715  */
static	ANTLR3_BITWORD FOLLOW_term_in_command715_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command715	= { FOLLOW_term_in_command715_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command756  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command756_bits[]	= { ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFF0), ANTLR3_UINT64_LIT(0x000007FFFFFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command756	= { FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command756_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command766  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command766_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command766	= { FOLLOW_LPAREN_TOK_in_command766_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_command768  */
static	ANTLR3_BITWORD FOLLOW_termList_in_command768_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_command768	= { FOLLOW_termList_in_command768_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command771  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command771_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command771	= { FOLLOW_RPAREN_TOK_in_command771_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_command787  */
static	ANTLR3_BITWORD FOLLOW_set_in_command787_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_command787	= { FOLLOW_set_in_command787_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSERTIONS_TOK_in_command814  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSERTIONS_TOK_in_command814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSERTIONS_TOK_in_command814	= { FOLLOW_GET_ASSERTIONS_TOK_in_command814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_PROOF_TOK_in_command834  */
static	ANTLR3_BITWORD FOLLOW_GET_PROOF_TOK_in_command834_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_PROOF_TOK_in_command834	= { FOLLOW_GET_PROOF_TOK_in_command834_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command854  */
static	ANTLR3_BITWORD FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command854	= { FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command854_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_UNSAT_CORE_TOK_in_command874  */
static	ANTLR3_BITWORD FOLLOW_GET_UNSAT_CORE_TOK_in_command874_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_UNSAT_CORE_TOK_in_command874	= { FOLLOW_GET_UNSAT_CORE_TOK_in_command874_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_command894  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_command894_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_command894	= { FOLLOW_PUSH_TOK_in_command894_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command912  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command912	= { FOLLOW_INTEGER_LITERAL_in_command912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_command936  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_command936_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_command936	= { FOLLOW_POP_TOK_in_command936_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command954  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command954_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command954	= { FOLLOW_INTEGER_LITERAL_in_command954_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_command988  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_command988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_command988	= { FOLLOW_EXIT_TOK_in_command988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smt25Command_in_command1007  */
static	ANTLR3_BITWORD FOLLOW_smt25Command_in_command1007_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_smt25Command_in_command1007	= { FOLLOW_smt25Command_in_command1007_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_extendedCommand_in_command1027  */
static	ANTLR3_BITWORD FOLLOW_extendedCommand_in_command1027_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_extendedCommand_in_command1027	= { FOLLOW_extendedCommand_in_command1027_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_command1047  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_command1047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_command1047	= { FOLLOW_SIMPLE_SYMBOL_in_command1047_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1081  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1081	= { FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1081_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1089  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1089_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1089	= { FOLLOW_symbol_in_sygusCommand1089_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1102  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1102	= { FOLLOW_sortSymbol_in_sygusCommand1102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1121  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1121	= { FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1121_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1129  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1129_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1129	= { FOLLOW_symbol_in_sygusCommand1129_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1142  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1142_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1142	= { FOLLOW_sortSymbol_in_sygusCommand1142_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_FUN_V1_TOK_in_sygusCommand1164  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_FUN_V1_TOK_in_sygusCommand1164_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_FUN_V1_TOK_in_sygusCommand1164	= { FOLLOW_SYNTH_FUN_V1_TOK_in_sygusCommand1164_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_INV_V1_TOK_in_sygusCommand1176  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_INV_V1_TOK_in_sygusCommand1176_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_INV_V1_TOK_in_sygusCommand1176	= { FOLLOW_SYNTH_INV_V1_TOK_in_sygusCommand1176_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1196  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1196	= { FOLLOW_symbol_in_sygusCommand1196_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1203  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1203	= { FOLLOW_LPAREN_TOK_in_sygusCommand1203_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_sygusCommand1205  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_sygusCommand1205_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_sygusCommand1205	= { FOLLOW_sortedVarList_in_sygusCommand1205_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1208  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1208_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1208	= { FOLLOW_RPAREN_TOK_in_sygusCommand1208_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1216  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1216_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1216	= { FOLLOW_sortSymbol_in_sygusCommand1216_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGrammarV1_in_sygusCommand1268  */
static	ANTLR3_BITWORD FOLLOW_sygusGrammarV1_in_sygusCommand1268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGrammarV1_in_sygusCommand1268	= { FOLLOW_sygusGrammarV1_in_sygusCommand1268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1296  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1296_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1296	= { FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1296_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_INV_TOK_in_sygusCommand1308  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_INV_TOK_in_sygusCommand1308_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_INV_TOK_in_sygusCommand1308	= { FOLLOW_SYNTH_INV_TOK_in_sygusCommand1308_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1328  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1328_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1328	= { FOLLOW_symbol_in_sygusCommand1328_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1335  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1335_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1335	= { FOLLOW_LPAREN_TOK_in_sygusCommand1335_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_sygusCommand1337  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_sygusCommand1337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_sygusCommand1337	= { FOLLOW_sortedVarList_in_sygusCommand1337_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1340  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1340	= { FOLLOW_RPAREN_TOK_in_sygusCommand1340_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1348  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1348_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1348	= { FOLLOW_sortSymbol_in_sygusCommand1348_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGrammar_in_sygusCommand1400  */
static	ANTLR3_BITWORD FOLLOW_sygusGrammar_in_sygusCommand1400_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGrammar_in_sygusCommand1400	= { FOLLOW_sygusGrammar_in_sygusCommand1400_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONSTRAINT_TOK_in_sygusCommand1426  */
static	ANTLR3_BITWORD FOLLOW_CONSTRAINT_TOK_in_sygusCommand1426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_CONSTRAINT_TOK_in_sygusCommand1426	= { FOLLOW_CONSTRAINT_TOK_in_sygusCommand1426_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_sygusCommand1434  */
static	ANTLR3_BITWORD FOLLOW_term_in_sygusCommand1434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_sygusCommand1434	= { FOLLOW_term_in_sygusCommand1434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1453  */
static	ANTLR3_BITWORD FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1453_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1453	= { FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1453_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1461  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1461_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1461	= { FOLLOW_symbol_in_sygusCommand1461_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1485  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1485_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1485	= { FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1485_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_sygusCommand1503  */
static	ANTLR3_BITWORD FOLLOW_command_in_sygusCommand1503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_sygusCommand1503	= { FOLLOW_command_in_sygusCommand1503_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammarV11525  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammarV11525_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammarV11525	= { FOLLOW_LPAREN_TOK_in_sygusGrammarV11525_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammarV11532  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammarV11532_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammarV11532	= { FOLLOW_LPAREN_TOK_in_sygusGrammarV11532_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGrammarV11541  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGrammarV11541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGrammarV11541	= { FOLLOW_symbol_in_sygusGrammarV11541_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGrammarV11544  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGrammarV11544_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGrammarV11544	= { FOLLOW_sortSymbol_in_sygusGrammarV11544_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammarV11560  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammarV11560_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammarV11560	= { FOLLOW_LPAREN_TOK_in_sygusGrammarV11560_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusGrammarV11562  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusGrammarV11562_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusGrammarV11562	= { FOLLOW_sygusGTerm_in_sygusGrammarV11562_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammarV11573  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammarV11573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammarV11573	= { FOLLOW_RPAREN_TOK_in_sygusGrammarV11573_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammarV11577  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammarV11577_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammarV11577	= { FOLLOW_RPAREN_TOK_in_sygusGrammarV11577_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammarV11588  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammarV11588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammarV11588	= { FOLLOW_RPAREN_TOK_in_sygusGrammarV11588_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGTerm1615  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGTerm1615_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x000001006C808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGTerm1615	= { FOLLOW_LPAREN_TOK_in_sygusGTerm1615_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1628  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1628_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1628	= { FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1628_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1630  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1630_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1630	= { FOLLOW_sortSymbol_in_sygusGTerm1630_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1647  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1647_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1647	= { FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1647_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1649  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1649_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1649	= { FOLLOW_sortSymbol_in_sygusGTerm1649_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1666  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1666_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1666	= { FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1666_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1668  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1668_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1668	= { FOLLOW_sortSymbol_in_sygusGTerm1668_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1685  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1685_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1685	= { FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1685_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1687  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1687_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1687	= { FOLLOW_sortSymbol_in_sygusGTerm1687_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1704  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1704	= { FOLLOW_symbol_in_sygusGTerm1704_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusGTerm1732  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusGTerm1732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusGTerm1732	= { FOLLOW_sygusGTerm_in_sygusGTerm1732_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGTerm1754  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGTerm1754_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGTerm1754	= { FOLLOW_RPAREN_TOK_in_sygusGTerm1754_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termAtomic_in_sygusGTerm1764  */
static	ANTLR3_BITWORD FOLLOW_termAtomic_in_sygusGTerm1764_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_termAtomic_in_sygusGTerm1764	= { FOLLOW_termAtomic_in_sygusGTerm1764_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1779  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1779_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1779	= { FOLLOW_symbol_in_sygusGTerm1779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1813  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1813	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1813_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1828  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1828_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1828	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1828_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGrammar1830  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGrammar1830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGrammar1830	= { FOLLOW_symbol_in_sygusGrammar1830_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGrammar1837  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGrammar1837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGrammar1837	= { FOLLOW_sortSymbol_in_sygusGrammar1837_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1862  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1862	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1862_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammar1878  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammar1878_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammar1878	= { FOLLOW_RPAREN_TOK_in_sygusGrammar1878_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammar1895  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammar1895_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammar1895	= { FOLLOW_RPAREN_TOK_in_sygusGrammar1895_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1906  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1906	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1906_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1916  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1916_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1916	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1916_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGrammar1922  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGrammar1922_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGrammar1922	= { FOLLOW_symbol_in_sygusGrammar1922_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGrammar1925  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGrammar1925_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGrammar1925	= { FOLLOW_sortSymbol_in_sygusGrammar1925_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1938  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1938_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1938	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1938_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_sygusGrammar1952  */
static	ANTLR3_BITWORD FOLLOW_term_in_sygusGrammar1952_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_sygusGrammar1952	= { FOLLOW_term_in_sygusGrammar1952_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1965  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1965_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1965	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1965_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGrammar1967  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGrammar1967_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGrammar1967	= { FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGrammar1967_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGrammar1969  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGrammar1969_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGrammar1969	= { FOLLOW_sortSymbol_in_sygusGrammar1969_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammar1972  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammar1972_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammar1972	= { FOLLOW_RPAREN_TOK_in_sygusGrammar1972_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGrammar1984  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGrammar1984_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000040000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGrammar1984	= { FOLLOW_LPAREN_TOK_in_sygusGrammar1984_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGrammar1986  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGrammar1986_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGrammar1986	= { FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGrammar1986_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGrammar1988  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGrammar1988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGrammar1988	= { FOLLOW_sortSymbol_in_sygusGrammar1988_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammar1991  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammar1991_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammar1991	= { FOLLOW_RPAREN_TOK_in_sygusGrammar1991_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammar2006  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammar2006_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammar2006	= { FOLLOW_RPAREN_TOK_in_sygusGrammar2006_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammar2012  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammar2012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammar2012	= { FOLLOW_RPAREN_TOK_in_sygusGrammar2012_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGrammar2027  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGrammar2027_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGrammar2027	= { FOLLOW_RPAREN_TOK_in_sygusGrammar2027_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_setInfoInternal2048  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_setInfoInternal2048_bits[]	= { ANTLR3_UINT64_LIT(0x73F24F2120831020), ANTLR3_UINT64_LIT(0x0000010003DBE2A1) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_setInfoInternal2048	= { FOLLOW_KEYWORD_in_setInfoInternal2048_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_setInfoInternal2050  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_setInfoInternal2050_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_setInfoInternal2050	= { FOLLOW_symbolicExpr_in_setInfoInternal2050_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_keyword_in_setOptionInternal2076  */
static	ANTLR3_BITWORD FOLLOW_keyword_in_setOptionInternal2076_bits[]	= { ANTLR3_UINT64_LIT(0x73F24F2120831020), ANTLR3_UINT64_LIT(0x0000010003DBE2A1) };
static  ANTLR3_BITSET_LIST FOLLOW_keyword_in_setOptionInternal2076	= { FOLLOW_keyword_in_setOptionInternal2076_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_setOptionInternal2079  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_setOptionInternal2079_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_setOptionInternal2079	= { FOLLOW_symbolicExpr_in_setOptionInternal2079_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CONST_TOK_in_smt25Command2111  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CONST_TOK_in_smt25Command2111_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CONST_TOK_in_smt25Command2111	= { FOLLOW_DECLARE_CONST_TOK_in_smt25Command2111_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command2119  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command2119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command2119	= { FOLLOW_symbol_in_smt25Command2119_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command2132  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command2132_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command2132	= { FOLLOW_sortSymbol_in_smt25Command2132_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_MODEL_TOK_in_smt25Command2152  */
static	ANTLR3_BITWORD FOLLOW_GET_MODEL_TOK_in_smt25Command2152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_MODEL_TOK_in_smt25Command2152	= { FOLLOW_GET_MODEL_TOK_in_smt25Command2152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_smt25Command2173  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_smt25Command2173_bits[]	= { ANTLR3_UINT64_LIT(0x73F24F2120831022), ANTLR3_UINT64_LIT(0x0000010003DBE0A1) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_smt25Command2173	= { FOLLOW_ECHO_TOK_in_smt25Command2173_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_smt25Command2181  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_smt25Command2181_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_smt25Command2181	= { FOLLOW_simpleSymbolicExpr_in_smt25Command2181_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_smt25Command2217  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_smt25Command2217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_smt25Command2217	= { FOLLOW_RESET_TOK_in_smt25Command2217_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command2235  */
static	ANTLR3_BITWORD FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command2235_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command2235	= { FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command2235_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2247  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2247	= { FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2247_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command2259  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command2259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command2259	= { FOLLOW_symbol_in_smt25Command2259_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2272  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2272	= { FOLLOW_LPAREN_TOK_in_smt25Command2272_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_smt25Command2274  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_smt25Command2274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_smt25Command2274	= { FOLLOW_sortedVarList_in_smt25Command2274_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2277  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2277	= { FOLLOW_RPAREN_TOK_in_smt25Command2277_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command2283  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command2283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command2283	= { FOLLOW_sortSymbol_in_smt25Command2283_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_smt25Command2296  */
static	ANTLR3_BITWORD FOLLOW_term_in_smt25Command2296_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_smt25Command2296	= { FOLLOW_term_in_smt25Command2296_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2309  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2309_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2309	= { FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2309_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2321  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2321	= { FOLLOW_LPAREN_TOK_in_smt25Command2321_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2329  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2329_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2329	= { FOLLOW_LPAREN_TOK_in_smt25Command2329_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command2337  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command2337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command2337	= { FOLLOW_symbol_in_smt25Command2337_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2354  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2354_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2354	= { FOLLOW_LPAREN_TOK_in_smt25Command2354_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_smt25Command2356  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_smt25Command2356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_smt25Command2356	= { FOLLOW_sortedVarList_in_smt25Command2356_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2359  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2359_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2359	= { FOLLOW_RPAREN_TOK_in_smt25Command2359_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command2367  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command2367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command2367	= { FOLLOW_sortSymbol_in_smt25Command2367_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2384  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2384	= { FOLLOW_RPAREN_TOK_in_smt25Command2384_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2397  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2397	= { FOLLOW_RPAREN_TOK_in_smt25Command2397_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2403  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2403_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2403	= { FOLLOW_LPAREN_TOK_in_smt25Command2403_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_smt25Command2421  */
static	ANTLR3_BITWORD FOLLOW_term_in_smt25Command2421_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_smt25Command2421	= { FOLLOW_term_in_smt25Command2421_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2441  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2441_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2441	= { FOLLOW_RPAREN_TOK_in_smt25Command2441_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2472  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2472_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2472	= { FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2472_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2474  */
static	ANTLR3_BITWORD FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2474	= { FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2474_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2481  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2481	= { FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2481_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2483  */
static	ANTLR3_BITWORD FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2483	= { FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2483_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2490  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2490	= { FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2490_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDefCommand_in_extendedCommand2492  */
static	ANTLR3_BITWORD FOLLOW_datatypeDefCommand_in_extendedCommand2492_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDefCommand_in_extendedCommand2492	= { FOLLOW_datatypeDefCommand_in_extendedCommand2492_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2499  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2499_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2499	= { FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2499_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_extendedCommand2501  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_extendedCommand2501_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_extendedCommand2501	= { FOLLOW_datatypesDefCommand_in_extendedCommand2501_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2516  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2516_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2516	= { FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2516_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2528  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2528_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2528	= { FOLLOW_LPAREN_TOK_in_extendedCommand2528_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2536  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2536_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2536	= { FOLLOW_symbol_in_extendedCommand2536_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2558  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2558_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2558	= { FOLLOW_RPAREN_TOK_in_extendedCommand2558_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2571  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2571_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2571	= { FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2571_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2585  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2585_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2585	= { FOLLOW_LPAREN_TOK_in_extendedCommand2585_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2593  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2593_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2593	= { FOLLOW_LPAREN_TOK_in_extendedCommand2593_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2595  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2595	= { FOLLOW_symbol_in_extendedCommand2595_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptySortList_in_extendedCommand2612  */
static	ANTLR3_BITWORD FOLLOW_nonemptySortList_in_extendedCommand2612_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptySortList_in_extendedCommand2612	= { FOLLOW_nonemptySortList_in_extendedCommand2612_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2615  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2615_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2615	= { FOLLOW_RPAREN_TOK_in_extendedCommand2615_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2636  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2636_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2636	= { FOLLOW_RPAREN_TOK_in_extendedCommand2636_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2648  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2648_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2648	= { FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2648_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2662  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2662_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2662	= { FOLLOW_LPAREN_TOK_in_extendedCommand2662_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2670  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2670_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2670	= { FOLLOW_LPAREN_TOK_in_extendedCommand2670_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2672  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2672	= { FOLLOW_symbol_in_extendedCommand2672_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_extendedCommand2689  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_extendedCommand2689_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_extendedCommand2689	= { FOLLOW_sortList_in_extendedCommand2689_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2692  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2692_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2692	= { FOLLOW_RPAREN_TOK_in_extendedCommand2692_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2713  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2713_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2713	= { FOLLOW_RPAREN_TOK_in_extendedCommand2713_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_TOK_in_extendedCommand2726  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_TOK_in_extendedCommand2726_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_TOK_in_extendedCommand2726	= { FOLLOW_DEFINE_TOK_in_extendedCommand2726_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2743  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2743	= { FOLLOW_symbol_in_extendedCommand2743_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2760  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2760	= { FOLLOW_term_in_extendedCommand2760_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2784  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2784_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2784	= { FOLLOW_LPAREN_TOK_in_extendedCommand2784_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2792  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2792	= { FOLLOW_symbol_in_extendedCommand2792_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_extendedCommand2809  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_extendedCommand2809_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_extendedCommand2809	= { FOLLOW_sortedVarList_in_extendedCommand2809_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2812  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2812	= { FOLLOW_RPAREN_TOK_in_extendedCommand2812_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2828  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2828_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2828	= { FOLLOW_term_in_extendedCommand2828_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2854  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2854	= { FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2854_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2862  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2862	= { FOLLOW_symbol_in_extendedCommand2862_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_extendedCommand2875  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_extendedCommand2875_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_extendedCommand2875	= { FOLLOW_sortSymbol_in_extendedCommand2875_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2888  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2888	= { FOLLOW_term_in_extendedCommand2888_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLIFY_TOK_in_extendedCommand2902  */
static	ANTLR3_BITWORD FOLLOW_SIMPLIFY_TOK_in_extendedCommand2902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLIFY_TOK_in_extendedCommand2902	= { FOLLOW_SIMPLIFY_TOK_in_extendedCommand2902_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2910  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2910_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2910	= { FOLLOW_term_in_extendedCommand2910_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_QE_TOK_in_extendedCommand2923  */
static	ANTLR3_BITWORD FOLLOW_GET_QE_TOK_in_extendedCommand2923_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_QE_TOK_in_extendedCommand2923	= { FOLLOW_GET_QE_TOK_in_extendedCommand2923_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2931  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2931	= { FOLLOW_term_in_extendedCommand2931_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2944  */
static	ANTLR3_BITWORD FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2944_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2944	= { FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2944_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2952  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2952_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2952	= { FOLLOW_term_in_extendedCommand2952_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ABDUCT_TOK_in_extendedCommand2965  */
static	ANTLR3_BITWORD FOLLOW_GET_ABDUCT_TOK_in_extendedCommand2965_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ABDUCT_TOK_in_extendedCommand2965	= { FOLLOW_GET_ABDUCT_TOK_in_extendedCommand2965_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2973  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2973_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2973	= { FOLLOW_symbol_in_extendedCommand2973_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2980  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2980_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2980	= { FOLLOW_term_in_extendedCommand2980_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGrammar_in_extendedCommand2995  */
static	ANTLR3_BITWORD FOLLOW_sygusGrammar_in_extendedCommand2995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGrammar_in_extendedCommand2995	= { FOLLOW_sygusGrammar_in_extendedCommand2995_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_HEAP_in_extendedCommand3015  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_HEAP_in_extendedCommand3015_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_HEAP_in_extendedCommand3015	= { FOLLOW_DECLARE_HEAP_in_extendedCommand3015_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand3017  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand3017_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand3017	= { FOLLOW_LPAREN_TOK_in_extendedCommand3017_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_extendedCommand3023  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_extendedCommand3023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_extendedCommand3023	= { FOLLOW_sortSymbol_in_extendedCommand3023_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_extendedCommand3030  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_extendedCommand3030_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_extendedCommand3030	= { FOLLOW_sortSymbol_in_extendedCommand3030_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand3048  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand3048_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand3048	= { FOLLOW_RPAREN_TOK_in_extendedCommand3048_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BLOCK_MODEL_TOK_in_extendedCommand3054  */
static	ANTLR3_BITWORD FOLLOW_BLOCK_MODEL_TOK_in_extendedCommand3054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BLOCK_MODEL_TOK_in_extendedCommand3054	= { FOLLOW_BLOCK_MODEL_TOK_in_extendedCommand3054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BLOCK_MODEL_VALUES_TOK_in_extendedCommand3069  */
static	ANTLR3_BITWORD FOLLOW_BLOCK_MODEL_VALUES_TOK_in_extendedCommand3069_bits[]	= { ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFF0), ANTLR3_UINT64_LIT(0x000007FFFFFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_BLOCK_MODEL_VALUES_TOK_in_extendedCommand3069	= { FOLLOW_BLOCK_MODEL_VALUES_TOK_in_extendedCommand3069_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand3079  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand3079_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand3079	= { FOLLOW_LPAREN_TOK_in_extendedCommand3079_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_extendedCommand3081  */
static	ANTLR3_BITWORD FOLLOW_termList_in_extendedCommand3081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_extendedCommand3081	= { FOLLOW_termList_in_extendedCommand3081_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand3084  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand3084_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand3084	= { FOLLOW_RPAREN_TOK_in_extendedCommand3084_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_extendedCommand3100  */
static	ANTLR3_BITWORD FOLLOW_set_in_extendedCommand3100_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_extendedCommand3100	= { FOLLOW_set_in_extendedCommand3100_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3139  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3139_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3139	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3139_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypes_2_5_DefCommand3147  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypes_2_5_DefCommand3147_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypes_2_5_DefCommand3147	= { FOLLOW_symbol_in_datatypes_2_5_DefCommand3147_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3163  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3163	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3163_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3167  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3167	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3167_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3171  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3171_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3171	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3171_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand3173  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand3173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand3173	= { FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand3173_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3176  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3176_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3176	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3176_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3181  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3181_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3181	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3181_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypeDefCommand3206  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypeDefCommand3206_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypeDefCommand3206	= { FOLLOW_symbol_in_datatypeDefCommand3206_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDef_in_datatypeDefCommand3213  */
static	ANTLR3_BITWORD FOLLOW_datatypesDef_in_datatypeDefCommand3213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDef_in_datatypeDefCommand3213	= { FOLLOW_datatypesDef_in_datatypeDefCommand3213_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand3236  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand3236_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand3236	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand3236_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand3244  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand3244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand3244	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand3244_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypesDefCommand3246  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypesDefCommand3246_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypesDefCommand3246	= { FOLLOW_symbol_in_datatypesDefCommand3246_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand3251  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand3251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand3251	= { FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand3251_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand3253  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand3253_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand3253	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand3253_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand3268  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand3268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand3268	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand3268_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand3272  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand3272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand3272	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand3272_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDef_in_datatypesDefCommand3276  */
static	ANTLR3_BITWORD FOLLOW_datatypesDef_in_datatypesDefCommand3276_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDef_in_datatypesDefCommand3276	= { FOLLOW_datatypesDef_in_datatypesDefCommand3276_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand3281  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand3281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand3281	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand3281_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef3310  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef3310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef3310	= { FOLLOW_LPAREN_TOK_in_datatypesDef3310_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PAR_TOK_in_datatypesDef3320  */
static	ANTLR3_BITWORD FOLLOW_PAR_TOK_in_datatypesDef3320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_PAR_TOK_in_datatypesDef3320	= { FOLLOW_PAR_TOK_in_datatypesDef3320_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef3324  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef3324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef3324	= { FOLLOW_LPAREN_TOK_in_datatypesDef3324_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypesDef3334  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypesDef3334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypesDef3334	= { FOLLOW_symbol_in_datatypesDef3334_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3362  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3362	= { FOLLOW_RPAREN_TOK_in_datatypesDef3362_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef3372  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef3372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef3372	= { FOLLOW_LPAREN_TOK_in_datatypesDef3372_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef3382  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef3382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef3382	= { FOLLOW_LPAREN_TOK_in_datatypesDef3382_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypesDef3384  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypesDef3384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypesDef3384	= { FOLLOW_constructorDef_in_datatypesDef3384_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3387  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3387	= { FOLLOW_RPAREN_TOK_in_datatypesDef3387_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3398  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3398	= { FOLLOW_RPAREN_TOK_in_datatypesDef3398_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef3418  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef3418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef3418	= { FOLLOW_LPAREN_TOK_in_datatypesDef3418_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypesDef3420  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypesDef3420_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypesDef3420	= { FOLLOW_constructorDef_in_datatypesDef3420_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3423  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3423_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3423	= { FOLLOW_RPAREN_TOK_in_datatypesDef3423_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3438  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3438_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3438	= { FOLLOW_RPAREN_TOK_in_datatypesDef3438_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3468  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3468_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3468	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3468_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3480  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3480_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3480	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3480_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3492  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3492_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3492	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3492_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3504  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3504	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3504_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExprNoKeyword3516  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExprNoKeyword3516_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExprNoKeyword3516	= { FOLLOW_str_in_simpleSymbolicExprNoKeyword3516_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3529  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3529_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3529	= { FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3529_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_simpleSymbolicExprNoKeyword3544  */
static	ANTLR3_BITWORD FOLLOW_set_in_simpleSymbolicExprNoKeyword3544_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_simpleSymbolicExprNoKeyword3544	= { FOLLOW_set_in_simpleSymbolicExprNoKeyword3544_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_keyword3742  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_keyword3742_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_keyword3742	= { FOLLOW_KEYWORD_in_keyword3742_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3762  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3762_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3762	= { FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3762_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_simpleSymbolicExpr3769  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_simpleSymbolicExpr3769_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_simpleSymbolicExpr3769	= { FOLLOW_KEYWORD_in_simpleSymbolicExpr3769_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr3794  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr3794_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr3794	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr3794_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_symbolicExpr3801  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_symbolicExpr3801_bits[]	= { ANTLR3_UINT64_LIT(0x73F24F2120831020), ANTLR3_UINT64_LIT(0x0000010003DFE2A1) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_symbolicExpr3801	= { FOLLOW_LPAREN_TOK_in_symbolicExpr3801_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr3809  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr3809_bits[]	= { ANTLR3_UINT64_LIT(0x73F24F2120831020), ANTLR3_UINT64_LIT(0x0000010003DFE2A1) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr3809	= { FOLLOW_symbolicExpr_in_symbolicExpr3809_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_symbolicExpr3817  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_symbolicExpr3817_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_symbolicExpr3817	= { FOLLOW_RPAREN_TOK_in_symbolicExpr3817_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termNonVariable_in_term3842  */
static	ANTLR3_BITWORD FOLLOW_termNonVariable_in_term3842_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_termNonVariable_in_term3842	= { FOLLOW_termNonVariable_in_term3842_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_qualIdentifier_in_term3854  */
static	ANTLR3_BITWORD FOLLOW_qualIdentifier_in_term3854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_qualIdentifier_in_term3854	= { FOLLOW_qualIdentifier_in_term3854_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3882  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3882_bits[]	= { ANTLR3_UINT64_LIT(0x0005000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3882	= { FOLLOW_LPAREN_TOK_in_termNonVariable3882_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quantOp_in_termNonVariable3884  */
static	ANTLR3_BITWORD FOLLOW_quantOp_in_termNonVariable3884_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_quantOp_in_termNonVariable3884	= { FOLLOW_quantOp_in_termNonVariable3884_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarList_in_termNonVariable3897  */
static	ANTLR3_BITWORD FOLLOW_boundVarList_in_termNonVariable3897_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarList_in_termNonVariable3897	= { FOLLOW_boundVarList_in_termNonVariable3897_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable3904  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable3904_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable3904	= { FOLLOW_term_in_termNonVariable3904_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3907  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3907_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3907	= { FOLLOW_RPAREN_TOK_in_termNonVariable3907_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3919  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3919_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3919	= { FOLLOW_LPAREN_TOK_in_termNonVariable3919_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMPREHENSION_TOK_in_termNonVariable3921  */
static	ANTLR3_BITWORD FOLLOW_COMPREHENSION_TOK_in_termNonVariable3921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_COMPREHENSION_TOK_in_termNonVariable3921	= { FOLLOW_COMPREHENSION_TOK_in_termNonVariable3921_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarList_in_termNonVariable3933  */
static	ANTLR3_BITWORD FOLLOW_boundVarList_in_termNonVariable3933_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarList_in_termNonVariable3933	= { FOLLOW_boundVarList_in_termNonVariable3933_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable3946  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable3946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable3946	= { FOLLOW_term_in_termNonVariable3946_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable3955  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable3955_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable3955	= { FOLLOW_term_in_termNonVariable3955_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3964  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3964	= { FOLLOW_RPAREN_TOK_in_termNonVariable3964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3970  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3970_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3970	= { FOLLOW_LPAREN_TOK_in_termNonVariable3970_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_qualIdentifier_in_termNonVariable3972  */
static	ANTLR3_BITWORD FOLLOW_qualIdentifier_in_termNonVariable3972_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_qualIdentifier_in_termNonVariable3972	= { FOLLOW_qualIdentifier_in_termNonVariable3972_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_termNonVariable3979  */
static	ANTLR3_BITWORD FOLLOW_termList_in_termNonVariable3979_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_termNonVariable3979	= { FOLLOW_termList_in_termNonVariable3979_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3982  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3982	= { FOLLOW_RPAREN_TOK_in_termNonVariable3982_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4000  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000010000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4000	= { FOLLOW_LPAREN_TOK_in_termNonVariable4000_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_termNonVariable4010  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_termNonVariable4010_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_termNonVariable4010	= { FOLLOW_LET_TOK_in_termNonVariable4010_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4012  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4012	= { FOLLOW_LPAREN_TOK_in_termNonVariable4012_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4030  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4030_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4030	= { FOLLOW_LPAREN_TOK_in_termNonVariable4030_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4032  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4032	= { FOLLOW_symbol_in_termNonVariable4032_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4043  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4043	= { FOLLOW_term_in_termNonVariable4043_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4054  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4054	= { FOLLOW_RPAREN_TOK_in_termNonVariable4054_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_LET_TOK_in_termNonVariable4095  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_LET_TOK_in_termNonVariable4095_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_LET_TOK_in_termNonVariable4095	= { FOLLOW_SYGUS_LET_TOK_in_termNonVariable4095_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4097  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4097	= { FOLLOW_LPAREN_TOK_in_termNonVariable4097_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4115  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4115_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4115	= { FOLLOW_LPAREN_TOK_in_termNonVariable4115_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4117  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4117	= { FOLLOW_symbol_in_termNonVariable4117_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_termNonVariable4128  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_termNonVariable4128_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_termNonVariable4128	= { FOLLOW_sortSymbol_in_termNonVariable4128_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4139  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4139_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4139	= { FOLLOW_term_in_termNonVariable4139_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4150  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4150_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4150	= { FOLLOW_RPAREN_TOK_in_termNonVariable4150_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4195  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4195_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4195	= { FOLLOW_RPAREN_TOK_in_termNonVariable4195_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4201  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4201_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4201	= { FOLLOW_term_in_termNonVariable4201_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4208  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4208_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4208	= { FOLLOW_RPAREN_TOK_in_termNonVariable4208_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4226  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4226_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4226	= { FOLLOW_LPAREN_TOK_in_termNonVariable4226_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MATCH_TOK_in_termNonVariable4228  */
static	ANTLR3_BITWORD FOLLOW_MATCH_TOK_in_termNonVariable4228_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_MATCH_TOK_in_termNonVariable4228	= { FOLLOW_MATCH_TOK_in_termNonVariable4228_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4230  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4230	= { FOLLOW_term_in_termNonVariable4230_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4239  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4239	= { FOLLOW_LPAREN_TOK_in_termNonVariable4239_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4260  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4260	= { FOLLOW_LPAREN_TOK_in_termNonVariable4260_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4262  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4262_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4262	= { FOLLOW_LPAREN_TOK_in_termNonVariable4262_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4264  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4264_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4264	= { FOLLOW_term_in_termNonVariable4264_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4288  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4288_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4288	= { FOLLOW_symbol_in_termNonVariable4288_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4312  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4312_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4312	= { FOLLOW_RPAREN_TOK_in_termNonVariable4312_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4314  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4314	= { FOLLOW_term_in_termNonVariable4314_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4327  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4327_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4327	= { FOLLOW_RPAREN_TOK_in_termNonVariable4327_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4344  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4344_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4344	= { FOLLOW_LPAREN_TOK_in_termNonVariable4344_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4346  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4346	= { FOLLOW_symbol_in_termNonVariable4346_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4359  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4359_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4359	= { FOLLOW_term_in_termNonVariable4359_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4372  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4372	= { FOLLOW_RPAREN_TOK_in_termNonVariable4372_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4385  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4385_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4385	= { FOLLOW_RPAREN_TOK_in_termNonVariable4385_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4387  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4387	= { FOLLOW_RPAREN_TOK_in_termNonVariable4387_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4403  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4403_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4403	= { FOLLOW_LPAREN_TOK_in_termNonVariable4403_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4405  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4405_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4405	= { FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4405_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4407  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000780), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4407	= { FOLLOW_term_in_termNonVariable4407_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_attribute_in_termNonVariable4416  */
static	ANTLR3_BITWORD FOLLOW_attribute_in_termNonVariable4416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000780), ANTLR3_UINT64_LIT(0x0000000000040080) };
static  ANTLR3_BITSET_LIST FOLLOW_attribute_in_termNonVariable4416	= { FOLLOW_attribute_in_termNonVariable4416_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4434  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4434	= { FOLLOW_RPAREN_TOK_in_termNonVariable4434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4452  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4452_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4452	= { FOLLOW_LPAREN_TOK_in_termNonVariable4452_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4454  */
static	ANTLR3_BITWORD FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4454	= { FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4454_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarList_in_termNonVariable4466  */
static	ANTLR3_BITWORD FOLLOW_boundVarList_in_termNonVariable4466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarList_in_termNonVariable4466	= { FOLLOW_boundVarList_in_termNonVariable4466_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4473  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4473_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4473	= { FOLLOW_term_in_termNonVariable4473_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4476  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4476_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4476	= { FOLLOW_RPAREN_TOK_in_termNonVariable4476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4488  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4488_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4488	= { FOLLOW_LPAREN_TOK_in_termNonVariable4488_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_CONST_TOK_in_termNonVariable4490  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_CONST_TOK_in_termNonVariable4490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_CONST_TOK_in_termNonVariable4490	= { FOLLOW_TUPLE_CONST_TOK_in_termNonVariable4490_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_termNonVariable4492  */
static	ANTLR3_BITWORD FOLLOW_termList_in_termNonVariable4492_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_termNonVariable4492	= { FOLLOW_termList_in_termNonVariable4492_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4495  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4495_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4495	= { FOLLOW_RPAREN_TOK_in_termNonVariable4495_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termAtomic_in_termNonVariable4511  */
static	ANTLR3_BITWORD FOLLOW_termAtomic_in_termNonVariable4511_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_termAtomic_in_termNonVariable4511	= { FOLLOW_termAtomic_in_termNonVariable4511_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_qualIdentifier4534  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_qualIdentifier4534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_qualIdentifier4534	= { FOLLOW_identifier_in_qualIdentifier4534_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_qualIdentifier4541  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_qualIdentifier4541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_qualIdentifier4541	= { FOLLOW_LPAREN_TOK_in_qualIdentifier4541_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AS_TOK_in_qualIdentifier4543  */
static	ANTLR3_BITWORD FOLLOW_AS_TOK_in_qualIdentifier4543_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_AS_TOK_in_qualIdentifier4543	= { FOLLOW_AS_TOK_in_qualIdentifier4543_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONST_TOK_in_qualIdentifier4551  */
static	ANTLR3_BITWORD FOLLOW_CONST_TOK_in_qualIdentifier4551_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_CONST_TOK_in_qualIdentifier4551	= { FOLLOW_CONST_TOK_in_qualIdentifier4551_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_qualIdentifier4553  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_qualIdentifier4553_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_qualIdentifier4553	= { FOLLOW_sortSymbol_in_qualIdentifier4553_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_qualIdentifier4570  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_qualIdentifier4570_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_qualIdentifier4570	= { FOLLOW_identifier_in_qualIdentifier4570_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_qualIdentifier4579  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_qualIdentifier4579_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_qualIdentifier4579	= { FOLLOW_sortSymbol_in_qualIdentifier4579_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_qualIdentifier4600  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_qualIdentifier4600_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_qualIdentifier4600	= { FOLLOW_RPAREN_TOK_in_qualIdentifier4600_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_functionName_in_identifier4619  */
static	ANTLR3_BITWORD FOLLOW_functionName_in_identifier4619_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_functionName_in_identifier4619	= { FOLLOW_functionName_in_identifier4619_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_identifier4631  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_identifier4631_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_identifier4631	= { FOLLOW_LPAREN_TOK_in_identifier4631_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_identifier4633  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_identifier4633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x000000A000800000) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_identifier4633	= { FOLLOW_INDEX_TOK_in_identifier4633_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TESTER_TOK_in_identifier4641  */
static	ANTLR3_BITWORD FOLLOW_TESTER_TOK_in_identifier4641_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_TESTER_TOK_in_identifier4641	= { FOLLOW_TESTER_TOK_in_identifier4641_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_identifier4643  */
static	ANTLR3_BITWORD FOLLOW_term_in_identifier4643_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_identifier4643	= { FOLLOW_term_in_identifier4643_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_SEL_TOK_in_identifier4660  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_SEL_TOK_in_identifier4660_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_SEL_TOK_in_identifier4660	= { FOLLOW_TUPLE_SEL_TOK_in_identifier4660_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_identifier4664  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_identifier4664_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_identifier4664	= { FOLLOW_INTEGER_LITERAL_in_identifier4664_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_identifier4682  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_identifier4682_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_identifier4682	= { FOLLOW_SIMPLE_SYMBOL_in_identifier4682_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptyNumeralList_in_identifier4684  */
static	ANTLR3_BITWORD FOLLOW_nonemptyNumeralList_in_identifier4684_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptyNumeralList_in_identifier4684	= { FOLLOW_nonemptyNumeralList_in_identifier4684_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_identifier4705  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_identifier4705_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_identifier4705	= { FOLLOW_RPAREN_TOK_in_identifier4705_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termAtomic4732  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termAtomic4732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termAtomic4732	= { FOLLOW_INTEGER_LITERAL_in_termAtomic4732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_termAtomic4744  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_termAtomic4744_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_termAtomic4744	= { FOLLOW_DECIMAL_LITERAL_in_termAtomic4744_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termAtomic4763  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termAtomic4763_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termAtomic4763	= { FOLLOW_LPAREN_TOK_in_termAtomic4763_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_termAtomic4765  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_termAtomic4765_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000008000), ANTLR3_UINT64_LIT(0x0000000000800000) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_termAtomic4765	= { FOLLOW_INDEX_TOK_in_termAtomic4765_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EMP_TOK_in_termAtomic4773  */
static	ANTLR3_BITWORD FOLLOW_EMP_TOK_in_termAtomic4773_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_EMP_TOK_in_termAtomic4773	= { FOLLOW_EMP_TOK_in_termAtomic4773_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_termAtomic4781  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_termAtomic4781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_termAtomic4781	= { FOLLOW_sortSymbol_in_termAtomic4781_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_termAtomic4790  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_termAtomic4790_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_termAtomic4790	= { FOLLOW_sortSymbol_in_termAtomic4790_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHAR_TOK_in_termAtomic4807  */
static	ANTLR3_BITWORD FOLLOW_CHAR_TOK_in_termAtomic4807_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_CHAR_TOK_in_termAtomic4807	= { FOLLOW_CHAR_TOK_in_termAtomic4807_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_termAtomic4809  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_termAtomic4809_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_termAtomic4809	= { FOLLOW_HEX_LITERAL_in_termAtomic4809_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_termAtomic4828  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_termAtomic4828_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_termAtomic4828	= { FOLLOW_SIMPLE_SYMBOL_in_termAtomic4828_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptyNumeralList_in_termAtomic4830  */
static	ANTLR3_BITWORD FOLLOW_nonemptyNumeralList_in_termAtomic4830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptyNumeralList_in_termAtomic4830	= { FOLLOW_nonemptyNumeralList_in_termAtomic4830_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termAtomic4851  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termAtomic4851_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termAtomic4851	= { FOLLOW_RPAREN_TOK_in_termAtomic4851_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_termAtomic4861  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_termAtomic4861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_termAtomic4861	= { FOLLOW_HEX_LITERAL_in_termAtomic4861_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_termAtomic4873  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_termAtomic4873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_termAtomic4873	= { FOLLOW_BINARY_LITERAL_in_termAtomic4873_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_termAtomic4889  */
static	ANTLR3_BITWORD FOLLOW_str_in_termAtomic4889_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_termAtomic4889	= { FOLLOW_str_in_termAtomic4889_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_CONST_TOK_in_termAtomic4906  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_CONST_TOK_in_termAtomic4906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_CONST_TOK_in_termAtomic4906	= { FOLLOW_TUPLE_CONST_TOK_in_termAtomic4906_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_attribute4933  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_attribute4933_bits[]	= { ANTLR3_UINT64_LIT(0x73F24F2120831022), ANTLR3_UINT64_LIT(0x0000010003DBE021) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_attribute4933	= { FOLLOW_KEYWORD_in_attribute4933_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4937  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4937_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4937	= { FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4937_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4953  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4953_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4953	= { FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4953_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_attribute4955  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_attribute4955_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_attribute4955	= { FOLLOW_LPAREN_TOK_in_attribute4955_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute4963  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute4963_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002848221) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute4963	= { FOLLOW_term_in_attribute4963_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_attribute4981  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_attribute4981_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_attribute4981	= { FOLLOW_RPAREN_TOK_in_attribute4981_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4993  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4993_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801000), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4993	= { FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4993_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute4995  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute4995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute4995	= { FOLLOW_term_in_attribute4995_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_INST_LEVEL_in_attribute5012  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_INST_LEVEL_in_attribute5012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_INST_LEVEL_in_attribute5012	= { FOLLOW_ATTRIBUTE_INST_LEVEL_in_attribute5012_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_attribute5016  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_attribute5016_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_attribute5016	= { FOLLOW_INTEGER_LITERAL_in_attribute5016_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5028  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5028_bits[]	= { ANTLR3_UINT64_LIT(0x73F24F2120831020), ANTLR3_UINT64_LIT(0x0000010003DBE2A1) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5028	= { FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5028_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_attribute5030  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_attribute5030_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_attribute5030	= { FOLLOW_symbolicExpr_in_attribute5030_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termList5062  */
static	ANTLR3_BITWORD FOLLOW_term_in_termList5062_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000801002), ANTLR3_UINT64_LIT(0x0000014002808221) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termList5062	= { FOLLOW_term_in_termList5062_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_in_str5084  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_in_str5084_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_in_str5084	= { FOLLOW_STRING_LITERAL_in_str5084_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_quantOp5109  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_quantOp5109_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_quantOp5109	= { FOLLOW_EXISTS_TOK_in_quantOp5109_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_quantOp5120  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_quantOp5120_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_quantOp5120	= { FOLLOW_FORALL_TOK_in_quantOp5120_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_functionName5141  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_functionName5141_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_functionName5141	= { FOLLOW_symbol_in_functionName5141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortList5165  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortList5165_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortList5165	= { FOLLOW_sortSymbol_in_sortList5165_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_nonemptySortList5192  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_nonemptySortList5192_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_nonemptySortList5192	= { FOLLOW_sortSymbol_in_nonemptySortList5192_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortedVarList5221  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortedVarList5221_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortedVarList5221	= { FOLLOW_LPAREN_TOK_in_sortedVarList5221_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortedVarList5223  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortedVarList5223_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortedVarList5223	= { FOLLOW_symbol_in_sortedVarList5223_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortedVarList5232  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortedVarList5232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortedVarList5232	= { FOLLOW_sortSymbol_in_sortedVarList5232_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortedVarList5235  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortedVarList5235_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortedVarList5235	= { FOLLOW_RPAREN_TOK_in_sortedVarList5235_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_boundVarList5270  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_boundVarList5270_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_boundVarList5270	= { FOLLOW_LPAREN_TOK_in_boundVarList5270_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_boundVarList5272  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_boundVarList5272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_boundVarList5272	= { FOLLOW_sortedVarList_in_boundVarList5272_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_boundVarList5275  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_boundVarList5275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_boundVarList5275	= { FOLLOW_RPAREN_TOK_in_boundVarList5275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortName5295  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortName5295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortName5295	= { FOLLOW_symbol_in_sortName5295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortName_in_sortSymbol5315  */
static	ANTLR3_BITWORD FOLLOW_sortName_in_sortSymbol5315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortName_in_sortSymbol5315	= { FOLLOW_sortName_in_sortSymbol5315_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortSymbol5328  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortSymbol5328_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808010) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortSymbol5328	= { FOLLOW_LPAREN_TOK_in_sortSymbol5328_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_sortSymbol5331  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_sortSymbol5331_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_sortSymbol5331	= { FOLLOW_INDEX_TOK_in_sortSymbol5331_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortSymbol5344  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortSymbol5344_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848220) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortSymbol5344	= { FOLLOW_symbol_in_sortSymbol5344_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptyNumeralList_in_sortSymbol5353  */
static	ANTLR3_BITWORD FOLLOW_nonemptyNumeralList_in_sortSymbol5353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptyNumeralList_in_sortSymbol5353	= { FOLLOW_nonemptyNumeralList_in_sortSymbol5353_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_sortSymbol5370  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_sortSymbol5370_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_sortSymbol5370	= { FOLLOW_sortList_in_sortSymbol5370_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortSymbol5387  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortSymbol5387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortSymbol5387	= { FOLLOW_RPAREN_TOK_in_sortSymbol5387_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortSymbol5393  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortSymbol5393_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortSymbol5393	= { FOLLOW_LPAREN_TOK_in_sortSymbol5393_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HO_ARROW_TOK_in_sortSymbol5395  */
static	ANTLR3_BITWORD FOLLOW_HO_ARROW_TOK_in_sortSymbol5395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000848200) };
static  ANTLR3_BITSET_LIST FOLLOW_HO_ARROW_TOK_in_sortSymbol5395	= { FOLLOW_HO_ARROW_TOK_in_sortSymbol5395_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_sortSymbol5397  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_sortSymbol5397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_sortSymbol5397	= { FOLLOW_sortList_in_sortSymbol5397_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortSymbol5400  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortSymbol5400_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortSymbol5400	= { FOLLOW_RPAREN_TOK_in_sortSymbol5400_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_symbolList5429  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_symbolList5429_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_symbolList5429	= { FOLLOW_symbol_in_symbolList5429_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_symbol5451  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_symbol5451_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_symbol5451	= { FOLLOW_SIMPLE_SYMBOL_in_symbol5451_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUOTED_SYMBOL_in_symbol5463  */
static	ANTLR3_BITWORD FOLLOW_QUOTED_SYMBOL_in_symbol5463_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_QUOTED_SYMBOL_in_symbol5463	= { FOLLOW_QUOTED_SYMBOL_in_symbol5463_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol5475  */
static	ANTLR3_BITWORD FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol5475_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol5475	= { FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol5475_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_symbol5483  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_symbol5483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_symbol5483	= { FOLLOW_EOF_in_symbol5483_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_106_in_symbol5499  */
static	ANTLR3_BITWORD FOLLOW_106_in_symbol5499_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_106_in_symbol5499	= { FOLLOW_106_in_symbol5499_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList5531  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList5531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList5531	= { FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList5531_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypeDef5573  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypeDef5573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypeDef5573	= { FOLLOW_symbol_in_datatypeDef5573_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypeDef5590  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypeDef5590_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypeDef5590	= { FOLLOW_LPAREN_TOK_in_datatypeDef5590_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef5592  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef5592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef5592	= { FOLLOW_constructorDef_in_datatypeDef5592_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypeDef5595  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypeDef5595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypeDef5595	= { FOLLOW_RPAREN_TOK_in_datatypeDef5595_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_constructorDef5625  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_constructorDef5625_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_constructorDef5625	= { FOLLOW_symbol_in_constructorDef5625_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_constructorDef5640  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_constructorDef5640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_constructorDef5640	= { FOLLOW_LPAREN_TOK_in_constructorDef5640_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef5642  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef5642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef5642	= { FOLLOW_selector_in_constructorDef5642_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_constructorDef5645  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_constructorDef5645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_constructorDef5645	= { FOLLOW_RPAREN_TOK_in_constructorDef5645_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_selector5673  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_selector5673_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000010000808200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_selector5673	= { FOLLOW_symbol_in_selector5673_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_selector5676  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_selector5676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_selector5676	= { FOLLOW_sortSymbol_in_selector5676_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:159:1: parseExpr returns [CVC4::parser::smt2::myExpr expr] : ( term[expr, expr2] | EOF );
 */
static CVC4::parser::smt2::myExpr
parseExpr(pSmt2Parser ctx)
{
    CVC4::parser::smt2::myExpr expr;



      CVC4::api::Term expr2;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:163:3: ( term[expr, expr2] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case LPAREN_TOK:
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case STRING_LITERAL:
            case TUPLE_CONST_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:163:5: term[expr, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_term_in_parseExpr119);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:164:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr126);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:171:1: parseCommand returns [CVC4::Command* cmd_return = NULL] : ( LPAREN_TOK command[&cmd] RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF );
 */
static CVC4::Command*
parseCommand(pSmt2Parser ctx)
{
    CVC4::Command* cmd_return;



      std::unique_ptr<CVC4::Command> cmd;
      std::string name;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:179:3: ( LPAREN_TOK command[&cmd] RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case INCLUDE_TOK:
            			{
            				alt2=2;
            			}
            		    break;
            		case ASSERT_TOK:
            		case BLOCK_MODEL_TOK:
            		case BLOCK_MODEL_VALUES_TOK:
            		case CHECK_SAT_ASSUMING_TOK:
            		case CHECK_SAT_TOK:
            		case DECLARE_CODATATYPES_2_5_TOK:
            		case DECLARE_CODATATYPES_TOK:
            		case DECLARE_CODATATYPE_TOK:
            		case DECLARE_CONST_TOK:
            		case DECLARE_DATATYPES_2_5_TOK:
            		case DECLARE_DATATYPES_TOK:
            		case DECLARE_DATATYPE_TOK:
            		case DECLARE_FUNS_TOK:
            		case DECLARE_FUN_TOK:
            		case DECLARE_HEAP:
            		case DECLARE_PREDS_TOK:
            		case DECLARE_SORTS_TOK:
            		case DECLARE_SORT_TOK:
            		case DEFINE_CONST_TOK:
            		case DEFINE_FUNS_REC_TOK:
            		case DEFINE_FUN_REC_TOK:
            		case DEFINE_FUN_TOK:
            		case DEFINE_SORT_TOK:
            		case DEFINE_TOK:
            		case ECHO_TOK:
            		case EXIT_TOK:
            		case GET_ABDUCT_TOK:
            		case GET_ASSERTIONS_TOK:
            		case GET_ASSIGNMENT_TOK:
            		case GET_INFO_TOK:
            		case GET_MODEL_TOK:
            		case GET_OPTION_TOK:
            		case GET_PROOF_TOK:
            		case GET_QE_DISJUNCT_TOK:
            		case GET_QE_TOK:
            		case GET_UNSAT_ASSUMPTIONS_TOK:
            		case GET_UNSAT_CORE_TOK:
            		case GET_VALUE_TOK:
            		case POP_TOK:
            		case PUSH_TOK:
            		case RESET_ASSERTIONS_TOK:
            		case RESET_TOK:
            		case SET_INFO_TOK:
            		case SET_LOGIC_TOK:
            		case SET_OPTION_TOK:
            		case SIMPLE_SYMBOL:
            		case SIMPLIFY_TOK:
            			{
            				alt2=1;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 2;
            		    EXCEPTION->state        = 1;


            		    goto ruleparseCommandEx;

            		}

            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:179:5: LPAREN_TOK command[&cmd] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand157);
        	        command(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand160);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:184:5: LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_parseCommand175);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_str_in_parseCommand177);
        	        str(ctx, name, true);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand180);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {
        	             if(!PARSER_STATE->canIncludeFile()) {
        	                    PARSER_STATE->parseError("include-file feature was disabled for this "
        	                                             "run.");
        	                  }
        	                  if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError("Extended commands are not permitted while "
        	                                             "operating in strict compliance mode.");
        	                  }
        	                  PARSER_STATE->includeFile(name);
        	                  // The command of the included file will be produced at the next
        	                  // parseCommand() call
        	                  cmd.reset(new EmptyCommand("include::" + name));
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:199:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand193);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                      cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start parseSygus
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:207:1: parseSygus returns [CVC4::Command* cmd_return = NULL] : ( LPAREN_TOK cmd= sygusCommand RPAREN_TOK | EOF );
 */
static CVC4::Command*
parseSygus(pSmt2Parser ctx)
{
    CVC4::Command* cmd_return;



      std::string name;

    std::unique_ptr<CVC4::Command> cmd;
    #undef	RETURN_TYPE_cmd
    #define	RETURN_TYPE_cmd std::unique_ptr<CVC4::Command>

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:214:3: ( LPAREN_TOK cmd= sygusCommand RPAREN_TOK | EOF )

            ANTLR3_UINT32 alt3;

            alt3=2;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt3=1;
            	}
                break;
            case EOF:
            	{
            		alt3=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 3;
                EXCEPTION->state        = 0;


                goto ruleparseSygusEx;

            }

            switch (alt3)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:214:5: LPAREN_TOK cmd= sygusCommand RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseSygus222);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sygusCommand_in_parseSygus226);
        	        cmd=sygusCommand(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseSygus228);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:215:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseSygus234);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseSygusEx; /* Prevent compiler warnings */
    ruleparseSygusEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                      cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseSygus */

/**
 * $ANTLR start command
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:222:1: command[std::unique_ptr<CVC4::Command>* cmd] : ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK setInfoInternal[cmd] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK setOptionInternal[cmd] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd] | DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECK_SAT_TOK ( term[expr, expr2] |) | CHECK_SAT_ASSUMING_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | smt25Command[cmd] | extendedCommand[cmd] | SIMPLE_SYMBOL );
 */
static void
command(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::string name;
      std::vector<std::string> names;
      CVC4::api::Term expr, expr2;
      CVC4::api::Sort t;
      std::vector<CVC4::api::Term> terms;
      std::vector<api::Sort> sorts;
      std::vector<std::pair<std::string, CVC4::api::Sort> > sortedVarNames;
      std::vector<CVC4::api::Term> flattenVars;

    pANTLR3_COMMON_TOKEN    n;
    pANTLR3_COMMON_TOKEN    k;
    pANTLR3_COMMON_TOKEN    KEYWORD1;
    pANTLR3_COMMON_TOKEN    KEYWORD2;
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL3;

    /* Initialize rule variables
     */

    n       = NULL;
    k       = NULL;
    KEYWORD1       = NULL;
    KEYWORD2       = NULL;
    SIMPLE_SYMBOL3       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:233:3: ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK setInfoInternal[cmd] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK setOptionInternal[cmd] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd] | DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECK_SAT_TOK ( term[expr, expr2] |) | CHECK_SAT_ASSUMING_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | smt25Command[cmd] | extendedCommand[cmd] | SIMPLE_SYMBOL )

            ANTLR3_UINT32 alt9;

            alt9=26;

            switch ( LA(1) )
            {
            case SET_LOGIC_TOK:
            	{
            		alt9=1;
            	}
                break;
            case SET_INFO_TOK:
            	{
            		alt9=2;
            	}
                break;
            case GET_INFO_TOK:
            	{
            		alt9=3;
            	}
                break;
            case SET_OPTION_TOK:
            	{
            		alt9=4;
            	}
                break;
            case GET_OPTION_TOK:
            	{
            		alt9=5;
            	}
                break;
            case DECLARE_SORT_TOK:
            	{
            		alt9=6;
            	}
                break;
            case DEFINE_SORT_TOK:
            	{
            		alt9=7;
            	}
                break;
            case DECLARE_FUN_TOK:
            	{
            		alt9=8;
            	}
                break;
            case DEFINE_FUN_TOK:
            	{
            		alt9=9;
            	}
                break;
            case DECLARE_DATATYPE_TOK:
            	{
            		alt9=10;
            	}
                break;
            case DECLARE_DATATYPES_TOK:
            	{
            		alt9=11;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt9=12;
            	}
                break;
            case GET_ASSIGNMENT_TOK:
            	{
            		alt9=13;
            	}
                break;
            case ASSERT_TOK:
            	{
            		alt9=14;
            	}
                break;
            case CHECK_SAT_TOK:
            	{
            		alt9=15;
            	}
                break;
            case CHECK_SAT_ASSUMING_TOK:
            	{
            		alt9=16;
            	}
                break;
            case GET_ASSERTIONS_TOK:
            	{
            		alt9=17;
            	}
                break;
            case GET_PROOF_TOK:
            	{
            		alt9=18;
            	}
                break;
            case GET_UNSAT_ASSUMPTIONS_TOK:
            	{
            		alt9=19;
            	}
                break;
            case GET_UNSAT_CORE_TOK:
            	{
            		alt9=20;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt9=21;
            	}
                break;
            case POP_TOK:
            	{
            		alt9=22;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt9=23;
            	}
                break;
            case DECLARE_CONST_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case ECHO_TOK:
            case GET_MODEL_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            	{
            		alt9=24;
            	}
                break;
            case BLOCK_MODEL_TOK:
            case BLOCK_MODEL_VALUES_TOK:
            case DECLARE_CODATATYPES_2_5_TOK:
            case DECLARE_CODATATYPES_TOK:
            case DECLARE_CODATATYPE_TOK:
            case DECLARE_DATATYPES_2_5_TOK:
            case DECLARE_FUNS_TOK:
            case DECLARE_HEAP:
            case DECLARE_PREDS_TOK:
            case DECLARE_SORTS_TOK:
            case DEFINE_CONST_TOK:
            case DEFINE_TOK:
            case GET_ABDUCT_TOK:
            case GET_QE_DISJUNCT_TOK:
            case GET_QE_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt9=25;
            	}
                break;
            case SIMPLE_SYMBOL:
            	{
            		alt9=26;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 9;
                EXCEPTION->state        = 0;


                goto rulecommandEx;

            }

            switch (alt9)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:234:5: SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT]
        	    {
        	         MATCHT(SET_LOGIC_TOK, &FOLLOW_SET_LOGIC_TOK_in_command262);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command264);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {

        	                  cmd->reset(PARSER_STATE->setLogic(name));
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:239:5: SET_INFO_TOK setInfoInternal[cmd]
        	    {
        	         MATCHT(SET_INFO_TOK, &FOLLOW_SET_INFO_TOK_in_command283);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_setInfoInternal_in_command285);
        	        setInfoInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:241:5: GET_INFO_TOK KEYWORD
        	    {
        	         MATCHT(GET_INFO_TOK, &FOLLOW_GET_INFO_TOK_in_command298);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        KEYWORD1 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command300);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new GetInfoCommand(
        	                      AntlrInput::tokenText(KEYWORD1).c_str() + 1));
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:246:5: SET_OPTION_TOK setOptionInternal[cmd]
        	    {
        	         MATCHT(SET_OPTION_TOK, &FOLLOW_SET_OPTION_TOK_in_command318);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_setOptionInternal_in_command320);
        	        setOptionInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:248:5: GET_OPTION_TOK KEYWORD
        	    {
        	         MATCHT(GET_OPTION_TOK, &FOLLOW_GET_OPTION_TOK_in_command333);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        KEYWORD2 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command335);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new GetOptionCommand(
        	                      AntlrInput::tokenText(KEYWORD2).c_str() + 1));
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:253:5: DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL
        	    {
        	         MATCHT(DECLARE_SORT_TOK, &FOLLOW_DECLARE_SORT_TOK_in_command353);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {

        	                  PARSER_STATE->checkThatLogicIsSet();
        	                  PARSER_STATE->checkLogicAllowsFreeSorts();
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command365);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command380);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "declare sort: '" << name
        	                                  << "' arity=" << n << std::endl;
        	                  unsigned arity = AntlrInput::tokenToUnsigned(n);
        	                  if(arity == 0) {
        	                    api::Sort type = PARSER_STATE->mkSort(name);
        	                    cmd->reset(new DeclareTypeCommand(name, 0, type.getType()));
        	                  } else {
        	                    api::Sort type = PARSER_STATE->mkSortConstructor(name, arity);
        	                    cmd->reset(new DeclareTypeCommand(name, arity, type.getType()));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:273:5: DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DEFINE_SORT_TOK, &FOLLOW_DEFINE_SORT_TOK_in_command398);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command406);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command419);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolList_in_command421);
        	        symbolList(ctx, names, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command424);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::string>::const_iterator i = names.begin(),
        	                        iend = names.end();
        	                      i != iend;
        	                      ++i) {
        	                    sorts.push_back(PARSER_STATE->mkSort(*i));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command436);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  // Do NOT call mkSort, since that creates a new sort!
        	                  // This name is not its own distinct sort, it's an alias.
        	                  PARSER_STATE->defineParameterizedType(name, sorts, t);
        	                  cmd->reset(new DefineTypeCommand(
        	                      name, api::sortVectorToTypes(sorts), t.getType()));
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:294:5: DECLARE_FUN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_FUN_TOK, &FOLLOW_DECLARE_FUN_TOK_in_command455);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command463);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command476);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortList_in_command478);
        	        sortList(ctx, sorts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command481);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command487);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "declare fun: '" << name << "'" << std::endl;
        	                  if( !sorts.empty() ) {
        	                    t = PARSER_STATE->mkFlatFunctionType(sorts, t);
        	                  }
        	                  if(t.isFunction())
        	                  {
        	                    PARSER_STATE->checkLogicAllowsFunctions();
        	                  }
        	                  // we allow overloading for function declarations
        	                  if (PARSER_STATE->sygus_v1())
        	                  {
        	                    // it is a higher-order universal variable
        	                    api::Term func = PARSER_STATE->bindBoundVar(name, t);
        	                    cmd->reset(
        	                        new DeclareSygusFunctionCommand(name, func.getExpr(), t.getType()));
        	                  }
        	                  else if( PARSER_STATE->sygus() )
        	                  {
        	                    PARSER_STATE->parseErrorLogic("declare-fun are not allowed in sygus "
        	                                                  "version 2.0");
        	                  }
        	                  else
        	                  {
        	                    api::Term func =
        	                        PARSER_STATE->bindVar(name, t, ExprManager::VAR_FLAG_NONE, true);
        	                    cmd->reset(
        	                        new DeclareFunctionCommand(name, func.getExpr(), t.getType()));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:329:5: DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_FUN_TOK, &FOLLOW_DEFINE_FUN_TOK_in_command506);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command514);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command527);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_command529);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command532);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command538);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	                  if( sortedVarNames.size() > 0 ) {
        	                    sorts.reserve(sortedVarNames.size());
        	                    for(std::vector<std::pair<std::string, api::Sort> >::const_iterator i =
        	                          sortedVarNames.begin(), iend = sortedVarNames.end();
        	                        i != iend;
        	                        ++i) {
        	                      sorts.push_back((*i).second);
        	                    }
        	                    t = PARSER_STATE->mkFlatFunctionType(sorts, t, flattenVars);
        	                  }
        	                  PARSER_STATE->pushScope(true);
        	                  terms = PARSER_STATE->bindBoundVars(sortedVarNames);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command551);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {

        	                  if( !flattenVars.empty() ){
        	                    // if this function has any implicit variables flattenVars,
        	                    // we apply the body of the definition to the flatten vars
        	                    expr = PARSER_STATE->mkHoApply(expr, flattenVars);
        	                    terms.insert(terms.end(), flattenVars.begin(), flattenVars.end());
        	                  }
        	                  PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  // we allow overloading for function definitions
        	                  api::Term func = PARSER_STATE->bindVar(name, t,
        	                                                  ExprManager::VAR_FLAG_DEFINED, true);
        	                  cmd->reset(
        	                      new DefineFunctionCommand(name,
        	                                                func.getExpr(),
        	                                                api::termVectorToExprs(terms),
        	                                                expr.getExpr(),
        	                                                PARSER_STATE->getGlobalDeclarations()));
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:371:5: DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPE_TOK, &FOLLOW_DECLARE_DATATYPE_TOK_in_command564);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDefCommand_in_command566);
        	        datatypeDefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 11:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:372:5: DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPES_TOK, &FOLLOW_DECLARE_DATATYPES_TOK_in_command573);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_command575);
        	        datatypesDefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 12:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:374:5: GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_command588);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:375:5: ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	        {
        	            int alt4=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt4=1;
        	            	}
        	                break;
        	            case ALPHA:
        	            case ASSERT_TOK:
        	            case AS_TOK:
        	            case ATTRIBUTE_INST_LEVEL:
        	            case ATTRIBUTE_NAMED_TOK:
        	            case ATTRIBUTE_NO_PATTERN_TOK:
        	            case ATTRIBUTE_PATTERN_TOK:
        	            case ATTRIBUTE_TOK:
        	            case BINARY_LITERAL:
        	            case BLOCK_MODEL_TOK:
        	            case BLOCK_MODEL_VALUES_TOK:
        	            case CHAR_TOK:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case COMMENT:
        	            case COMPREHENSION_TOK:
        	            case CONSTRAINT_TOK:
        	            case CONST_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_CODATATYPES_2_5_TOK:
        	            case DECLARE_CODATATYPES_TOK:
        	            case DECLARE_CODATATYPE_TOK:
        	            case DECLARE_CONST_TOK:
        	            case DECLARE_DATATYPES_2_5_TOK:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_DATATYPE_TOK:
        	            case DECLARE_FUNS_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_HEAP:
        	            case DECLARE_PREDS_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORTS_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_CONST_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DEFINE_TOK:
        	            case DIGIT:
        	            case ECHO_TOK:
        	            case EMP_TOK:
        	            case EXISTS_TOK:
        	            case EXIT_TOK:
        	            case FORALL_TOK:
        	            case GET_ABDUCT_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_QE_DISJUNCT_TOK:
        	            case GET_QE_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case HEX_DIGIT:
        	            case HEX_LITERAL:
        	            case HO_ARROW_TOK:
        	            case HO_LAMBDA_TOK:
        	            case INCLUDE_TOK:
        	            case INDEX_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case KEYWORD:
        	            case LET_TOK:
        	            case MATCH_TOK:
        	            case NUMERAL:
        	            case PAR_TOK:
        	            case POP_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case RPAREN_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STRING_LITERAL:
        	            case SYGUS_CONSTANT_TOK:
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            case SYGUS_LET_TOK:
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            case SYGUS_VARIABLE_TOK:
        	            case SYMBOL_CHAR:
        	            case SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_FUN_V1_TOK:
        	            case SYNTH_INV_TOK:
        	            case SYNTH_INV_V1_TOK:
        	            case TESTER_TOK:
        	            case TUPLE_CONST_TOK:
        	            case TUPLE_SEL_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case WHITESPACE:
        	            case 106:
        	            	{
        	            		alt4=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 4;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt4)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:375:7: LPAREN_TOK termList[terms,expr] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command598);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_command600);
        	        	        termList(ctx, terms, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command603);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new GetValueCommand(api::termVectorToExprs(terms))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:377:7: ~ LPAREN_TOK
        	        	    {
        	        	        if ( ((LA(1) >= ALPHA) && (LA(1) <= LET_TOK)) || ((LA(1) >= MATCH_TOK) && (LA(1) <= 106)) )
        	        	        {
        	        	            CONSUME();
        	        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        	        }
        	        	        else
        	        	        {
        	        	            CONSTRUCTEX();
        	        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	        	            EXCEPTION->expectingSet = NULL;

        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->parseError("The get-value command expects a list of "
        	        	                                             "terms.  Perhaps you forgot a pair of "
        	        	                                             "parentheses?");
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 13:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:384:5: GET_ASSIGNMENT_TOK
        	    {
        	         MATCHT(GET_ASSIGNMENT_TOK, &FOLLOW_GET_ASSIGNMENT_TOK_in_command646);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetAssignmentCommand()); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:387:5: ASSERT_TOK term[expr, expr2]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_command666);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             PARSER_STATE->clearLastNamedTerm(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command680);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             bool inUnsatCore = PARSER_STATE->lastNamedTerm().first == expr;
        	                  cmd->reset(new AssertCommand(expr.getExpr(), inUnsatCore));
        	                  if(inUnsatCore) {
        	                    // set the expression name, if there was a named term
        	                    std::pair<api::Term, std::string> namedTerm =
        	                        PARSER_STATE->lastNamedTerm();
        	                    Command* csen = new SetExpressionNameCommand(namedTerm.first.getExpr(),
        	                                                                 namedTerm.second);
        	                    csen->setMuted(true);
        	                    PARSER_STATE->preemptCommand(csen);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 15:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:403:5: CHECK_SAT_TOK ( term[expr, expr2] |)
        	    {
        	         MATCHT(CHECK_SAT_TOK, &FOLLOW_CHECK_SAT_TOK_in_command699);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support check-sat command.");
        	                  }
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:408:5: ( term[expr, expr2] |)
        	        {
        	            int alt5=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case SIMPLE_SYMBOL:
        	            case STRING_LITERAL:
        	            case TUPLE_CONST_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt5=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt5=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 5;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt5)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:408:7: term[expr, expr2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_term_in_command715);
        	        	        term(ctx, expr, expr2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Extended commands (such as check-sat with an argument) are not "
        	        	                          "permitted while operating in strict compliance mode.");
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:415:7: 
        	        	    {
        	        	        {
        	        	             expr = api::Term(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             cmd->reset(new CheckSatCommand(expr.getExpr())); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:419:5: CHECK_SAT_ASSUMING_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	    {
        	         MATCHT(CHECK_SAT_ASSUMING_TOK, &FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command756);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:420:5: ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	        {
        	            int alt6=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt6=1;
        	            	}
        	                break;
        	            case ALPHA:
        	            case ASSERT_TOK:
        	            case AS_TOK:
        	            case ATTRIBUTE_INST_LEVEL:
        	            case ATTRIBUTE_NAMED_TOK:
        	            case ATTRIBUTE_NO_PATTERN_TOK:
        	            case ATTRIBUTE_PATTERN_TOK:
        	            case ATTRIBUTE_TOK:
        	            case BINARY_LITERAL:
        	            case BLOCK_MODEL_TOK:
        	            case BLOCK_MODEL_VALUES_TOK:
        	            case CHAR_TOK:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case COMMENT:
        	            case COMPREHENSION_TOK:
        	            case CONSTRAINT_TOK:
        	            case CONST_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_CODATATYPES_2_5_TOK:
        	            case DECLARE_CODATATYPES_TOK:
        	            case DECLARE_CODATATYPE_TOK:
        	            case DECLARE_CONST_TOK:
        	            case DECLARE_DATATYPES_2_5_TOK:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_DATATYPE_TOK:
        	            case DECLARE_FUNS_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_HEAP:
        	            case DECLARE_PREDS_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORTS_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_CONST_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DEFINE_TOK:
        	            case DIGIT:
        	            case ECHO_TOK:
        	            case EMP_TOK:
        	            case EXISTS_TOK:
        	            case EXIT_TOK:
        	            case FORALL_TOK:
        	            case GET_ABDUCT_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_QE_DISJUNCT_TOK:
        	            case GET_QE_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case HEX_DIGIT:
        	            case HEX_LITERAL:
        	            case HO_ARROW_TOK:
        	            case HO_LAMBDA_TOK:
        	            case INCLUDE_TOK:
        	            case INDEX_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case KEYWORD:
        	            case LET_TOK:
        	            case MATCH_TOK:
        	            case NUMERAL:
        	            case PAR_TOK:
        	            case POP_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case RPAREN_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STRING_LITERAL:
        	            case SYGUS_CONSTANT_TOK:
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            case SYGUS_LET_TOK:
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            case SYGUS_VARIABLE_TOK:
        	            case SYMBOL_CHAR:
        	            case SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_FUN_V1_TOK:
        	            case SYNTH_INV_TOK:
        	            case SYNTH_INV_V1_TOK:
        	            case TESTER_TOK:
        	            case TUPLE_CONST_TOK:
        	            case TUPLE_SEL_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case WHITESPACE:
        	            case 106:
        	            	{
        	            		alt6=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 6;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt6)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:420:7: LPAREN_TOK termList[terms,expr] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command766);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_command768);
        	        	        termList(ctx, terms, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command771);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {

        	        	                    cmd->reset(new CheckSatAssumingCommand(api::termVectorToExprs(terms)));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:424:7: ~ LPAREN_TOK
        	        	    {
        	        	        if ( ((LA(1) >= ALPHA) && (LA(1) <= LET_TOK)) || ((LA(1) >= MATCH_TOK) && (LA(1) <= 106)) )
        	        	        {
        	        	            CONSUME();
        	        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        	        }
        	        	        else
        	        	        {
        	        	            CONSTRUCTEX();
        	        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	        	            EXCEPTION->expectingSet = NULL;

        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->parseError("The check-sat-assuming command expects a "
        	        	                                             "list of terms.  Perhaps you forgot a pair of "
        	        	                                             "parentheses?");
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 17:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:431:5: GET_ASSERTIONS_TOK
        	    {
        	         MATCHT(GET_ASSERTIONS_TOK, &FOLLOW_GET_ASSERTIONS_TOK_in_command814);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetAssertionsCommand()); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:434:5: GET_PROOF_TOK
        	    {
        	         MATCHT(GET_PROOF_TOK, &FOLLOW_GET_PROOF_TOK_in_command834);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetProofCommand()); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:437:5: GET_UNSAT_ASSUMPTIONS_TOK
        	    {
        	         MATCHT(GET_UNSAT_ASSUMPTIONS_TOK, &FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command854);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetUnsatAssumptionsCommand); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:440:5: GET_UNSAT_CORE_TOK
        	    {
        	         MATCHT(GET_UNSAT_CORE_TOK, &FOLLOW_GET_UNSAT_CORE_TOK_in_command874);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetUnsatCoreCommand); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:443:5: PUSH_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_command894);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support push command.");
        	                  }
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:448:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt7=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt7=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt7=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 7;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt7)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:448:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command912);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             unsigned num = AntlrInput::tokenToUnsigned(k);
        	        	                    if(num == 0) {
        	        	                      cmd->reset(new EmptyCommand());
        	        	                    } else if(num == 1) {
        	        	                      PARSER_STATE->pushScope();
        	        	                      cmd->reset(new PushCommand());
        	        	                    } else {
        	        	                      std::unique_ptr<CommandSequence> seq(new CommandSequence());
        	        	                      do {
        	        	                        PARSER_STATE->pushScope();
        	        	                        Command* push_cmd = new PushCommand();
        	        	                        push_cmd->setMuted(num > 1);
        	        	                        seq->addCommand(push_cmd);
        	        	                        --num;
        	        	                        } while(num > 0);
        	        	                      cmd->reset(seq.release());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:467:7: 
        	        	    {
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Strict compliance mode demands an integer to be provided to "
        	        	                          "PUSH.  Maybe you want (push 1)?");
        	        	                    } else {
        	        	                      PARSER_STATE->pushScope();
        	        	                      cmd->reset(new PushCommand());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 22:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:476:5: POP_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_command936);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support pop command.");
        	                  }
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:481:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt8=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:481:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command954);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             unsigned num = AntlrInput::tokenToUnsigned(k);
        	        	                    if(num > PARSER_STATE->scopeLevel()) {
        	        	                      PARSER_STATE->parseError("Attempted to pop above the top stack "
        	        	                                               "frame.");
        	        	                    }
        	        	                    if(num == 0) {
        	        	                      cmd->reset(new EmptyCommand());
        	        	                    } else if(num == 1) {
        	        	                      PARSER_STATE->popScope();
        	        	                      cmd->reset(new PopCommand());
        	        	                    } else {
        	        	                      std::unique_ptr<CommandSequence> seq(new CommandSequence());
        	        	                      do {
        	        	                        PARSER_STATE->popScope();
        	        	                        Command* pop_command = new PopCommand();
        	        	                        pop_command->setMuted(num > 1);
        	        	                        seq->addCommand(pop_command);
        	        	                        --num;
        	        	                      } while(num > 0);
        	        	                      cmd->reset(seq.release());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:504:7: 
        	        	    {
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Strict compliance mode demands an integer to be provided to POP."
        	        	                          "Maybe you want (pop 1)?");
        	        	                    } else {
        	        	                      PARSER_STATE->popScope();
        	        	                      cmd->reset(new PopCommand());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 23:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:515:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_command988);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new QuitCommand()); 
        	        }


        	    }
        	    break;
        	case 24:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:519:5: smt25Command[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_smt25Command_in_command1007);
        	        smt25Command(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             if(PARSER_STATE->v2_0() && PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError(
        	                        "SMT-LIB 2.5 commands are not permitted while operating in strict "
        	                        "compliance mode and in SMT-LIB 2.0 mode.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 25:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:528:5: extendedCommand[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_extendedCommand_in_command1027);
        	        extendedCommand(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError(
        	                        "Extended commands are not permitted while operating in strict "
        	                        "compliance mode.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 26:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:537:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL3 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_command1047);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             std::string id = AntlrInput::tokenText(SIMPLE_SYMBOL3);
        	                  if(id == "benchmark") {
        	                    PARSER_STATE->parseError(
        	                        "In SMT-LIBv2 mode, but got something that looks like SMT-LIBv1, "
        	                        "which is not supported anymore.");
        	                  } else {
        	                    PARSER_STATE->parseError("expected SMT-LIBv2 command, got `" + id +
        	                                             "'.");
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end command */

/**
 * $ANTLR start sygusCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:550:1: sygusCommand returns [std::unique_ptr<CVC4::Command> cmd] : ( DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | ( SYNTH_FUN_V1_TOK | SYNTH_INV_V1_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( sygusGrammarV1[grammar, synthFunFactory->getSygusVars(), fun] )? | ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( sygusGrammar[grammar, synthFunFactory->getSygusVars(), fun] )? | CONSTRAINT_TOK term[expr, expr2] | INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+ | CHECK_SYNTH_TOK | command[&cmd] );
 */
static std::unique_ptr<CVC4::Command>
sygusCommand(pSmt2Parser ctx)
{
    std::unique_ptr<CVC4::Command> cmd;



      CVC4::api::Term expr, expr2;
      CVC4::api::Sort t, range;
      std::vector<std::string> names;
      std::vector<std::pair<std::string, CVC4::api::Sort> > sortedVarNames;
      std::unique_ptr<Smt2::SynthFunFactory> synthFunFactory;
      std::string name, fun;
      bool isInv;
      CVC4::api::Sort grammar;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:561:3: ( DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | ( SYNTH_FUN_V1_TOK | SYNTH_INV_V1_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( sygusGrammarV1[grammar, synthFunFactory->getSygusVars(), fun] )? | ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( sygusGrammar[grammar, synthFunFactory->getSygusVars(), fun] )? | CONSTRAINT_TOK term[expr, expr2] | INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+ | CHECK_SYNTH_TOK | command[&cmd] )

            ANTLR3_UINT32 alt17;

            alt17=8;

            switch ( LA(1) )
            {
            case DECLARE_VAR_TOK:
            	{
            		alt17=1;
            	}
                break;
            case DECLARE_PRIMED_VAR_TOK:
            	{
            		alt17=2;
            	}
                break;
            case SYNTH_FUN_V1_TOK:
            case SYNTH_INV_V1_TOK:
            	{
            		alt17=3;
            	}
                break;
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            	{
            		alt17=4;
            	}
                break;
            case CONSTRAINT_TOK:
            	{
            		alt17=5;
            	}
                break;
            case INV_CONSTRAINT_TOK:
            	{
            		alt17=6;
            	}
                break;
            case CHECK_SYNTH_TOK:
            	{
            		alt17=7;
            	}
                break;
            case ASSERT_TOK:
            case BLOCK_MODEL_TOK:
            case BLOCK_MODEL_VALUES_TOK:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case DECLARE_CODATATYPES_2_5_TOK:
            case DECLARE_CODATATYPES_TOK:
            case DECLARE_CODATATYPE_TOK:
            case DECLARE_CONST_TOK:
            case DECLARE_DATATYPES_2_5_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_DATATYPE_TOK:
            case DECLARE_FUNS_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_HEAP:
            case DECLARE_PREDS_TOK:
            case DECLARE_SORTS_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_CONST_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DEFINE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ABDUCT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_QE_DISJUNCT_TOK:
            case GET_QE_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case POP_TOK:
            case PUSH_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            	{
            		alt17=8;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 17;
                EXCEPTION->state        = 0;


                goto rulesygusCommandEx;

            }

            switch (alt17)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:562:5: DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_VAR_TOK, &FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1081);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1089);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1102);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {

        	                  api::Term var = PARSER_STATE->bindBoundVar(name, t);
        	                  cmd.reset(new DeclareSygusVarCommand(name, var.getExpr(), t.getType()));
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:571:5: DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_PRIMED_VAR_TOK, &FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1121);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1129);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1142);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {

        	                  // spurious command, we do not need to create a variable. We only keep
        	                  // track of the command for sanity checking / dumping
        	                  cmd.reset(new DeclareSygusPrimedVarCommand(name, t.getType()));
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:582:5: ( SYNTH_FUN_V1_TOK | SYNTH_INV_V1_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( sygusGrammarV1[grammar, synthFunFactory->getSygusVars(), fun] )?
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:582:5: ( SYNTH_FUN_V1_TOK | SYNTH_INV_V1_TOK )
        	        {
        	            int alt10=2;
        	            switch ( LA(1) )
        	            {
        	            case SYNTH_FUN_V1_TOK:
        	            	{
        	            		alt10=1;
        	            	}
        	                break;
        	            case SYNTH_INV_V1_TOK:
        	            	{
        	            		alt10=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 10;
        	                EXCEPTION->state        = 0;


        	                goto rulesygusCommandEx;

        	            }

        	            switch (alt10)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:582:7: SYNTH_FUN_V1_TOK
        	        	    {
        	        	         MATCHT(SYNTH_FUN_V1_TOK, &FOLLOW_SYNTH_FUN_V1_TOK_in_sygusCommand1164);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             isInv = false; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:583:9: SYNTH_INV_V1_TOK
        	        	    {
        	        	         MATCHT(SYNTH_INV_V1_TOK, &FOLLOW_SYNTH_INV_V1_TOK_in_sygusCommand1176);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             isInv = true; range = SOLVER->getBooleanSort(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1196);
        	        symbol(ctx, fun, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1203);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_sygusCommand1205);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1208);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:588:5: ( sortSymbol[range,CHECK_DECLARED] )?
        	        {
        	            int alt11=2;
        	            switch ( LA(1) )
        	            {
        	                case QUOTED_SYMBOL:
        	                case SIMPLE_SYMBOL:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                	{
        	                		alt11=1;
        	                	}
        	                    break;
        	                case LPAREN_TOK:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case HO_ARROW_TOK:
        	                		    case INDEX_TOK:
        	                		    case QUOTED_SYMBOL:
        	                		    case SIMPLE_SYMBOL:
        	                		    case UNTERMINATED_QUOTED_SYMBOL:
        	                		    	{
        	                		    		alt11=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt11)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:588:7: sortSymbol[range,CHECK_DECLARED]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1216);
        	        	        sortSymbol(ctx, range, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  synthFunFactory.reset(new Smt2::SynthFunFactory(
        	                      PARSER_STATE, fun, isInv, range, sortedVarNames));
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:593:5: ( sygusGrammarV1[grammar, synthFunFactory->getSygusVars(), fun] )?
        	        {
        	            int alt12=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt12=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt12)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:598:7: sygusGrammarV1[grammar, synthFunFactory->getSygusVars(), fun]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sygusGrammarV1_in_sygusCommand1268);
        	        	        sygusGrammarV1(ctx, grammar, synthFunFactory->getSygusVars(), fun);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  cmd = synthFunFactory->mkCommand(grammar);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:604:5: ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( sygusGrammar[grammar, synthFunFactory->getSygusVars(), fun] )?
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:604:5: ( SYNTH_FUN_TOK | SYNTH_INV_TOK )
        	        {
        	            int alt13=2;
        	            switch ( LA(1) )
        	            {
        	            case SYNTH_FUN_TOK:
        	            	{
        	            		alt13=1;
        	            	}
        	                break;
        	            case SYNTH_INV_TOK:
        	            	{
        	            		alt13=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 13;
        	                EXCEPTION->state        = 0;


        	                goto rulesygusCommandEx;

        	            }

        	            switch (alt13)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:604:7: SYNTH_FUN_TOK
        	        	    {
        	        	         MATCHT(SYNTH_FUN_TOK, &FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1296);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             isInv = false; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:605:9: SYNTH_INV_TOK
        	        	    {
        	        	         MATCHT(SYNTH_INV_TOK, &FOLLOW_SYNTH_INV_TOK_in_sygusCommand1308);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             isInv = true; range = SOLVER->getBooleanSort(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1328);
        	        symbol(ctx, fun, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1335);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_sygusCommand1337);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1340);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:610:5: ( sortSymbol[range,CHECK_DECLARED] )?
        	        {
        	            int alt14=2;
        	            switch ( LA(1) )
        	            {
        	                case QUOTED_SYMBOL:
        	                case SIMPLE_SYMBOL:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                	{
        	                		alt14=1;
        	                	}
        	                    break;
        	                case LPAREN_TOK:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case HO_ARROW_TOK:
        	                		    case INDEX_TOK:
        	                		    case QUOTED_SYMBOL:
        	                		    case SIMPLE_SYMBOL:
        	                		    case UNTERMINATED_QUOTED_SYMBOL:
        	                		    	{
        	                		    		alt14=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt14)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:610:7: sortSymbol[range,CHECK_DECLARED]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1348);
        	        	        sortSymbol(ctx, range, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  synthFunFactory.reset(new Smt2::SynthFunFactory(
        	                      PARSER_STATE, fun, isInv, range, sortedVarNames));
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:615:5: ( sygusGrammar[grammar, synthFunFactory->getSygusVars(), fun] )?
        	        {
        	            int alt15=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt15=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt15)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:620:7: sygusGrammar[grammar, synthFunFactory->getSygusVars(), fun]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sygusGrammar_in_sygusCommand1400);
        	        	        sygusGrammar(ctx, grammar, synthFunFactory->getSygusVars(), fun);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  cmd = synthFunFactory->mkCommand(grammar);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:626:5: CONSTRAINT_TOK term[expr, expr2]
        	    {
        	         MATCHT(CONSTRAINT_TOK, &FOLLOW_CONSTRAINT_TOK_in_sygusCommand1426);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {

        	                  PARSER_STATE->checkThatLogicIsSet();
        	                  Debug("parser-sygus") << "Sygus : define sygus funs..." << std::endl;
        	                  Debug("parser-sygus") << "Sygus : read constraint..." << std::endl;
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_sygusCommand1434);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "...read constraint " << expr << std::endl;
        	                  cmd.reset(new SygusConstraintCommand(expr.getExpr()));
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:636:5: INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+
        	    {
        	         MATCHT(INV_CONSTRAINT_TOK, &FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1453);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:637:5: ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+
        	        {
        	            int cnt16=0;

        	            for (;;)
        	            {
        	                int alt16=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case QUOTED_SYMBOL:
        	        	case SIMPLE_SYMBOL:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        		{
        	        			alt16=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt16)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:637:7: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1461);
        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesygusCommandEx;
        	        	            }


        	        	            {
        	        	                 names.push_back(name); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt16 >= 1 )
        	        		{
        	        		    goto loop16;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesygusCommandEx;
        	        	}
        	        	cnt16++;
        	            }
        	            loop16: ;	/* Jump to here if this rule does not match */
        	        }

        	        {

        	                  cmd = PARSER_STATE->invConstraint(names);
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:642:5: CHECK_SYNTH_TOK
        	    {
        	         MATCHT(CHECK_SYNTH_TOK, &FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1485);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {

        	                  cmd.reset(new CheckSynthCommand());
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:647:5: command[&cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_command_in_sygusCommand1503);
        	        command(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesygusCommandEx; /* Prevent compiler warnings */
    rulesygusCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return cmd;
}
/* $ANTLR end sygusCommand */

/**
 * $ANTLR start sygusGrammarV1
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:659:1: sygusGrammarV1[CVC4::api::Sort & ret,\n const std::vector<CVC4::api::Term>& sygus_vars,\n const std::string& fun] : LPAREN_TOK ( LPAREN_TOK symbol[name, CHECK_NONE, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
sygusGrammarV1(pSmt2Parser ctx, CVC4::api::Sort & ret, const std::vector<CVC4::api::Term>& sygus_vars, const std::string& fun)
{

      CVC4::api::Sort t;
      std::string name;
      unsigned startIndex = 0;
      std::vector<std::vector<CVC4::SygusGTerm>> sgts;
      std::vector<api::DatatypeDecl> datatypes;
      std::vector<api::Sort> sorts;
      std::vector<std::vector<ParseOp>> ops;
      std::vector<std::vector<std::string>> cnames;
      std::vector<std::vector<std::vector<CVC4::api::Sort>>> cargs;
      std::vector<bool> allow_const;
      std::vector<std::vector<std::string>> unresolved_gterm_sym;
      std::map<CVC4::api::Sort, CVC4::api::Sort> sygus_to_builtin;
      std::map<CVC4::api::Sort, CVC4::api::Term> sygus_to_builtin_expr;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:678:3: ( LPAREN_TOK ( LPAREN_TOK symbol[name, CHECK_NONE, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:678:5: LPAREN_TOK ( LPAREN_TOK symbol[name, CHECK_NONE, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammarV11525);
            if  (HASEXCEPTION())
            {
                goto rulesygusGrammarV1Ex;
            }


            {
                 PARSER_STATE->pushScope(); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:679:3: ( LPAREN_TOK symbol[name, CHECK_NONE, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+
            {
                int cnt19=0;

                for (;;)
                {
                    int alt19=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt19=1;
            		}
            	    break;

            	}

            	switch (alt19)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:679:4: LPAREN_TOK symbol[name, CHECK_NONE, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammarV11532);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarV1Ex;
            	            }


            	            FOLLOWPUSH(FOLLOW_symbol_in_sygusGrammarV11541);
            	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarV1Ex;
            	            }


            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGrammarV11544);
            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarV1Ex;
            	            }


            	            {

            	                         if (name == "Start")
            	                         {
            	                           startIndex = datatypes.size();
            	                         }
            	                         sgts.push_back(std::vector<CVC4::SygusGTerm>());
            	                         sgts.back().push_back(CVC4::SygusGTerm());
            	                         PARSER_STATE->pushSygusDatatypeDef(t,
            	                                                            name,
            	                                                            datatypes,
            	                                                            sorts,
            	                                                            ops,
            	                                                            cnames,
            	                                                            cargs,
            	                                                            allow_const,
            	                                                            unresolved_gterm_sym);
            	                         api::Sort unres_t;
            	                         if (!PARSER_STATE->isUnresolvedType(name))
            	                         {
            	                           // if not unresolved, must be undeclared
            	                           Debug("parser-sygus") << "Make unresolved type : " << name
            	                                                 << std::endl;
            	                           PARSER_STATE->checkDeclaration(name, CHECK_UNDECLARED, SYM_SORT);
            	                           unres_t = PARSER_STATE->mkUnresolvedType(name);
            	                         }
            	                         else
            	                         {
            	                           Debug("parser-sygus") << "Get sort : " << name << std::endl;
            	                           unres_t = PARSER_STATE->getSort(name);
            	                         }
            	                         sygus_to_builtin[unres_t] = t;
            	                         Debug("parser-sygus") << "--- Read sygus grammar " << name
            	                                               << " under function " << fun << "..."
            	                                               << std::endl
            	                                               << "    type to resolve " << unres_t << std::endl
            	                                               << "    builtin type " << t << std::endl;
            	                       
            	            }


            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammarV11560);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarV1Ex;
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:719:14: ( sygusGTerm[sgts.back().back(), fun] )+
            	            {
            	                int cnt18=0;

            	                for (;;)
            	                {
            	                    int alt18=2;
            	            	switch ( LA(1) )
            	            	{
            	            	case BINARY_LITERAL:
            	            	case DECIMAL_LITERAL:
            	            	case HEX_LITERAL:
            	            	case INTEGER_LITERAL:
            	            	case LPAREN_TOK:
            	            	case QUOTED_SYMBOL:
            	            	case SIMPLE_SYMBOL:
            	            	case STRING_LITERAL:
            	            	case TUPLE_CONST_TOK:
            	            	case UNTERMINATED_QUOTED_SYMBOL:
            	            		{
            	            			alt18=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt18)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:719:15: sygusGTerm[sgts.back().back(), fun]
            	            	        {
            	            	            FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusGrammarV11562);
            	            	            sygusGTerm(ctx, sgts.back().back(), fun);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarV1Ex;
            	            	            }


            	            	            {

            	            	                     sgts.back().push_back(CVC4::SygusGTerm());
            	            	                   
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt18 >= 1 )
            	            		{
            	            		    goto loop18;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto rulesygusGrammarV1Ex;
            	            	}
            	            	cnt18++;
            	                }
            	                loop18: ;	/* Jump to here if this rule does not match */
            	            }

            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammarV11573);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarV1Ex;
            	            }


            	            {
            	                 sgts.back().pop_back(); 
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammarV11577);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarV1Ex;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt19 >= 1 )
            		{
            		    goto loop19;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulesygusGrammarV1Ex;
            	}
            	cnt19++;
                }
                loop19: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammarV11588);
            if  (HASEXCEPTION())
            {
                goto rulesygusGrammarV1Ex;
            }


            {

                    unsigned numSTerms = sgts.size();
                    Debug("parser-sygus") << "--- Process " << numSTerms << " sygus gterms..."
                                          << std::endl;
                    for (unsigned i = 0; i < numSTerms; i++)
                    {
                      for (unsigned j = 0, size = sgts[i].size(); j < size; j++)
                      {
                        api::Sort sub_ret;
                        PARSER_STATE->processSygusGTerm(sgts[i][j],
                                                        i,
                                                        datatypes,
                                                        sorts,
                                                        ops,
                                                        cnames,
                                                        cargs,
                                                        allow_const,
                                                        unresolved_gterm_sym,
                                                        sygus_vars,
                                                        sygus_to_builtin,
                                                        sygus_to_builtin_expr,
                                                        sub_ret);
                      }
                    }
                    // swap index if necessary
                    Debug("parser-sygus") << "--- Making sygus datatypes..." << std::endl;
                    unsigned ndatatypes = datatypes.size();
                    for (unsigned i = 0; i < ndatatypes; i++)
                    {
                      Debug("parser-sygus") << "..." << datatypes[i].getName()
                                            << " has builtin sort " << sorts[i] << std::endl;
                    }
                    api::Term bvl;
                    if (!sygus_vars.empty())
                    {
                      bvl = MK_TERM(api::BOUND_VAR_LIST, sygus_vars);
                    }
                    for (unsigned i = 0; i < ndatatypes; i++)
                    {
                      Debug("parser-sygus") << "...make " << datatypes[i].getName()
                                            << " with builtin sort " << sorts[i] << std::endl;
                      if (sorts[i].isNull())
                      {
                        PARSER_STATE->parseError(
                            "Internal error : could not infer "
                            "builtin sort for nested gterm.");
                      }
                      datatypes[i].getDatatype().setSygus(
                          sorts[i].getType(), bvl.getExpr(), allow_const[i], false);
                      PARSER_STATE->mkSygusDatatype(datatypes[i],
                                                    ops[i],
                                                    cnames[i],
                                                    cargs[i],
                                                    unresolved_gterm_sym[i],
                                                    sygus_to_builtin);
                    }
                    PARSER_STATE->setSygusStartIndex(fun, startIndex, datatypes, sorts, ops);
                    PARSER_STATE->popScope();
                    Debug("parser-sygus") << "--- Make " << ndatatypes
                                          << " mutual datatypes..." << std::endl;
                    for (unsigned i = 0; i < ndatatypes; i++)
                    {
                      Debug("parser-sygus") << "  " << i << " : " << datatypes[i].getName()
                                            << std::endl;
                    }

                    std::vector<CVC4::Datatype> dtypes;
                    dtypes.reserve(ndatatypes);

                    for (api::DatatypeDecl i : datatypes)
                    {
                      dtypes.push_back(i.getDatatype());
                    }

                    std::set<Type> tset =
                        api::sortSetToTypes(PARSER_STATE->getUnresolvedSorts());

                    std::vector<DatatypeType> datatypeTypes =
                        SOLVER->getExprManager()->mkMutualDatatypeTypes(
                            dtypes, tset, ExprManager::DATATYPE_FLAG_PLACEHOLDER);

                    PARSER_STATE->getUnresolvedSorts().clear();

                    ret = api::Sort(SOLVER, datatypeTypes[0]);
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesygusGrammarV1Ex; /* Prevent compiler warnings */
    rulesygusGrammarV1Ex: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sygusGrammarV1 */

/**
 * $ANTLR start sygusGTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:817:1: sygusGTerm[CVC4::SygusGTerm& sgt, const std::string& fun] : ( LPAREN_TOK ( SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK | termAtomic[atomTerm] | symbol[name,CHECK_NONE,SYM_VARIABLE] );
 */
static void
sygusGTerm(pSmt2Parser ctx, CVC4::SygusGTerm& sgt, const std::string& fun)
{

      std::string name, name2;
      CVC4::api::Kind k;
      CVC4::api::Sort t;
      std::string sname;
      std::vector< CVC4::api::Term > let_vars;
      std::string s;
      CVC4::api::Term atomTerm;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:827:3: ( LPAREN_TOK ( SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK | termAtomic[atomTerm] | symbol[name,CHECK_NONE,SYM_VARIABLE] )

            ANTLR3_UINT32 alt22;

            alt22=3;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case INDEX_TOK:
            			{
            				alt22=2;
            			}
            		    break;
            		case QUOTED_SYMBOL:
            		case SIMPLE_SYMBOL:
            		case SYGUS_CONSTANT_TOK:
            		case SYGUS_INPUT_VARIABLE_TOK:
            		case SYGUS_LOCAL_VARIABLE_TOK:
            		case SYGUS_VARIABLE_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            			{
            				alt22=1;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 22;
            		    EXCEPTION->state        = 1;


            		    goto rulesygusGTermEx;

            		}

            	}
                break;
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case STRING_LITERAL:
            case TUPLE_CONST_TOK:
            	{
            		alt22=2;
            	}
                break;
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt22=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 22;
                EXCEPTION->state        = 0;


                goto rulesygusGTermEx;

            }

            switch (alt22)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:827:5: LPAREN_TOK ( SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGTerm1615);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:829:5: ( SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] )
        	        {
        	            int alt20=5;
        	            switch ( LA(1) )
        	            {
        	            case SYGUS_CONSTANT_TOK:
        	            	{
        	            		alt20=1;
        	            	}
        	                break;
        	            case SYGUS_VARIABLE_TOK:
        	            	{
        	            		alt20=2;
        	            	}
        	                break;
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            	{
        	            		alt20=3;
        	            	}
        	                break;
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            	{
        	            		alt20=4;
        	            	}
        	                break;
        	            case QUOTED_SYMBOL:
        	            case SIMPLE_SYMBOL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt20=5;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 20;
        	                EXCEPTION->state        = 0;


        	                goto rulesygusGTermEx;

        	            }

        	            switch (alt20)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:829:7: SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_CONSTANT_TOK, &FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1628);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1630);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_constant;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar constant." << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:834:7: SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_VARIABLE_TOK, &FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1647);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1649);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar variable." << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:839:7: SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_LOCAL_VARIABLE_TOK, &FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1666);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1668);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_local_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar local variable...ignore."
        	        	                                          << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:845:7: SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_INPUT_VARIABLE_TOK, &FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1685);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1687);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_input_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar (input) variable."
        	        	                                          << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 5:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:851:7: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1704);
        	        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {

        	        	                    bool isBuiltinOperator = PARSER_STATE->isOperatorEnabled(name);
        	        	                    if(isBuiltinOperator) {
        	        	                      Debug("parser-sygus") << "Sygus grammar " << fun << " : builtin op : "
        	        	                                            << name << std::endl;
        	        	                      k = PARSER_STATE->getOperatorKind(name);
        	        	                      sgt.d_name = api::kindToString(k);
        	        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                      sgt.d_op.d_kind = k;
        	        	                    }else{
        	        	                      // what is this sygus term trying to accomplish here, if the
        	        	                      // symbol isn't yet declared?!  probably the following line will
        	        	                      // fail, but we need an operator to continue here..
        	        	                      Debug("parser-sygus")
        	        	                          << "Sygus grammar " << fun << " : op (declare="
        	        	                          << PARSER_STATE->isDeclared(name) << ") : " << name
        	        	                          << std::endl;
        	        	                      if (!PARSER_STATE->isDeclared(name))
        	        	                      {
        	        	                        PARSER_STATE->parseError("Functions in sygus grammars must be "
        	        	                                                 "defined.");
        	        	                      }
        	        	                      sgt.d_name = name;
        	        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                      sgt.d_op.d_expr = PARSER_STATE->getVariable(name) ;
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             Debug("parser-sygus") << "Read arguments under " << sgt.d_name
        	                                        << std::endl;
        	                  sgt.addChild();
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:884:5: ( sygusGTerm[sgt.d_children.back(), fun] )*

        	        for (;;)
        	        {
        	            int alt21=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case SIMPLE_SYMBOL:
        	            case STRING_LITERAL:
        	            case TUPLE_CONST_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt21=1;
        	            	}
        	                break;

        	            }

        	            switch (alt21)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:884:7: sygusGTerm[sgt.d_children.back(), fun]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusGTerm1732);
        	        	        sygusGTerm(ctx, sgt.d_children.back(), fun);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             Debug("parser-sygus") << "Finished read argument #"
        	        	                                          << sgt.d_children.size() << "..." << std::endl;
        	        	                    sgt.addChild();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop21;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop21: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGTerm1754);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {

        	                  //pop last child index
        	                  sgt.d_children.pop_back();
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:894:7: termAtomic[atomTerm]
        	    {
        	        FOLLOWPUSH(FOLLOW_termAtomic_in_sygusGTerm1764);
        	        termAtomic(ctx, atomTerm);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {

        	                    Debug("parser-sygus") << "Sygus grammar " << fun << " : atomic "
        	                                          << "expression " << atomTerm << std::endl;
        	                    std::stringstream ss;
        	                    ss << atomTerm;
        	                    sgt.d_op.d_expr = atomTerm;
        	                    sgt.d_name = ss.str();
        	                    sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                  
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:904:5: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1779);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {

        	                  if( name[0] == '-' ){  //hack for unary minus
        	                    Debug("parser-sygus") << "Sygus grammar " << fun
        	                                          << " : unary minus integer literal " << name
        	                                          << std::endl;
        	                    sgt.d_op.d_expr = SOLVER->mkReal(name);
        	                    sgt.d_name = name;
        	                    sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                  }else if( PARSER_STATE->isDeclared(name,SYM_VARIABLE) ){
        	                    Debug("parser-sygus") << "Sygus grammar " << fun << " : symbol "
        	                                          << name << std::endl;
        	                    sgt.d_op.d_expr = PARSER_STATE->getExpressionForName(name);
        	                    sgt.d_name = name;
        	                    sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                  }else{
        	                    if( PARSER_STATE->isDeclared(name, SYM_SORT) ){
        	                      Debug("parser-sygus") << "Sygus grammar " << fun
        	                                            << " : nested sort " << name << std::endl;
        	                      sgt.d_type = PARSER_STATE->getSort(name);
        	                      sgt.d_gterm_type = SygusGTerm::gterm_nested_sort;
        	                    }else{
        	                      Debug("parser-sygus") << "Sygus grammar " << fun
        	                                            << " : unresolved symbol " << name
        	                                            << std::endl;
        	                      sgt.d_gterm_type = SygusGTerm::gterm_unresolved;
        	                      sgt.d_name = name;
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesygusGTermEx; /* Prevent compiler warnings */
    rulesygusGTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sygusGTerm */

/**
 * $ANTLR start sygusGrammar
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:946:1: sygusGrammar[CVC4::api::Sort & ret,\n const std::vector<CVC4::api::Term>& sygusVars,\n const std::string& fun] : LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] ( LPAREN_TOK | RPAREN_TOK ) )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK symbol[name, CHECK_DECLARED, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( term[e,e2] | LPAREN_TOK SYGUS_CONSTANT_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK SYGUS_VARIABLE_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
sygusGrammar(pSmt2Parser ctx, CVC4::api::Sort & ret, const std::vector<CVC4::api::Term>& sygusVars, const std::string& fun)
{

      // the pre-declaration
      std::vector<std::pair<std::string, CVC4::api::Sort> > sortedVarNames;
      // non-terminal symbols of the grammar
      std::vector<CVC4::api::Term> ntSyms;
      CVC4::api::Sort t;
      std::string name;
      CVC4::api::Term e, e2;
      std::vector<api::DatatypeDecl> datatypes;
      std::set<api::Sort> unresTypes;
      std::map<CVC4::api::Term, CVC4::api::Sort> ntsToUnres;
      unsigned dtProcessed = 0;
      std::unordered_set<unsigned> allowConst;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:964:3: ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] ( LPAREN_TOK | RPAREN_TOK ) )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK symbol[name, CHECK_DECLARED, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( term[e,e2] | LPAREN_TOK SYGUS_CONSTANT_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK SYGUS_VARIABLE_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:966:3: LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] ( LPAREN_TOK | RPAREN_TOK ) )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK symbol[name, CHECK_DECLARED, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( term[e,e2] | LPAREN_TOK SYGUS_CONSTANT_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK SYGUS_VARIABLE_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1813);
            if  (HASEXCEPTION())
            {
                goto rulesygusGrammarEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:970:3: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] ( LPAREN_TOK | RPAREN_TOK ) )*

            for (;;)
            {
                int alt24=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt24=1;
                	}
                    break;

                }

                switch (alt24)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:970:5: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] ( LPAREN_TOK | RPAREN_TOK )
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1828);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesygusGrammarEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGrammar1830);
            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesygusGrammarEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGrammar1837);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesygusGrammarEx;
            	        }


            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:971:34: ( LPAREN_TOK | RPAREN_TOK )
            	        {
            	            int alt23=2;
            	            switch ( LA(1) )
            	            {
            	            case LPAREN_TOK:
            	            	{
            	            		alt23=1;
            	            	}
            	                break;
            	            case RPAREN_TOK:
            	            	{
            	            		alt23=2;
            	            	}
            	                break;

            	            default:
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 23;
            	                EXCEPTION->state        = 0;


            	                goto rulesygusGrammarEx;

            	            }

            	            switch (alt23)
            	            {
            	        	case 1:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:974:7: LPAREN_TOK
            	        	    {
            	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1862);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulesygusGrammarEx;
            	        	        }


            	        	        {

            	        	                    std::stringstream sse;
            	        	                    if (sortedVarNames.empty())
            	        	                    {
            	        	                      sse << "The expected SyGuS language is version 2.0, whereas the "
            	        	                          << "input appears to be SyGuS version 1.0 format. The version "
            	        	                          << "2.0 format requires a predeclaration of the non-terminal "
            	        	                          << "symbols of the grammar to be given prior to the definition "
            	        	                          << "of the grammar. See https://sygus.org/language/ for details "
            	        	                          << "and examples. CVC4 versions past 1.8 do not support SyGuS "
            	        	                          << "version 1.0.";
            	        	                    }
            	        	                    else
            	        	                    {
            	        	                      // an unknown syntax error
            	        	                      sse << "Unexpected syntax for SyGuS predeclaration.";
            	        	                    }
            	        	                    PARSER_STATE->parseError(sse.str().c_str());
            	        	                  
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:994:7: RPAREN_TOK
            	        	    {
            	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammar1878);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulesygusGrammarEx;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	        {
            	             sortedVarNames.push_back(make_pair(name, t)); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop24;	/* break out of the loop */
            	    break;
                }
            }
            loop24: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammar1895);
            if  (HASEXCEPTION())
            {
                goto rulesygusGrammarEx;
            }


            {

                    // non-terminal symbols in the pre-declaration are locally scoped
                    PARSER_STATE->pushScope(true);
                    for (std::pair<std::string, api::Sort>& i : sortedVarNames)
                    {
                      Trace("parser-sygus2") << "Declare datatype " << i.first << std::endl;
                      // make the datatype, which encodes terms generated by this non-terminal
                      std::string dname = i.first;
                      datatypes.push_back(SOLVER->mkDatatypeDecl(dname));
                      // make its unresolved type, used for referencing the final version of
                      // the datatype
                      PARSER_STATE->checkDeclaration(dname, CHECK_UNDECLARED, SYM_SORT);
                      api::Sort urt = PARSER_STATE->mkUnresolvedType(dname);
                      unresTypes.insert(urt);
                      // make the non-terminal symbol, which will be parsed as an ordinary
                      // free variable.
                      api::Term nts = PARSER_STATE->bindBoundVar(i.first, i.second);
                      ntSyms.push_back(nts);
                      ntsToUnres[nts] = urt;
                    }
                  
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1906);
            if  (HASEXCEPTION())
            {
                goto rulesygusGrammarEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1021:3: ( LPAREN_TOK symbol[name, CHECK_DECLARED, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( term[e,e2] | LPAREN_TOK SYGUS_CONSTANT_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK SYGUS_VARIABLE_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK )+
            {
                int cnt26=0;

                for (;;)
                {
                    int alt26=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt26=1;
            		}
            	    break;

            	}

            	switch (alt26)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1022:5: LPAREN_TOK symbol[name, CHECK_DECLARED, SYM_VARIABLE] sortSymbol[t, CHECK_DECLARED] LPAREN_TOK ( term[e,e2] | LPAREN_TOK SYGUS_CONSTANT_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK SYGUS_VARIABLE_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1916);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_symbol_in_sygusGrammar1922);
            	            symbol(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGrammar1925);
            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarEx;
            	            }


            	            {

            	                      // check that it matches sortedVarNames
            	                      if (sortedVarNames[dtProcessed].first != name)
            	                      {
            	                        std::stringstream sse;
            	                        sse << "Grouped rule listing " << name
            	                            << " does not match the name (in order) from the predeclaration ("
            	                            << sortedVarNames[dtProcessed].first << ")." << std::endl;
            	                        PARSER_STATE->parseError(sse.str().c_str());
            	                      }
            	                      if (sortedVarNames[dtProcessed].second != t)
            	                      {
            	                        std::stringstream sse;
            	                        sse << "Type for grouped rule listing " << name
            	                            << " does not match the type (in order) from the predeclaration ("
            	                            << sortedVarNames[dtProcessed].second << ")." << std::endl;
            	                        PARSER_STATE->parseError(sse.str().c_str());
            	                      }
            	                    
            	            }


            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1938);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarEx;
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1044:5: ( term[e,e2] | LPAREN_TOK SYGUS_CONSTANT_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK SYGUS_VARIABLE_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK )+
            	            {
            	                int cnt25=0;

            	                for (;;)
            	                {
            	                    int alt25=4;
            	            	switch ( LA(1) )
            	            	{
            	            	case LPAREN_TOK:
            	            		{
            	            			switch ( LA(2) )
            	            			{
            	            			case AS_TOK:
            	            			case ATTRIBUTE_TOK:
            	            			case COMPREHENSION_TOK:
            	            			case EXISTS_TOK:
            	            			case FORALL_TOK:
            	            			case HO_LAMBDA_TOK:
            	            			case INDEX_TOK:
            	            			case LET_TOK:
            	            			case LPAREN_TOK:
            	            			case MATCH_TOK:
            	            			case QUOTED_SYMBOL:
            	            			case SIMPLE_SYMBOL:
            	            			case SYGUS_LET_TOK:
            	            			case TUPLE_CONST_TOK:
            	            			case UNTERMINATED_QUOTED_SYMBOL:
            	            				{
            	            					alt25=1;
            	            				}
            	            			    break;
            	            			case SYGUS_CONSTANT_TOK:
            	            				{
            	            					alt25=2;
            	            				}
            	            			    break;
            	            			case SYGUS_VARIABLE_TOK:
            	            				{
            	            					alt25=3;
            	            				}
            	            			    break;

            	            			}

            	            		}
            	            	    break;
            	            	case BINARY_LITERAL:
            	            	case DECIMAL_LITERAL:
            	            	case HEX_LITERAL:
            	            	case INTEGER_LITERAL:
            	            	case QUOTED_SYMBOL:
            	            	case SIMPLE_SYMBOL:
            	            	case STRING_LITERAL:
            	            	case TUPLE_CONST_TOK:
            	            	case UNTERMINATED_QUOTED_SYMBOL:
            	            		{
            	            			alt25=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt25)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1045:7: term[e,e2]
            	            	        {
            	            	            FOLLOWPUSH(FOLLOW_term_in_sygusGrammar1952);
            	            	            term(ctx, e, e2);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	            {

            	            	                        // add term as constructor to datatype
            	            	                        PARSER_STATE->addSygusConstructorTerm(
            	            	                            datatypes[dtProcessed], e, ntsToUnres);
            	            	                      
            	            	            }


            	            	        }
            	            	        break;
            	            	    case 2:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1050:9: LPAREN_TOK SYGUS_CONSTANT_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK
            	            	        {
            	            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1965);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	             MATCHT(SYGUS_CONSTANT_TOK, &FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGrammar1967);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGrammar1969);
            	            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammar1972);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	            {

            	            	                        // allow constants in datatypes[dtProcessed]
            	            	                        allowConst.insert(dtProcessed);
            	            	                      
            	            	            }


            	            	        }
            	            	        break;
            	            	    case 3:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1054:9: LPAREN_TOK SYGUS_VARIABLE_TOK sortSymbol[t, CHECK_DECLARED] RPAREN_TOK
            	            	        {
            	            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGrammar1984);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	             MATCHT(SYGUS_VARIABLE_TOK, &FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGrammar1986);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGrammar1988);
            	            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammar1991);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulesygusGrammarEx;
            	            	            }


            	            	            {

            	            	                        // add variable constructors to datatype
            	            	                        PARSER_STATE->addSygusConstructorVariables(
            	            	                            datatypes[dtProcessed], sygusVars, t);
            	            	                      
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt25 >= 1 )
            	            		{
            	            		    goto loop25;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto rulesygusGrammarEx;
            	            	}
            	            	cnt25++;
            	                }
            	                loop25: ;	/* Jump to here if this rule does not match */
            	            }

            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammar2006);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammar2012);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulesygusGrammarEx;
            	            }


            	            {

            	                      dtProcessed++;
            	                    
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt26 >= 1 )
            		{
            		    goto loop26;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulesygusGrammarEx;
            	}
            	cnt26++;
                }
                loop26: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGrammar2027);
            if  (HASEXCEPTION())
            {
                goto rulesygusGrammarEx;
            }


            {

                    if (dtProcessed != sortedVarNames.size())
                    {
                      PARSER_STATE->parseError(
                          "Number of grouped rule listings does not match "
                          "number of symbols in predeclaration.");
                    }
                    api::Term bvl;
                    if (!sygusVars.empty())
                    {
                      bvl = MK_TERM(api::BOUND_VAR_LIST, sygusVars);
                    }
                    Trace("parser-sygus2") << "Process " << dtProcessed << " sygus datatypes..." << std::endl;
                    for (unsigned i = 0; i < dtProcessed; i++)
                    {
                      bool aci = allowConst.find(i)!=allowConst.end();
                      api::Sort btt = sortedVarNames[i].second;
                      datatypes[i].getDatatype().setSygus(btt.getType(), bvl.getExpr(), aci, false);
                      Trace("parser-sygus2") << "- " << datatypes[i].getName()
                                             << ", #cons= " << datatypes[i].getNumConstructors()
                                             << ", aci= " << aci << std::endl;
                      // We can be in a case where the only rule specified was (Variable T)
                      // and there are no variables of type T, in which case this is a bogus
                      // grammar. This results in the error below.
                      if (datatypes[i].getNumConstructors() == 0)
                      {
                        std::stringstream se;
                        se << "Grouped rule listing for " << datatypes[i].getName()
                           << " produced an empty rule list.";
                        PARSER_STATE->parseError(se.str());
                      }
                    }
                    // pop scope from the pre-declaration
                    PARSER_STATE->popScope();
                    // now, make the sygus datatype
                    Trace("parser-sygus2") << "Make the sygus datatypes..." << std::endl;
                    std::vector<api::Sort> datatypeTypes =
                      SOLVER->mkDatatypeSorts(datatypes, unresTypes);
                    // return is the first datatype
                    ret = api::Sort(datatypeTypes[0]);
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesygusGrammarEx; /* Prevent compiler warnings */
    rulesygusGrammarEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sygusGrammar */

/**
 * $ANTLR start setInfoInternal
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1110:1: setInfoInternal[std::unique_ptr<CVC4::Command>* cmd] : KEYWORD symbolicExpr[sexpr] ;
 */
static void
setInfoInternal(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::string name;
      SExpr sexpr;

    pANTLR3_COMMON_TOKEN    KEYWORD4;

    /* Initialize rule variables
     */

    KEYWORD4       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1115:3: ( KEYWORD symbolicExpr[sexpr] )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1115:5: KEYWORD symbolicExpr[sexpr]
        {
            KEYWORD4 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_setInfoInternal2048);
            if  (HASEXCEPTION())
            {
                goto rulesetInfoInternalEx;
            }


            FOLLOWPUSH(FOLLOW_symbolicExpr_in_setInfoInternal2050);
            symbolicExpr(ctx, sexpr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesetInfoInternalEx;
            }


            {
                 name = AntlrInput::tokenText(KEYWORD4);
                      PARSER_STATE->setInfo(name.c_str() + 1, sexpr);
                      cmd->reset(new SetInfoCommand(name.c_str() + 1, sexpr));
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesetInfoInternalEx; /* Prevent compiler warnings */
    rulesetInfoInternalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end setInfoInternal */

/**
 * $ANTLR start setOptionInternal
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1122:1: setOptionInternal[std::unique_ptr<CVC4::Command>* cmd] : keyword[name] symbolicExpr[sexpr] ;
 */
static void
setOptionInternal(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    /* Initialize rule variables
     */


      std::string name;
      SExpr sexpr;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1127:3: ( keyword[name] symbolicExpr[sexpr] )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1127:5: keyword[name] symbolicExpr[sexpr]
        {
            FOLLOWPUSH(FOLLOW_keyword_in_setOptionInternal2076);
            keyword(ctx, name);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesetOptionInternalEx;
            }


            FOLLOWPUSH(FOLLOW_symbolicExpr_in_setOptionInternal2079);
            symbolicExpr(ctx, sexpr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesetOptionInternalEx;
            }


            {
                 PARSER_STATE->setOption(name.c_str() + 1, sexpr);
                      cmd->reset(new SetOptionCommand(name.c_str() + 1, sexpr));
                      // Ugly that this changes the state of the parser; but
                      // global-declarations affects parsing, so we can't hold off
                      // on this until some SmtEngine eventually (if ever) executes it.
                      if(name == ":global-declarations") {
                        PARSER_STATE->setGlobalDeclarations(sexpr.getValue() == "true");
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesetOptionInternalEx; /* Prevent compiler warnings */
    rulesetOptionInternalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end setOptionInternal */

/**
 * $ANTLR start smt25Command
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1139:1: smt25Command[std::unique_ptr<CVC4::Command>* cmd] : ( DECLARE_CONST_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | RESET_TOK | RESET_ASSERTIONS_TOK | DEFINE_FUN_REC_TOK symbol[fname,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK );
 */
static void
smt25Command(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::string name;
      std::string fname;
      CVC4::api::Term expr, expr2;
      std::vector<std::pair<std::string, CVC4::api::Sort> > sortedVarNames;
      SExpr sexpr;
      CVC4::api::Sort t;
      CVC4::api::Term func;
      std::vector<CVC4::api::Term> bvs;
      std::vector<std::vector<std::pair<std::string, CVC4::api::Sort>>>
          sortedVarNamesList;
      std::vector<std::vector<CVC4::api::Term>> flattenVarsList;
      std::vector<std::vector<CVC4::api::Term>> formals;
      std::vector<CVC4::api::Term> funcs;
      std::vector<CVC4::api::Term> func_defs;
      CVC4::api::Term aexpr;
      std::unique_ptr<CVC4::CommandSequence> seq;
      std::vector<api::Sort> sorts;
      std::vector<CVC4::api::Term> flattenVars;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1161:3: ( DECLARE_CONST_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | RESET_TOK | RESET_ASSERTIONS_TOK | DEFINE_FUN_REC_TOK symbol[fname,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK )

            ANTLR3_UINT32 alt30;

            alt30=7;

            switch ( LA(1) )
            {
            case DECLARE_CONST_TOK:
            	{
            		alt30=1;
            	}
                break;
            case GET_MODEL_TOK:
            	{
            		alt30=2;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt30=3;
            	}
                break;
            case RESET_TOK:
            	{
            		alt30=4;
            	}
                break;
            case RESET_ASSERTIONS_TOK:
            	{
            		alt30=5;
            	}
                break;
            case DEFINE_FUN_REC_TOK:
            	{
            		alt30=6;
            	}
                break;
            case DEFINE_FUNS_REC_TOK:
            	{
            		alt30=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 30;
                EXCEPTION->state        = 0;


                goto rulesmt25CommandEx;

            }

            switch (alt30)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1161:5: DECLARE_CONST_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_CONST_TOK, &FOLLOW_DECLARE_CONST_TOK_in_smt25Command2111);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_smt25Command2119);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command2132);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             // allow overloading here
        	                  api::Term c =
        	                      PARSER_STATE->bindVar(name, t, ExprManager::VAR_FLAG_NONE, true);
        	                  cmd->reset(new DeclareFunctionCommand(name, c.getExpr(), t.getType())); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1171:5: GET_MODEL_TOK
        	    {
        	         MATCHT(GET_MODEL_TOK, &FOLLOW_GET_MODEL_TOK_in_smt25Command2152);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetModelCommand()); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1175:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_smt25Command2173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1176:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt27=2;
        	            switch ( LA(1) )
        	            {
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case ECHO_TOK:
        	            case EXIT_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case KEYWORD:
        	            case POP_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STRING_LITERAL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt27=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt27=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 27;
        	                EXCEPTION->state        = 0;


        	                goto rulesmt25CommandEx;

        	            }

        	            switch (alt27)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1176:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_smt25Command2181);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesmt25CommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new EchoCommand(sexpr.toString())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1178:7: 
        	        	    {
        	        	        {
        	        	             cmd->reset(new EchoCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1183:5: RESET_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_smt25Command2217);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             cmd->reset(new ResetCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1189:5: RESET_ASSERTIONS_TOK
        	    {
        	         MATCHT(RESET_ASSERTIONS_TOK, &FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command2235);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             cmd->reset(new ResetAssertionsCommand());
        	                  PARSER_STATE->resetAssertions();
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1193:5: DEFINE_FUN_REC_TOK symbol[fname,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_FUN_REC_TOK, &FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2247);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_smt25Command2259);
        	        symbol(ctx, fname, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(fname); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2272);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_smt25Command2274);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2277);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command2283);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {

        	                  func =
        	                      PARSER_STATE->bindDefineFunRec(fname, sortedVarNames, t, flattenVars);
        	                  PARSER_STATE->pushDefineFunRecScope(
        	                      sortedVarNames, func, flattenVars, bvs, true);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_smt25Command2296);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  if( !flattenVars.empty() ){
        	                    expr = PARSER_STATE->mkHoApply( expr, flattenVars );
        	                  }
        	                  cmd->reset(new DefineFunctionRecCommand(
        	                      SOLVER, func, bvs, expr, PARSER_STATE->getGlobalDeclarations()));
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1213:5: DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK
        	    {
        	         MATCHT(DEFINE_FUNS_REC_TOK, &FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2309);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet();
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2321);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1216:5: ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+
        	        {
        	            int cnt28=0;

        	            for (;;)
        	            {
        	                int alt28=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt28=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt28)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1216:7: LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2329);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_smt25Command2337);
        	        	            symbol(ctx, fname, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(fname); 
        	        	            }


        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2354);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortedVarList_in_smt25Command2356);
        	        	            sortedVarList(ctx, sortedVarNames);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2359);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command2367);
        	        	            sortSymbol(ctx, t, CHECK_DECLARED);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {

        	        	                        flattenVars.clear();
        	        	                        func = PARSER_STATE->bindDefineFunRec(
        	        	                            fname, sortedVarNames, t, flattenVars);
        	        	                        funcs.push_back( func );

        	        	                        // add to lists (need to remember for when parsing the bodies)
        	        	                        sortedVarNamesList.push_back( sortedVarNames );
        	        	                        flattenVarsList.push_back( flattenVars );

        	        	                        // set up parsing the next variable list block
        	        	                        sortedVarNames.clear();
        	        	                        flattenVars.clear();
        	        	                      
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2384);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt28 >= 1 )
        	        		{
        	        		    goto loop28;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesmt25CommandEx;
        	        	}
        	        	cnt28++;
        	            }
        	            loop28: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2397);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2403);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {

        	                  //set up the first scope
        	                  if( sortedVarNamesList.empty() ){
        	                    PARSER_STATE->parseError("Must define at least one function in "
        	                                             "define-funs-rec");
        	                  }
        	                  bvs.clear();
        	                  PARSER_STATE->pushDefineFunRecScope( sortedVarNamesList[0], funcs[0],
        	                                                       flattenVarsList[0], bvs, true);
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1249:5: ( term[expr,expr2] )+
        	        {
        	            int cnt29=0;

        	            for (;;)
        	            {
        	                int alt29=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case DECIMAL_LITERAL:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case LPAREN_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL:
        	        	case TUPLE_CONST_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        		{
        	        			alt29=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt29)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1250:5: term[expr,expr2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_smt25Command2421);
        	        	            term(ctx, expr, expr2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {

        	        	                      unsigned j = func_defs.size();
        	        	                      if( !flattenVarsList[j].empty() ){
        	        	                        expr = PARSER_STATE->mkHoApply( expr, flattenVarsList[j] );
        	        	                      }
        	        	                      func_defs.push_back( expr );
        	        	                      formals.push_back(bvs);
        	        	                      j++;
        	        	                      //set up the next scope
        	        	                      PARSER_STATE->popScope();
        	        	                      if( func_defs.size()<funcs.size() ){
        	        	                        bvs.clear();
        	        	                        PARSER_STATE->pushDefineFunRecScope( sortedVarNamesList[j], funcs[j],
        	        	                                                             flattenVarsList[j], bvs, true);
        	        	                      }
        	        	                    
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt29 >= 1 )
        	        		{
        	        		    goto loop29;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesmt25CommandEx;
        	        	}
        	        	cnt29++;
        	            }
        	            loop29: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2441);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             if( funcs.size()!=func_defs.size() ){
        	                    PARSER_STATE->parseError(std::string(
        	                        "Number of functions defined does not match number listed in "
        	                        "define-funs-rec"));
        	                  }
        	                  cmd->reset(
        	                      new DefineFunctionRecCommand(SOLVER,
        	                                                   funcs,
        	                                                   formals,
        	                                                   func_defs,
        	                                                   PARSER_STATE->getGlobalDeclarations()));
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesmt25CommandEx; /* Prevent compiler warnings */
    rulesmt25CommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end smt25Command */

/**
 * $ANTLR start extendedCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1283:1: extendedCommand[std::unique_ptr<CVC4::Command>* cmd] : ( DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd] | DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd] | DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2] | SIMPLIFY_TOK term[e,e2] | GET_QE_TOK term[e,e2] | GET_QE_DISJUNCT_TOK term[e,e2] | GET_ABDUCT_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] ( sygusGrammar[t, terms, name] )? | DECLARE_HEAP LPAREN_TOK sortSymbol[t, CHECK_DECLARED] sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | BLOCK_MODEL_TOK | BLOCK_MODEL_VALUES_TOK ( LPAREN_TOK termList[terms,e] RPAREN_TOK |~ LPAREN_TOK ) );
 */
static void
extendedCommand(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<api::DatatypeDecl> dts;
      CVC4::api::Term e, e2;
      CVC4::api::Sort t;
      std::string name;
      std::vector<std::string> names;
      std::vector<CVC4::api::Term> terms;
      std::vector<api::Sort> sorts;
      std::vector<std::pair<std::string, CVC4::api::Sort> > sortedVarNames;
      std::unique_ptr<CVC4::CommandSequence> seq;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1297:3: ( DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd] | DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd] | DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2] | SIMPLIFY_TOK term[e,e2] | GET_QE_TOK term[e,e2] | GET_QE_DISJUNCT_TOK term[e,e2] | GET_ABDUCT_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] ( sygusGrammar[t, terms, name] )? | DECLARE_HEAP LPAREN_TOK sortSymbol[t, CHECK_DECLARED] sortSymbol[t, CHECK_DECLARED] RPAREN_TOK | BLOCK_MODEL_TOK | BLOCK_MODEL_VALUES_TOK ( LPAREN_TOK termList[terms,e] RPAREN_TOK |~ LPAREN_TOK ) )

            ANTLR3_UINT32 alt37;

            alt37=16;

            switch ( LA(1) )
            {
            case DECLARE_DATATYPES_2_5_TOK:
            	{
            		alt37=1;
            	}
                break;
            case DECLARE_CODATATYPES_2_5_TOK:
            	{
            		alt37=2;
            	}
                break;
            case DECLARE_CODATATYPE_TOK:
            	{
            		alt37=3;
            	}
                break;
            case DECLARE_CODATATYPES_TOK:
            	{
            		alt37=4;
            	}
                break;
            case DECLARE_SORTS_TOK:
            	{
            		alt37=5;
            	}
                break;
            case DECLARE_FUNS_TOK:
            	{
            		alt37=6;
            	}
                break;
            case DECLARE_PREDS_TOK:
            	{
            		alt37=7;
            	}
                break;
            case DEFINE_TOK:
            	{
            		alt37=8;
            	}
                break;
            case DEFINE_CONST_TOK:
            	{
            		alt37=9;
            	}
                break;
            case SIMPLIFY_TOK:
            	{
            		alt37=10;
            	}
                break;
            case GET_QE_TOK:
            	{
            		alt37=11;
            	}
                break;
            case GET_QE_DISJUNCT_TOK:
            	{
            		alt37=12;
            	}
                break;
            case GET_ABDUCT_TOK:
            	{
            		alt37=13;
            	}
                break;
            case DECLARE_HEAP:
            	{
            		alt37=14;
            	}
                break;
            case BLOCK_MODEL_TOK:
            	{
            		alt37=15;
            	}
                break;
            case BLOCK_MODEL_VALUES_TOK:
            	{
            		alt37=16;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 37;
                EXCEPTION->state        = 0;


                goto ruleextendedCommandEx;

            }

            switch (alt37)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1297:5: DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPES_2_5_TOK, &FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2472);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2474);
        	        datatypes_2_5_DefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1298:5: DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPES_2_5_TOK, &FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2481);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2483);
        	        datatypes_2_5_DefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1299:5: DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPE_TOK, &FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2490);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDefCommand_in_extendedCommand2492);
        	        datatypeDefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1300:5: DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPES_TOK, &FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2499);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_extendedCommand2501);
        	        datatypesDefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1304:5: DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_SORTS_TOK, &FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2516);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {

        	                  PARSER_STATE->checkThatLogicIsSet();
        	                  PARSER_STATE->checkLogicAllowsFreeSorts();
        	                  seq.reset(new CVC4::CommandSequence());
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2528);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1311:5: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+
        	        {
        	            int cnt31=0;

        	            for (;;)
        	            {
        	                int alt31=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case QUOTED_SYMBOL:
        	        	case SIMPLE_SYMBOL:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        		{
        	        			alt31=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt31)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1311:7: symbol[name,CHECK_UNDECLARED,SYM_SORT]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2536);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name);
        	        	                        api::Sort type = PARSER_STATE->mkSort(name);
        	        	                        seq->addCommand(new DeclareTypeCommand(name, 0, type.getType()));
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt31 >= 1 )
        	        		{
        	        		    goto loop31;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt31++;
        	            }
        	            loop31: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2558);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1320:5: DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_FUNS_TOK, &FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2571);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2585);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1323:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt32=0;

        	            for (;;)
        	            {
        	                int alt32=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt32=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt32)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1323:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2593);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2595);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_nonemptySortList_in_extendedCommand2612);
        	        	            nonemptySortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2615);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 api::Sort tt;
        	        	                        if(sorts.size() > 1) {
        	        	                          PARSER_STATE->checkLogicAllowsFunctions();
        	        	                          // must flatten
        	        	                          api::Sort range = sorts.back();
        	        	                          sorts.pop_back();
        	        	                          tt = PARSER_STATE->mkFlatFunctionType(sorts, range);
        	        	                        } else {
        	        	                          tt = sorts[0];
        	        	                        }
        	        	                        // allow overloading
        	        	                        api::Term func =
        	        	                            PARSER_STATE->bindVar(name, tt, ExprManager::VAR_FLAG_NONE, true);
        	        	                        seq->addCommand(
        	        	                            new DeclareFunctionCommand(name, func.getExpr(), tt.getType()));
        	        	                        sorts.clear();
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt32 >= 1 )
        	        		{
        	        		    goto loop32;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt32++;
        	            }
        	            loop32: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2636);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1346:5: DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_PREDS_TOK, &FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2648);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2662);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1349:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt33=0;

        	            for (;;)
        	            {
        	                int alt33=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt33=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt33)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1349:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2670);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2672);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortList_in_extendedCommand2689);
        	        	            sortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2692);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 t = SOLVER->getBooleanSort();
        	        	                        if(sorts.size() > 0) {
        	        	                          PARSER_STATE->checkLogicAllowsFunctions();
        	        	                          t = SOLVER->mkFunctionSort(sorts, t);
        	        	                        }
        	        	                        // allow overloading
        	        	                        api::Term func =
        	        	                            PARSER_STATE->bindVar(name, t, ExprManager::VAR_FLAG_NONE, true);
        	        	                        seq->addCommand(
        	        	                            new DeclareFunctionCommand(name, func.getExpr(), t.getType()));
        	        	                        sorts.clear();
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt33 >= 1 )
        	        		{
        	        		    goto loop33;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt33++;
        	            }
        	            loop33: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2713);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1368:5: DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	    {
        	         MATCHT(DEFINE_TOK, &FOLLOW_DEFINE_TOK_in_extendedCommand2726);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1369:5: ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	        {
        	            int alt34=2;
        	            switch ( LA(1) )
        	            {
        	            case QUOTED_SYMBOL:
        	            case SIMPLE_SYMBOL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt34=1;
        	            	}
        	                break;
        	            case LPAREN_TOK:
        	            	{
        	            		alt34=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 34;
        	                EXCEPTION->state        = 0;


        	                goto ruleextendedCommandEx;

        	            }

        	            switch (alt34)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1370:7: symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2743);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2760);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {

        	        	                    api::Term func = PARSER_STATE->bindVar(name, e.getSort(),
        	        	                                                    ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd->reset(
        	        	                        new DefineFunctionCommand(name,
        	        	                                                  func.getExpr(),
        	        	                                                  e.getExpr(),
        	        	                                                  PARSER_STATE->getGlobalDeclarations()));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1383:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2]
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2784);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2792);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_extendedCommand2809);
        	        	        sortedVarList(ctx, sortedVarNames);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2812);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             /* add variables to parser state before parsing term */
        	        	                    Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	        	                    PARSER_STATE->pushScope(true);
        	        	                    terms = PARSER_STATE->bindBoundVars(sortedVarNames);
        	        	                  
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2828);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {

        	        	                    PARSER_STATE->popScope();
        	        	                    // declare the name down here (while parsing term, signature
        	        	                    // must not be extended with the name itself; no recursion
        	        	                    // permitted)
        	        	                    api::Sort tt = e.getSort();
        	        	                    if( sortedVarNames.size() > 0 ) {
        	        	                      sorts.reserve(sortedVarNames.size());
        	        	                      for(std::vector<std::pair<std::string, api::Sort> >::const_iterator
        	        	                            i = sortedVarNames.begin(), iend = sortedVarNames.end();
        	        	                          i != iend; ++i) {
        	        	                        sorts.push_back((*i).second);
        	        	                      }
        	        	                      tt = SOLVER->mkFunctionSort(sorts, tt);
        	        	                    }
        	        	                    api::Term func = PARSER_STATE->bindVar(name, tt,
        	        	                                                    ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd->reset(
        	        	                        new DefineFunctionCommand(name,
        	        	                                                  func.getExpr(),
        	        	                                                  api::termVectorToExprs(terms),
        	        	                                                  e.getExpr(),
        	        	                                                  PARSER_STATE->getGlobalDeclarations()));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1419:5: DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2]
        	    {
        	         MATCHT(DEFINE_CONST_TOK, &FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2854);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2862);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_extendedCommand2875);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define const: '" << name << "'" << std::endl;
        	                  PARSER_STATE->pushScope(true);
        	                  terms = PARSER_STATE->bindBoundVars(sortedVarNames);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2888);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {

        	                  PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  api::Term func = PARSER_STATE->bindVar(name, t,
        	                                                  ExprManager::VAR_FLAG_DEFINED);
        	                  cmd->reset(
        	                      new DefineFunctionCommand(name,
        	                                                func.getExpr(),
        	                                                api::termVectorToExprs(terms),
        	                                                e.getExpr(),
        	                                                PARSER_STATE->getGlobalDeclarations()));
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1444:5: SIMPLIFY_TOK term[e,e2]
        	    {
        	         MATCHT(SIMPLIFY_TOK, &FOLLOW_SIMPLIFY_TOK_in_extendedCommand2902);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2910);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new SimplifyCommand(e.getExpr())); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1447:5: GET_QE_TOK term[e,e2]
        	    {
        	         MATCHT(GET_QE_TOK, &FOLLOW_GET_QE_TOK_in_extendedCommand2923);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2931);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new GetQuantifierEliminationCommand(e.getExpr(), true)); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1450:5: GET_QE_DISJUNCT_TOK term[e,e2]
        	    {
        	         MATCHT(GET_QE_DISJUNCT_TOK, &FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2944);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2952);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new GetQuantifierEliminationCommand(e.getExpr(), false)); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1453:5: GET_ABDUCT_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] ( sygusGrammar[t, terms, name] )?
        	    {
        	         MATCHT(GET_ABDUCT_TOK, &FOLLOW_GET_ABDUCT_TOK_in_extendedCommand2965);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {

        	                  PARSER_STATE->checkThatLogicIsSet();
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2973);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2980);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1458:5: ( sygusGrammar[t, terms, name] )?
        	        {
        	            int alt35=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt35=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt35)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1459:7: sygusGrammar[t, terms, name]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sygusGrammar_in_extendedCommand2995);
        	        	        sygusGrammar(ctx, t, terms, name);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  cmd->reset(new GetAbductCommand(name,e.getExpr(), t.getType()));
        	                
        	        }


        	    }
        	    break;
        	case 14:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1464:5: DECLARE_HEAP LPAREN_TOK sortSymbol[t, CHECK_DECLARED] sortSymbol[t, CHECK_DECLARED] RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_HEAP, &FOLLOW_DECLARE_HEAP_in_extendedCommand3015);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand3017);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_extendedCommand3023);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_extendedCommand3030);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new EmptyCommand()); 
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand3048);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 15:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1470:5: BLOCK_MODEL_TOK
        	    {
        	         MATCHT(BLOCK_MODEL_TOK, &FOLLOW_BLOCK_MODEL_TOK_in_extendedCommand3054);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new BlockModelCommand()); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1473:5: BLOCK_MODEL_VALUES_TOK ( LPAREN_TOK termList[terms,e] RPAREN_TOK |~ LPAREN_TOK )
        	    {
        	         MATCHT(BLOCK_MODEL_VALUES_TOK, &FOLLOW_BLOCK_MODEL_VALUES_TOK_in_extendedCommand3069);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1474:5: ( LPAREN_TOK termList[terms,e] RPAREN_TOK |~ LPAREN_TOK )
        	        {
        	            int alt36=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt36=1;
        	            	}
        	                break;
        	            case ALPHA:
        	            case ASSERT_TOK:
        	            case AS_TOK:
        	            case ATTRIBUTE_INST_LEVEL:
        	            case ATTRIBUTE_NAMED_TOK:
        	            case ATTRIBUTE_NO_PATTERN_TOK:
        	            case ATTRIBUTE_PATTERN_TOK:
        	            case ATTRIBUTE_TOK:
        	            case BINARY_LITERAL:
        	            case BLOCK_MODEL_TOK:
        	            case BLOCK_MODEL_VALUES_TOK:
        	            case CHAR_TOK:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case COMMENT:
        	            case COMPREHENSION_TOK:
        	            case CONSTRAINT_TOK:
        	            case CONST_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_CODATATYPES_2_5_TOK:
        	            case DECLARE_CODATATYPES_TOK:
        	            case DECLARE_CODATATYPE_TOK:
        	            case DECLARE_CONST_TOK:
        	            case DECLARE_DATATYPES_2_5_TOK:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_DATATYPE_TOK:
        	            case DECLARE_FUNS_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_HEAP:
        	            case DECLARE_PREDS_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORTS_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_CONST_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DEFINE_TOK:
        	            case DIGIT:
        	            case ECHO_TOK:
        	            case EMP_TOK:
        	            case EXISTS_TOK:
        	            case EXIT_TOK:
        	            case FORALL_TOK:
        	            case GET_ABDUCT_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_QE_DISJUNCT_TOK:
        	            case GET_QE_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case HEX_DIGIT:
        	            case HEX_LITERAL:
        	            case HO_ARROW_TOK:
        	            case HO_LAMBDA_TOK:
        	            case INCLUDE_TOK:
        	            case INDEX_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case KEYWORD:
        	            case LET_TOK:
        	            case MATCH_TOK:
        	            case NUMERAL:
        	            case PAR_TOK:
        	            case POP_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case RPAREN_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STRING_LITERAL:
        	            case SYGUS_CONSTANT_TOK:
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            case SYGUS_LET_TOK:
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            case SYGUS_VARIABLE_TOK:
        	            case SYMBOL_CHAR:
        	            case SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_FUN_V1_TOK:
        	            case SYNTH_INV_TOK:
        	            case SYNTH_INV_V1_TOK:
        	            case TESTER_TOK:
        	            case TUPLE_CONST_TOK:
        	            case TUPLE_SEL_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case WHITESPACE:
        	            case 106:
        	            	{
        	            		alt36=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 36;
        	                EXCEPTION->state        = 0;


        	                goto ruleextendedCommandEx;

        	            }

        	            switch (alt36)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1474:7: LPAREN_TOK termList[terms,e] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand3079);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_extendedCommand3081);
        	        	        termList(ctx, terms, e);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand3084);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new BlockModelValuesCommand(api::termVectorToExprs(terms))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1476:7: ~ LPAREN_TOK
        	        	    {
        	        	        if ( ((LA(1) >= ALPHA) && (LA(1) <= LET_TOK)) || ((LA(1) >= MATCH_TOK) && (LA(1) <= 106)) )
        	        	        {
        	        	            CONSUME();
        	        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        	        }
        	        	        else
        	        	        {
        	        	            CONSTRUCTEX();
        	        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	        	            EXCEPTION->expectingSet = NULL;

        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->parseError("The block-model-value command expects a list "
        	        	                                             "of terms.  Perhaps you forgot a pair of "
        	        	                                             "parentheses?");
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleextendedCommandEx; /* Prevent compiler warnings */
    ruleextendedCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end extendedCommand */

/**
 * $ANTLR start datatypes_2_5_DefCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1485:1: datatypes_2_5_DefCommand[bool isCo, std::unique_ptr<CVC4::Command>* cmd] : LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
datatypes_2_5_DefCommand(pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<api::DatatypeDecl> dts;
      std::string name;
      std::vector<api::Sort> sorts;
      std::vector<std::string> dnames;
      std::vector<unsigned> arities;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1493:3: ( LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1493:5: LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK
        {
            {
                 PARSER_STATE->checkThatLogicIsSet();
                    /* open a scope to keep the UnresolvedTypes contained */
                    PARSER_STATE->pushScope(true); 
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3139);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1497:3: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )*

            for (;;)
            {
                int alt38=2;
                switch ( LA(1) )
                {
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                	{
                		alt38=1;
                	}
                    break;

                }

                switch (alt38)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1497:5: symbol[name,CHECK_UNDECLARED,SYM_SORT]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_datatypes_2_5_DefCommand3147);
            	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypes_2_5_DefCommandEx;
            	        }


            	        {

            	                  sorts.push_back(PARSER_STATE->mkSort(name, ExprManager::SORT_FLAG_PLACEHOLDER));
            	                
            	        }


            	    }
            	    break;

            	default:
            	    goto loop38;	/* break out of the loop */
            	    break;
                }
            }
            loop38: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3163);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3167);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1503:14: ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+
            {
                int cnt39=0;

                for (;;)
                {
                    int alt39=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt39=1;
            		}
            	    break;

            	}

            	switch (alt39)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1503:16: LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand3171);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand3173);
            	            datatypeDef(ctx, isCo, dts, sorts);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3176);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt39 >= 1 )
            		{
            		    goto loop39;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypes_2_5_DefCommandEx;
            	}
            	cnt39++;
                }
                loop39: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand3181);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            {
                 PARSER_STATE->popScope();
                    cmd->reset(new DatatypeDeclarationCommand(
                      api::sortVectorToTypes(
                        PARSER_STATE->bindMutualDatatypeTypes(dts, true))));
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypes_2_5_DefCommandEx; /* Prevent compiler warnings */
    ruledatatypes_2_5_DefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypes_2_5_DefCommand */

/**
 * $ANTLR start datatypeDefCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1511:1: datatypeDefCommand[bool isCo, std::unique_ptr<CVC4::Command>* cmd] : symbol[name,CHECK_UNDECLARED,SYM_SORT] datatypesDef[isCo, dnames, arities, cmd] ;
 */
static void
datatypeDefCommand(pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<api::DatatypeDecl> dts;
      std::string name;
      std::vector<std::string> dnames;
      std::vector<int> arities;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1518:2: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] datatypesDef[isCo, dnames, arities, cmd] )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1518:4: symbol[name,CHECK_UNDECLARED,SYM_SORT] datatypesDef[isCo, dnames, arities, cmd]
        {
            {
                 PARSER_STATE->checkThatLogicIsSet(); 
            }


            FOLLOWPUSH(FOLLOW_symbol_in_datatypeDefCommand3206);
            symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefCommandEx;
            }


            {

                   dnames.push_back(name);
                   arities.push_back(-1);
                 
            }


            FOLLOWPUSH(FOLLOW_datatypesDef_in_datatypeDefCommand3213);
            datatypesDef(ctx, isCo, dnames, arities, cmd);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefCommandEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefCommandEx; /* Prevent compiler warnings */
    ruledatatypeDefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDefCommand */

/**
 * $ANTLR start datatypesDefCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1527:1: datatypesDefCommand[bool isCo, std::unique_ptr<CVC4::Command>* cmd] : LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK datatypesDef[isCo, dnames, arities, cmd] RPAREN_TOK ;
 */
static void
datatypesDefCommand(pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<api::DatatypeDecl> dts;
      std::string name;
      std::vector<std::string> dnames;
      std::vector<int> arities;

    pANTLR3_COMMON_TOKEN    n;

    /* Initialize rule variables
     */

    n       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1534:3: ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK datatypesDef[isCo, dnames, arities, cmd] RPAREN_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1534:5: LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK datatypesDef[isCo, dnames, arities, cmd] RPAREN_TOK
        {
            {
                 PARSER_STATE->checkThatLogicIsSet(); 
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand3236);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1536:3: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )*

            for (;;)
            {
                int alt40=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt40=1;
                	}
                    break;

                }

                switch (alt40)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1536:5: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand3244);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_datatypesDefCommand3246);
            	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand3251);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand3253);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        {
            	             unsigned arity = AntlrInput::tokenToUnsigned(n);
            	                  Debug("parser-dt") << "Datatype : " << name << ", arity = " << arity << std::endl;
            	                  dnames.push_back(name);
            	                  arities.push_back( static_cast<int>(arity) );
            	                
            	        }


            	    }
            	    break;

            	default:
            	    goto loop40;	/* break out of the loop */
            	    break;
                }
            }
            loop40: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand3268);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand3272);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


            FOLLOWPUSH(FOLLOW_datatypesDef_in_datatypesDefCommand3276);
            datatypesDef(ctx, isCo, dnames, arities, cmd);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand3281);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypesDefCommandEx; /* Prevent compiler warnings */
    ruledatatypesDefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypesDefCommand */

/**
 * $ANTLR start datatypesDef
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1557:1: datatypesDef[bool isCo,\n const std::vector<std::string>& dnames,\n const std::vector<int>& arities,\n std::unique_ptr<CVC4::Command>* cmd] : ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+ ;
 */
static void
datatypesDef(pSmt2Parser ctx, bool isCo, const std::vector<std::string>& dnames, const std::vector<int>& arities, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<api::DatatypeDecl> dts;
      std::string name;
      std::vector<api::Sort> params;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1566:3: ( ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+ )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1566:5: ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+
        {
            {
                 PARSER_STATE->pushScope(true);
                      // Declare the datatypes that are currently being defined as unresolved
                      // types. If we do not know the arity of the datatype yet, we wait to
                      // define it until parsing the preamble of its body, which may optionally
                      // involve `par`. This is limited to the case of single datatypes defined
                      // via declare-datatype, and hence no datatype body is parsed without
                      // having all types declared. This ensures we can parse datatypes with
                      // nested recursion, e.g. datatypes D having a subfield type
                      // (Array Int D).
                      for (unsigned i=0, dsize=dnames.size(); i<dsize; i++)
                      {
                        if( arities[i]<0 )
                        {
                          // do not know the arity yet
                          continue;
                        }
                        unsigned arity = static_cast<unsigned>(arities[i]);
                        PARSER_STATE->mkUnresolvedType(dnames[i], arity);
                      }
                    
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1586:5: ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+
            {
                int cnt45=0;

                for (;;)
                {
                    int alt45=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt45=1;
            		}
            	    break;

            	}

            	switch (alt45)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1586:7: LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef3310);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefEx;
            	            }


            	            {

            	                      params.clear();
            	                      Debug("parser-dt") << "Processing datatype #" << dts.size() << std::endl;
            	                      if( dts.size()>=dnames.size() ){
            	                        PARSER_STATE->parseError("Too many datatypes defined in this block.");
            	                      }
            	                    
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1593:5: ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ )
            	            {
            	                int alt44=2;
            	                switch ( LA(1) )
            	                {
            	                case PAR_TOK:
            	                	{
            	                		alt44=1;
            	                	}
            	                    break;
            	                case LPAREN_TOK:
            	                	{
            	                		alt44=2;
            	                	}
            	                    break;

            	                default:
            	                    CONSTRUCTEX();
            	                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                    EXCEPTION->message      = (void *)"";
            	                    EXCEPTION->decisionNum  = 44;
            	                    EXCEPTION->state        = 0;


            	                    goto ruledatatypesDefEx;

            	                }

            	                switch (alt44)
            	                {
            	            	case 1:
            	            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1593:7: PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK
            	            	    {
            	            	         MATCHT(PAR_TOK, &FOLLOW_PAR_TOK_in_datatypesDef3320);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        {
            	            	             PARSER_STATE->pushScope(true); 
            	            	        }


            	            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef3324);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1594:7: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )*

            	            	        for (;;)
            	            	        {
            	            	            int alt41=2;
            	            	            switch ( LA(1) )
            	            	            {
            	            	            case QUOTED_SYMBOL:
            	            	            case SIMPLE_SYMBOL:
            	            	            case UNTERMINATED_QUOTED_SYMBOL:
            	            	            	{
            	            	            		alt41=1;
            	            	            	}
            	            	                break;

            	            	            }

            	            	            switch (alt41)
            	            	            {
            	            	        	case 1:
            	            	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1594:9: symbol[name,CHECK_UNDECLARED,SYM_SORT]
            	            	        	    {
            	            	        	        FOLLOWPUSH(FOLLOW_symbol_in_datatypesDef3334);
            	            	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	            	        	        FOLLOWPOP();
            	            	        	        if  (HASEXCEPTION())
            	            	        	        {
            	            	        	            goto ruledatatypesDefEx;
            	            	        	        }


            	            	        	        {

            	            	        	                      params.push_back( PARSER_STATE->mkSort(name, ExprManager::SORT_FLAG_PLACEHOLDER)); 
            	            	        	        }


            	            	        	    }
            	            	        	    break;

            	            	        	default:
            	            	        	    goto loop41;	/* break out of the loop */
            	            	        	    break;
            	            	            }
            	            	        }
            	            	        loop41: ; /* Jump out to here if this rule does not match */


            	            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3362);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        {

            	            	                    // if the arity was fixed by prelude and is not equal to the number of parameters
            	            	                    if( arities[dts.size()]>=0 && static_cast<int>(params.size())!=arities[dts.size()] ){
            	            	                      PARSER_STATE->parseError("Wrong number of parameters for datatype.");
            	            	                    }
            	            	                    if (arities[dts.size()]<0)
            	            	                    {
            	            	                      // now declare it as an unresolved type
            	            	                      PARSER_STATE->mkUnresolvedType(dnames[dts.size()], params.size());
            	            	                    }
            	            	                    Debug("parser-dt") << params.size() << " parameters for " << dnames[dts.size()] << std::endl;
            	            	                    dts.push_back(SOLVER->mkDatatypeDecl(dnames[dts.size()], params, isCo));
            	            	                  
            	            	        }


            	            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef3372);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1612:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	        {
            	            	            int cnt42=0;

            	            	            for (;;)
            	            	            {
            	            	                int alt42=2;
            	            	        	switch ( LA(1) )
            	            	        	{
            	            	        	case LPAREN_TOK:
            	            	        		{
            	            	        			alt42=1;
            	            	        		}
            	            	        	    break;

            	            	        	}

            	            	        	switch (alt42)
            	            	        	{
            	            	        	    case 1:
            	            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1612:9: LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK
            	            	        	        {
            	            	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef3382);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypesDef3384);
            	            	        	            constructorDef(ctx, dts.back());

            	            	        	            FOLLOWPOP();
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3387);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	        }
            	            	        	        break;

            	            	        	    default:

            	            	        		if ( cnt42 >= 1 )
            	            	        		{
            	            	        		    goto loop42;
            	            	        		}
            	            	        		/* mismatchedSetEx()
            	            	        		 */
            	            	        		CONSTRUCTEX();
            	            	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            	        		goto ruledatatypesDefEx;
            	            	        	}
            	            	        	cnt42++;
            	            	            }
            	            	            loop42: ;	/* Jump to here if this rule does not match */
            	            	        }

            	            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3398);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        {
            	            	             PARSER_STATE->popScope(); 
            	            	        }


            	            	    }
            	            	    break;
            	            	case 2:
            	            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1614:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	    {
            	            	        {
            	            	             // if the arity was fixed by prelude and is not equal to 0
            	            	                    if( arities[dts.size()]>0 ){
            	            	                      PARSER_STATE->parseError("No parameters given for datatype.");
            	            	                    }
            	            	                    else if (arities[dts.size()]<0)
            	            	                    {
            	            	                      // now declare it as an unresolved type
            	            	                      PARSER_STATE->mkUnresolvedType(dnames[dts.size()], 0);
            	            	                    }
            	            	                    Debug("parser-dt") << params.size() << " parameters for " << dnames[dts.size()] << std::endl;
            	            	                    dts.push_back(SOLVER->mkDatatypeDecl(dnames[dts.size()],
            	            	                                                         params,
            	            	                                                         isCo));
            	            	                  
            	            	        }


            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1628:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	        {
            	            	            int cnt43=0;

            	            	            for (;;)
            	            	            {
            	            	                int alt43=2;
            	            	        	switch ( LA(1) )
            	            	        	{
            	            	        	case LPAREN_TOK:
            	            	        		{
            	            	        			alt43=1;
            	            	        		}
            	            	        	    break;

            	            	        	}

            	            	        	switch (alt43)
            	            	        	{
            	            	        	    case 1:
            	            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1628:9: LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK
            	            	        	        {
            	            	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef3418);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypesDef3420);
            	            	        	            constructorDef(ctx, dts.back());

            	            	        	            FOLLOWPOP();
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3423);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	        }
            	            	        	        break;

            	            	        	    default:

            	            	        		if ( cnt43 >= 1 )
            	            	        		{
            	            	        		    goto loop43;
            	            	        		}
            	            	        		/* mismatchedSetEx()
            	            	        		 */
            	            	        		CONSTRUCTEX();
            	            	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            	        		goto ruledatatypesDefEx;
            	            	        	}
            	            	        	cnt43++;
            	            	            }
            	            	            loop43: ;	/* Jump to here if this rule does not match */
            	            	        }

            	            	    }
            	            	    break;

            	                }
            	            }

            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3438);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt45 >= 1 )
            		{
            		    goto loop45;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypesDefEx;
            	}
            	cnt45++;
                }
                loop45: ;	/* Jump to here if this rule does not match */
            }

            {

                    PARSER_STATE->popScope();
                    cmd->reset(new DatatypeDeclarationCommand(
                      api::sortVectorToTypes(
                        PARSER_STATE->bindMutualDatatypeTypes(dts, true))));
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypesDefEx; /* Prevent compiler warnings */
    ruledatatypesDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypesDef */

/**
 * $ANTLR start simpleSymbolicExprNoKeyword
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1640:1: simpleSymbolicExprNoKeyword[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECK_SAT_TOK | CHECK_SAT_ASSUMING_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | SIMPLIFY_TOK ) );
 */
static void
simpleSymbolicExprNoKeyword(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      CVC4::Kind k;
      std::string s;
      std::vector<unsigned int> s_vec;

    pANTLR3_COMMON_TOKEN    tok;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL5;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL6;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL7;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL8;

    /* Initialize rule variables
     */

    tok       = NULL;
    INTEGER_LITERAL5       = NULL;
    DECIMAL_LITERAL6       = NULL;
    HEX_LITERAL7       = NULL;
    BINARY_LITERAL8       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1646:3: ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECK_SAT_TOK | CHECK_SAT_ASSUMING_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | SIMPLIFY_TOK ) )

            ANTLR3_UINT32 alt46;

            alt46=7;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt46=1;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt46=2;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt46=3;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt46=4;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt46=5;
            	}
                break;
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt46=6;
            	}
                break;
            case ASSERT_TOK:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case POP_TOK:
            case PUSH_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt46=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 46;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprNoKeywordEx;

            }

            switch (alt46)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1646:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL5 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3468);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL5))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1648:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL6 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3480);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL6)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1650:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL7 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3492);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL7).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL7, 2);
        	                  sexpr = SExpr(Integer(hexString, 16));
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1655:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL8 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3504);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL8).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL8, 2);
        	                  sexpr = SExpr(Integer(binString, 2));
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1660:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExprNoKeyword3516);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1662:5: symbol[s,CHECK_NONE,SYM_SORT]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3529);
        	        symbol(ctx, s, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(SExpr::Keyword(s)); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1664:5: tok= ( ASSERT_TOK | CHECK_SAT_TOK | CHECK_SAT_ASSUMING_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | SIMPLIFY_TOK )
        	    {
        	        tok=(pANTLR3_COMMON_TOKEN)LT(1);

        	        if ( LA(1) == ASSERT_TOK || ((LA(1) >= CHECK_SAT_ASSUMING_TOK) && (LA(1) <= CHECK_SAT_TOK)) || LA(1) == DECLARE_DATATYPES_TOK || LA(1) == DECLARE_FUN_TOK || LA(1) == DECLARE_SORT_TOK || ((LA(1) >= DEFINE_FUNS_REC_TOK) && (LA(1) <= DEFINE_SORT_TOK)) || LA(1) == ECHO_TOK || LA(1) == EXIT_TOK || ((LA(1) >= GET_ASSERTIONS_TOK) && (LA(1) <= GET_PROOF_TOK)) || ((LA(1) >= GET_UNSAT_ASSUMPTIONS_TOK) && (LA(1) <= GET_VALUE_TOK)) || ((LA(1) >= POP_TOK) && (LA(1) <= PUSH_TOK)) || ((LA(1) >= RESET_ASSERTIONS_TOK) && (LA(1) <= RESET_TOK)) || ((LA(1) >= SET_INFO_TOK) && (LA(1) <= SET_LOGIC_TOK)) || LA(1) == SET_OPTION_TOK || LA(1) == SIMPLIFY_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        }
        	        else
        	        {
        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(SExpr::Keyword(AntlrInput::tokenText(tok))); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprNoKeywordEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprNoKeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExprNoKeyword */

/**
 * $ANTLR start keyword
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1676:1: keyword[std::string& s] : KEYWORD ;
 */
static void
keyword(pSmt2Parser ctx, std::string& s)
{
    pANTLR3_COMMON_TOKEN    KEYWORD9;

    /* Initialize rule variables
     */

    KEYWORD9       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1677:3: ( KEYWORD )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1677:5: KEYWORD
        {
            KEYWORD9 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_keyword3742);
            if  (HASEXCEPTION())
            {
                goto rulekeywordEx;
            }


            {
                 s = AntlrInput::tokenText(KEYWORD9); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulekeywordEx; /* Prevent compiler warnings */
    rulekeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end keyword */

/**
 * $ANTLR start simpleSymbolicExpr
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1681:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD );
 */
static void
simpleSymbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{
    pANTLR3_COMMON_TOKEN    KEYWORD10;

    /* Initialize rule variables
     */

    KEYWORD10       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1682:3: ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD )

            ANTLR3_UINT32 alt47;

            alt47=2;

            switch ( LA(1) )
            {
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case POP_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STRING_LITERAL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt47=1;
            	}
                break;
            case KEYWORD:
            	{
            		alt47=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 47;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt47)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1682:5: simpleSymbolicExprNoKeyword[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3762);
        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1683:5: KEYWORD
        	    {
        	        KEYWORD10 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_simpleSymbolicExpr3769);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }


        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(KEYWORD10)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1687:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK );
 */
static void
symbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1691:3: ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK )

            ANTLR3_UINT32 alt49;

            alt49=2;

            switch ( LA(1) )
            {
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case KEYWORD:
            case POP_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STRING_LITERAL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt49=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt49=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 49;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt49)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1691:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr3794);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1692:5: LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_symbolicExpr3801);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1693:5: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt48=2;
        	            switch ( LA(1) )
        	            {
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case ECHO_TOK:
        	            case EXIT_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case KEYWORD:
        	            case LPAREN_TOK:
        	            case POP_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STRING_LITERAL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt48=1;
        	            	}
        	                break;

        	            }

        	            switch (alt48)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1693:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr3809);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }


        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop48;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop48: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_symbolicExpr3817);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start term
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1701:1: term[CVC4::api::Term& expr, CVC4::api::Term& expr2] : ( termNonVariable[expr, expr2] | qualIdentifier[p] );
 */
static void
term(pSmt2Parser ctx, CVC4::api::Term& expr, CVC4::api::Term& expr2)
{
    /* Initialize rule variables
     */


      api::Kind kind = api::NULL_EXPR;
      CVC4::api::Term f;
      std::string name;
      CVC4::api::Sort type;
      ParseOp p;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1709:3: ( termNonVariable[expr, expr2] | qualIdentifier[p] )

            ANTLR3_UINT32 alt50;

            alt50=2;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case ATTRIBUTE_TOK:
            		case COMPREHENSION_TOK:
            		case EXISTS_TOK:
            		case FORALL_TOK:
            		case HO_LAMBDA_TOK:
            		case LET_TOK:
            		case LPAREN_TOK:
            		case MATCH_TOK:
            		case QUOTED_SYMBOL:
            		case SIMPLE_SYMBOL:
            		case SYGUS_LET_TOK:
            		case TUPLE_CONST_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            			{
            				alt50=1;
            			}
            		    break;
            		case INDEX_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case AS_TOK:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 1;


            		    goto ruletermEx;

            		}

            	}
                break;
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case STRING_LITERAL:
            case TUPLE_CONST_TOK:
            	{
            		alt50=1;
            	}
                break;
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt50=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 50;
                EXCEPTION->state        = 0;


                goto ruletermEx;

            }

            switch (alt50)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1709:3: termNonVariable[expr, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_termNonVariable_in_term3842);
        	        termNonVariable(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1713:5: qualIdentifier[p]
        	    {
        	        FOLLOWPUSH(FOLLOW_qualIdentifier_in_term3854);
        	        qualIdentifier(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {

        	                  expr = PARSER_STATE->parseOpToExpr(p);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start termNonVariable
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1724:1: termNonVariable[CVC4::api::Term& expr, CVC4::api::Term& expr2] : ( LPAREN_TOK quantOp[kind] boundVarList[bvl] term[f, f2] RPAREN_TOK | LPAREN_TOK COMPREHENSION_TOK boundVarList[bvl] term[f, f2] term[f, f2] RPAREN_TOK | LPAREN_TOK qualIdentifier[p] termList[args,expr] RPAREN_TOK | LPAREN_TOK ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ ) RPAREN_TOK term[expr, f2] RPAREN_TOK | LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK | LPAREN_TOK HO_LAMBDA_TOK boundVarList[bvl] term[f, f2] RPAREN_TOK | LPAREN_TOK TUPLE_CONST_TOK termList[args,expr] RPAREN_TOK | termAtomic[atomTerm] );
 */
static void
termNonVariable(pSmt2Parser ctx, CVC4::api::Term& expr, CVC4::api::Term& expr2)
{
    /* Initialize rule variables
     */


      Debug("parser") << "term: " << AntlrInput::tokenText(LT(1)) << std::endl;
      api::Kind kind = api::NULL_EXPR;
      std::string name;
      std::vector<CVC4::api::Term> args;
      std::vector< std::pair<std::string, CVC4::api::Sort> > sortedVarNames;
      CVC4::api::Term bvl;
      CVC4::api::Term f, f2, f3;
      std::string attr;
      CVC4::api::Term attexpr;
      std::vector<CVC4::api::Term> patexprs;
      std::vector<CVC4::api::Term> matchcases;
      std::unordered_set<std::string> names;
      std::vector< std::pair<std::string, CVC4::api::Term> > binders;
      CVC4::api::Sort type;
      CVC4::api::Sort type2;
      api::Term atomTerm;
      ParseOp p;
      std::vector<api::Sort> argTypes;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1745:3: ( LPAREN_TOK quantOp[kind] boundVarList[bvl] term[f, f2] RPAREN_TOK | LPAREN_TOK COMPREHENSION_TOK boundVarList[bvl] term[f, f2] term[f, f2] RPAREN_TOK | LPAREN_TOK qualIdentifier[p] termList[args,expr] RPAREN_TOK | LPAREN_TOK ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ ) RPAREN_TOK term[expr, f2] RPAREN_TOK | LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK | LPAREN_TOK HO_LAMBDA_TOK boundVarList[bvl] term[f, f2] RPAREN_TOK | LPAREN_TOK TUPLE_CONST_TOK termList[args,expr] RPAREN_TOK | termAtomic[atomTerm] )

            ANTLR3_UINT32 alt57;

            alt57=9;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case COMPREHENSION_TOK:
            			{
            				alt57=2;
            			}
            		    break;
            		case MATCH_TOK:
            			{
            				alt57=5;
            			}
            		    break;
            		case ATTRIBUTE_TOK:
            			{
            				alt57=6;
            			}
            		    break;
            		case HO_LAMBDA_TOK:
            			{
            				alt57=7;
            			}
            		    break;
            		case TUPLE_CONST_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case INDEX_TOK:
            			{
            				alt57=9;
            			}
            		    break;
            		case EXISTS_TOK:
            		case FORALL_TOK:
            			{
            				alt57=1;
            			}
            		    break;
            		case LPAREN_TOK:
            		case QUOTED_SYMBOL:
            		case SIMPLE_SYMBOL:
            		case UNTERMINATED_QUOTED_SYMBOL:
            			{
            				alt57=3;
            			}
            		    break;
            		case LET_TOK:
            		case SYGUS_LET_TOK:
            			{
            				alt57=4;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 1;


            		    goto ruletermNonVariableEx;

            		}

            	}
                break;
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case STRING_LITERAL:
            case TUPLE_CONST_TOK:
            	{
            		alt57=9;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 57;
                EXCEPTION->state        = 0;


                goto ruletermNonVariableEx;

            }

            switch (alt57)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1745:5: LPAREN_TOK quantOp[kind] boundVarList[bvl] term[f, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3882);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_quantOp_in_termNonVariable3884);
        	        quantOp(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  if (!PARSER_STATE->isTheoryEnabled(theory::THEORY_QUANTIFIERS))
        	                  {
        	                    PARSER_STATE->parseError("Quantifier used in non-quantified logic.");
        	                  }
        	                  PARSER_STATE->pushScope(true);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarList_in_termNonVariable3897);
        	        boundVarList(ctx, bvl);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable3904);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3907);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  args.push_back(bvl);

        	                  PARSER_STATE->popScope();
        	                  args.push_back(f);
        	                  if(! f2.isNull()){
        	                    args.push_back(f2);
        	                  }
        	                  expr = MK_TERM(kind, args);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1765:5: LPAREN_TOK COMPREHENSION_TOK boundVarList[bvl] term[f, f2] term[f, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3919);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(COMPREHENSION_TOK, &FOLLOW_COMPREHENSION_TOK_in_termNonVariable3921);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(true); 
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarList_in_termNonVariable3933);
        	        boundVarList(ctx, bvl);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  args.push_back(bvl);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable3946);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             args.push_back(f); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable3955);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  args.push_back(f);
        	                  expr = MK_TERM(api::COMPREHENSION, args);
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3964);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1777:5: LPAREN_TOK qualIdentifier[p] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3970);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_qualIdentifier_in_termNonVariable3972);
        	        qualIdentifier(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_termNonVariable3979);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3982);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  expr = PARSER_STATE->applyParseOp(p, args);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1783:5: LPAREN_TOK ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ ) RPAREN_TOK term[expr, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4000);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1783:16: ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ )
        	        {
        	            int alt53=2;
        	            switch ( LA(1) )
        	            {
        	            case LET_TOK:
        	            	{
        	            		alt53=1;
        	            	}
        	                break;
        	            case SYGUS_LET_TOK:
        	            	{
        	            		alt53=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 53;
        	                EXCEPTION->state        = 0;


        	                goto ruletermNonVariableEx;

        	            }

        	            switch (alt53)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1784:7: LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+
        	        	    {
        	        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_termNonVariable4010);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4012);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->pushScope(true); 
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1786:7: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+
        	        	        {
        	        	            int cnt51=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt51=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt51=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt51)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1786:9: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4030);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4032);
        	        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4043);
        	        	        	            term(ctx, expr, f2);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4054);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 if(names.count(name) == 1) {
        	        	        	                            std::stringstream ss;
        	        	        	                            ss << "warning: symbol `" << name << "' bound multiple times by let;"
        	        	        	                               << " the last binding will be used, shadowing earlier ones";
        	        	        	                            PARSER_STATE->warning(ss.str());
        	        	        	                          } else {
        	        	        	                            names.insert(name);
        	        	        	                          }
        	        	        	                          binders.push_back(std::make_pair(name, expr)); 
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt51 >= 1 )
        	        	        		{
        	        	        		    goto loop51;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto ruletermNonVariableEx;
        	        	        	}
        	        	        	cnt51++;
        	        	            }
        	        	            loop51: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1800:7: SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+
        	        	    {
        	        	         MATCHT(SYGUS_LET_TOK, &FOLLOW_SYGUS_LET_TOK_in_termNonVariable4095);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4097);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->pushScope(true); 
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1802:7: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+
        	        	        {
        	        	            int cnt52=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt52=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt52=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt52)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1802:9: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4115);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4117);
        	        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_termNonVariable4128);
        	        	        	            sortSymbol(ctx, type, CHECK_DECLARED);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4139);
        	        	        	            term(ctx, expr, f2);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4150);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 if(names.count(name) == 1) {
        	        	        	                            std::stringstream ss;
        	        	        	                            ss << "warning: symbol `" << name << "' bound multiple times by let;"
        	        	        	                               << " the last binding will be used, shadowing earlier ones";
        	        	        	                            PARSER_STATE->warning(ss.str());
        	        	        	                          } else {
        	        	        	                            names.insert(name);
        	        	        	                          }
        	        	        	                          binders.push_back(std::make_pair(name, expr)); 
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt52 >= 1 )
        	        	        		{
        	        	        		    goto loop52;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto ruletermNonVariableEx;
        	        	        	}
        	        	        	cnt52++;
        	        	            }
        	        	            loop52: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             // now implement these bindings
        	                  for (const std::pair<std::string, api::Term>& binder : binders)
        	                  {
        	                    {
        	                      PARSER_STATE->defineVar(binder.first, binder.second);
        	                    }
        	                  }
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4195);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4201);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4208);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1830:5: LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4226);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(MATCH_TOK, &FOLLOW_MATCH_TOK_in_termNonVariable4228);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4230);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  if( !expr.getSort().isDatatype() ){
        	                    PARSER_STATE->parseError("Cannot match on non-datatype term.");
        	                  }
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4239);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1836:5: ( LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+
        	        {
        	            int cnt55=0;

        	            for (;;)
        	            {
        	                int alt55=3;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			switch ( LA(2) )
        	        			{
        	        			case LPAREN_TOK:
        	        				{
        	        					alt55=1;
        	        				}
        	        			    break;
        	        			case QUOTED_SYMBOL:
        	        			case SIMPLE_SYMBOL:
        	        			case UNTERMINATED_QUOTED_SYMBOL:
        	        				{
        	        					alt55=2;
        	        				}
        	        			    break;

        	        			}

        	        		}
        	        	    break;

        	        	}

        	        	switch (alt55)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1838:7: LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4260);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4262);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4264);
        	        	            term(ctx, f, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {

        	        	                          args.clear();
        	        	                          PARSER_STATE->pushScope(true);
        	        	                          // f should be a constructor
        	        	                          type = f.getSort();
        	        	                          Debug("parser-dt") << "Pattern head : " << f << " " << type << std::endl;
        	        	                          if (!type.isConstructor())
        	        	                          {
        	        	                            PARSER_STATE->parseError("Pattern must be application of a constructor or a variable.");
        	        	                          }
        	        	                          Expr ef = f.getExpr();
        	        	                          if (Datatype::datatypeOf(ef).isParametric())
        	        	                          {
        	        	                            type = api::Sort(
        	        	                                SOLVER,
        	        	                                Datatype::datatypeOf(ef)[Datatype::indexOf(ef)]
        	        	                                    .getSpecializedConstructorType(expr.getSort().getType()));
        	        	                          }
        	        	                          argTypes = type.getConstructorDomainSorts();
        	        	                        
        	        	            }


        	        	            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1859:9: ( symbol[name,CHECK_NONE,SYM_VARIABLE] )*

        	        	            for (;;)
        	        	            {
        	        	                int alt54=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                case QUOTED_SYMBOL:
        	        	                case SIMPLE_SYMBOL:
        	        	                case UNTERMINATED_QUOTED_SYMBOL:
        	        	                	{
        	        	                		alt54=1;
        	        	                	}
        	        	                    break;

        	        	                }

        	        	                switch (alt54)
        	        	                {
        	        	            	case 1:
        	        	            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1859:11: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	            	    {
        	        	            	        FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4288);
        	        	            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            	        FOLLOWPOP();
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto ruletermNonVariableEx;
        	        	            	        }


        	        	            	        {

        	        	            	                        if (args.size() >= argTypes.size())
        	        	            	                        {
        	        	            	                          PARSER_STATE->parseError("Too many arguments for pattern.");
        	        	            	                        }
        	        	            	                        //make of proper type
        	        	            	                        api::Term arg = PARSER_STATE->bindBoundVar(name, argTypes[args.size()]);
        	        	            	                        args.push_back( arg );
        	        	            	                      
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	            	default:
        	        	            	    goto loop54;	/* break out of the loop */
        	        	            	    break;
        	        	                }
        	        	            }
        	        	            loop54: ; /* Jump out to here if this rule does not match */


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4312);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4314);
        	        	            term(ctx, f3, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {

        	        	                          // make the match case
        	        	                          std::vector<CVC4::api::Term> cargs;
        	        	                          cargs.push_back(f);
        	        	                          cargs.insert(cargs.end(),args.begin(),args.end());
        	        	                          api::Term c = MK_TERM(api::APPLY_CONSTRUCTOR,cargs);
        	        	                          api::Term bvla = MK_TERM(api::BOUND_VAR_LIST,args);
        	        	                          api::Term mc = MK_TERM(api::MATCH_BIND_CASE, bvla, c, f3);
        	        	                          matchcases.push_back(mc);
        	        	                          // now, pop the scope
        	        	                          PARSER_STATE->popScope();
        	        	                        
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4327);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	        }
        	        	        break;
        	        	    case 2:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1883:9: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[f3, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4344);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4346);
        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {

        	        	                          if (PARSER_STATE->isDeclared(name,SYM_VARIABLE))
        	        	                          {
        	        	                            f = PARSER_STATE->getVariable(name);
        	        	                            type = f.getSort();
        	        	                            if (!type.isConstructor() ||
        	        	                                !type.getConstructorDomainSorts().empty())
        	        	                            {
        	        	                              PARSER_STATE->parseError("Must apply constructors of arity greater than 0 to arguments in pattern.");
        	        	                            }
        	        	                            // make nullary constructor application
        	        	                            f = MK_TERM(api::APPLY_CONSTRUCTOR, f);
        	        	                          }
        	        	                          else
        	        	                          {
        	        	                            // it has the type of the head expr
        	        	                            f = PARSER_STATE->bindBoundVar(name, expr.getSort());
        	        	                          }
        	        	                        
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4359);
        	        	            term(ctx, f3, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {

        	        	                          api::Term mc;
        	        	                          if (f.getKind() == api::VARIABLE)
        	        	                          {
        	        	                            api::Term bvlf = MK_TERM(api::BOUND_VAR_LIST, f);
        	        	                            mc = MK_TERM(api::MATCH_BIND_CASE, bvlf, f, f3);
        	        	                          }
        	        	                          else
        	        	                          {
        	        	                            mc = MK_TERM(api::MATCH_CASE, f, f3);
        	        	                          }
        	        	                          matchcases.push_back(mc);
        	        	                        
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4372);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt55 >= 1 )
        	        		{
        	        		    goto loop55;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermNonVariableEx;
        	        	}
        	        	cnt55++;
        	            }
        	            loop55: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4385);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4387);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  //now, make the match
        	                  if (matchcases.empty())
        	                  {
        	                    PARSER_STATE->parseError("Must have at least one case in match.");
        	                  }
        	                  std::vector<api::Term> mchildren;
        	                  mchildren.push_back(expr);
        	                  mchildren.insert(mchildren.end(), matchcases.begin(), matchcases.end());
        	                  expr = MK_TERM(api::MATCH, mchildren);
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1930:5: LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4403);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(ATTRIBUTE_TOK, &FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4405);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4407);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1931:5: ( attribute[expr, attexpr, attr] )+
        	        {
        	            int cnt56=0;

        	            for (;;)
        	            {
        	                int alt56=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case ATTRIBUTE_INST_LEVEL:
        	        	case ATTRIBUTE_NAMED_TOK:
        	        	case ATTRIBUTE_NO_PATTERN_TOK:
        	        	case ATTRIBUTE_PATTERN_TOK:
        	        	case KEYWORD:
        	        		{
        	        			alt56=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt56)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1931:7: attribute[expr, attexpr, attr]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_attribute_in_termNonVariable4416);
        	        	            attribute(ctx, expr, attexpr, attr);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {
        	        	                 if( ! attexpr.isNull()) {
        	        	                          patexprs.push_back( attexpr );
        	        	                        }
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt56 >= 1 )
        	        		{
        	        		    goto loop56;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermNonVariableEx;
        	        	}
        	        	cnt56++;
        	            }
        	            loop56: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4434);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  if(! patexprs.empty()) {
        	                    if( !f2.isNull() && f2.getKind()==api::INST_PATTERN_LIST ){
        	                      for( size_t i=0; i<f2.getNumChildren(); i++ ){
        	                        if( f2[i].getKind()==api::INST_PATTERN ){
        	                          patexprs.push_back( f2[i] );
        	                        }else{
        	                          std::stringstream ss;
        	                          ss << "warning: rewrite rules do not support " << f2[i]
        	                             << " within instantiation pattern list";
        	                          PARSER_STATE->warning(ss.str());
        	                        }
        	                      }
        	                    }
        	                    expr2 = MK_TERM(api::INST_PATTERN_LIST, patexprs);
        	                  } else {
        	                    expr2 = f2;
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1957:5: LPAREN_TOK HO_LAMBDA_TOK boundVarList[bvl] term[f, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4452);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(HO_LAMBDA_TOK, &FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4454);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(true); 
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarList_in_termNonVariable4466);
        	        boundVarList(ctx, bvl);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4473);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4476);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  args.push_back(bvl);
        	                  args.push_back(f);
        	                  PARSER_STATE->popScope();
        	                  expr = MK_TERM(api::LAMBDA, args);
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1967:5: LPAREN_TOK TUPLE_CONST_TOK termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4488);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(TUPLE_CONST_TOK, &FOLLOW_TUPLE_CONST_TOK_in_termNonVariable4490);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_termNonVariable4492);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4495);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                std::vector<api::Sort> sorts;
        	                std::vector<api::Term> terms;
        	                for (const api::Term& arg : args)
        	                {
        	                  sorts.emplace_back(arg.getSort());
        	                  terms.emplace_back(arg);
        	                }
        	                expr = SOLVER->mkTuple(sorts, terms);
        	              
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:1979:5: termAtomic[atomTerm]
        	    {
        	        FOLLOWPUSH(FOLLOW_termAtomic_in_termNonVariable4511);
        	        termAtomic(ctx, atomTerm);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = atomTerm; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermNonVariableEx; /* Prevent compiler warnings */
    ruletermNonVariableEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end termNonVariable */

/**
 * $ANTLR start qualIdentifier
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2033:1: qualIdentifier[CVC4::ParseOp& p] : ( identifier[p] | LPAREN_TOK AS_TOK ( CONST_TOK sortSymbol[type, CHECK_DECLARED] | identifier[p] sortSymbol[type, CHECK_DECLARED] ) RPAREN_TOK );
 */
static void
qualIdentifier(pSmt2Parser ctx, CVC4::ParseOp& p)
{
    /* Initialize rule variables
     */


      api::Kind k;
      std::string baseName;
      CVC4::api::Term f;
      CVC4::api::Sort type;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2040:3: ( identifier[p] | LPAREN_TOK AS_TOK ( CONST_TOK sortSymbol[type, CHECK_DECLARED] | identifier[p] sortSymbol[type, CHECK_DECLARED] ) RPAREN_TOK )

            ANTLR3_UINT32 alt59;

            alt59=2;

            switch ( LA(1) )
            {
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt59=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case INDEX_TOK:
            			{
            				alt59=1;
            			}
            		    break;
            		case AS_TOK:
            			{
            				alt59=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 59;
            		    EXCEPTION->state        = 4;


            		    goto rulequalIdentifierEx;

            		}

            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 59;
                EXCEPTION->state        = 0;


                goto rulequalIdentifierEx;

            }

            switch (alt59)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2040:3: identifier[p]
        	    {
        	        FOLLOWPUSH(FOLLOW_identifier_in_qualIdentifier4534);
        	        identifier(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequalIdentifierEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2041:5: LPAREN_TOK AS_TOK ( CONST_TOK sortSymbol[type, CHECK_DECLARED] | identifier[p] sortSymbol[type, CHECK_DECLARED] ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_qualIdentifier4541);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequalIdentifierEx;
        	        }


        	         MATCHT(AS_TOK, &FOLLOW_AS_TOK_in_qualIdentifier4543);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequalIdentifierEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2042:5: ( CONST_TOK sortSymbol[type, CHECK_DECLARED] | identifier[p] sortSymbol[type, CHECK_DECLARED] )
        	        {
        	            int alt58=2;
        	            switch ( LA(1) )
        	            {
        	            case CONST_TOK:
        	            	{
        	            		alt58=1;
        	            	}
        	                break;
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case SIMPLE_SYMBOL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt58=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 58;
        	                EXCEPTION->state        = 0;


        	                goto rulequalIdentifierEx;

        	            }

        	            switch (alt58)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2042:7: CONST_TOK sortSymbol[type, CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(CONST_TOK, &FOLLOW_CONST_TOK_in_qualIdentifier4551);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulequalIdentifierEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_qualIdentifier4553);
        	        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulequalIdentifierEx;
        	        	        }


        	        	        {

        	        	                    p.d_kind = api::CONST_ARRAY;
        	        	                    PARSER_STATE->parseOpApplyTypeAscription(p, type);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2047:7: identifier[p] sortSymbol[type, CHECK_DECLARED]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_identifier_in_qualIdentifier4570);
        	        	        identifier(ctx, p);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulequalIdentifierEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_qualIdentifier4579);
        	        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulequalIdentifierEx;
        	        	        }


        	        	        {

        	        	                    PARSER_STATE->parseOpApplyTypeAscription(p, type);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_qualIdentifier4600);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequalIdentifierEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulequalIdentifierEx; /* Prevent compiler warnings */
    rulequalIdentifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end qualIdentifier */

/**
 * $ANTLR start identifier
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2064:1: identifier[CVC4::ParseOp& p] : ( functionName[p.d_name, CHECK_NONE] | LPAREN_TOK INDEX_TOK ( TESTER_TOK term[f, f2] | TUPLE_SEL_TOK m= INTEGER_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] ) RPAREN_TOK );
 */
static void
identifier(pSmt2Parser ctx, CVC4::ParseOp& p)
{
    pANTLR3_COMMON_TOKEN    m;
    pANTLR3_COMMON_TOKEN    sym;

    /* Initialize rule variables
     */


      CVC4::api::Term f;
      CVC4::api::Term f2;
      std::vector<uint64_t> numerals;

    m       = NULL;
    sym       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2070:3: ( functionName[p.d_name, CHECK_NONE] | LPAREN_TOK INDEX_TOK ( TESTER_TOK term[f, f2] | TUPLE_SEL_TOK m= INTEGER_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] ) RPAREN_TOK )

            ANTLR3_UINT32 alt61;

            alt61=2;

            switch ( LA(1) )
            {
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt61=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt61=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 61;
                EXCEPTION->state        = 0;


                goto ruleidentifierEx;

            }

            switch (alt61)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2070:3: functionName[p.d_name, CHECK_NONE]
        	    {
        	        FOLLOWPUSH(FOLLOW_functionName_in_identifier4619);
        	        functionName(ctx, p.d_name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleidentifierEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2074:5: LPAREN_TOK INDEX_TOK ( TESTER_TOK term[f, f2] | TUPLE_SEL_TOK m= INTEGER_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_identifier4631);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleidentifierEx;
        	        }


        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_identifier4633);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleidentifierEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2075:5: ( TESTER_TOK term[f, f2] | TUPLE_SEL_TOK m= INTEGER_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] )
        	        {
        	            int alt60=3;
        	            switch ( LA(1) )
        	            {
        	            case TESTER_TOK:
        	            	{
        	            		alt60=1;
        	            	}
        	                break;
        	            case TUPLE_SEL_TOK:
        	            	{
        	            		alt60=2;
        	            	}
        	                break;
        	            case SIMPLE_SYMBOL:
        	            	{
        	            		alt60=3;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 60;
        	                EXCEPTION->state        = 0;


        	                goto ruleidentifierEx;

        	            }

        	            switch (alt60)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2075:7: TESTER_TOK term[f, f2]
        	        	    {
        	        	         MATCHT(TESTER_TOK, &FOLLOW_TESTER_TOK_in_identifier4641);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleidentifierEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_identifier4643);
        	        	        term(ctx, f, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleidentifierEx;
        	        	        }


        	        	        {

        	        	                    if (f.getKind() == api::APPLY_CONSTRUCTOR && f.getNumChildren() == 1)
        	        	                    {
        	        	                      // for nullary constructors, must get the operator
        	        	                      f = f[0];
        	        	                    }
        	        	                    if (!f.getSort().isConstructor())
        	        	                    {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Bad syntax for test (_ is X), X must be a constructor.");
        	        	                    }
        	        	                    // get the datatype that f belongs to
        	        	                    api::Sort sf = f.getSort().getConstructorCodomainSort();
        	        	                    api::Datatype d = sf.getDatatype();
        	        	                    // lookup by name
        	        	                    api::DatatypeConstructor dc = d.getConstructor(f.toString());
        	        	                    p.d_expr = dc.getTesterTerm();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2094:7: TUPLE_SEL_TOK m= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(TUPLE_SEL_TOK, &FOLLOW_TUPLE_SEL_TOK_in_identifier4660);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleidentifierEx;
        	        	        }


        	        	        m = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_identifier4664);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleidentifierEx;
        	        	        }


        	        	        {

        	        	                    // we adopt a special syntax (_ tupSel n)
        	        	                    p.d_kind = api::APPLY_SELECTOR;
        	        	                    // put m in expr so that the caller can deal with this case
        	        	                    p.d_expr = SOLVER->mkReal(AntlrInput::tokenToUnsigned(m));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2101:7: sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals]
        	        	    {
        	        	        sym = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_identifier4682);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleidentifierEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_nonemptyNumeralList_in_identifier4684);
        	        	        nonemptyNumeralList(ctx, numerals);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleidentifierEx;
        	        	        }


        	        	        {

        	        	                    p.d_op = PARSER_STATE->mkIndexedOp(AntlrInput::tokenText(sym), numerals);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_identifier4705);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleidentifierEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierEx; /* Prevent compiler warnings */
    ruleidentifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifier */

/**
 * $ANTLR start termAtomic
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2113:1: termAtomic[CVC4::api::Term& atomTerm] : ( INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK ( EMP_TOK sortSymbol[type,CHECK_DECLARED] sortSymbol[type2,CHECK_DECLARED] | CHAR_TOK HEX_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] ) RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | TUPLE_CONST_TOK );
 */
static void
termAtomic(pSmt2Parser ctx, CVC4::api::Term& atomTerm)
{
    pANTLR3_COMMON_TOKEN    sym;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL11;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL12;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL13;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL14;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL15;

    /* Initialize rule variables
     */


      CVC4::api::Sort type;
      CVC4::api::Sort type2;
      std::string s;
      std::vector<uint64_t> numerals;

    sym       = NULL;
    INTEGER_LITERAL11       = NULL;
    DECIMAL_LITERAL12       = NULL;
    HEX_LITERAL13       = NULL;
    HEX_LITERAL14       = NULL;
    BINARY_LITERAL15       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2121:3: ( INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK ( EMP_TOK sortSymbol[type,CHECK_DECLARED] sortSymbol[type2,CHECK_DECLARED] | CHAR_TOK HEX_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] ) RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | TUPLE_CONST_TOK )

            ANTLR3_UINT32 alt63;

            alt63=7;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt63=1;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt63=2;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt63=3;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt63=4;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt63=5;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt63=6;
            	}
                break;
            case TUPLE_CONST_TOK:
            	{
            		alt63=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 63;
                EXCEPTION->state        = 0;


                goto ruletermAtomicEx;

            }

            switch (alt63)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2121:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termAtomic4732);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	        {

        	                  std::string intStr = AntlrInput::tokenText(INTEGER_LITERAL11);
        	                  atomTerm = SOLVER->mkReal(intStr);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2126:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL12 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_termAtomic4744);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	        {

        	                  std::string realStr = AntlrInput::tokenText(DECIMAL_LITERAL12);
        	                  atomTerm = SOLVER->ensureTermSort(SOLVER->mkReal(realStr),
        	                                                    SOLVER->getRealSort());
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2135:5: LPAREN_TOK INDEX_TOK ( EMP_TOK sortSymbol[type,CHECK_DECLARED] sortSymbol[type2,CHECK_DECLARED] | CHAR_TOK HEX_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termAtomic4763);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_termAtomic4765);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2136:5: ( EMP_TOK sortSymbol[type,CHECK_DECLARED] sortSymbol[type2,CHECK_DECLARED] | CHAR_TOK HEX_LITERAL |sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals] )
        	        {
        	            int alt62=3;
        	            switch ( LA(1) )
        	            {
        	            case EMP_TOK:
        	            	{
        	            		alt62=1;
        	            	}
        	                break;
        	            case CHAR_TOK:
        	            	{
        	            		alt62=2;
        	            	}
        	                break;
        	            case SIMPLE_SYMBOL:
        	            	{
        	            		alt62=3;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 62;
        	                EXCEPTION->state        = 0;


        	                goto ruletermAtomicEx;

        	            }

        	            switch (alt62)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2136:7: EMP_TOK sortSymbol[type,CHECK_DECLARED] sortSymbol[type2,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(EMP_TOK, &FOLLOW_EMP_TOK_in_termAtomic4773);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermAtomicEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_termAtomic4781);
        	        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermAtomicEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_termAtomic4790);
        	        	        sortSymbol(ctx, type2, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermAtomicEx;
        	        	        }


        	        	        {

        	        	                    // Empty heap constant in seperation logic
        	        	                    api::Term v1 = SOLVER->mkConst(api::Sort(type), "_emp1");
        	        	                    api::Term v2 = SOLVER->mkConst(api::Sort(type2), "_emp2");
        	        	                    atomTerm = SOLVER->mkTerm(api::SEP_EMP, v1, v2);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2145:7: CHAR_TOK HEX_LITERAL
        	        	    {
        	        	         MATCHT(CHAR_TOK, &FOLLOW_CHAR_TOK_in_termAtomic4807);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermAtomicEx;
        	        	        }


        	        	        HEX_LITERAL13 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_termAtomic4809);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermAtomicEx;
        	        	        }


        	        	        {

        	        	                    std::string hexStr = AntlrInput::tokenTextSubstr(HEX_LITERAL13, 2);
        	        	                    atomTerm = SOLVER->mkChar(hexStr);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2150:7: sym= SIMPLE_SYMBOL nonemptyNumeralList[numerals]
        	        	    {
        	        	        sym = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_termAtomic4828);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermAtomicEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_nonemptyNumeralList_in_termAtomic4830);
        	        	        nonemptyNumeralList(ctx, numerals);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermAtomicEx;
        	        	        }


        	        	        {

        	        	                    atomTerm =
        	        	                      PARSER_STATE->mkIndexedConstant(AntlrInput::tokenText(sym),
        	        	                                                      numerals);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termAtomic4851);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2160:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL14 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_termAtomic4861);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	        {

        	                  assert(AntlrInput::tokenText(HEX_LITERAL14).find("#x") == 0);
        	                  std::string hexStr = AntlrInput::tokenTextSubstr(HEX_LITERAL14, 2);
        	                  atomTerm = SOLVER->mkBitVector(hexStr, 16);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2166:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL15 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_termAtomic4873);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	        {

        	                  assert(AntlrInput::tokenText(BINARY_LITERAL15).find("#b") == 0);
        	                  std::string binStr = AntlrInput::tokenTextSubstr(BINARY_LITERAL15, 2);
        	                  atomTerm = SOLVER->mkBitVector(binStr, 2);
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2174:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_termAtomic4889);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	        {
        	             atomTerm = PARSER_STATE->mkStringConstant(s); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2179:5: TUPLE_CONST_TOK
        	    {
        	         MATCHT(TUPLE_CONST_TOK, &FOLLOW_TUPLE_CONST_TOK_in_termAtomic4906);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermAtomicEx;
        	        }


        	        {

        	                  atomTerm = SOLVER->mkTuple(std::vector<api::Sort>(),
        	                                             std::vector<api::Term>());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermAtomicEx; /* Prevent compiler warnings */
    ruletermAtomicEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end termAtomic */

/**
 * $ANTLR start attribute
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2189:1: attribute[CVC4::api::Term& expr, CVC4::api::Term& retExpr, std::string& attr] : ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2] |tok= ( ATTRIBUTE_INST_LEVEL ) INTEGER_LITERAL | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] );
 */
static void
attribute(pSmt2Parser ctx, CVC4::api::Term& expr, CVC4::api::Term& retExpr, std::string& attr)
{
    pANTLR3_COMMON_TOKEN    tok;
    pANTLR3_COMMON_TOKEN    KEYWORD16;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL17;

    /* Initialize rule variables
     */


      SExpr sexpr;
      CVC4::api::Term patexpr;
      std::vector<CVC4::api::Term> patexprs;
      CVC4::api::Term e2;
      bool hasValue = false;

    tok       = NULL;
    KEYWORD16       = NULL;
    INTEGER_LITERAL17       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2197:3: ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2] |tok= ( ATTRIBUTE_INST_LEVEL ) INTEGER_LITERAL | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] )

            ANTLR3_UINT32 alt66;

            alt66=5;

            switch ( LA(1) )
            {
            case KEYWORD:
            	{
            		alt66=1;
            	}
                break;
            case ATTRIBUTE_PATTERN_TOK:
            	{
            		alt66=2;
            	}
                break;
            case ATTRIBUTE_NO_PATTERN_TOK:
            	{
            		alt66=3;
            	}
                break;
            case ATTRIBUTE_INST_LEVEL:
            	{
            		alt66=4;
            	}
                break;
            case ATTRIBUTE_NAMED_TOK:
            	{
            		alt66=5;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 66;
                EXCEPTION->state        = 0;


                goto ruleattributeEx;

            }

            switch (alt66)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2197:5: KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )?
        	    {
        	        KEYWORD16 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_attribute4933);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2197:13: ( simpleSymbolicExprNoKeyword[sexpr] )?
        	        {
        	            int alt64=2;
        	            switch ( LA(1) )
        	            {
        	                case ASSERT_TOK:
        	                case BINARY_LITERAL:
        	                case CHECK_SAT_ASSUMING_TOK:
        	                case CHECK_SAT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_DATATYPES_TOK:
        	                case DECLARE_FUN_TOK:
        	                case DECLARE_SORT_TOK:
        	                case DEFINE_FUNS_REC_TOK:
        	                case DEFINE_FUN_REC_TOK:
        	                case DEFINE_FUN_TOK:
        	                case DEFINE_SORT_TOK:
        	                case ECHO_TOK:
        	                case EXIT_TOK:
        	                case GET_ASSERTIONS_TOK:
        	                case GET_ASSIGNMENT_TOK:
        	                case GET_INFO_TOK:
        	                case GET_MODEL_TOK:
        	                case GET_OPTION_TOK:
        	                case GET_PROOF_TOK:
        	                case GET_UNSAT_ASSUMPTIONS_TOK:
        	                case GET_UNSAT_CORE_TOK:
        	                case GET_VALUE_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case POP_TOK:
        	                case PUSH_TOK:
        	                case QUOTED_SYMBOL:
        	                case RESET_ASSERTIONS_TOK:
        	                case RESET_TOK:
        	                case SET_INFO_TOK:
        	                case SET_LOGIC_TOK:
        	                case SET_OPTION_TOK:
        	                case SIMPLE_SYMBOL:
        	                case SIMPLIFY_TOK:
        	                case STRING_LITERAL:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                	{
        	                		alt64=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt64)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2197:15: simpleSymbolicExprNoKeyword[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4937);
        	        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleattributeEx;
        	        	        }


        	        	        {
        	        	             hasValue = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                attr = AntlrInput::tokenText(KEYWORD16);
        	                PARSER_STATE->attributeNotSupported(attr);
        	              
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2202:5: ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK
        	    {
        	         MATCHT(ATTRIBUTE_PATTERN_TOK, &FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4953);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_attribute4955);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2203:5: ( term[patexpr, e2] )+
        	        {
        	            int cnt65=0;

        	            for (;;)
        	            {
        	                int alt65=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case DECIMAL_LITERAL:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case LPAREN_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL:
        	        	case TUPLE_CONST_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        		{
        	        			alt65=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt65)
        	        	{
        	        	    case 1:
        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2203:7: term[patexpr, e2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_attribute4963);
        	        	            term(ctx, patexpr, e2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleattributeEx;
        	        	            }


        	        	            {
        	        	                 patexprs.push_back( patexpr ); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt65 >= 1 )
        	        		{
        	        		    goto loop65;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleattributeEx;
        	        	}
        	        	cnt65++;
        	            }
        	            loop65: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_attribute4981);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":pattern");
        	                  retExpr = MK_TERM(api::INST_PATTERN, patexprs);
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2210:5: ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2]
        	    {
        	         MATCHT(ATTRIBUTE_NO_PATTERN_TOK, &FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4993);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_attribute4995);
        	        term(ctx, patexpr, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":no-pattern");
        	                  retExpr = MK_TERM(api::INST_NO_PATTERN, patexpr);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2215:5: tok= ( ATTRIBUTE_INST_LEVEL ) INTEGER_LITERAL
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2215:9: ( ATTRIBUTE_INST_LEVEL )
        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2215:11: ATTRIBUTE_INST_LEVEL
        	        {
        	             MATCHT(ATTRIBUTE_INST_LEVEL, &FOLLOW_ATTRIBUTE_INST_LEVEL_in_attribute5012);
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleattributeEx;
        	            }


        	        }


        	        INTEGER_LITERAL17 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_attribute5016);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  std::stringstream sIntLit;
        	                  sIntLit << INTEGER_LITERAL17;
        	                  api::Term n = SOLVER->mkReal(sIntLit.str());
        	                  std::vector<api::Term> values;
        	                  values.push_back( n );
        	                  std::string attr_name(AntlrInput::tokenText(tok));
        	                  attr_name.erase( attr_name.begin() );
        	                  api::Sort boolType = SOLVER->getBooleanSort();
        	                  api::Term avar = PARSER_STATE->bindVar(attr_name, boolType);
        	                  retExpr = MK_TERM(api::INST_ATTRIBUTE, avar);
        	                  Command* c = new SetUserAttributeCommand(
        	                      attr_name, avar.getExpr(), api::termVectorToExprs(values));
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2232:5: ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr]
        	    {
        	         MATCHT(ATTRIBUTE_NAMED_TOK, &FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5028);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_attribute5030);
        	        symbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":named");
        	                  api::Term func = PARSER_STATE->setNamedAttribute(expr, sexpr);
        	                  std::string name = sexpr.getValue();
        	                  // bind name to expr with define-fun
        	                  Command* c = new DefineNamedFunctionCommand(
        	                      name, func.getExpr(), std::vector<Expr>(), expr.getExpr(), PARSER_STATE->getGlobalDeclarations());
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleattributeEx; /* Prevent compiler warnings */
    ruleattributeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end attribute */

/**
 * $ANTLR start termList
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2253:1: termList[std::vector<CVC4::api::Term>& formulas, CVC4::api::Term& expr] : ( term[expr, expr2] )+ ;
 */
static void
termList(pSmt2Parser ctx, std::vector<CVC4::api::Term>& formulas, CVC4::api::Term& expr)
{

      CVC4::api::Term expr2;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2257:3: ( ( term[expr, expr2] )+ )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2257:5: ( term[expr, expr2] )+
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2257:5: ( term[expr, expr2] )+
            {
                int cnt67=0;

                for (;;)
                {
                    int alt67=2;
            	switch ( LA(1) )
            	{
            	case BINARY_LITERAL:
            	case DECIMAL_LITERAL:
            	case HEX_LITERAL:
            	case INTEGER_LITERAL:
            	case LPAREN_TOK:
            	case QUOTED_SYMBOL:
            	case SIMPLE_SYMBOL:
            	case STRING_LITERAL:
            	case TUPLE_CONST_TOK:
            	case UNTERMINATED_QUOTED_SYMBOL:
            		{
            			alt67=1;
            		}
            	    break;

            	}

            	switch (alt67)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2257:7: term[expr, expr2]
            	        {
            	            FOLLOWPUSH(FOLLOW_term_in_termList5062);
            	            term(ctx, expr, expr2);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruletermListEx;
            	            }


            	            {
            	                 formulas.push_back(expr); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt67 >= 1 )
            		{
            		    goto loop67;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruletermListEx;
            	}
            	cnt67++;
                }
                loop67: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermListEx; /* Prevent compiler warnings */
    ruletermListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end termList */

/**
 * $ANTLR start str
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2263:1: str[std::string& s, bool fsmtlib] : STRING_LITERAL ;
 */
static void
str(pSmt2Parser ctx, std::string& s, bool fsmtlib)
{
    pANTLR3_COMMON_TOKEN    STRING_LITERAL18;

    /* Initialize rule variables
     */

    STRING_LITERAL18       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2264:3: ( STRING_LITERAL )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2264:5: STRING_LITERAL
        {
            STRING_LITERAL18 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL, &FOLLOW_STRING_LITERAL_in_str5084);
            if  (HASEXCEPTION())
            {
                goto rulestrEx;
            }


            {

                      s = AntlrInput::tokenText(STRING_LITERAL18);
                      /* strip off the quotes */
                      s = s.substr(1, s.size() - 2);
                      for (size_t i = 0; i < s.size(); i++)
                      {
                        if ((unsigned)s[i] > 127 && !isprint(s[i]))
                        {
                          PARSER_STATE->parseError(
                              "Extended/unprintable characters are not "
                              "part of SMT-LIB, and they must be encoded "
                              "as escape sequences");
                        }
                      }
                      if (fsmtlib || PARSER_STATE->escapeDupDblQuote())
                      {
                        char* p_orig = strdup(s.c_str());
                        char *p = p_orig, *q = p_orig;
                        while (*q != '\0')
                        {
                          if (PARSER_STATE->escapeDupDblQuote() && *q == '"')
                          {
                            // Handle SMT-LIB >=2.5 standard escape '""'.
                            ++q;
                            assert(*q == '"');
                          }
                          else if (!PARSER_STATE->escapeDupDblQuote() && *q == '\\')
                          {
                            ++q;
                            // Handle SMT-LIB 2.0 standard escapes '\\' and '\"'.
                            if (*q != '\\' && *q != '"')
                            {
                              assert(*q != '\0');
                              *p++ = '\\';
                            }
                          }
                          *p++ = *q++;
                        }
                        *p = '\0';
                        s = p_orig;
                        free(p_orig);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulestrEx; /* Prevent compiler warnings */
    rulestrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end str */

/**
 * $ANTLR start quantOp
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2310:1: quantOp[CVC4::api::Kind& kind] : ( EXISTS_TOK | FORALL_TOK );
 */
static void
quantOp(pSmt2Parser ctx, CVC4::api::Kind& kind)
{
    /* Initialize rule variables
     */


      Debug("parser") << "quant: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2314:3: ( EXISTS_TOK | FORALL_TOK )

            ANTLR3_UINT32 alt68;

            alt68=2;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            	{
            		alt68=1;
            	}
                break;
            case FORALL_TOK:
            	{
            		alt68=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 68;
                EXCEPTION->state        = 0;


                goto rulequantOpEx;

            }

            switch (alt68)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2314:5: EXISTS_TOK
        	    {
        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_quantOp5109);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }


        	        {
        	             kind= api::EXISTS; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2315:5: FORALL_TOK
        	    {
        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_quantOp5120);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }


        	        {
        	             kind= api::FORALL; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulequantOpEx; /* Prevent compiler warnings */
    rulequantOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end quantOp */

/**
 * $ANTLR start functionName
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2322:1: functionName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_VARIABLE] ;
 */
static void
functionName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2323:3: ( symbol[name,check,SYM_VARIABLE] )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2323:5: symbol[name,check,SYM_VARIABLE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_functionName5141);
            symbol(ctx, name, check, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulefunctionNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulefunctionNameEx; /* Prevent compiler warnings */
    rulefunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end functionName */

/**
 * $ANTLR start sortList
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2330:1: sortList[std::vector<CVC4::api::Sort>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )* ;
 */
static void
sortList(pSmt2Parser ctx, std::vector<CVC4::api::Sort>& sorts)
{

      CVC4::api::Sort t;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2334:3: ( ( sortSymbol[t,CHECK_DECLARED] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2334:5: ( sortSymbol[t,CHECK_DECLARED] )*
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2334:5: ( sortSymbol[t,CHECK_DECLARED] )*

            for (;;)
            {
                int alt69=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                	{
                		alt69=1;
                	}
                    break;

                }

                switch (alt69)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2334:7: sortSymbol[t,CHECK_DECLARED]
            	    {
            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortList5165);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortListEx;
            	        }


            	        {
            	             sorts.push_back(t); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop69;	/* break out of the loop */
            	    break;
                }
            }
            loop69: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortListEx; /* Prevent compiler warnings */
    rulesortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortList */

/**
 * $ANTLR start nonemptySortList
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2337:1: nonemptySortList[std::vector<CVC4::api::Sort>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )+ ;
 */
static void
nonemptySortList(pSmt2Parser ctx, std::vector<CVC4::api::Sort>& sorts)
{

      CVC4::api::Sort t;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2341:3: ( ( sortSymbol[t,CHECK_DECLARED] )+ )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2341:5: ( sortSymbol[t,CHECK_DECLARED] )+
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2341:5: ( sortSymbol[t,CHECK_DECLARED] )+
            {
                int cnt70=0;

                for (;;)
                {
                    int alt70=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            	case QUOTED_SYMBOL:
            	case SIMPLE_SYMBOL:
            	case UNTERMINATED_QUOTED_SYMBOL:
            		{
            			alt70=1;
            		}
            	    break;

            	}

            	switch (alt70)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2341:7: sortSymbol[t,CHECK_DECLARED]
            	        {
            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_nonemptySortList5192);
            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptySortListEx;
            	            }


            	            {
            	                 sorts.push_back(t); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt70 >= 1 )
            		{
            		    goto loop70;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptySortListEx;
            	}
            	cnt70++;
                }
                loop70: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptySortListEx; /* Prevent compiler warnings */
    rulenonemptySortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptySortList */

/**
 * $ANTLR start sortedVarList
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2348:1: sortedVarList[std::vector<std::pair<std::string, CVC4::api::Sort> >& sortedVars] : ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* ;
 */
static void
sortedVarList(pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::api::Sort> >& sortedVars)
{

      std::string name;
      CVC4::api::Sort t;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2353:3: ( ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2353:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2353:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*

            for (;;)
            {
                int alt71=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt71=1;
                	}
                    break;

                }

                switch (alt71)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2353:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortedVarList5221);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_sortedVarList5223);
            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortedVarList5232);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortedVarList5235);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        {
            	             sortedVars.push_back(make_pair(name, t)); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop71;	/* break out of the loop */
            	    break;
                }
            }
            loop71: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortedVarListEx; /* Prevent compiler warnings */
    rulesortedVarListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortedVarList */

/**
 * $ANTLR start boundVarList
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2363:1: boundVarList[CVC4::api::Term& expr] : LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ;
 */
static void
boundVarList(pSmt2Parser ctx, CVC4::api::Term& expr)
{

      std::vector<std::pair<std::string, CVC4::api::Sort>> sortedVarNames;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2367:2: ( LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2367:4: LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_boundVarList5270);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarListEx;
            }


            FOLLOWPUSH(FOLLOW_sortedVarList_in_boundVarList5272);
            sortedVarList(ctx, sortedVarNames);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarListEx;
            }


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_boundVarList5275);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarListEx;
            }


            {

                     std::vector<CVC4::api::Term> args =
                         PARSER_STATE->bindBoundVars(sortedVarNames);
                     expr = MK_TERM(api::BOUND_VAR_LIST, args);
                   
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarListEx; /* Prevent compiler warnings */
    ruleboundVarListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarList */

/**
 * $ANTLR start sortName
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2379:1: sortName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_SORT] ;
 */
static void
sortName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2380:3: ( symbol[name,check,SYM_SORT] )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2380:5: symbol[name,check,SYM_SORT]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_sortName5295);
            symbol(ctx, name, check, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesortNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortNameEx; /* Prevent compiler warnings */
    rulesortNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortName */

/**
 * $ANTLR start sortSymbol
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2383:1: sortSymbol[CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check] : ( sortName[name,CHECK_NONE] | LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK | LPAREN_TOK HO_ARROW_TOK sortList[args] RPAREN_TOK );
 */
static void
sortSymbol(pSmt2Parser ctx, CVC4::api::Sort& t, CVC4::parser::DeclarationCheck check)
{

      std::string name;
      std::vector<CVC4::api::Sort> args;
      std::vector<uint64_t> numerals;
      bool indexed = false;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2390:3: ( sortName[name,CHECK_NONE] | LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK | LPAREN_TOK HO_ARROW_TOK sortList[args] RPAREN_TOK )

            ANTLR3_UINT32 alt74;

            alt74=3;

            switch ( LA(1) )
            {
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt74=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case HO_ARROW_TOK:
            			{
            				alt74=3;
            			}
            		    break;
            		case INDEX_TOK:
            		case QUOTED_SYMBOL:
            		case SIMPLE_SYMBOL:
            		case UNTERMINATED_QUOTED_SYMBOL:
            			{
            				alt74=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 74;
            		    EXCEPTION->state        = 4;


            		    goto rulesortSymbolEx;

            		}

            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 74;
                EXCEPTION->state        = 0;


                goto rulesortSymbolEx;

            }

            switch (alt74)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2390:5: sortName[name,CHECK_NONE]
        	    {
        	        FOLLOWPUSH(FOLLOW_sortName_in_sortSymbol5315);
        	        sortName(ctx, name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        {

        	                  if(check == CHECK_DECLARED || PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	                    t = PARSER_STATE->getSort(name);
        	                  } else {
        	                    t = PARSER_STATE->mkUnresolvedType(name);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2398:5: LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortSymbol5328);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2398:16: ( INDEX_TOK |)
        	        {
        	            int alt72=2;
        	            switch ( LA(1) )
        	            {
        	            case INDEX_TOK:
        	            	{
        	            		alt72=1;
        	            	}
        	                break;
        	            case QUOTED_SYMBOL:
        	            case SIMPLE_SYMBOL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt72=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 72;
        	                EXCEPTION->state        = 0;


        	                goto rulesortSymbolEx;

        	            }

        	            switch (alt72)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2398:17: INDEX_TOK
        	        	    {
        	        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_sortSymbol5331);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	            indexed = true;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2398:47: 
        	        	    {
        	        	        {
        	        	            indexed = false;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_symbol_in_sortSymbol5344);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2400:5: ( nonemptyNumeralList[numerals] | sortList[args] )
        	        {
        	            int alt73=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt73=1;
        	            	}
        	                break;
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case RPAREN_TOK:
        	            case SIMPLE_SYMBOL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		alt73=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 73;
        	                EXCEPTION->state        = 0;


        	                goto rulesortSymbolEx;

        	            }

        	            switch (alt73)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2400:7: nonemptyNumeralList[numerals]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_nonemptyNumeralList_in_sortSymbol5353);
        	        	        nonemptyNumeralList(ctx, numerals);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	             // allow sygus inputs to elide the `_'
        	        	                    if( !indexed && !PARSER_STATE->sygus_v1() ) {
        	        	                      std::stringstream ss;
        	        	                      ss << "SMT-LIB requires use of an indexed sort here, e.g. (_ " << name
        	        	                         << " ...)";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if( name == "BitVec" ) {
        	        	                      if( numerals.size() != 1 ) {
        	        	                        PARSER_STATE->parseError("Illegal bitvector type.");
        	        	                      }
        	        	                      if(numerals.front() == 0) {
        	        	                        PARSER_STATE->parseError("Illegal bitvector size: 0");
        	        	                      }
        	        	                      t = SOLVER->mkBitVectorSort(numerals.front());
        	        	                    } else if ( name == "FloatingPoint" ) {
        	        	                      if( numerals.size() != 2 ) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point type.");
        	        	                      }
        	        	                      if(!validExponentSize(numerals[0])) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point exponent size");
        	        	                      }
        	        	                      if(!validSignificandSize(numerals[1])) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point significand size");
        	        	                      }
        	        	                      t = SOLVER->mkFloatingPointSort(numerals[0],numerals[1]);
        	        	                    } else {
        	        	                      std::stringstream ss;
        	        	                      ss << "unknown indexed sort symbol `" << name << "'";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2433:7: sortList[args]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sortList_in_sortSymbol5370);
        	        	        sortList(ctx, args);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	             if( indexed ) {
        	        	                      std::stringstream ss;
        	        	                      ss << "Unexpected use of indexing operator `_' before `" << name
        	        	                         << "', try leaving it out";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if(args.empty()) {
        	        	                      PARSER_STATE->parseError("Extra parentheses around sort name not "
        	        	                                               "permitted in SMT-LIB");
        	        	                    } else if(name == "Array" &&
        	        	                       PARSER_STATE->isTheoryEnabled(theory::THEORY_ARRAYS) ) {
        	        	                      if(args.size() != 2) {
        	        	                        PARSER_STATE->parseError("Illegal array type.");
        	        	                      }
        	        	                      t = SOLVER->mkArraySort( args[0], args[1] );
        	        	                    } else if(name == "Set" &&
        	        	                              PARSER_STATE->isTheoryEnabled(theory::THEORY_SETS) ) {
        	        	                      if(args.size() != 1) {
        	        	                        PARSER_STATE->parseError("Illegal set type.");
        	        	                      }
        	        	                      t = SOLVER->mkSetSort( args[0] );
        	        	                    } else if(name == "Tuple") {
        	        	                      t = SOLVER->mkTupleSort(args);
        	        	                    } else if(check == CHECK_DECLARED ||
        	        	                              PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	        	                      t = PARSER_STATE->getSort(name, args);
        	        	                    } else {
        	        	                      // make unresolved type
        	        	                      if(args.empty()) {
        	        	                        t = PARSER_STATE->mkUnresolvedType(name);
        	        	                        Debug("parser-param") << "param: make unres type " << name
        	        	                                              << std::endl;
        	        	                      } else {
        	        	                        t = PARSER_STATE->mkUnresolvedTypeConstructor(name,args);
        	        	                        t = t.instantiate( args );
        	        	                        Debug("parser-param")
        	        	                            << "param: make unres param type " << name << " " << args.size()
        	        	                            << " " << PARSER_STATE->getArity( name ) << std::endl;
        	        	                      }
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortSymbol5387);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2476:5: LPAREN_TOK HO_ARROW_TOK sortList[args] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortSymbol5393);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	         MATCHT(HO_ARROW_TOK, &FOLLOW_HO_ARROW_TOK_in_sortSymbol5395);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortList_in_sortSymbol5397);
        	        sortList(ctx, args);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortSymbol5400);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        {

        	                  if(args.size()<2) {
        	                    PARSER_STATE->parseError("Arrow types must have at least 2 arguments");
        	                  }
        	                  //flatten the type
        	                  api::Sort rangeType = args.back();
        	                  args.pop_back();
        	                  t = PARSER_STATE->mkFlatFunctionType( args, rangeType );
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesortSymbolEx; /* Prevent compiler warnings */
    rulesortSymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortSymbol */

/**
 * $ANTLR start symbolList
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2492:1: symbolList[std::vector<std::string>& names,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( symbol[id,check,type] )* ;
 */
static void
symbolList(pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{

      std::string id;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2498:3: ( ( symbol[id,check,type] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2498:5: ( symbol[id,check,type] )*
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2498:5: ( symbol[id,check,type] )*

            for (;;)
            {
                int alt75=2;
                switch ( LA(1) )
                {
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                	{
                		alt75=1;
                	}
                    break;

                }

                switch (alt75)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2498:7: symbol[id,check,type]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_symbolList5429);
            	        symbol(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesymbolListEx;
            	        }


            	        {
            	             names.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop75;	/* break out of the loop */
            	    break;
                }
            }
            loop75: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesymbolListEx; /* Prevent compiler warnings */
    rulesymbolListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolList */

/**
 * $ANTLR start symbol
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2507:1: symbol[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) );
 */
static void
symbol(pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL19;
    pANTLR3_COMMON_TOKEN    QUOTED_SYMBOL20;

    /* Initialize rule variables
     */

    SIMPLE_SYMBOL19       = NULL;
    QUOTED_SYMBOL20       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2510:3: ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) )

            ANTLR3_UINT32 alt77;

            alt77=3;

            switch ( LA(1) )
            {
            case SIMPLE_SYMBOL:
            	{
            		alt77=1;
            	}
                break;
            case QUOTED_SYMBOL:
            	{
            		alt77=2;
            	}
                break;
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt77=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 77;
                EXCEPTION->state        = 0;


                goto rulesymbolEx;

            }

            switch (alt77)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2510:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL19 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_symbol5451);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        {
        	             id = AntlrInput::tokenText(SIMPLE_SYMBOL19);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2517:5: QUOTED_SYMBOL
        	    {
        	        QUOTED_SYMBOL20 = (pANTLR3_COMMON_TOKEN) MATCHT(QUOTED_SYMBOL, &FOLLOW_QUOTED_SYMBOL_in_symbol5463);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        {
        	             id = AntlrInput::tokenText(QUOTED_SYMBOL20);
        	                  /* strip off the quotes */
        	                  id = id.substr(1, id.size() - 2);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2526:5: UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' )
        	    {
        	         MATCHT(UNTERMINATED_QUOTED_SYMBOL, &FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol5475);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2527:5: ( EOF | '\\\\' )
        	        {
        	            int alt76=2;
        	            switch ( LA(1) )
        	            {
        	            case EOF:
        	            	{
        	            		alt76=1;
        	            	}
        	                break;
        	            case 106:
        	            	{
        	            		alt76=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 76;
        	                EXCEPTION->state        = 0;


        	                goto rulesymbolEx;

        	            }

        	            switch (alt76)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2527:7: EOF
        	        	    {
        	        	         MATCHT(EOF, &FOLLOW_EOF_in_symbol5483);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("unterminated |quoted| symbol"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2529:7: '\\\\'
        	        	    {
        	        	         MATCHT(106, &FOLLOW_106_in_symbol5499);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("backslash not permitted in |quoted| "
        	        	                                                "symbol"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolEx; /* Prevent compiler warnings */
    rulesymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbol */

/**
 * $ANTLR start nonemptyNumeralList
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2539:1: nonemptyNumeralList[std::vector<uint64_t>& numerals] : ( INTEGER_LITERAL )+ ;
 */
static void
nonemptyNumeralList(pSmt2Parser ctx, std::vector<uint64_t>& numerals)
{
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL21;

    /* Initialize rule variables
     */

    INTEGER_LITERAL21       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2540:3: ( ( INTEGER_LITERAL )+ )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2540:5: ( INTEGER_LITERAL )+
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2540:5: ( INTEGER_LITERAL )+
            {
                int cnt78=0;

                for (;;)
                {
                    int alt78=2;
            	switch ( LA(1) )
            	{
            	case INTEGER_LITERAL:
            		{
            			alt78=1;
            		}
            	    break;

            	}

            	switch (alt78)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2540:7: INTEGER_LITERAL
            	        {
            	            INTEGER_LITERAL21 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList5531);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptyNumeralListEx;
            	            }


            	            {
            	                 numerals.push_back(AntlrInput::tokenToUnsigned(INTEGER_LITERAL21)); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt78 >= 1 )
            		{
            		    goto loop78;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptyNumeralListEx;
            	}
            	cnt78++;
                }
                loop78: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptyNumeralListEx; /* Prevent compiler warnings */
    rulenonemptyNumeralListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptyNumeralList */

/**
 * $ANTLR start datatypeDef
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2548:1: datatypeDef[bool isCo, std::vector<CVC4::api::DatatypeDecl>& datatypes,\n std::vector< CVC4::api::Sort >& params] : symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ ;
 */
static void
datatypeDef(pSmt2Parser ctx, bool isCo, std::vector<CVC4::api::DatatypeDecl>& datatypes, std::vector< CVC4::api::Sort >& params)
{
    /* Initialize rule variables
     */


      std::string id;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2557:3: ( symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2557:5: symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
        {
            FOLLOWPUSH(FOLLOW_symbol_in_datatypeDef5573);
            symbol(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }


            {
                 PARSER_STATE->pushScope(true); 
            }


            {

                      datatypes.push_back(SOLVER->mkDatatypeDecl(id, params, isCo));
                    
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2561:5: ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
            {
                int cnt79=0;

                for (;;)
                {
                    int alt79=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt79=1;
            		}
            	    break;

            	}

            	switch (alt79)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2561:7: LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypeDef5590);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef5592);
            	            constructorDef(ctx, datatypes.back());

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypeDef5595);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt79 >= 1 )
            		{
            		    goto loop79;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypeDefEx;
            	}
            	cnt79++;
                }
                loop79: ;	/* Jump to here if this rule does not match */
            }

            {
                 PARSER_STATE->popScope(); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefEx; /* Prevent compiler warnings */
    ruledatatypeDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDef */

/**
 * $ANTLR start constructorDef
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2568:1: constructorDef[CVC4::api::DatatypeDecl& type] : symbol[id,CHECK_NONE,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* ;
 */
static void
constructorDef(pSmt2Parser ctx, CVC4::api::DatatypeDecl& type)
{
    /* Initialize rule variables
     */


      std::string id;
      CVC4::api::DatatypeConstructorDecl* ctor = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2573:3: ( symbol[id,CHECK_NONE,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2573:5: symbol[id,CHECK_NONE,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*
        {
            FOLLOWPUSH(FOLLOW_symbol_in_constructorDef5625);
            symbol(ctx, id, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconstructorDefEx;
            }


            {

                      ctor = new api::DatatypeConstructorDecl(
                          SOLVER->mkDatatypeConstructorDecl(id));
                    
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2578:5: ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*

            for (;;)
            {
                int alt80=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt80=1;
                	}
                    break;

                }

                switch (alt80)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2578:7: LPAREN_TOK selector[*ctor] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_constructorDef5640);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef5642);
            	        selector(ctx, *ctor);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_constructorDef5645);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop80;	/* break out of the loop */
            	    break;
                }
            }
            loop80: ; /* Jump out to here if this rule does not match */


            {
                 // make the constructor
                      type.addConstructor(*ctor);
                      Debug("parser-idt") << "constructor: " << id.c_str() << std::endl;
                      delete ctor;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleconstructorDefEx; /* Prevent compiler warnings */
    ruleconstructorDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end constructorDef */

/**
 * $ANTLR start selector
 * /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2586:1: selector[CVC4::api::DatatypeConstructorDecl& ctor] : symbol[id,CHECK_NONE,SYM_SORT] sortSymbol[t,CHECK_NONE] ;
 */
static void
selector(pSmt2Parser ctx, CVC4::api::DatatypeConstructorDecl& ctor)
{
    /* Initialize rule variables
     */


      std::string id;
      CVC4::api::Sort t, t2;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2591:3: ( symbol[id,CHECK_NONE,SYM_SORT] sortSymbol[t,CHECK_NONE] )
        // /build/cvc4/src/cvc5-1.8/src/parser/smt2/Smt2.g:2591:5: symbol[id,CHECK_NONE,SYM_SORT] sortSymbol[t,CHECK_NONE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_selector5673);
            symbol(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }


            FOLLOWPUSH(FOLLOW_sortSymbol_in_selector5676);
            sortSymbol(ctx, t, CHECK_NONE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }


            {
                 
                      ctor.addSelector(id, t);
                      Debug("parser-idt") << "selector: " << id.c_str()
                                          << " of type " << t << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleselectorEx; /* Prevent compiler warnings */
    ruleselectorEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end selector */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
