// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// PatchEndpointIDReader is a Reader for the PatchEndpointID structure.
type PatchEndpointIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PatchEndpointIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPatchEndpointIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPatchEndpointIDInvalid()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPatchEndpointIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewPatchEndpointIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPatchEndpointIDTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPatchEndpointIDFailed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 503:
		result := NewPatchEndpointIDServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /endpoint/{id}] PatchEndpointID", response, response.Code())
	}
}

// NewPatchEndpointIDOK creates a PatchEndpointIDOK with default headers values
func NewPatchEndpointIDOK() *PatchEndpointIDOK {
	return &PatchEndpointIDOK{}
}

/*
PatchEndpointIDOK describes a response with status code 200, with default header values.

Success
*/
type PatchEndpointIDOK struct {
}

// IsSuccess returns true when this patch endpoint Id o k response has a 2xx status code
func (o *PatchEndpointIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this patch endpoint Id o k response has a 3xx status code
func (o *PatchEndpointIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id o k response has a 4xx status code
func (o *PatchEndpointIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch endpoint Id o k response has a 5xx status code
func (o *PatchEndpointIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id o k response a status code equal to that given
func (o *PatchEndpointIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the patch endpoint Id o k response
func (o *PatchEndpointIDOK) Code() int {
	return 200
}

func (o *PatchEndpointIDOK) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdOK", 200)
}

func (o *PatchEndpointIDOK) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdOK", 200)
}

func (o *PatchEndpointIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDInvalid creates a PatchEndpointIDInvalid with default headers values
func NewPatchEndpointIDInvalid() *PatchEndpointIDInvalid {
	return &PatchEndpointIDInvalid{}
}

/*
PatchEndpointIDInvalid describes a response with status code 400, with default header values.

Invalid modify endpoint request
*/
type PatchEndpointIDInvalid struct {
	Payload models.Error
}

// IsSuccess returns true when this patch endpoint Id invalid response has a 2xx status code
func (o *PatchEndpointIDInvalid) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id invalid response has a 3xx status code
func (o *PatchEndpointIDInvalid) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id invalid response has a 4xx status code
func (o *PatchEndpointIDInvalid) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch endpoint Id invalid response has a 5xx status code
func (o *PatchEndpointIDInvalid) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id invalid response a status code equal to that given
func (o *PatchEndpointIDInvalid) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the patch endpoint Id invalid response
func (o *PatchEndpointIDInvalid) Code() int {
	return 400
}

func (o *PatchEndpointIDInvalid) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdInvalid %s", 400, payload)
}

func (o *PatchEndpointIDInvalid) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdInvalid %s", 400, payload)
}

func (o *PatchEndpointIDInvalid) GetPayload() models.Error {
	return o.Payload
}

func (o *PatchEndpointIDInvalid) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchEndpointIDForbidden creates a PatchEndpointIDForbidden with default headers values
func NewPatchEndpointIDForbidden() *PatchEndpointIDForbidden {
	return &PatchEndpointIDForbidden{}
}

/*
PatchEndpointIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PatchEndpointIDForbidden struct {
}

// IsSuccess returns true when this patch endpoint Id forbidden response has a 2xx status code
func (o *PatchEndpointIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id forbidden response has a 3xx status code
func (o *PatchEndpointIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id forbidden response has a 4xx status code
func (o *PatchEndpointIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch endpoint Id forbidden response has a 5xx status code
func (o *PatchEndpointIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id forbidden response a status code equal to that given
func (o *PatchEndpointIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the patch endpoint Id forbidden response
func (o *PatchEndpointIDForbidden) Code() int {
	return 403
}

func (o *PatchEndpointIDForbidden) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdForbidden", 403)
}

func (o *PatchEndpointIDForbidden) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdForbidden", 403)
}

func (o *PatchEndpointIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDNotFound creates a PatchEndpointIDNotFound with default headers values
func NewPatchEndpointIDNotFound() *PatchEndpointIDNotFound {
	return &PatchEndpointIDNotFound{}
}

/*
PatchEndpointIDNotFound describes a response with status code 404, with default header values.

Endpoint does not exist
*/
type PatchEndpointIDNotFound struct {
}

// IsSuccess returns true when this patch endpoint Id not found response has a 2xx status code
func (o *PatchEndpointIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id not found response has a 3xx status code
func (o *PatchEndpointIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id not found response has a 4xx status code
func (o *PatchEndpointIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch endpoint Id not found response has a 5xx status code
func (o *PatchEndpointIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id not found response a status code equal to that given
func (o *PatchEndpointIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the patch endpoint Id not found response
func (o *PatchEndpointIDNotFound) Code() int {
	return 404
}

func (o *PatchEndpointIDNotFound) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdNotFound", 404)
}

func (o *PatchEndpointIDNotFound) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdNotFound", 404)
}

func (o *PatchEndpointIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDTooManyRequests creates a PatchEndpointIDTooManyRequests with default headers values
func NewPatchEndpointIDTooManyRequests() *PatchEndpointIDTooManyRequests {
	return &PatchEndpointIDTooManyRequests{}
}

/*
PatchEndpointIDTooManyRequests describes a response with status code 429, with default header values.

Rate-limiting too many requests in the given time frame
*/
type PatchEndpointIDTooManyRequests struct {
}

// IsSuccess returns true when this patch endpoint Id too many requests response has a 2xx status code
func (o *PatchEndpointIDTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id too many requests response has a 3xx status code
func (o *PatchEndpointIDTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id too many requests response has a 4xx status code
func (o *PatchEndpointIDTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch endpoint Id too many requests response has a 5xx status code
func (o *PatchEndpointIDTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id too many requests response a status code equal to that given
func (o *PatchEndpointIDTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the patch endpoint Id too many requests response
func (o *PatchEndpointIDTooManyRequests) Code() int {
	return 429
}

func (o *PatchEndpointIDTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdTooManyRequests", 429)
}

func (o *PatchEndpointIDTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdTooManyRequests", 429)
}

func (o *PatchEndpointIDTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDFailed creates a PatchEndpointIDFailed with default headers values
func NewPatchEndpointIDFailed() *PatchEndpointIDFailed {
	return &PatchEndpointIDFailed{}
}

/*
PatchEndpointIDFailed describes a response with status code 500, with default header values.

Endpoint update failed
*/
type PatchEndpointIDFailed struct {
	Payload models.Error
}

// IsSuccess returns true when this patch endpoint Id failed response has a 2xx status code
func (o *PatchEndpointIDFailed) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id failed response has a 3xx status code
func (o *PatchEndpointIDFailed) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id failed response has a 4xx status code
func (o *PatchEndpointIDFailed) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch endpoint Id failed response has a 5xx status code
func (o *PatchEndpointIDFailed) IsServerError() bool {
	return true
}

// IsCode returns true when this patch endpoint Id failed response a status code equal to that given
func (o *PatchEndpointIDFailed) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the patch endpoint Id failed response
func (o *PatchEndpointIDFailed) Code() int {
	return 500
}

func (o *PatchEndpointIDFailed) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdFailed %s", 500, payload)
}

func (o *PatchEndpointIDFailed) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdFailed %s", 500, payload)
}

func (o *PatchEndpointIDFailed) GetPayload() models.Error {
	return o.Payload
}

func (o *PatchEndpointIDFailed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchEndpointIDServiceUnavailable creates a PatchEndpointIDServiceUnavailable with default headers values
func NewPatchEndpointIDServiceUnavailable() *PatchEndpointIDServiceUnavailable {
	return &PatchEndpointIDServiceUnavailable{}
}

/*
PatchEndpointIDServiceUnavailable describes a response with status code 503, with default header values.

Service Unavailable
*/
type PatchEndpointIDServiceUnavailable struct {
}

// IsSuccess returns true when this patch endpoint Id service unavailable response has a 2xx status code
func (o *PatchEndpointIDServiceUnavailable) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id service unavailable response has a 3xx status code
func (o *PatchEndpointIDServiceUnavailable) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id service unavailable response has a 4xx status code
func (o *PatchEndpointIDServiceUnavailable) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch endpoint Id service unavailable response has a 5xx status code
func (o *PatchEndpointIDServiceUnavailable) IsServerError() bool {
	return true
}

// IsCode returns true when this patch endpoint Id service unavailable response a status code equal to that given
func (o *PatchEndpointIDServiceUnavailable) IsCode(code int) bool {
	return code == 503
}

// Code gets the status code for the patch endpoint Id service unavailable response
func (o *PatchEndpointIDServiceUnavailable) Code() int {
	return 503
}

func (o *PatchEndpointIDServiceUnavailable) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdServiceUnavailable", 503)
}

func (o *PatchEndpointIDServiceUnavailable) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdServiceUnavailable", 503)
}

func (o *PatchEndpointIDServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
