
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "webhittestresult_wrapper.h"

// Argument includes
#include <QMap>
#include <QString>
#include <qpoint.h>
#include <qrect.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebenginecontextmenurequest.h>
#include <webpage.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_WebHitTestResult_Type = nullptr;
static PyTypeObject *Sbk_WebHitTestResult_TypeF(void)
{
    return _Sbk_WebHitTestResult_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WebHitTestResult_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WebHitTestResult >()))
        return -1;

    ::WebHitTestResult *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "WebHitTestResult", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: WebHitTestResult::WebHitTestResult(WebHitTestResult)
    // 1: WebHitTestResult::WebHitTestResult(const WebPage*,QPoint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArgs[1])))) {
        overloadId = 1; // WebHitTestResult(const WebPage*,QPoint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), (pyArgs[0])))) {
        overloadId = 0; // WebHitTestResult(WebHitTestResult)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // WebHitTestResult(const WebHitTestResult &WebHitTestResult)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WebHitTestResult cppArg0_local = ::WebHitTestResult(static_cast<::WebPage*>(nullptr), ::QPoint());
            ::WebHitTestResult *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // WebHitTestResult(WebHitTestResult)
                cptr = new ::WebHitTestResult(*cppArg0);
            }
            break;
        }
        case 1: // WebHitTestResult(const WebPage *page, const QPoint &pos)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WebPage *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // WebHitTestResult(const WebPage*,QPoint)
                cptr = new ::WebHitTestResult(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::WebHitTestResult >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_WebHitTestResultFunc_alternateText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // alternateText()const
        QString cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->alternateText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_baseUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // baseUrl()const
        QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->baseUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_boundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // boundingRect()const
        QRect cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->boundingRect();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_imageUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // imageUrl()const
        QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->imageUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_isContentEditable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isContentEditable()const
        bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->isContentEditable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_isContentSelected(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isContentSelected()const
        bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->isContentSelected();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_linkTitle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // linkTitle()const
        QString cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->linkTitle();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_linkUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // linkUrl()const
        QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->linkUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_mediaMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mediaMuted()const
        bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->mediaMuted();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_mediaPaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mediaPaused()const
        bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->mediaPaused();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_mediaUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mediaUrl()const
        QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->mediaUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pos()const
        QPoint cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->pos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_tagName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tagName()const
        QString cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->tagName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResultFunc_updateWithContextMenuData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebHitTestResult::updateWithContextMenuData(QWebEngineContextMenuRequest)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineContextMenuRequest_IDX]), (pyArg)))) {
        overloadId = 0; // updateWithContextMenuData(QWebEngineContextMenuRequest)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "updateWithContextMenuData", errInfo, SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineContextMenuRequest *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // updateWithContextMenuData(QWebEngineContextMenuRequest)
            cppSelf->updateWithContextMenuData(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebHitTestResultFunc_viewportPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // viewportPos()const
        QPointF cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->viewportPos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebHitTestResult__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_WebHitTestResult_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_WebHitTestResult_methods[] = {
    {"alternateText", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_alternateText), METH_NOARGS, nullptr},
    {"baseUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_baseUrl), METH_NOARGS, nullptr},
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_boundingRect), METH_NOARGS, nullptr},
    {"imageUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_imageUrl), METH_NOARGS, nullptr},
    {"isContentEditable", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_isContentEditable), METH_NOARGS, nullptr},
    {"isContentSelected", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_isContentSelected), METH_NOARGS, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_isNull), METH_NOARGS, nullptr},
    {"linkTitle", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_linkTitle), METH_NOARGS, nullptr},
    {"linkUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_linkUrl), METH_NOARGS, nullptr},
    {"mediaMuted", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_mediaMuted), METH_NOARGS, nullptr},
    {"mediaPaused", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_mediaPaused), METH_NOARGS, nullptr},
    {"mediaUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_mediaUrl), METH_NOARGS, nullptr},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_pos), METH_NOARGS, nullptr},
    {"tagName", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_tagName), METH_NOARGS, nullptr},
    {"updateWithContextMenuData", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_updateWithContextMenuData), METH_O, nullptr},
    {"viewportPos", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_viewportPos), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResult__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_WebHitTestResult___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto *cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull() ? 1 : 0;
}

} // extern "C"

static int Sbk_WebHitTestResult_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_WebHitTestResult_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_WebHitTestResult_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WebHitTestResult_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WebHitTestResult_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WebHitTestResult_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WebHitTestResult_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    // type supports number protocol
    {Py_nb_bool,        reinterpret_cast<void *>(Sbk_WebHitTestResult___nb_bool)},
    {0, nullptr}
};
static PyType_Spec Sbk_WebHitTestResult_spec = {
    "1:PyFalkon.WebHitTestResult",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_WebHitTestResult_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WebHitTestResult_PythonToCpp_WebHitTestResult_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_WebHitTestResult_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WebHitTestResult_PythonToCpp_WebHitTestResult_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_WebHitTestResult_TypeF()))
        return WebHitTestResult_PythonToCpp_WebHitTestResult_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WebHitTestResult_PTR_CppToPython_WebHitTestResult(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_WebHitTestResult_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_WebHitTestResult_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *WebHitTestResult_COPY_CppToPython_WebHitTestResult(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::WebHitTestResult *>(cppIn);
    return Shiboken::Object::newObject(Sbk_WebHitTestResult_TypeF(), new ::WebHitTestResult(*source), true, true);
}

// Python to C++ copy conversion.
static void WebHitTestResult_PythonToCpp_WebHitTestResult_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::WebHitTestResult *>(cppOut) = *reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_WebHitTestResult_PythonToCpp_WebHitTestResult_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_WebHitTestResult_TypeF()))
        return WebHitTestResult_PythonToCpp_WebHitTestResult_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *WebHitTestResult_SignatureStrings[] = {
    "1:PyFalkon.WebHitTestResult(self,WebHitTestResult:PyFalkon.WebHitTestResult)",
    "0:PyFalkon.WebHitTestResult(self,page:PyFalkon.WebPage,pos:PySide6.QtCore.QPoint)",
    "PyFalkon.WebHitTestResult.alternateText(self)->QString",
    "PyFalkon.WebHitTestResult.baseUrl(self)->PySide6.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.boundingRect(self)->PySide6.QtCore.QRect",
    "PyFalkon.WebHitTestResult.imageUrl(self)->PySide6.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.isContentEditable(self)->bool",
    "PyFalkon.WebHitTestResult.isContentSelected(self)->bool",
    "PyFalkon.WebHitTestResult.isNull(self)->bool",
    "PyFalkon.WebHitTestResult.linkTitle(self)->QString",
    "PyFalkon.WebHitTestResult.linkUrl(self)->PySide6.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.mediaMuted(self)->bool",
    "PyFalkon.WebHitTestResult.mediaPaused(self)->bool",
    "PyFalkon.WebHitTestResult.mediaUrl(self)->PySide6.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.pos(self)->PySide6.QtCore.QPoint",
    "PyFalkon.WebHitTestResult.tagName(self)->QString",
    "PyFalkon.WebHitTestResult.updateWithContextMenuData(self,data:PySide6.QtWebEngineCore.QWebEngineContextMenuRequest)",
    "PyFalkon.WebHitTestResult.viewportPos(self)->PySide6.QtCore.QPointF",
    "PyFalkon.WebHitTestResult.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t WebHitTestResult_SignatureByteSize = 303;
static constexpr uint8_t WebHitTestResult_SignatureBytes[303] = {
    0x78, 0xda, 0x9d, 0x93, 0x4d, 0x6f, 0xc2, 0x30, 0x0c, 0x40, 0xef, 0xfc, 0x92, 0x21, 0xb1, 0x6a,
    0xbb, 0xec, 0xb0, 0xc3, 0x2e, 0x0c, 0xb4, 0x0b, 0xa8, 0xd0, 0x4e, 0x1c, 0x2b, 0x97, 0x98, 0xce,
    0x22, 0x24, 0x5d, 0xe3, 0x6c, 0xf4, 0xdf, 0xcf, 0xb4, 0xea, 0xc6, 0x90, 0xfa, 0x01, 0xc7, 0x3a,
    0x7e, 0xaf, 0x76, 0x62, 0x3f, 0x3e, 0x87, 0xe5, 0x1c, 0xf4, 0xde, 0x9a, 0x60, 0x83, 0xe9, 0x1b,
    0x71, 0x8c, 0x8e, 0xd7, 0xe8, 0xbc, 0xe6, 0x3b, 0x87, 0x7a, 0x37, 0xb9, 0x8c, 0xb6, 0xe7, 0x8f,
    0x47, 0x0f, 0x7d, 0xb2, 0x1c, 0x32, 0xfc, 0x97, 0x13, 0x4a, 0x60, 0x92, 0x5b, 0x27, 0xc1, 0x88,
    0x14, 0x3e, 0x05, 0x2b, 0x9e, 0xda, 0x02, 0x83, 0x55, 0x68, 0xc9, 0x88, 0xb1, 0xd5, 0x17, 0x80,
    0x66, 0x2c, 0x0c, 0x30, 0xc6, 0x78, 0xac, 0xed, 0xe3, 0xfb, 0x97, 0x55, 0xc4, 0x05, 0x99, 0xac,
    0x03, 0x4b, 0xc1, 0xe1, 0x7b, 0xa1, 0x1b, 0xe0, 0xf2, 0xb7, 0x72, 0xd4, 0x05, 0x5b, 0x6f, 0x94,
    0xf8, 0xd7, 0xb8, 0xe5, 0x36, 0xc3, 0xe9, 0xac, 0x43, 0x41, 0x07, 0xe9, 0xf8, 0xe6, 0x02, 0xc8,
    0x4d, 0xad, 0x61, 0x34, 0x3c, 0x53, 0xc4, 0x90, 0x6a, 0x6c, 0x34, 0xa9, 0xb5, 0x83, 0xb8, 0x08,
    0xb5, 0xd4, 0x87, 0x6a, 0x30, 0xb7, 0xf4, 0x5a, 0x0f, 0x4c, 0xd6, 0x64, 0xf6, 0x31, 0xf1, 0x5f,
    0x51, 0xfd, 0xaf, 0x71, 0x42, 0x6e, 0xbe, 0x8c, 0x03, 0x2a, 0x82, 0x85, 0x1f, 0xde, 0x4d, 0x05,
    0x84, 0xe0, 0xdd, 0x75, 0xc4, 0xcd, 0x05, 0xca, 0x5c, 0xb7, 0x81, 0xd5, 0x78, 0x77, 0xa0, 0x0c,
    0xd9, 0x12, 0x0e, 0x57, 0xdc, 0xa4, 0xcf, 0x95, 0xec, 0xc2, 0x86, 0xf8, 0xa3, 0x7a, 0xe9, 0x23,
    0x2f, 0xd0, 0xf8, 0x57, 0x60, 0xa8, 0x17, 0x4f, 0x0e, 0xe1, 0x6c, 0xc7, 0x04, 0x9f, 0x99, 0x8c,
    0x0c, 0xd6, 0xd5, 0x9c, 0x7d, 0xfe, 0xb2, 0x6b, 0xfc, 0xf4, 0xa2, 0xef, 0x5a, 0xc1, 0x2f, 0xc2,
    0xef, 0xdc, 0x16, 0x1c, 0xf6, 0xf4, 0x39, 0xef, 0x70, 0x24, 0xc9, 0xd6, 0xe6, 0x65, 0x92, 0x34,
    0x02, 0x2e, 0x73, 0x69, 0x34, 0x48, 0x64, 0x50, 0x77, 0xa3, 0x1f, 0xdf, 0x23, 0xb0, 0x0d
};
#endif

PyTypeObject *init_WebHitTestResult(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX].type;

    Shiboken::AutoDecRef Sbk_WebHitTestResult_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_WebHitTestResult_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WebHitTestResult",
        "WebHitTestResult",
        &Sbk_WebHitTestResult_spec,
        &Shiboken::callCppDestructor< ::WebHitTestResult >,
        Sbk_WebHitTestResult_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_WebHitTestResult_Type; // references _Sbk_WebHitTestResult_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, WebHitTestResult_SignatureStrings);
#else
    InitSignatureBytes(pyType, WebHitTestResult_SignatureBytes, WebHitTestResult_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_WebHitTestResult_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        WebHitTestResult_PythonToCpp_WebHitTestResult_PTR,
        is_WebHitTestResult_PythonToCpp_WebHitTestResult_PTR_Convertible,
        WebHitTestResult_PTR_CppToPython_WebHitTestResult,
        WebHitTestResult_COPY_CppToPython_WebHitTestResult);

    Shiboken::Conversions::registerConverterName(converter, "WebHitTestResult");
    Shiboken::Conversions::registerConverterName(converter, "WebHitTestResult*");
    Shiboken::Conversions::registerConverterName(converter, "WebHitTestResult&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WebHitTestResult).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        WebHitTestResult_PythonToCpp_WebHitTestResult_COPY,
        is_WebHitTestResult_PythonToCpp_WebHitTestResult_COPY_Convertible);


    return pyType;
}
