\name{ValuedRegionalMinimaImageFilter}
\alias{ValuedRegionalMinimaImageFilter}
\title{ValuedRegionalMinimaImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Transforms the image so that any pixel that is not a regional minima
is set to the maximum value for the pixel type. Pixels that are
regional minima retain their value.
ValuedRegionalMinimaImageFilter}
\details{
Regional minima are flat zones surrounded by pixels of higher value. A
completely flat image will be marked as a regional minima by this
filter.
This code was contributed in the Insight Journal paper: "Finding
regional extrema - methods and performance" by Beare R., Lehmann G. https://www.insight-journal.org/browse/publication/65
Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
See:
ValuedRegionalMaximaImageFilter , ValuedRegionalExtremaImageFilter ,
HMinimaImageFilter
ValuedRegionalMinima for the procedural interface
itk::ValuedRegionalMinimaImageFilter for the Doxygen on the original ITK class.
ValuedRegionalMinimaImageFilter}
%C++ includes: sitkValuedRegionalMinimaImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFlat() const:}{
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{bool GetFullyConnected() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetFullyConnected(bool FullyConnected):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ValuedRegionalMinimaImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~ValuedRegionalMinimaImageFilter():}{
Destructor
}
}
}
