/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.dangling_indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.dangling_indices.list_dangling_indices.DanglingIndex;
import org.opensearch.client.opensearch.nodes.NodesResponseBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ListDanglingIndicesResponse
extends NodesResponseBase
implements ToCopyableBuilder<Builder, ListDanglingIndicesResponse> {
    @Nullable
    private final String clusterName;
    @Nonnull
    private final List<DanglingIndex> danglingIndices;
    public static final JsonpDeserializer<ListDanglingIndicesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ListDanglingIndicesResponse::setupListDanglingIndicesResponseDeserializer);

    private ListDanglingIndicesResponse(Builder builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.danglingIndices = ApiTypeHelper.unmodifiableRequired(builder.danglingIndices, (Object)this, "danglingIndices");
    }

    public static ListDanglingIndicesResponse of(Function<Builder, ObjectBuilder<ListDanglingIndicesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final List<DanglingIndex> danglingIndices() {
        return this.danglingIndices;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.clusterName != null) {
            generator.writeKey("cluster_name");
            generator.write(this.clusterName);
        }
        generator.writeKey("dangling_indices");
        generator.writeStartArray();
        for (DanglingIndex item0 : this.danglingIndices) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupListDanglingIndicesResponseDeserializer(ObjectDeserializer<Builder> op) {
        ListDanglingIndicesResponse.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::danglingIndices, JsonpDeserializer.arrayDeserializer(DanglingIndex._DESERIALIZER), "dangling_indices");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.clusterName);
        result = 31 * result + this.danglingIndices.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListDanglingIndicesResponse other = (ListDanglingIndicesResponse)o;
        return Objects.equals(this.clusterName, other.clusterName) && this.danglingIndices.equals(other.danglingIndices);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ListDanglingIndicesResponse> {
        @Nullable
        private String clusterName;
        private List<DanglingIndex> danglingIndices;

        public Builder() {
        }

        private Builder(ListDanglingIndicesResponse o) {
            super(o);
            this.clusterName = o.clusterName;
            this.danglingIndices = Builder._listCopy(o.danglingIndices);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.danglingIndices = Builder._listCopy(o.danglingIndices);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(@Nullable String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder danglingIndices(List<DanglingIndex> list) {
            this.danglingIndices = Builder._listAddAll(this.danglingIndices, list);
            return this;
        }

        @Nonnull
        public final Builder danglingIndices(DanglingIndex value, DanglingIndex ... values) {
            this.danglingIndices = Builder._listAdd(this.danglingIndices, value, values);
            return this;
        }

        @Nonnull
        public final Builder danglingIndices(Function<DanglingIndex.Builder, ObjectBuilder<DanglingIndex>> fn) {
            return this.danglingIndices(fn.apply(new DanglingIndex.Builder()).build(), new DanglingIndex[0]);
        }

        @Override
        @Nonnull
        public ListDanglingIndicesResponse build() {
            this._checkSingleUse();
            return new ListDanglingIndicesResponse(this);
        }
    }
}

