/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.ArrayDeref;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.function.BiFunction;

final class ArrayStoreViaHandle
extends Item {
    private final ArrayDeref arrayDeref;
    private final Item value;
    private final MemoryOrder mode;

    ArrayStoreViaHandle(ArrayDeref arrayDeref, Item value, MemoryOrder mode) {
        this.arrayDeref = arrayDeref;
        this.value = value;
        this.mode = mode;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return ConstImpl.ofArrayVarHandle(this.arrayDeref.array().type()).process(this.arrayDeref.array().process(this.arrayDeref.index().process(this.value.process(node.prev(), op), op), op), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Plain -> "set";
            case MemoryOrder.Opaque -> "setOpaque";
            case MemoryOrder.Release -> "setRelease";
            case MemoryOrder.Volatile -> "setVolatile";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, MethodTypeDesc.of(ConstantDescs.CD_void, this.arrayDeref.array().type(), ConstantDescs.CD_int, this.arrayDeref.type()));
    }
}

