/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.freeplane.view.swing.map.MapView;

class RectangleMemorizer
extends MouseAdapter {
    private Point startPoint;
    private MapView mapView;

    @Override
    public void mousePressed(MouseEvent e) {
        Component component = e.getComponent();
        if (component instanceof MapView) {
            this.startPoint = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        if (this.mapView != null) {
            e.consume();
            this.mapView.selectNodeViewBySelectionRectangle(!e.isShiftDown());
            this.mapView.setSelectionRectangle(null);
            this.mapView = null;
        }
        this.startPoint = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        Component component = e.getComponent();
        if (!(component instanceof MapView)) {
            return;
        }
        this.mapView = (MapView)component;
        e.consume();
        Point endPoint = e.getPoint();
        Rectangle newRectangle = new Rectangle(Math.min(this.startPoint.x, endPoint.x), Math.min(this.startPoint.y, endPoint.y), Math.abs(this.startPoint.x - endPoint.x), Math.abs(this.startPoint.y - endPoint.y));
        this.mapView.setSelectionRectangle(newRectangle);
    }
}

