/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import org.freeplane.api.swing.JFileChooser;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.BitmapImagePreview;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ImageRendererFactory;
import org.freeplane.view.swing.features.filepreview.ViewerController;

public class MindMapPreview
extends BitmapImagePreview {
    private static final String EXTENSION = ".mm";
    private static final long serialVersionUID = 1L;

    public MindMapPreview(JFileChooser fc) {
        super(fc);
        int previewSize = ResourceController.getResourceController().getIntProperty("image_preview_size", 200);
        this.setPreferredSize(new Dimension(4 * previewSize, previewSize));
    }

    public MindMapPreview() {
        int previewSize = ResourceController.getResourceController().getIntProperty("image_preview_size", 200);
        Dimension preferredSize = new Dimension(4 * previewSize, previewSize);
        this.setPreferredSize(preferredSize);
        this.setSize(preferredSize);
    }

    @Override
    public void updateView(File file) {
        this.removeView();
        if (file != null) {
            String path = file.getPath();
            this.updateViewByImage(this.previewFile(path));
        }
    }

    private void updateViewByImage(File file) {
        URI uri;
        ViewerController viewerController;
        IViewerFactory factory;
        if (file != null && (factory = (viewerController = Controller.getCurrentModeController().getExtension(ViewerController.class)).getViewerFactory()).accept(uri = file.getAbsoluteFile().toURI())) {
            new ImageRendererFactory().configureRenderer(factory, uri, this.getSize(), this);
        }
    }

    private File previewFile(String path) {
        if (path.endsWith(EXTENSION)) {
            return this.previewFile(path, ".svg", ".png");
        }
        return null;
    }

    private File previewFile(String path, String ... extensions) {
        for (String extension : extensions) {
            File imageFile = new File(path.substring(0, path.length() - EXTENSION.length()) + extension);
            if (!imageFile.canRead()) continue;
            return imageFile;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
    }
}

