/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPageSwapEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSNavigationActivation.h"
#include "JSViewTransition.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PageSwapEvent::Init>> convertDictionary<PageSwapEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PageSwapEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue activationValue;
    if (isNullOrUndefined)
        activationValue = jsUndefined();
    else {
        activationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "activation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto activationConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<NavigationActivation>>>(lexicalGlobalObject, activationValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<NavigationActivation>>> { return typename Converter<IDLNullable<IDLInterface<NavigationActivation>>>::ReturnType { nullptr }; });
    if (activationConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.activation = activationConversionResult.releaseReturnValue();
    JSValue viewTransitionValue;
    if (isNullOrUndefined)
        viewTransitionValue = jsUndefined();
    else {
        viewTransitionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewTransition"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewTransitionConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<ViewTransition>>>(lexicalGlobalObject, viewTransitionValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<ViewTransition>>> { return typename Converter<IDLNullable<IDLInterface<ViewTransition>>>::ReturnType { nullptr }; });
    if (viewTransitionConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.viewTransition = viewTransitionConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPageSwapEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPageSwapEvent_activation);
static JSC_DECLARE_CUSTOM_GETTER(jsPageSwapEvent_viewTransition);

class JSPageSwapEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPageSwapEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPageSwapEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPageSwapEventPrototype>(vm)) JSPageSwapEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPageSwapEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPageSwapEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPageSwapEventPrototype, JSPageSwapEventPrototype::Base);

using JSPageSwapEventDOMConstructor = JSDOMConstructor<JSPageSwapEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSPageSwapEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPageSwapEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<PageSwapEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = PageSwapEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<PageSwapEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<PageSwapEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSPageSwapEventDOMConstructorConstruct, JSPageSwapEventDOMConstructor::construct);

template<> const ClassInfo JSPageSwapEventDOMConstructor::s_info = { "PageSwapEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPageSwapEventDOMConstructor) };

template<> JSValue JSPageSwapEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSPageSwapEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PageSwapEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPageSwapEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSPageSwapEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPageSwapEventConstructor, 0 } },
    HashTableValue { "activation"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPageSwapEvent_activation, 0 } },
    HashTableValue { "viewTransition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPageSwapEvent_viewTransition, 0 } },
};

const ClassInfo JSPageSwapEventPrototype::s_info = { "PageSwapEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPageSwapEventPrototype) };

void JSPageSwapEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPageSwapEvent::info(), JSPageSwapEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPageSwapEvent::s_info = { "PageSwapEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPageSwapEvent) };

JSPageSwapEvent::JSPageSwapEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PageSwapEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<PageSwapEvent> JSPageSwapEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, PageSwapEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPageSwapEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPageSwapEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSPageSwapEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPageSwapEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPageSwapEvent>(vm, globalObject);
}

JSValue JSPageSwapEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPageSwapEventDOMConstructor, DOMConstructorID::PageSwapEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPageSwapEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPageSwapEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPageSwapEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPageSwapEvent_activationGetter(JSGlobalObject& lexicalGlobalObject, JSPageSwapEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<NavigationActivation>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activation())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPageSwapEvent_activation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPageSwapEvent>::get<jsPageSwapEvent_activationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPageSwapEvent_viewTransitionGetter(JSGlobalObject& lexicalGlobalObject, JSPageSwapEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<ViewTransition>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewTransition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPageSwapEvent_viewTransition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPageSwapEvent>::get<jsPageSwapEvent_viewTransitionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSPageSwapEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPageSwapEvent, UseCustomHeapCellType::No>(vm, "JSPageSwapEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPageSwapEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPageSwapEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPageSwapEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPageSwapEvent = std::forward<decltype(space)>(space); }
    );
}

void JSPageSwapEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPageSwapEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PageSwapEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13PageSwapEventE[]; }
#endif
template<std::same_as<PageSwapEvent> T>
static inline void verifyVTable(PageSwapEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PageSwapEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13PageSwapEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PageSwapEvent has subclasses. If PageSwapEvent has subclasses that get passed
        // to toJS() we currently require PageSwapEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PageSwapEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<PageSwapEvent>(impl.ptr());
#endif
    return createWrapper<PageSwapEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PageSwapEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
