/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSBaseAudioContext.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAnalyserNode.h"
#include "JSAudioBuffer.h"
#include "JSAudioBufferCallback.h"
#include "JSAudioBufferSourceNode.h"
#include "JSAudioContextState.h"
#include "JSAudioDestinationNode.h"
#include "JSAudioListener.h"
#include "JSAudioWorklet.h"
#include "JSBiquadFilterNode.h"
#include "JSChannelMergerNode.h"
#include "JSChannelSplitterNode.h"
#include "JSConstantSourceNode.h"
#include "JSConvolverNode.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSDelayNode.h"
#include "JSDynamicsCompressorNode.h"
#include "JSEventListener.h"
#include "JSGainNode.h"
#include "JSIIRFilterNode.h"
#include "JSOscillatorNode.h"
#include "JSPannerNode.h"
#include "JSPeriodicWave.h"
#include "JSPeriodicWaveOptions.h"
#include "JSScriptProcessorNode.h"
#include "JSStereoPannerNode.h"
#include "JSWaveShaperNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_decodeAudioData);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBufferSource);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createGain);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDelay);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBiquadFilter);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createWaveShaper);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPanner);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConvolver);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDynamicsCompressor);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createAnalyser);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createScriptProcessor);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createOscillator);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPeriodicWave);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConstantSource);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createStereoPanner);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createIIRFilter);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelSplitter);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelMerger);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContextConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_destination);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_currentTime);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_sampleRate);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_listener);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_audioWorklet);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_state);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_onstatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSBaseAudioContext_onstatechange);

class JSBaseAudioContextPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBaseAudioContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBaseAudioContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSBaseAudioContextPrototype>(vm)) JSBaseAudioContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBaseAudioContextPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBaseAudioContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBaseAudioContextPrototype, JSBaseAudioContextPrototype::Base);

using JSBaseAudioContextDOMConstructor = JSDOMConstructorNotConstructable<JSBaseAudioContext>;

template<> const ClassInfo JSBaseAudioContextDOMConstructor::s_info = { "BaseAudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBaseAudioContextDOMConstructor) };

template<> JSValue JSBaseAudioContextDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSBaseAudioContextDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BaseAudioContext"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBaseAudioContext::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 27> JSBaseAudioContextPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContextConstructor, 0 } },
    HashTableValue { "destination"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_destination, 0 } },
    HashTableValue { "currentTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_currentTime, 0 } },
    HashTableValue { "sampleRate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_sampleRate, 0 } },
    HashTableValue { "listener"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_listener, 0 } },
    HashTableValue { "audioWorklet"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_audioWorklet, 0 } },
    HashTableValue { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_state, 0 } },
    HashTableValue { "onstatechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_onstatechange, setJSBaseAudioContext_onstatechange } },
    HashTableValue { "createBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createBuffer, 3 } },
    HashTableValue { "decodeAudioData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_decodeAudioData, 1 } },
    HashTableValue { "createBufferSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createBufferSource, 0 } },
    HashTableValue { "createGain"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createGain, 0 } },
    HashTableValue { "createDelay"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createDelay, 0 } },
    HashTableValue { "createBiquadFilter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createBiquadFilter, 0 } },
    HashTableValue { "createWaveShaper"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createWaveShaper, 0 } },
    HashTableValue { "createPanner"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createPanner, 0 } },
    HashTableValue { "createConvolver"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createConvolver, 0 } },
    HashTableValue { "createDynamicsCompressor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createDynamicsCompressor, 0 } },
    HashTableValue { "createAnalyser"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createAnalyser, 0 } },
    HashTableValue { "createScriptProcessor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createScriptProcessor, 0 } },
    HashTableValue { "createOscillator"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createOscillator, 0 } },
    HashTableValue { "createPeriodicWave"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createPeriodicWave, 2 } },
    HashTableValue { "createConstantSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createConstantSource, 0 } },
    HashTableValue { "createStereoPanner"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createStereoPanner, 0 } },
    HashTableValue { "createIIRFilter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createIIRFilter, 2 } },
    HashTableValue { "createChannelSplitter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createChannelSplitter, 0 } },
    HashTableValue { "createChannelMerger"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createChannelMerger, 0 } },
};

const ClassInfo JSBaseAudioContextPrototype::s_info = { "BaseAudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBaseAudioContextPrototype) };

void JSBaseAudioContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBaseAudioContext::info(), JSBaseAudioContextPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "audioWorklet"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBaseAudioContext::s_info = { "BaseAudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBaseAudioContext) };

JSBaseAudioContext::JSBaseAudioContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BaseAudioContext>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<BaseAudioContext> JSBaseAudioContext::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, BaseAudioContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSBaseAudioContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBaseAudioContextPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSBaseAudioContextPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBaseAudioContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBaseAudioContext>(vm, globalObject);
}

JSValue JSBaseAudioContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBaseAudioContextDOMConstructor, DOMConstructorID::BaseAudioContext>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBaseAudioContextPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBaseAudioContext::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsBaseAudioContext_destinationGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioDestinationNode>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.destination())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_destination, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_destinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_currentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.currentTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_currentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_sampleRateGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.sampleRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_sampleRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_sampleRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_listenerGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioListener>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.listener())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_listener, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_listenerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_audioWorkletGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioWorklet>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.audioWorklet())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_audioWorklet, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_audioWorkletGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_stateGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<AudioContextState>>(lexicalGlobalObject, throwScope, impl.state())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_onstatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().statechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_onstatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_onstatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSBaseAudioContext_onstatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().statechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSBaseAudioContext_onstatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::set<setJSBaseAudioContext_onstatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto numberOfChannelsConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (numberOfChannelsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto numberOfFramesConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (numberOfFramesConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto sampleRateConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument2.value());
    if (sampleRateConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBuffer(numberOfChannelsConversionResult.releaseReturnValue(), numberOfFramesConversionResult.releaseReturnValue(), sampleRateConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createBufferBody>(*lexicalGlobalObject, *callFrame, "createBuffer");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_decodeAudioDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBaseAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto audioDataConversionResult = convert<IDLArrayBuffer>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "audioData"_s, "BaseAudioContext"_s, "decodeAudioData"_s, "ArrayBuffer"_s); });
    if (audioDataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto successCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSAudioBufferCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "successCallback"_s, "BaseAudioContext"_s, "decodeAudioData"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSAudioBufferCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "errorCallback"_s, "BaseAudioContext"_s, "decodeAudioData"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<AudioBuffer>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.decodeAudioData(audioDataConversionResult.releaseReturnValue(), successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_decodeAudioData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_decodeAudioDataBody>(*lexicalGlobalObject, *callFrame, "decodeAudioData");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createBufferSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioBufferSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBufferSource())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBufferSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createBufferSourceBody>(*lexicalGlobalObject, *callFrame, "createBufferSource");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createGainBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GainNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createGain())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createGain, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createGainBody>(*lexicalGlobalObject, *callFrame, "createGain");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createDelayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto maxDelayTimeConversionResult = convertOptionalWithDefault<IDLDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 1 }; });
    if (maxDelayTimeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DelayNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDelay(maxDelayTimeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDelay, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createDelayBody>(*lexicalGlobalObject, *callFrame, "createDelay");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createBiquadFilterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<BiquadFilterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBiquadFilter())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBiquadFilter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createBiquadFilterBody>(*lexicalGlobalObject, *callFrame, "createBiquadFilter");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createWaveShaperBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WaveShaperNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createWaveShaper())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createWaveShaper, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createWaveShaperBody>(*lexicalGlobalObject, *callFrame, "createWaveShaper");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createPannerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<PannerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPanner())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPanner, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createPannerBody>(*lexicalGlobalObject, *callFrame, "createPanner");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createConvolverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ConvolverNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createConvolver())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConvolver, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createConvolverBody>(*lexicalGlobalObject, *callFrame, "createConvolver");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createDynamicsCompressorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DynamicsCompressorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDynamicsCompressor())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDynamicsCompressor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createDynamicsCompressorBody>(*lexicalGlobalObject, *callFrame, "createDynamicsCompressor");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createAnalyserBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AnalyserNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createAnalyser())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createAnalyser, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createAnalyserBody>(*lexicalGlobalObject, *callFrame, "createAnalyser");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createScriptProcessorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto bufferSizeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (bufferSizeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto numberOfInputChannelsConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 2 }; });
    if (numberOfInputChannelsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto numberOfOutputChannelsConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 2 }; });
    if (numberOfOutputChannelsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ScriptProcessorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createScriptProcessor(bufferSizeConversionResult.releaseReturnValue(), numberOfInputChannelsConversionResult.releaseReturnValue(), numberOfOutputChannelsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createScriptProcessor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createScriptProcessorBody>(*lexicalGlobalObject, *callFrame, "createScriptProcessor");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createOscillatorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<OscillatorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createOscillator())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createOscillator, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createOscillatorBody>(*lexicalGlobalObject, *callFrame, "createOscillator");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createPeriodicWaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto realConversionResult = convert<IDLSequence<IDLFloat>>(*lexicalGlobalObject, argument0.value());
    if (realConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto imagConversionResult = convert<IDLSequence<IDLFloat>>(*lexicalGlobalObject, argument1.value());
    if (imagConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto optionsConversionResult = convert<IDLDictionary<PeriodicWaveOptions>>(*lexicalGlobalObject, argument2.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<PeriodicWave>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPeriodicWave(realConversionResult.releaseReturnValue(), imagConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPeriodicWave, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createPeriodicWaveBody>(*lexicalGlobalObject, *callFrame, "createPeriodicWave");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createConstantSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ConstantSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createConstantSource())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConstantSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createConstantSourceBody>(*lexicalGlobalObject, *callFrame, "createConstantSource");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createStereoPannerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<StereoPannerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createStereoPanner())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createStereoPanner, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createStereoPannerBody>(*lexicalGlobalObject, *callFrame, "createStereoPanner");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createIIRFilterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto feedforwardConversionResult = convert<IDLSequence<IDLDouble>>(*lexicalGlobalObject, argument0.value());
    if (feedforwardConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto feedbackConversionResult = convert<IDLSequence<IDLDouble>>(*lexicalGlobalObject, argument1.value());
    if (feedbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<IIRFilterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createIIRFilter(*context, feedforwardConversionResult.releaseReturnValue(), feedbackConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createIIRFilter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createIIRFilterBody>(*lexicalGlobalObject, *callFrame, "createIIRFilter");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createChannelSplitterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto numberOfOutputsConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 6 }; });
    if (numberOfOutputsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ChannelSplitterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createChannelSplitter(numberOfOutputsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelSplitter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createChannelSplitterBody>(*lexicalGlobalObject, *callFrame, "createChannelSplitter");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createChannelMergerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto numberOfInputsConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 6 }; });
    if (numberOfInputsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ChannelMergerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createChannelMerger(numberOfInputsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelMerger, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createChannelMergerBody>(*lexicalGlobalObject, *callFrame, "createChannelMerger");
}

JSC::GCClient::IsoSubspace* JSBaseAudioContext::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBaseAudioContext, UseCustomHeapCellType::No>(vm, "JSBaseAudioContext"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBaseAudioContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBaseAudioContext = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBaseAudioContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBaseAudioContext = std::forward<decltype(space)>(space); }
    );
}

void JSBaseAudioContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBaseAudioContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSBaseAudioContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsBaseAudioContext = jsCast<JSBaseAudioContext*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsBaseAudioContext->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSBaseAudioContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBaseAudioContext = static_cast<JSBaseAudioContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsBaseAudioContext->protectedWrapped().ptr(), jsBaseAudioContext);
}

BaseAudioContext* JSBaseAudioContext::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBaseAudioContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
