/** @file
 * VirtualBox API class wrapper code for ISharedFolder.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_SHAREDFOLDER

#include "SharedFolderWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(SharedFolderWrap)

//
// ISharedFolder properties
//

STDMETHODIMP SharedFolderWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "SharedFolder::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "SharedFolder::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(HostPath)(BSTR *aHostPath)
{
    LogRelFlow(("{%p} %s: enter aHostPath=%p\n", this, "SharedFolder::getHostPath", aHostPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostPath);
        BSTROutConverter TmpHostPath(aHostPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_HOSTPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostPath(TmpHostPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_HOSTPATH_RETURN(this, hrc, 0 /*normal*/,TmpHostPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_HOSTPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_HOSTPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostPath=%ls hrc=%Rhrc\n", this, "SharedFolder::getHostPath", *aHostPath, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(Accessible)(BOOL *aAccessible)
{
    LogRelFlow(("{%p} %s: enter aAccessible=%p\n", this, "SharedFolder::getAccessible", aAccessible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAccessible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_ACCESSIBLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAccessible(aAccessible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_ACCESSIBLE_RETURN(this, hrc, 0 /*normal*/,*aAccessible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_ACCESSIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aAccessible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_ACCESSIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAccessible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAccessible=%RTbool hrc=%Rhrc\n", this, "SharedFolder::getAccessible", *aAccessible, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(Writable)(BOOL *aWritable)
{
    LogRelFlow(("{%p} %s: enter aWritable=%p\n", this, "SharedFolder::getWritable", aWritable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_WRITABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWritable(aWritable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_WRITABLE_RETURN(this, hrc, 0 /*normal*/,*aWritable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_WRITABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aWritable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_WRITABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aWritable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWritable=%RTbool hrc=%Rhrc\n", this, "SharedFolder::getWritable", *aWritable, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMSETTER(Writable)(BOOL aWritable)
{
    LogRelFlow(("{%p} %s: enter aWritable=%RTbool\n", this, "SharedFolder::setWritable", aWritable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_WRITABLE_ENTER(this, aWritable != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setWritable(aWritable != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_WRITABLE_RETURN(this, hrc, 0 /*normal*/,aWritable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_WRITABLE_RETURN(this, hrc, 1 /*hrc exception*/,aWritable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_WRITABLE_RETURN(this, hrc, 9 /*unhandled exception*/,aWritable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SharedFolder::setWritable", hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(AutoMount)(BOOL *aAutoMount)
{
    LogRelFlow(("{%p} %s: enter aAutoMount=%p\n", this, "SharedFolder::getAutoMount", aAutoMount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutoMount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutoMount(aAutoMount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNT_RETURN(this, hrc, 0 /*normal*/,*aAutoMount != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aAutoMount != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aAutoMount != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutoMount=%RTbool hrc=%Rhrc\n", this, "SharedFolder::getAutoMount", *aAutoMount, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMSETTER(AutoMount)(BOOL aAutoMount)
{
    LogRelFlow(("{%p} %s: enter aAutoMount=%RTbool\n", this, "SharedFolder::setAutoMount", aAutoMount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNT_ENTER(this, aAutoMount != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutoMount(aAutoMount != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNT_RETURN(this, hrc, 0 /*normal*/,aAutoMount != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNT_RETURN(this, hrc, 1 /*hrc exception*/,aAutoMount != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,aAutoMount != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SharedFolder::setAutoMount", hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(AutoMountPoint)(BSTR *aAutoMountPoint)
{
    LogRelFlow(("{%p} %s: enter aAutoMountPoint=%p\n", this, "SharedFolder::getAutoMountPoint", aAutoMountPoint));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutoMountPoint);
        BSTROutConverter TmpAutoMountPoint(aAutoMountPoint);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNTPOINT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutoMountPoint(TmpAutoMountPoint.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNTPOINT_RETURN(this, hrc, 0 /*normal*/,TmpAutoMountPoint.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNTPOINT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_AUTOMOUNTPOINT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutoMountPoint=%ls hrc=%Rhrc\n", this, "SharedFolder::getAutoMountPoint", *aAutoMountPoint, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMSETTER(AutoMountPoint)(IN_BSTR aAutoMountPoint)
{
    LogRelFlow(("{%p} %s: enter aAutoMountPoint=%ls\n", this, "SharedFolder::setAutoMountPoint", aAutoMountPoint));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpAutoMountPoint(aAutoMountPoint);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNTPOINT_ENTER(this, TmpAutoMountPoint.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutoMountPoint(TmpAutoMountPoint.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNTPOINT_RETURN(this, hrc, 0 /*normal*/,TmpAutoMountPoint.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNTPOINT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_AUTOMOUNTPOINT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SharedFolder::setAutoMountPoint", hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(LastAccessError)(BSTR *aLastAccessError)
{
    LogRelFlow(("{%p} %s: enter aLastAccessError=%p\n", this, "SharedFolder::getLastAccessError", aLastAccessError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLastAccessError);
        BSTROutConverter TmpLastAccessError(aLastAccessError);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_LASTACCESSERROR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLastAccessError(TmpLastAccessError.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_LASTACCESSERROR_RETURN(this, hrc, 0 /*normal*/,TmpLastAccessError.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_LASTACCESSERROR_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_LASTACCESSERROR_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLastAccessError=%ls hrc=%Rhrc\n", this, "SharedFolder::getLastAccessError", *aLastAccessError, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(SymlinkPolicy)(SymlinkPolicy_T *aSymlinkPolicy)
{
    LogRelFlow(("{%p} %s: enter aSymlinkPolicy=%p\n", this, "SharedFolder::getSymlinkPolicy", aSymlinkPolicy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSymlinkPolicy);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_SYMLINKPOLICY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSymlinkPolicy(aSymlinkPolicy);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_SYMLINKPOLICY_RETURN(this, hrc, 0 /*normal*/,*aSymlinkPolicy);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_SYMLINKPOLICY_RETURN(this, hrc, 1 /*hrc exception*/,*aSymlinkPolicy);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_GET_SYMLINKPOLICY_RETURN(this, hrc, 9 /*unhandled exception*/,*aSymlinkPolicy);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSymlinkPolicy=%RU32 hrc=%Rhrc\n", this, "SharedFolder::getSymlinkPolicy", *aSymlinkPolicy, hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMSETTER(SymlinkPolicy)(SymlinkPolicy_T aSymlinkPolicy)
{
    LogRelFlow(("{%p} %s: enter aSymlinkPolicy=%RU32\n", this, "SharedFolder::setSymlinkPolicy", aSymlinkPolicy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_SYMLINKPOLICY_ENTER(this, aSymlinkPolicy);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSymlinkPolicy(aSymlinkPolicy);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_SYMLINKPOLICY_RETURN(this, hrc, 0 /*normal*/,aSymlinkPolicy);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_SYMLINKPOLICY_RETURN(this, hrc, 1 /*hrc exception*/,aSymlinkPolicy);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SHAREDFOLDER_SET_SYMLINKPOLICY_RETURN(this, hrc, 9 /*unhandled exception*/,aSymlinkPolicy);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SharedFolder::setSymlinkPolicy", hrc));
    return hrc;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute1ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute2ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute3ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute4ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute5ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute6ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute7ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SharedFolderWrap::COMGETTER(InternalAndReservedAttribute8ISharedFolder)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ISharedFolder methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SharedFolderWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(SharedFolderWrap, ISharedFolder)
#endif // VBOX_WITH_XPCOM
