/* preferences-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/*
 * Copyright (C) 2009-2017 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Eduard Gotwig <g@ox.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define DEFAULT_TEXT_DPI 150
#define DEFAULT_PHOTO_DPI 300
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DPI_ITEM (dpi_item_get_type ())
#define DPI_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DPI_ITEM, DpiItem))
#define DPI_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DPI_ITEM, DpiItemClass))
#define IS_DPI_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DPI_ITEM))
#define IS_DPI_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DPI_ITEM))
#define DPI_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DPI_ITEM, DpiItemClass))

typedef struct _DpiItem DpiItem;
typedef struct _DpiItemClass DpiItemClass;
typedef struct _DpiItemPrivate DpiItemPrivate;
enum  {
	DPI_ITEM_0_PROPERTY,
	DPI_ITEM_NUM_PROPERTIES
};
static GParamSpec* dpi_item_properties[DPI_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAPER_SIZE_ITEM (paper_size_item_get_type ())
#define PAPER_SIZE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAPER_SIZE_ITEM, PaperSizeItem))
#define PAPER_SIZE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAPER_SIZE_ITEM, PaperSizeItemClass))
#define IS_PAPER_SIZE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAPER_SIZE_ITEM))
#define IS_PAPER_SIZE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAPER_SIZE_ITEM))
#define PAPER_SIZE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAPER_SIZE_ITEM, PaperSizeItemClass))

typedef struct _PaperSizeItem PaperSizeItem;
typedef struct _PaperSizeItemClass PaperSizeItemClass;
typedef struct _PaperSizeItemPrivate PaperSizeItemPrivate;
enum  {
	PAPER_SIZE_ITEM_0_PROPERTY,
	PAPER_SIZE_ITEM_NUM_PROPERTIES
};
static GParamSpec* paper_size_item_properties[PAPER_SIZE_ITEM_NUM_PROPERTIES];

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))
typedef enum  {
	SCAN_SIDE_FRONT,
	SCAN_SIDE_BACK,
	SCAN_SIDE_BOTH
} ScanSide;

#define TYPE_SCAN_SIDE (scan_side_get_type ())

struct _DpiItem {
	GObject parent_instance;
	DpiItemPrivate * priv;
	gint dpi;
	gchar* label;
};

struct _DpiItemClass {
	GObjectClass parent_class;
};

struct _PaperSizeItem {
	GObject parent_instance;
	PaperSizeItemPrivate * priv;
	gchar* label;
	gint width;
	gint height;
};

struct _PaperSizeItemClass {
	GObjectClass parent_class;
};

struct _PreferencesDialog {
	AdwPreferencesDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	AdwPreferencesDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GSettings* settings;
	AdwComboRow* text_dpi_row;
	AdwComboRow* photo_dpi_row;
	AdwComboRow* paper_size_row;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* compression_scale;
	GtkToggleButton* page_delay_0s_button;
	GtkToggleButton* page_delay_3s_button;
	GtkToggleButton* page_delay_6s_button;
	GtkToggleButton* page_delay_10s_button;
	GtkToggleButton* page_delay_15s_button;
	GListStore* text_dpi_model;
	GListStore* photo_dpi_model;
	GtkToggleButton* front_side_button;
	GtkToggleButton* back_side_button;
	GtkToggleButton* both_side_button;
	GListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* compression_adjustment;
	GtkSwitch* postproc_enable_switch;
	GtkEntry* postproc_script_entry;
	GtkEntry* postproc_args_entry;
	GtkSwitch* postproc_keep_original_switch;
};

struct _Block11Data {
	int _ref_count_;
	PreferencesDialog* self;
	GSettings* settings;
};

static gpointer dpi_item_parent_class = NULL;
static gpointer paper_size_item_parent_class = NULL;
static gint PreferencesDialog_private_offset;
static gpointer preferences_dialog_parent_class = NULL;

VALA_EXTERN GType dpi_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DpiItem, g_object_unref)
VALA_EXTERN DpiItem* dpi_item_new (gint dpi,
                       const gchar* label);
VALA_EXTERN DpiItem* dpi_item_construct (GType object_type,
                             gint dpi,
                             const gchar* label);
static void dpi_item_finalize (GObject * obj);
static GType dpi_item_get_type_once (void);
VALA_EXTERN GType paper_size_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperSizeItem, g_object_unref)
VALA_EXTERN PaperSizeItem* paper_size_item_new (const gchar* label,
                                    gint width,
                                    gint height);
VALA_EXTERN PaperSizeItem* paper_size_item_construct (GType object_type,
                                          const gchar* label,
                                          gint width,
                                          gint height);
static void paper_size_item_finalize (GObject * obj);
static GType paper_size_item_get_type_once (void);
VALA_EXTERN GType preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
static gchar* preferences_dialog_get_dpi_label (DpiItem* device);
static gchar* preferences_dialog_get_page_size_label (PaperSizeItem* size);
VALA_EXTERN PreferencesDialog* preferences_dialog_new (GSettings* settings);
VALA_EXTERN PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GSettings* settings);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void preferences_dialog_set_dpi_combo (PreferencesDialog* self,
                                       AdwComboRow* combo,
                                       gint default_dpi,
                                       gint current_dpi);
static void __lambda10_ (Block11Data* _data11_);
VALA_EXTERN gint preferences_dialog_get_text_dpi (PreferencesDialog* self);
static void ___lambda10__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda11_ (Block11Data* _data11_);
VALA_EXTERN gint preferences_dialog_get_photo_dpi (PreferencesDialog* self);
static void ___lambda11__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN GType scan_side_get_type (void) G_GNUC_CONST ;
static void preferences_dialog_set_page_side (PreferencesDialog* self,
                                       ScanSide page_side);
static void __lambda12_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda13_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda13__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda14_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda14__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda15_ (Block11Data* _data11_);
VALA_EXTERN gint preferences_dialog_get_brightness (PreferencesDialog* self);
static void ___lambda15__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda16_ (Block11Data* _data11_);
VALA_EXTERN gint preferences_dialog_get_contrast (PreferencesDialog* self);
static void ___lambda16__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda17_ (Block11Data* _data11_);
static void ___lambda17__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
VALA_EXTERN void preferences_dialog_set_paper_size (PreferencesDialog* self,
                                        gint width,
                                        gint height);
static void __lambda18_ (Block11Data* _data11_);
VALA_EXTERN gboolean preferences_dialog_get_paper_size (PreferencesDialog* self,
                                            gint* width,
                                            gint* height);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void preferences_dialog_set_page_delay (PreferencesDialog* self,
                                        gint page_delay);
static void __lambda19_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda19__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda20_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda20__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda21_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda21__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda22_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda23_ (Block11Data* _data11_,
                  GtkToggleButton* button);
static void ___lambda23__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void preferences_dialog_toggle_postproc_visibility (PreferencesDialog* self,
                                                    gboolean enabled);
static gboolean __lambda24_ (Block11Data* _data11_,
                      gboolean is_active);
static gboolean ___lambda24__gtk_switch_state_set (GtkSwitch* _sender,
                                            gboolean state,
                                            gpointer self);
static void __lambda25_ (Block11Data* _data11_);
static void ___lambda25__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static void __lambda26_ (Block11Data* _data11_);
static void ___lambda26__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static gboolean __lambda27_ (Block11Data* _data11_,
                      gboolean is_active);
static gboolean ___lambda27__gtk_switch_state_set (GtkSwitch* _sender,
                                            gboolean state,
                                            gpointer self);
VALA_EXTERN ScanSide preferences_dialog_get_page_side (PreferencesDialog* self);
VALA_EXTERN void preferences_dialog_set_brightness (PreferencesDialog* self,
                                        gint brightness);
VALA_EXTERN void preferences_dialog_set_contrast (PreferencesDialog* self,
                                      gint contrast);
VALA_EXTERN gint preferences_dialog_get_page_delay (PreferencesDialog* self);
static void preferences_dialog_finalize (GObject * obj);
static GType preferences_dialog_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

DpiItem*
dpi_item_construct (GType object_type,
                    gint dpi,
                    const gchar* label)
{
	DpiItem * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (DpiItem*) g_object_new (object_type, NULL);
	self->dpi = dpi;
	_tmp0_ = g_strdup (label);
	_g_free0 (self->label);
	self->label = _tmp0_;
	return self;
}

DpiItem*
dpi_item_new (gint dpi,
              const gchar* label)
{
	return dpi_item_construct (TYPE_DPI_ITEM, dpi, label);
}

static void
dpi_item_class_init (DpiItemClass * klass,
                     gpointer klass_data)
{
	dpi_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dpi_item_finalize;
}

static void
dpi_item_instance_init (DpiItem * self,
                        gpointer klass)
{
}

static void
dpi_item_finalize (GObject * obj)
{
	DpiItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DPI_ITEM, DpiItem);
	_g_free0 (self->label);
	G_OBJECT_CLASS (dpi_item_parent_class)->finalize (obj);
}

static GType
dpi_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DpiItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dpi_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DpiItem), 0, (GInstanceInitFunc) dpi_item_instance_init, NULL };
	GType dpi_item_type_id;
	dpi_item_type_id = g_type_register_static (G_TYPE_OBJECT, "DpiItem", &g_define_type_info, 0);
	return dpi_item_type_id;
}

GType
dpi_item_get_type (void)
{
	static volatile gsize dpi_item_type_id__once = 0;
	if (g_once_init_enter (&dpi_item_type_id__once)) {
		GType dpi_item_type_id;
		dpi_item_type_id = dpi_item_get_type_once ();
		g_once_init_leave (&dpi_item_type_id__once, dpi_item_type_id);
	}
	return dpi_item_type_id__once;
}

PaperSizeItem*
paper_size_item_construct (GType object_type,
                           const gchar* label,
                           gint width,
                           gint height)
{
	PaperSizeItem * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (PaperSizeItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (label);
	_g_free0 (self->label);
	self->label = _tmp0_;
	self->width = width;
	self->height = height;
	return self;
}

PaperSizeItem*
paper_size_item_new (const gchar* label,
                     gint width,
                     gint height)
{
	return paper_size_item_construct (TYPE_PAPER_SIZE_ITEM, label, width, height);
}

static void
paper_size_item_class_init (PaperSizeItemClass * klass,
                            gpointer klass_data)
{
	paper_size_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = paper_size_item_finalize;
}

static void
paper_size_item_instance_init (PaperSizeItem * self,
                               gpointer klass)
{
}

static void
paper_size_item_finalize (GObject * obj)
{
	PaperSizeItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAPER_SIZE_ITEM, PaperSizeItem);
	_g_free0 (self->label);
	G_OBJECT_CLASS (paper_size_item_parent_class)->finalize (obj);
}

static GType
paper_size_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PaperSizeItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paper_size_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaperSizeItem), 0, (GInstanceInitFunc) paper_size_item_instance_init, NULL };
	GType paper_size_item_type_id;
	paper_size_item_type_id = g_type_register_static (G_TYPE_OBJECT, "PaperSizeItem", &g_define_type_info, 0);
	return paper_size_item_type_id;
}

GType
paper_size_item_get_type (void)
{
	static volatile gsize paper_size_item_type_id__once = 0;
	if (g_once_init_enter (&paper_size_item_type_id__once)) {
		GType paper_size_item_type_id;
		paper_size_item_type_id = paper_size_item_get_type_once ();
		g_once_init_leave (&paper_size_item_type_id__once, paper_size_item_type_id);
	}
	return paper_size_item_type_id__once;
}

static inline gpointer
preferences_dialog_get_instance_private (PreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PreferencesDialog_private_offset);
}

static gchar*
preferences_dialog_get_dpi_label (DpiItem* device)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device->label;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
preferences_dialog_get_page_size_label (PaperSizeItem* size)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (size != NULL, NULL);
	_tmp0_ = size->label;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		PreferencesDialog* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda10_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	self = _data11_->self;
	g_settings_set_int (_data11_->settings, "text-dpi", preferences_dialog_get_text_dpi (self));
}

static void
___lambda10__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda10_ (self);
}

static void
__lambda11_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	self = _data11_->self;
	g_settings_set_int (_data11_->settings, "photo-dpi", preferences_dialog_get_photo_dpi (self));
}

static void
___lambda11__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda11_ (self);
}

static void
__lambda12_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_enum (_data11_->settings, "page-side", (gint) SCAN_SIDE_FRONT);
	}
}

static void
___lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda12_ (self, _sender);
}

static void
__lambda13_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_enum (_data11_->settings, "page-side", (gint) SCAN_SIDE_BACK);
	}
}

static void
___lambda13__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda13_ (self, _sender);
}

static void
__lambda14_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_enum (_data11_->settings, "page-side", (gint) SCAN_SIDE_BOTH);
	}
}

static void
___lambda14__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda14_ (self, _sender);
}

static void
__lambda15_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	self = _data11_->self;
	g_settings_set_int (_data11_->settings, "brightness", preferences_dialog_get_brightness (self));
}

static void
___lambda15__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda15_ (self);
}

static void
__lambda16_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	self = _data11_->self;
	g_settings_set_int (_data11_->settings, "contrast", preferences_dialog_get_contrast (self));
}

static void
___lambda16__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda16_ (self);
}

static void
__lambda17_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = _data11_->self;
	_tmp0_ = self->priv->compression_adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	g_settings_set_int (_data11_->settings, "jpeg-quality", (gint) _tmp2_);
}

static void
___lambda17__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda17_ (self);
}

static void
__lambda18_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = _data11_->self;
	preferences_dialog_get_paper_size (self, &_tmp0_, &_tmp1_);
	w = _tmp0_;
	h = _tmp1_;
	g_settings_set_int (_data11_->settings, "paper-width", w);
	g_settings_set_int (_data11_->settings, "paper-height", h);
}

static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda18_ (self);
}

static void
__lambda19_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data11_->settings, "page-delay", 0);
	}
}

static void
___lambda19__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda19_ (self, _sender);
}

static void
__lambda20_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data11_->settings, "page-delay", 3000);
	}
}

static void
___lambda20__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda20_ (self, _sender);
}

static void
__lambda21_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data11_->settings, "page-delay", 6000);
	}
}

static void
___lambda21__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda21_ (self, _sender);
}

static void
__lambda22_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data11_->settings, "page-delay", 10000);
	}
}

static void
___lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda22_ (self, _sender);
}

static void
__lambda23_ (Block11Data* _data11_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data11_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data11_->settings, "page-delay", 15000);
	}
}

static void
___lambda23__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda23_ (self, _sender);
}

static gboolean
__lambda24_ (Block11Data* _data11_,
             gboolean is_active)
{
	PreferencesDialog* self;
	gboolean result;
	self = _data11_->self;
	preferences_dialog_toggle_postproc_visibility (self, is_active);
	g_settings_set_boolean (_data11_->settings, "postproc-enabled", is_active);
	result = TRUE;
	return result;
}

static gboolean
___lambda24__gtk_switch_state_set (GtkSwitch* _sender,
                                   gboolean state,
                                   gpointer self)
{
	gboolean result;
	result = __lambda24_ (self, state);
	return result;
}

static void
__lambda25_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	self = _data11_->self;
	_tmp0_ = self->priv->postproc_script_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	g_settings_set_string (_data11_->settings, "postproc-script", _tmp1_);
}

static void
___lambda25__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda25_ (self);
}

static void
__lambda26_ (Block11Data* _data11_)
{
	PreferencesDialog* self;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	self = _data11_->self;
	_tmp0_ = self->priv->postproc_args_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	g_settings_set_string (_data11_->settings, "postproc-arguments", _tmp1_);
}

static void
___lambda26__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda26_ (self);
}

static gboolean
__lambda27_ (Block11Data* _data11_,
             gboolean is_active)
{
	PreferencesDialog* self;
	gboolean result;
	self = _data11_->self;
	g_settings_set_boolean (_data11_->settings, "postproc-keep-original", is_active);
	result = TRUE;
	return result;
}

static gboolean
___lambda27__gtk_switch_state_set (GtkSwitch* _sender,
                                   gboolean state,
                                   gpointer self)
{
	gboolean result;
	result = __lambda27_ (self, state);
	return result;
}

PreferencesDialog*
preferences_dialog_construct (GType object_type,
                              GSettings* settings)
{
	PreferencesDialog * self = NULL;
	Block11Data* _data11_;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	AdwComboRow* _tmp2_;
	GtkExpression** _tmp3_;
	GtkCClosureExpression* _tmp4_;
	GtkCClosureExpression* _tmp5_;
	GListStore* _tmp6_;
	GListStore* _tmp7_;
	PaperSizeItem* _tmp8_;
	PaperSizeItem* _tmp9_;
	GListStore* _tmp10_;
	PaperSizeItem* _tmp11_;
	PaperSizeItem* _tmp12_;
	GListStore* _tmp13_;
	PaperSizeItem* _tmp14_;
	PaperSizeItem* _tmp15_;
	GListStore* _tmp16_;
	PaperSizeItem* _tmp17_;
	PaperSizeItem* _tmp18_;
	GListStore* _tmp19_;
	PaperSizeItem* _tmp20_;
	PaperSizeItem* _tmp21_;
	GListStore* _tmp22_;
	PaperSizeItem* _tmp23_;
	PaperSizeItem* _tmp24_;
	GListStore* _tmp25_;
	PaperSizeItem* _tmp26_;
	PaperSizeItem* _tmp27_;
	GListStore* _tmp28_;
	PaperSizeItem* _tmp29_;
	PaperSizeItem* _tmp30_;
	AdwComboRow* _tmp31_;
	GListStore* _tmp32_;
	AdwComboRow* _tmp33_;
	GtkExpression** _tmp34_;
	GtkCClosureExpression* _tmp35_;
	GtkCClosureExpression* _tmp36_;
	GListStore* _tmp37_;
	AdwComboRow* _tmp38_;
	GListStore* _tmp39_;
	AdwComboRow* _tmp40_;
	GtkExpression** _tmp41_;
	GtkCClosureExpression* _tmp42_;
	GtkCClosureExpression* _tmp43_;
	GListStore* _tmp44_;
	AdwComboRow* _tmp45_;
	GListStore* _tmp46_;
	gint dpi = 0;
	AdwComboRow* _tmp47_;
	AdwComboRow* _tmp48_;
	AdwComboRow* _tmp49_;
	AdwComboRow* _tmp50_;
	GtkToggleButton* _tmp51_;
	GtkToggleButton* _tmp52_;
	GtkToggleButton* _tmp53_;
	gdouble lower = 0.0;
	GtkAdjustment* _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	gchar* darker_label = NULL;
	gchar* _tmp57_;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gchar* lighter_label = NULL;
	gchar* _tmp61_;
	GtkScale* _tmp62_;
	GtkScale* _tmp63_;
	GtkScale* _tmp64_;
	GtkAdjustment* _tmp65_;
	GtkAdjustment* _tmp66_;
	GtkAdjustment* _tmp67_;
	gdouble _tmp68_;
	gdouble _tmp69_;
	gchar* less_label = NULL;
	gchar* _tmp70_;
	GtkAdjustment* _tmp71_;
	gdouble _tmp72_;
	gdouble _tmp73_;
	gchar* more_label = NULL;
	gchar* _tmp74_;
	GtkScale* _tmp75_;
	GtkScale* _tmp76_;
	GtkScale* _tmp77_;
	GtkAdjustment* _tmp78_;
	GtkAdjustment* _tmp79_;
	gchar* minimum_size_label = NULL;
	gchar* _tmp80_;
	GtkScale* _tmp81_;
	GtkAdjustment* _tmp82_;
	gdouble _tmp83_;
	gdouble _tmp84_;
	GtkScale* _tmp85_;
	GtkScale* _tmp86_;
	gchar* full_detail_label = NULL;
	gchar* _tmp87_;
	GtkScale* _tmp88_;
	GtkAdjustment* _tmp89_;
	gdouble _tmp90_;
	gdouble _tmp91_;
	GtkAdjustment* _tmp92_;
	GtkAdjustment* _tmp93_;
	gint paper_width = 0;
	gint paper_height = 0;
	AdwComboRow* _tmp94_;
	GtkToggleButton* _tmp95_;
	GtkToggleButton* _tmp96_;
	GtkToggleButton* _tmp97_;
	GtkToggleButton* _tmp98_;
	GtkToggleButton* _tmp99_;
	gboolean postproc_enabled = FALSE;
	GtkSwitch* _tmp100_;
	GtkSwitch* _tmp101_;
	gchar* postproc_script = NULL;
	gchar* _tmp102_;
	GtkEntry* _tmp103_;
	GtkEntry* _tmp104_;
	gchar* postproc_arguments = NULL;
	gchar* _tmp105_;
	GtkEntry* _tmp106_;
	GtkEntry* _tmp107_;
	gboolean postproc_keep_original = FALSE;
	GtkSwitch* _tmp108_;
	GtkSwitch* _tmp109_;
	g_return_val_if_fail (settings != NULL, NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (_data11_->settings);
	_data11_->settings = _tmp0_;
	self = (PreferencesDialog*) g_object_new (object_type, NULL);
	_data11_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_data11_->settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->paper_size_row;
	_tmp3_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp4_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp3_, (GCallback) preferences_dialog_get_page_size_label, NULL, NULL);
	_tmp5_ = _tmp4_;
	adw_combo_row_set_expression (_tmp2_, (GtkExpression*) _tmp5_);
	_gtk_expression_unref0 (_tmp5_);
	_tmp6_ = g_list_store_new (TYPE_PAPER_SIZE_ITEM);
	_g_object_unref0 (self->priv->paper_size_model);
	self->priv->paper_size_model = _tmp6_;
	_tmp7_ = self->priv->paper_size_model;
	_tmp8_ = paper_size_item_new (_ ("Automatic"), 0, 0);
	_tmp9_ = _tmp8_;
	g_list_store_append (_tmp7_, (GObject*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->paper_size_model;
	_tmp11_ = paper_size_item_new ("A6", 1050, 1480);
	_tmp12_ = _tmp11_;
	g_list_store_append (_tmp10_, (GObject*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->paper_size_model;
	_tmp14_ = paper_size_item_new ("A5", 1480, 2100);
	_tmp15_ = _tmp14_;
	g_list_store_append (_tmp13_, (GObject*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->paper_size_model;
	_tmp17_ = paper_size_item_new ("A4", 2100, 2970);
	_tmp18_ = _tmp17_;
	g_list_store_append (_tmp16_, (GObject*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->paper_size_model;
	_tmp20_ = paper_size_item_new ("A3", 2970, 4200);
	_tmp21_ = _tmp20_;
	g_list_store_append (_tmp19_, (GObject*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->paper_size_model;
	_tmp23_ = paper_size_item_new ("Letter", 2159, 2794);
	_tmp24_ = _tmp23_;
	g_list_store_append (_tmp22_, (GObject*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->paper_size_model;
	_tmp26_ = paper_size_item_new ("Legal", 2159, 3556);
	_tmp27_ = _tmp26_;
	g_list_store_append (_tmp25_, (GObject*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = self->priv->paper_size_model;
	_tmp29_ = paper_size_item_new ("4×6", 1016, 1524);
	_tmp30_ = _tmp29_;
	g_list_store_append (_tmp28_, (GObject*) _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = self->priv->paper_size_row;
	_tmp32_ = self->priv->paper_size_model;
	adw_combo_row_set_model (_tmp31_, (GListModel*) _tmp32_);
	_tmp33_ = self->priv->text_dpi_row;
	_tmp34_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp35_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp34_, (GCallback) preferences_dialog_get_dpi_label, NULL, NULL);
	_tmp36_ = _tmp35_;
	adw_combo_row_set_expression (_tmp33_, (GtkExpression*) _tmp36_);
	_gtk_expression_unref0 (_tmp36_);
	_tmp37_ = g_list_store_new (TYPE_DPI_ITEM);
	_g_object_unref0 (self->priv->text_dpi_model);
	self->priv->text_dpi_model = _tmp37_;
	_tmp38_ = self->priv->text_dpi_row;
	_tmp39_ = self->priv->text_dpi_model;
	adw_combo_row_set_model (_tmp38_, (GListModel*) _tmp39_);
	_tmp40_ = self->priv->photo_dpi_row;
	_tmp41_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp42_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp41_, (GCallback) preferences_dialog_get_dpi_label, NULL, NULL);
	_tmp43_ = _tmp42_;
	adw_combo_row_set_expression (_tmp40_, (GtkExpression*) _tmp43_);
	_gtk_expression_unref0 (_tmp43_);
	_tmp44_ = g_list_store_new (TYPE_DPI_ITEM);
	_g_object_unref0 (self->priv->photo_dpi_model);
	self->priv->photo_dpi_model = _tmp44_;
	_tmp45_ = self->priv->photo_dpi_row;
	_tmp46_ = self->priv->photo_dpi_model;
	adw_combo_row_set_model (_tmp45_, (GListModel*) _tmp46_);
	dpi = g_settings_get_int (_data11_->settings, "text-dpi");
	if (dpi <= 0) {
		dpi = DEFAULT_TEXT_DPI;
	}
	_tmp47_ = self->priv->text_dpi_row;
	preferences_dialog_set_dpi_combo (self, _tmp47_, DEFAULT_TEXT_DPI, dpi);
	_tmp48_ = self->priv->text_dpi_row;
	g_signal_connect_data ((GObject*) _tmp48_, "notify::selected", (GCallback) ___lambda10__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	dpi = g_settings_get_int (_data11_->settings, "photo-dpi");
	if (dpi <= 0) {
		dpi = DEFAULT_PHOTO_DPI;
	}
	_tmp49_ = self->priv->photo_dpi_row;
	preferences_dialog_set_dpi_combo (self, _tmp49_, DEFAULT_PHOTO_DPI, dpi);
	_tmp50_ = self->priv->photo_dpi_row;
	g_signal_connect_data ((GObject*) _tmp50_, "notify::selected", (GCallback) ___lambda11__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	preferences_dialog_set_page_side (self, (ScanSide) g_settings_get_enum (_data11_->settings, "page-side"));
	_tmp51_ = self->priv->front_side_button;
	g_signal_connect_data (_tmp51_, "toggled", (GCallback) ___lambda12__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp52_ = self->priv->back_side_button;
	g_signal_connect_data (_tmp52_, "toggled", (GCallback) ___lambda13__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp53_ = self->priv->both_side_button;
	g_signal_connect_data (_tmp53_, "toggled", (GCallback) ___lambda14__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp54_ = self->priv->brightness_adjustment;
	_tmp55_ = gtk_adjustment_get_lower (_tmp54_);
	_tmp56_ = _tmp55_;
	lower = _tmp56_;
	_tmp57_ = g_strdup_printf ("<small>%s</small>", _ ("Darker"));
	darker_label = _tmp57_;
	_tmp58_ = self->priv->brightness_adjustment;
	_tmp59_ = gtk_adjustment_get_upper (_tmp58_);
	_tmp60_ = _tmp59_;
	upper = _tmp60_;
	_tmp61_ = g_strdup_printf ("<small>%s</small>", _ ("Lighter"));
	lighter_label = _tmp61_;
	_tmp62_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp62_, lower, GTK_POS_BOTTOM, darker_label);
	_tmp63_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp63_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp64_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp64_, upper, GTK_POS_BOTTOM, lighter_label);
	_tmp65_ = self->priv->brightness_adjustment;
	gtk_adjustment_set_value (_tmp65_, (gdouble) g_settings_get_int (_data11_->settings, "brightness"));
	_tmp66_ = self->priv->brightness_adjustment;
	g_signal_connect_data (_tmp66_, "value-changed", (GCallback) ___lambda15__gtk_adjustment_value_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp67_ = self->priv->contrast_adjustment;
	_tmp68_ = gtk_adjustment_get_lower (_tmp67_);
	_tmp69_ = _tmp68_;
	lower = _tmp69_;
	_tmp70_ = g_strdup_printf ("<small>%s</small>", _ ("Less"));
	less_label = _tmp70_;
	_tmp71_ = self->priv->contrast_adjustment;
	_tmp72_ = gtk_adjustment_get_upper (_tmp71_);
	_tmp73_ = _tmp72_;
	upper = _tmp73_;
	_tmp74_ = g_strdup_printf ("<small>%s</small>", _ ("More"));
	more_label = _tmp74_;
	_tmp75_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp75_, lower, GTK_POS_BOTTOM, less_label);
	_tmp76_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp76_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp77_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp77_, upper, GTK_POS_BOTTOM, more_label);
	_tmp78_ = self->priv->contrast_adjustment;
	gtk_adjustment_set_value (_tmp78_, (gdouble) g_settings_get_int (_data11_->settings, "contrast"));
	_tmp79_ = self->priv->contrast_adjustment;
	g_signal_connect_data (_tmp79_, "value-changed", (GCallback) ___lambda16__gtk_adjustment_value_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp80_ = g_strdup_printf ("<small>%s</small>", _ ("Minimum size"));
	minimum_size_label = _tmp80_;
	_tmp81_ = self->priv->compression_scale;
	_tmp82_ = self->priv->compression_adjustment;
	_tmp83_ = gtk_adjustment_get_lower (_tmp82_);
	_tmp84_ = _tmp83_;
	gtk_scale_add_mark (_tmp81_, _tmp84_, GTK_POS_BOTTOM, minimum_size_label);
	_tmp85_ = self->priv->compression_scale;
	gtk_scale_add_mark (_tmp85_, (gdouble) 75, GTK_POS_BOTTOM, NULL);
	_tmp86_ = self->priv->compression_scale;
	gtk_scale_add_mark (_tmp86_, (gdouble) 90, GTK_POS_BOTTOM, NULL);
	_tmp87_ = g_strdup_printf ("<small>%s</small>", _ ("Full detail"));
	full_detail_label = _tmp87_;
	_tmp88_ = self->priv->compression_scale;
	_tmp89_ = self->priv->compression_adjustment;
	_tmp90_ = gtk_adjustment_get_upper (_tmp89_);
	_tmp91_ = _tmp90_;
	gtk_scale_add_mark (_tmp88_, _tmp91_, GTK_POS_BOTTOM, full_detail_label);
	_tmp92_ = self->priv->compression_adjustment;
	gtk_adjustment_set_value (_tmp92_, (gdouble) g_settings_get_int (_data11_->settings, "jpeg-quality"));
	_tmp93_ = self->priv->compression_adjustment;
	g_signal_connect_data (_tmp93_, "value-changed", (GCallback) ___lambda17__gtk_adjustment_value_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	paper_width = g_settings_get_int (_data11_->settings, "paper-width");
	paper_height = g_settings_get_int (_data11_->settings, "paper-height");
	preferences_dialog_set_paper_size (self, paper_width, paper_height);
	_tmp94_ = self->priv->paper_size_row;
	g_signal_connect_data ((GObject*) _tmp94_, "notify::selected", (GCallback) ___lambda18__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	preferences_dialog_set_page_delay (self, g_settings_get_int (_data11_->settings, "page-delay"));
	_tmp95_ = self->priv->page_delay_0s_button;
	g_signal_connect_data (_tmp95_, "toggled", (GCallback) ___lambda19__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp96_ = self->priv->page_delay_3s_button;
	g_signal_connect_data (_tmp96_, "toggled", (GCallback) ___lambda20__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp97_ = self->priv->page_delay_6s_button;
	g_signal_connect_data (_tmp97_, "toggled", (GCallback) ___lambda21__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp98_ = self->priv->page_delay_10s_button;
	g_signal_connect_data (_tmp98_, "toggled", (GCallback) ___lambda22__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp99_ = self->priv->page_delay_15s_button;
	g_signal_connect_data (_tmp99_, "toggled", (GCallback) ___lambda23__gtk_toggle_button_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	postproc_enabled = g_settings_get_boolean (_data11_->settings, "postproc-enabled");
	_tmp100_ = self->priv->postproc_enable_switch;
	gtk_switch_set_state (_tmp100_, postproc_enabled);
	preferences_dialog_toggle_postproc_visibility (self, postproc_enabled);
	_tmp101_ = self->priv->postproc_enable_switch;
	g_signal_connect_data (_tmp101_, "state-set", (GCallback) ___lambda24__gtk_switch_state_set, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp102_ = g_settings_get_string (_data11_->settings, "postproc-script");
	postproc_script = _tmp102_;
	_tmp103_ = self->priv->postproc_script_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp103_, postproc_script);
	_tmp104_ = self->priv->postproc_script_entry;
	g_signal_connect_data ((GtkEditable*) _tmp104_, "changed", (GCallback) ___lambda25__gtk_editable_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp105_ = g_settings_get_string (_data11_->settings, "postproc-arguments");
	postproc_arguments = _tmp105_;
	_tmp106_ = self->priv->postproc_args_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp106_, postproc_arguments);
	_tmp107_ = self->priv->postproc_args_entry;
	g_signal_connect_data ((GtkEditable*) _tmp107_, "changed", (GCallback) ___lambda26__gtk_editable_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	postproc_keep_original = g_settings_get_boolean (_data11_->settings, "postproc-keep-original");
	_tmp108_ = self->priv->postproc_keep_original_switch;
	gtk_switch_set_state (_tmp108_, postproc_keep_original);
	_tmp109_ = self->priv->postproc_keep_original_switch;
	g_signal_connect_data (_tmp109_, "state-set", (GCallback) ___lambda27__gtk_switch_state_set, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_g_free0 (postproc_arguments);
	_g_free0 (postproc_script);
	_g_free0 (full_detail_label);
	_g_free0 (minimum_size_label);
	_g_free0 (more_label);
	_g_free0 (less_label);
	_g_free0 (lighter_label);
	_g_free0 (darker_label);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return self;
}

PreferencesDialog*
preferences_dialog_new (GSettings* settings)
{
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, settings);
}

static void
preferences_dialog_toggle_postproc_visibility (PreferencesDialog* self,
                                               gboolean enabled)
{
	GtkEntry* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkEntry* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkSwitch* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->postproc_script_entry;
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) _tmp0_);
	_tmp2_ = gtk_widget_get_parent (_tmp1_);
	_tmp3_ = gtk_widget_get_parent (_tmp2_);
	_tmp4_ = gtk_widget_get_parent (_tmp3_);
	gtk_widget_set_visible (_tmp4_, enabled);
	_tmp5_ = self->priv->postproc_args_entry;
	_tmp6_ = gtk_widget_get_parent ((GtkWidget*) _tmp5_);
	_tmp7_ = gtk_widget_get_parent (_tmp6_);
	_tmp8_ = gtk_widget_get_parent (_tmp7_);
	_tmp9_ = gtk_widget_get_parent (_tmp8_);
	gtk_widget_set_visible (_tmp9_, enabled);
	_tmp10_ = self->priv->postproc_keep_original_switch;
	_tmp11_ = gtk_widget_get_parent ((GtkWidget*) _tmp10_);
	_tmp12_ = gtk_widget_get_parent (_tmp11_);
	_tmp13_ = gtk_widget_get_parent (_tmp12_);
	_tmp14_ = gtk_widget_get_parent (_tmp13_);
	gtk_widget_set_visible (_tmp14_, enabled);
}

static void
preferences_dialog_set_page_side (PreferencesDialog* self,
                                  ScanSide page_side)
{
	g_return_if_fail (self != NULL);
	switch (page_side) {
		case SCAN_SIDE_FRONT:
		{
			GtkToggleButton* _tmp0_;
			_tmp0_ = self->priv->front_side_button;
			gtk_toggle_button_set_active (_tmp0_, TRUE);
			break;
		}
		case SCAN_SIDE_BACK:
		{
			GtkToggleButton* _tmp1_;
			_tmp1_ = self->priv->back_side_button;
			gtk_toggle_button_set_active (_tmp1_, TRUE);
			break;
		}
		default:
		case SCAN_SIDE_BOTH:
		{
			GtkToggleButton* _tmp2_;
			_tmp2_ = self->priv->both_side_button;
			gtk_toggle_button_set_active (_tmp2_, TRUE);
			break;
		}
	}
}

ScanSide
preferences_dialog_get_page_side (PreferencesDialog* self)
{
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ScanSide result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->front_side_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = SCAN_SIDE_FRONT;
		return result;
	} else {
		GtkToggleButton* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->back_side_button;
		_tmp4_ = gtk_toggle_button_get_active (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			result = SCAN_SIDE_BACK;
			return result;
		} else {
			result = SCAN_SIDE_BOTH;
			return result;
		}
	}
}

void
preferences_dialog_set_paper_size (PreferencesDialog* self,
                                   gint width,
                                   gint height)
{
	g_return_if_fail (self != NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				PaperSizeItem* item = NULL;
				GListStore* _tmp5_;
				GObject* _tmp6_;
				PaperSizeItem* _tmp7_;
				gboolean _tmp8_ = FALSE;
				PaperSizeItem* _tmp9_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->paper_size_model;
				g_object_get (_tmp2_, "n-items", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->paper_size_model;
				_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, i);
				_tmp7_ = IS_PAPER_SIZE_ITEM (_tmp6_) ? ((PaperSizeItem*) _tmp6_) : NULL;
				if (_tmp7_ == NULL) {
					_g_object_unref0 (_tmp6_);
				}
				item = _tmp7_;
				_tmp9_ = item;
				if (_tmp9_->width == width) {
					PaperSizeItem* _tmp10_;
					_tmp10_ = item;
					_tmp8_ = _tmp10_->height == height;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					AdwComboRow* _tmp11_;
					_tmp11_ = self->priv->paper_size_row;
					adw_combo_row_set_selected (_tmp11_, i);
					_g_object_unref0 (item);
					break;
				}
				_g_object_unref0 (item);
			}
		}
	}
}

gint
preferences_dialog_get_text_dpi (PreferencesDialog* self)
{
	AdwComboRow* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->text_dpi_row;
	_tmp1_ = adw_combo_row_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GTK_INVALID_LIST_POSITION) {
		DpiItem* item = NULL;
		GListStore* _tmp3_;
		AdwComboRow* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		GObject* _tmp7_;
		DpiItem* _tmp8_;
		DpiItem* _tmp9_;
		_tmp3_ = self->priv->text_dpi_model;
		_tmp4_ = self->priv->text_dpi_row;
		_tmp5_ = adw_combo_row_get_selected (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_list_model_get_item ((GListModel*) _tmp3_, _tmp6_);
		_tmp8_ = IS_DPI_ITEM (_tmp7_) ? ((DpiItem*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		item = _tmp8_;
		_tmp9_ = item;
		result = _tmp9_->dpi;
		_g_object_unref0 (item);
		return result;
	}
	result = DEFAULT_TEXT_DPI;
	return result;
}

gint
preferences_dialog_get_photo_dpi (PreferencesDialog* self)
{
	AdwComboRow* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->photo_dpi_row;
	_tmp1_ = adw_combo_row_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GTK_INVALID_LIST_POSITION) {
		DpiItem* item = NULL;
		GListStore* _tmp3_;
		AdwComboRow* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		GObject* _tmp7_;
		DpiItem* _tmp8_;
		DpiItem* _tmp9_;
		_tmp3_ = self->priv->photo_dpi_model;
		_tmp4_ = self->priv->photo_dpi_row;
		_tmp5_ = adw_combo_row_get_selected (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_list_model_get_item ((GListModel*) _tmp3_, _tmp6_);
		_tmp8_ = IS_DPI_ITEM (_tmp7_) ? ((DpiItem*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		item = _tmp8_;
		_tmp9_ = item;
		result = _tmp9_->dpi;
		_g_object_unref0 (item);
		return result;
	}
	result = DEFAULT_PHOTO_DPI;
	return result;
}

gboolean
preferences_dialog_get_paper_size (PreferencesDialog* self,
                                   gint* width,
                                   gint* height)
{
	gint _vala_width = 0;
	gint _vala_height = 0;
	AdwComboRow* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_height = 0;
	_vala_width = _vala_height;
	_tmp0_ = self->priv->paper_size_row;
	_tmp1_ = adw_combo_row_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GTK_INVALID_LIST_POSITION) {
		PaperSizeItem* item = NULL;
		GListStore* _tmp3_;
		AdwComboRow* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		GObject* _tmp7_;
		PaperSizeItem* _tmp8_;
		PaperSizeItem* _tmp9_;
		PaperSizeItem* _tmp10_;
		_tmp3_ = self->priv->paper_size_model;
		_tmp4_ = self->priv->paper_size_row;
		_tmp5_ = adw_combo_row_get_selected (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_list_model_get_item ((GListModel*) _tmp3_, _tmp6_);
		_tmp8_ = IS_PAPER_SIZE_ITEM (_tmp7_) ? ((PaperSizeItem*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		item = _tmp8_;
		_tmp9_ = item;
		_vala_width = _tmp9_->width;
		_tmp10_ = item;
		_vala_height = _tmp10_->height;
		result = TRUE;
		_g_object_unref0 (item);
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		return result;
	}
	result = FALSE;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

gint
preferences_dialog_get_brightness (PreferencesDialog* self)
{
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) _tmp2_;
	return result;
}

void
preferences_dialog_set_brightness (PreferencesDialog* self,
                                   gint brightness)
{
	GtkAdjustment* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_adjustment;
	gtk_adjustment_set_value (_tmp0_, (gdouble) brightness);
}

gint
preferences_dialog_get_contrast (PreferencesDialog* self)
{
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->contrast_adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) _tmp2_;
	return result;
}

void
preferences_dialog_set_contrast (PreferencesDialog* self,
                                 gint contrast)
{
	GtkAdjustment* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contrast_adjustment;
	gtk_adjustment_set_value (_tmp0_, (gdouble) contrast);
}

gint
preferences_dialog_get_page_delay (PreferencesDialog* self)
{
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->page_delay_15s_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = 15000;
		return result;
	} else {
		GtkToggleButton* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->page_delay_10s_button;
		_tmp4_ = gtk_toggle_button_get_active (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			result = 10000;
			return result;
		} else {
			GtkToggleButton* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->page_delay_6s_button;
			_tmp7_ = gtk_toggle_button_get_active (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				result = 6000;
				return result;
			} else {
				GtkToggleButton* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = self->priv->page_delay_3s_button;
				_tmp10_ = gtk_toggle_button_get_active (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_) {
					result = 3000;
					return result;
				} else {
					result = 0;
					return result;
				}
			}
		}
	}
}

void
preferences_dialog_set_page_delay (PreferencesDialog* self,
                                   gint page_delay)
{
	g_return_if_fail (self != NULL);
	if (page_delay >= 15000) {
		GtkToggleButton* _tmp0_;
		_tmp0_ = self->priv->page_delay_15s_button;
		gtk_toggle_button_set_active (_tmp0_, TRUE);
	} else {
		if (page_delay >= 10000) {
			GtkToggleButton* _tmp1_;
			_tmp1_ = self->priv->page_delay_10s_button;
			gtk_toggle_button_set_active (_tmp1_, TRUE);
		} else {
			if (page_delay >= 6000) {
				GtkToggleButton* _tmp2_;
				_tmp2_ = self->priv->page_delay_6s_button;
				gtk_toggle_button_set_active (_tmp2_, TRUE);
			} else {
				if (page_delay >= 3000) {
					GtkToggleButton* _tmp3_;
					_tmp3_ = self->priv->page_delay_3s_button;
					gtk_toggle_button_set_active (_tmp3_, TRUE);
				} else {
					GtkToggleButton* _tmp4_;
					_tmp4_ = self->priv->page_delay_0s_button;
					gtk_toggle_button_set_active (_tmp4_, TRUE);
				}
			}
		}
	}
}

static void
preferences_dialog_set_dpi_combo (PreferencesDialog* self,
                                  AdwComboRow* combo,
                                  gint default_dpi,
                                  gint current_dpi)
{
	GListStore* model = NULL;
	GListModel* _tmp0_;
	GListModel* _tmp1_;
	GListStore* _tmp2_;
	gint* scan_resolutions = NULL;
	gint* _tmp3_;
	gint scan_resolutions_length1;
	gint _scan_resolutions_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = adw_combo_row_get_model (combo);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_list_store_get_type ()) ? ((GListStore*) _tmp1_) : NULL);
	model = _tmp2_;
	_tmp3_ = g_new0 (gint, 7);
	_tmp3_[0] = 75;
	_tmp3_[1] = 150;
	_tmp3_[2] = 200;
	_tmp3_[3] = 300;
	_tmp3_[4] = 600;
	_tmp3_[5] = 1200;
	_tmp3_[6] = 2400;
	scan_resolutions = _tmp3_;
	scan_resolutions_length1 = 7;
	_scan_resolutions_size_ = scan_resolutions_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint* _tmp6_;
				gint _tmp6__length1;
				gint dpi = 0;
				gint* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gchar* label = NULL;
				GListStore* _tmp13_;
				const gchar* _tmp14_;
				DpiItem* _tmp15_;
				DpiItem* _tmp16_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = scan_resolutions;
				_tmp6__length1 = scan_resolutions_length1;
				if (!(i < _tmp6__length1)) {
					break;
				}
				_tmp7_ = scan_resolutions;
				_tmp7__length1 = scan_resolutions_length1;
				_tmp8_ = _tmp7_[i];
				dpi = _tmp8_;
				if (dpi == default_dpi) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup_printf (_ ("%d dpi (default)"), dpi);
					_g_free0 (label);
					label = _tmp9_;
				} else {
					if (dpi == 75) {
						gchar* _tmp10_;
						_tmp10_ = g_strdup_printf (_ ("%d dpi (draft)"), dpi);
						_g_free0 (label);
						label = _tmp10_;
					} else {
						if (dpi == 1200) {
							gchar* _tmp11_;
							_tmp11_ = g_strdup_printf (_ ("%d dpi (high resolution)"), dpi);
							_g_free0 (label);
							label = _tmp11_;
						} else {
							gchar* _tmp12_;
							_tmp12_ = g_strdup_printf (_ ("%d dpi"), dpi);
							_g_free0 (label);
							label = _tmp12_;
						}
					}
				}
				_tmp13_ = model;
				_tmp14_ = label;
				_tmp15_ = dpi_item_new (dpi, _tmp14_);
				_tmp16_ = _tmp15_;
				g_list_store_append (_tmp13_, (GObject*) _tmp16_);
				_g_object_unref0 (_tmp16_);
				if (dpi == current_dpi) {
					adw_combo_row_set_selected (combo, (guint) i);
				}
				_g_free0 (label);
			}
		}
	}
	scan_resolutions = (g_free (scan_resolutions), NULL);
	_g_object_unref0 (model);
}

static void
preferences_dialog_class_init (PreferencesDialogClass * klass,
                               gpointer klass_data)
{
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PreferencesDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SimpleScan/ui/preferences-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_dpi_row", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, text_dpi_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_dpi_row", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, photo_dpi_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "paper_size_row", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, paper_size_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "brightness_scale", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, brightness_scale));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contrast_scale", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, contrast_scale));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "compression_scale", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, compression_scale));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_0s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_0s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_3s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_3s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_6s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_6s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_10s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_10s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_15s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_15s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "front_side_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, front_side_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_side_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, back_side_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "both_side_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, both_side_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "brightness_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, brightness_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contrast_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, contrast_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "compression_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, compression_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_enable_switch", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_enable_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_script_entry", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_script_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_args_entry", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_args_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_keep_original_switch", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_keep_original_switch));
}

static void
preferences_dialog_instance_init (PreferencesDialog * self,
                                  gpointer klass)
{
	self->priv = preferences_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->text_dpi_model);
	_g_object_unref0 (self->priv->photo_dpi_model);
	_g_object_unref0 (self->priv->paper_size_model);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}

static GType
preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
	GType preferences_dialog_type_id;
	preferences_dialog_type_id = g_type_register_static (adw_preferences_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
	PreferencesDialog_private_offset = g_type_add_instance_private (preferences_dialog_type_id, sizeof (PreferencesDialogPrivate));
	return preferences_dialog_type_id;
}

GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__once)) {
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = preferences_dialog_get_type_once ();
		g_once_init_leave (&preferences_dialog_type_id__once, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

