/* rygel-music-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-music-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib-object.h>
#include "rygel-core.h"
#include <libxml/tree.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_MUSIC_ITEM_0_PROPERTY,
	RYGEL_MUSIC_ITEM_TRACK_NUMBER_PROPERTY,
	RYGEL_MUSIC_ITEM_DISC_NUMBER_PROPERTY,
	RYGEL_MUSIC_ITEM_ALBUM_ART_PROPERTY,
	RYGEL_MUSIC_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_music_item_properties[RYGEL_MUSIC_ITEM_NUM_PROPERTIES];
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMusicItemPrivate {
	gint _track_number;
	gint _disc_number;
	RygelThumbnail* _album_art;
};

static gint RygelMusicItem_private_offset;
static gpointer rygel_music_item_parent_class = NULL;

VALA_EXTERN gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
VALA_EXTERN void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base,
                                                RygelMediaObject* media_object,
                                                const gchar* property);
static void rygel_music_item_real_apply_didl_lite (RygelMediaObject* base,
                                            GUPnPDIDLLiteObject* didl_object);
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base,
                                                      RygelSerializer* serializer,
                                                      RygelHTTPServer* http_server,
                                                      GError** error);
VALA_EXTERN gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
VALA_EXTERN gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
static void rygel_music_item_finalize (GObject * obj);
static GType rygel_music_item_get_type_once (void);
static void _vala_rygel_music_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_rygel_music_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
rygel_music_item_get_instance_private (RygelMusicItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMusicItem_private_offset);
}

RygelMusicItem*
rygel_music_item_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            const gchar* upnp_class)
{
	RygelMusicItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelMusicItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelMusicItem*
rygel_music_item_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      const gchar* upnp_class)
{
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title, upnp_class);
}

void
rygel_music_item_lookup_album_art (RygelMusicItem* self)
{
	RygelThumbnail* _tmp0_;
	RygelMediaArtStore* media_art_store = NULL;
	RygelMediaArtStore* _tmp1_;
	RygelMediaArtStore* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_album_art;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = rygel_media_art_store_get_default ();
	media_art_store = _tmp1_;
	_tmp2_ = media_art_store;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (media_art_store);
		return;
	}
	{
		RygelThumbnail* _tmp3_ = NULL;
		RygelMediaArtStore* _tmp4_;
		RygelThumbnail* _tmp5_;
		_tmp4_ = media_art_store;
		_tmp5_ = rygel_media_art_store_lookup_media_art (_tmp4_, self, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		rygel_music_item_set_album_art (self, _tmp3_);
		_rygel_icon_info_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_debug ("rygel-music-item.vala:66: Failed to look up album art: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (media_art_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (media_art_store);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
rygel_music_item_real_compare_by_property (RygelMediaObject* base,
                                           RygelMediaObject* media_object,
                                           const gchar* property)
{
	RygelMusicItem * self;
	RygelMusicItem* item = NULL;
	RygelMusicItem* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	gint result;
	self = (RygelMusicItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	if (!RYGEL_IS_MUSIC_ITEM (media_object)) {
		result = 1;
		return result;
	}
	_tmp0_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (media_object) ? ((RygelMusicItem*) media_object) : NULL);
	item = _tmp0_;
	_tmp1_ = property;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
		switch (0) {
			default:
			{
				gint _tmp4_;
				RygelMusicItem* _tmp5_;
				gint _tmp6_;
				_tmp4_ = self->priv->_track_number;
				_tmp5_ = item;
				_tmp6_ = _tmp5_->priv->_track_number;
				result = rygel_media_object_compare_int_props ((RygelMediaObject*) self, _tmp4_, _tmp6_);
				_g_object_unref0 (item);
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("upnp:originalDiscNumber")))) {
		switch (0) {
			default:
			{
				gint _tmp7_;
				RygelMusicItem* _tmp8_;
				gint _tmp9_;
				_tmp7_ = self->priv->_disc_number;
				_tmp8_ = item;
				_tmp9_ = _tmp8_->priv->_disc_number;
				result = rygel_media_object_compare_int_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp10_;
				_tmp10_ = item;
				result = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp10_, property);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
}

static void
rygel_music_item_real_apply_didl_lite (RygelMediaObject* base,
                                       GUPnPDIDLLiteObject* didl_object)
{
	RygelMusicItem * self;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (RygelMusicItem*) base;
	g_return_if_fail (didl_object != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), didl_object);
	_tmp0_ = gupnp_didl_lite_object_get_track_number (didl_object);
	_tmp1_ = _tmp0_;
	rygel_music_item_set_track_number (self, _tmp1_);
	_tmp3_ = gupnp_didl_lite_object_get_album_art (didl_object);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = gupnp_didl_lite_object_get_album_art (didl_object);
		_tmp6_ = _tmp5_;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		RygelThumbnail* _tmp9_;
		RygelThumbnail* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = self->priv->_album_art;
		if (_tmp9_ == NULL) {
			RygelThumbnail* _tmp10_;
			RygelThumbnail* _tmp11_;
			_tmp10_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
			_tmp11_ = _tmp10_;
			rygel_music_item_set_album_art (self, _tmp11_);
			_rygel_icon_info_unref0 (_tmp11_);
		}
		_tmp12_ = self->priv->_album_art;
		_tmp13_ = gupnp_didl_lite_object_get_album_art (didl_object);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (((RygelIconInfo*) _tmp12_)->uri);
		((RygelIconInfo*) _tmp12_)->uri = _tmp15_;
	} else {
		RygelThumbnail* _tmp16_;
		_tmp16_ = self->priv->_album_art;
		if (_tmp16_ != NULL) {
			rygel_music_item_set_album_art (self, NULL);
		}
	}
}

static GUPnPDIDLLiteObject*
rygel_music_item_real_serialize (RygelMediaObject* base,
                                 RygelSerializer* serializer,
                                 RygelHTTPServer* http_server,
                                 GError** error)
{
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp0_;
	gint _tmp1_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GError* _inner_error0_ = NULL;
	GUPnPDIDLLiteObject* result;
	self = (RygelMusicItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), serializer, http_server, &_inner_error0_);
	didl_item = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = self->priv->_track_number;
	if (_tmp1_ >= 0) {
		GUPnPDIDLLiteObject* _tmp2_;
		gint _tmp3_;
		xmlNode* node = NULL;
		GUPnPDIDLLiteObject* _tmp4_;
		xmlNode* _tmp5_;
		xmlNode* _tmp6_;
		xmlNs* ns = NULL;
		gboolean strict_sharing = FALSE;
		xmlNode* _tmp15_;
		xmlNs* _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp2_ = didl_item;
		_tmp3_ = self->priv->_track_number;
		gupnp_didl_lite_object_set_track_number (_tmp2_, _tmp3_);
		_tmp4_ = didl_item;
		_tmp5_ = gupnp_didl_lite_object_get_xml_node (_tmp4_);
		_tmp6_ = _tmp5_;
		node = _tmp6_;
		ns = NULL;
		strict_sharing = FALSE;
		{
			gboolean _tmp7_ = FALSE;
			RygelMetaConfig* _tmp8_;
			RygelMetaConfig* _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = rygel_meta_config_get_default ();
			_tmp9_ = _tmp8_;
			_tmp10_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp9_, "general", "strict-dlna", &_inner_error0_);
			_g_object_unref0 (_tmp9_);
			_tmp7_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			strict_sharing = _tmp7_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
		if (strict_sharing) {
			xmlNode* _tmp11_;
			xmlNs* _tmp12_;
			_tmp11_ = node;
			_tmp12_ = rygel_xml_utils_get_namespace (_tmp11_, "http://www.rygel-project.org/ns/", "rygel");
			ns = _tmp12_;
		} else {
			GUPnPDIDLLiteObject* _tmp13_;
			xmlNs* _tmp14_;
			_tmp13_ = didl_item;
			_tmp14_ = gupnp_didl_lite_object_get_upnp_namespace (_tmp13_);
			ns = _tmp14_;
		}
		_tmp15_ = node;
		_tmp16_ = ns;
		_tmp17_ = self->priv->_disc_number;
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
		_tmp19_ = _tmp18_;
		xmlNewChild (_tmp15_, _tmp16_, (xmlChar*) "originalDiscNumber", (xmlChar*) _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp21_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
	_tmp22_ = _tmp21_;
	if (!_tmp22_) {
		RygelThumbnail* _tmp23_;
		_tmp23_ = self->priv->_album_art;
		_tmp20_ = _tmp23_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gchar* protocol = NULL;
		RygelThumbnail* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gboolean _tmp27_ = FALSE;
		_tmp24_ = self->priv->_album_art;
		_tmp25_ = ((RygelIconInfo*) _tmp24_)->uri;
		_tmp26_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp25_, &_inner_error0_);
		protocol = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
		if (rygel_http_server_is_local (http_server)) {
			_tmp27_ = TRUE;
		} else {
			const gchar* _tmp28_;
			_tmp28_ = protocol;
			_tmp27_ = g_strcmp0 (_tmp28_, "internal") != 0;
		}
		if (_tmp27_) {
			GUPnPDIDLLiteObject* _tmp29_;
			RygelThumbnail* _tmp30_;
			const gchar* _tmp31_;
			_tmp29_ = didl_item;
			_tmp30_ = self->priv->_album_art;
			_tmp31_ = ((RygelIconInfo*) _tmp30_)->uri;
			gupnp_didl_lite_object_set_album_art (_tmp29_, _tmp31_);
		} else {
			gchar* http_uri = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			GRegex* _tmp34_;
			const gchar* _tmp35_;
			GUPnPContext* _tmp36_;
			GInetAddress* _tmp37_;
			GInetAddress* _tmp38_;
			GInetAddress* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			GUPnPDIDLLiteObject* _tmp44_;
			_tmp32_ = rygel_http_server_create_uri_for_object (http_server, (RygelMediaObject*) self, 0, -1, NULL);
			http_uri = _tmp32_;
			_tmp34_ = rygel_media_file_item_address_regex;
			_tmp35_ = http_uri;
			_tmp36_ = http_server->context;
			_tmp37_ = gssdp_client_get_address ((GSSDPClient*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_;
			_tmp40_ = g_inet_address_to_string (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_regex_replace_literal (_tmp34_, _tmp35_, (gssize) -1, 0, _tmp41_, 0, &_inner_error0_);
			_tmp43_ = _tmp42_;
			_g_free0 (_tmp41_);
			_g_object_unref0 (_tmp39_);
			_tmp33_ = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (http_uri);
				_g_free0 (protocol);
				_g_object_unref0 (didl_item);
				return NULL;
			}
			_tmp44_ = didl_item;
			gupnp_didl_lite_object_set_album_art (_tmp44_, _tmp33_);
			_g_free0 (_tmp33_);
			_g_free0 (http_uri);
		}
		_g_free0 (protocol);
	}
	result = didl_item;
	return result;
}

gint
rygel_music_item_get_track_number (RygelMusicItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_track_number;
	return result;
}

void
rygel_music_item_set_track_number (RygelMusicItem* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_music_item_get_track_number (self);
	if (old_value != value) {
		self->priv->_track_number = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_music_item_properties[RYGEL_MUSIC_ITEM_TRACK_NUMBER_PROPERTY]);
	}
}

gint
rygel_music_item_get_disc_number (RygelMusicItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_disc_number;
	return result;
}

void
rygel_music_item_set_disc_number (RygelMusicItem* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_music_item_get_disc_number (self);
	if (old_value != value) {
		self->priv->_disc_number = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_music_item_properties[RYGEL_MUSIC_ITEM_DISC_NUMBER_PROPERTY]);
	}
}

RygelThumbnail*
rygel_music_item_get_album_art (RygelMusicItem* self)
{
	RygelThumbnail* result;
	RygelThumbnail* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_album_art;
	result = _tmp0_;
	return result;
}

static gpointer
_rygel_icon_info_ref0 (gpointer self)
{
	return self ? rygel_icon_info_ref (self) : NULL;
}

void
rygel_music_item_set_album_art (RygelMusicItem* self,
                                RygelThumbnail* value)
{
	RygelThumbnail* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_music_item_get_album_art (self);
	if (old_value != value) {
		RygelThumbnail* _tmp0_;
		_tmp0_ = _rygel_icon_info_ref0 (value);
		_rygel_icon_info_unref0 (self->priv->_album_art);
		self->priv->_album_art = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_music_item_properties[RYGEL_MUSIC_ITEM_ALBUM_ART_PROPERTY]);
	}
}

static void
rygel_music_item_class_init (RygelMusicItemClass * klass,
                             gpointer klass_data)
{
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMusicItem_private_offset);
	((RygelMediaObjectClass *) klass)->compare_by_property = (gint (*) (RygelMediaObject*, RygelMediaObject*, const gchar*)) rygel_music_item_real_compare_by_property;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject*, GUPnPDIDLLiteObject*)) rygel_music_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_music_item_real_serialize;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_music_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_music_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_TRACK_NUMBER_PROPERTY, rygel_music_item_properties[RYGEL_MUSIC_ITEM_TRACK_NUMBER_PROPERTY] = g_param_spec_int ("track-number", "track-number", "track-number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_DISC_NUMBER_PROPERTY, rygel_music_item_properties[RYGEL_MUSIC_ITEM_DISC_NUMBER_PROPERTY] = g_param_spec_int ("disc-number", "disc-number", "disc-number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_ALBUM_ART_PROPERTY, rygel_music_item_properties[RYGEL_MUSIC_ITEM_ALBUM_ART_PROPERTY] = rygel_param_spec_icon_info ("album-art", "album-art", "album-art", RYGEL_TYPE_THUMBNAIL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_music_item_instance_init (RygelMusicItem * self,
                                gpointer klass)
{
	self->priv = rygel_music_item_get_instance_private (self);
	self->priv->_track_number = -1;
	self->priv->_disc_number = -1;
}

static void
rygel_music_item_finalize (GObject * obj)
{
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	_rygel_icon_info_unref0 (self->priv->_album_art);
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
}

/**
 * Represents a music item.
 */
 G_GNUC_NO_INLINE static GType
rygel_music_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
	GType rygel_music_item_type_id;
	rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
	RygelMusicItem_private_offset = g_type_add_instance_private (rygel_music_item_type_id, sizeof (RygelMusicItemPrivate));
	return rygel_music_item_type_id;
}

GType
rygel_music_item_get_type (void)
{
	static volatile gsize rygel_music_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__once)) {
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = rygel_music_item_get_type_once ();
		g_once_init_leave (&rygel_music_item_type_id__once, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__once;
}

static void
_vala_rygel_music_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	switch (property_id) {
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER_PROPERTY:
		g_value_set_int (value, rygel_music_item_get_track_number (self));
		break;
		case RYGEL_MUSIC_ITEM_DISC_NUMBER_PROPERTY:
		g_value_set_int (value, rygel_music_item_get_disc_number (self));
		break;
		case RYGEL_MUSIC_ITEM_ALBUM_ART_PROPERTY:
		rygel_value_set_icon_info (value, rygel_music_item_get_album_art (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_music_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	switch (property_id) {
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER_PROPERTY:
		rygel_music_item_set_track_number (self, g_value_get_int (value));
		break;
		case RYGEL_MUSIC_ITEM_DISC_NUMBER_PROPERTY:
		rygel_music_item_set_disc_number (self, g_value_get_int (value));
		break;
		case RYGEL_MUSIC_ITEM_ALBUM_ART_PROPERTY:
		rygel_music_item_set_album_art (self, rygel_value_get_icon_info (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

