/* rygel-v1-hacks.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-v1-hacks.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 * Copyright (C) 2012 Jens Georg.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <libgupnp/gupnp.h>

#define RYGEL_V1_HACKS_MATCHING_PATTERN ".*%s.*"
#define RYGEL_V1_HACKS_SERVICE_TYPE_PATTERN ":[0-9]+$"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_V1_HACKS_0_PROPERTY,
	RYGEL_V1_HACKS_DEVICE_TYPE_PROPERTY,
	RYGEL_V1_HACKS_SERVICE_TYPES_PROPERTY,
	RYGEL_V1_HACKS_NUM_PROPERTIES
};
static GParamSpec* rygel_v1_hacks_properties[RYGEL_V1_HACKS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_AGENT_MATCHER (rygel_agent_matcher_get_type ())
#define RYGEL_AGENT_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcher))
#define RYGEL_AGENT_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcherClass))
#define RYGEL_IS_AGENT_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AGENT_MATCHER))
#define RYGEL_IS_AGENT_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AGENT_MATCHER))
#define RYGEL_AGENT_MATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcherClass))

typedef struct _RygelAgentMatcher RygelAgentMatcher;
typedef struct _RygelAgentMatcherClass RygelAgentMatcherClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelV1HacksPrivate {
	gchar* _device_type;
	gchar* device_type_v1;
	gchar** _service_types;
	gint _service_types_length1;
	gint __service_types_size_;
	GRegex* service_type_regex;
};

static gint RygelV1Hacks_private_offset;
static gpointer rygel_v1_hacks_parent_class = NULL;
static RygelAgentMatcher* rygel_v1_hacks_agent_matcher;
static RygelAgentMatcher* rygel_v1_hacks_agent_matcher = NULL;

VALA_EXTERN GType rygel_agent_matcher_get_type (void) G_GNUC_CONST ;
static void rygel_v1_hacks_real_constructed (GObject* base);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN RygelAgentMatcher* rygel_agent_matcher_new (const gchar* name,
                                            GeeArrayList* agents);
VALA_EXTERN RygelAgentMatcher* rygel_agent_matcher_construct (GType object_type,
                                                  const gchar* name,
                                                  GeeArrayList* agents);
VALA_EXTERN GRegex* rygel_agent_matcher_get_agent_regex (RygelAgentMatcher* self);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void rygel_v1_hacks_finalize (GObject * obj);
static GType rygel_v1_hacks_get_type_once (void);
static void _vala_rygel_v1_hacks_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_rygel_v1_hacks_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* RYGEL_V1_HACKS_AGENTS[9] = {"Allegro-Software-WebClient", "SEC HHP", "SEC_HHP", "Mediabolic-IMHTTP/1.", "TwoPlayer", "Reciva", "FDSSDP", "Portable SDK for UPnP devices", "Darwin"};

static inline gpointer
rygel_v1_hacks_get_instance_private (RygelV1Hacks* self)
{
	return G_STRUCT_MEMBER_P (self, RygelV1Hacks_private_offset);
}

RygelV1Hacks*
rygel_v1_hacks_construct (GType object_type,
                          const gchar* device_type,
                          gchar** service_types,
                          gint service_types_length1)
{
	RygelV1Hacks * self = NULL;
	g_return_val_if_fail (device_type != NULL, NULL);
	self = (RygelV1Hacks*) g_object_new (object_type, "device-type", device_type, "service-types", service_types, NULL);
	return self;
}

RygelV1Hacks*
rygel_v1_hacks_new (const gchar* device_type,
                    gchar** service_types,
                    gint service_types_length1)
{
	return rygel_v1_hacks_construct (RYGEL_TYPE_V1_HACKS, device_type, service_types, service_types_length1);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
rygel_v1_hacks_real_constructed (GObject* base)
{
	RygelV1Hacks * self;
	RygelAgentMatcher* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelV1Hacks*) base;
	G_OBJECT_CLASS (rygel_v1_hacks_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = rygel_v1_hacks_agent_matcher;
	if (_tmp0_ == NULL) {
		GeeArrayList* defaults = NULL;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GEqualFunc _tmp2_;
		GeeArrayList* _tmp3_;
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp4_;
		GeeArrayList* agents = NULL;
		RygelMetaConfig* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		RygelAgentMatcher* _tmp9_;
		_tmp1_ = _vala_array_dup2 (RYGEL_V1_HACKS_AGENTS, G_N_ELEMENTS (RYGEL_V1_HACKS_AGENTS));
		_tmp1__length1 = G_N_ELEMENTS (RYGEL_V1_HACKS_AGENTS);
		_tmp2_ = g_str_equal;
		_tmp3_ = gee_array_list_new_wrap (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_, _tmp1__length1, (GeeEqualDataFunc) _tmp2_, NULL, NULL);
		defaults = _tmp3_;
		_tmp4_ = rygel_meta_config_get_default ();
		config = _tmp4_;
		_tmp5_ = config;
		_tmp6_ = defaults;
		_tmp7_ = rygel_configuration_get_string_list_with_default ((RygelConfiguration*) _tmp5_, "general", "force-downgrade-for", _tmp6_);
		agents = _tmp7_;
		_tmp8_ = agents;
		_tmp9_ = rygel_agent_matcher_new ("V1 hacks", _tmp8_);
		_g_object_unref0 (rygel_v1_hacks_agent_matcher);
		rygel_v1_hacks_agent_matcher = _tmp9_;
		_g_object_unref0 (agents);
		_g_object_unref0 (config);
		_g_object_unref0 (defaults);
	}
	{
		GRegex* _tmp10_ = NULL;
		GRegex* _tmp11_;
		GRegex* _tmp12_;
		_tmp11_ = g_regex_new (RYGEL_V1_HACKS_SERVICE_TYPE_PATTERN, 0, 0, &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp10_;
		_tmp10_ = NULL;
		_g_regex_unref0 (self->priv->service_type_regex);
		self->priv->service_type_regex = _tmp12_;
		_g_regex_unref0 (_tmp10_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
rygel_v1_hacks_apply_on_device (RygelV1Hacks* self,
                                RygelRootDevice* device,
                                const gchar* template_path,
                                GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelDescriptionFile* description_file = NULL;
	RygelDescriptionFile* _tmp3_;
	RygelDescriptionFile* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp16_;
	RygelDescriptionFile* _tmp17_;
	const gchar* _tmp18_;
	gchar* server_path = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	RygelAgentMatcher* _tmp21_;
	GRegex* _tmp22_;
	GRegex* _tmp23_;
	const gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) device);
	_tmp1_ = rygel_v1_hacks_get_device_type (self);
	_tmp2_ = _tmp1_;
	if (!g_str_has_prefix (_tmp0_, _tmp2_)) {
		return;
	}
	if (template_path == NULL) {
		return;
	}
	_tmp3_ = rygel_description_file_new (template_path, &_inner_error0_);
	description_file = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp4_ = description_file;
	_tmp5_ = self->priv->device_type_v1;
	rygel_description_file_set_device_type (_tmp4_, _tmp5_);
	_tmp6_ = rygel_v1_hacks_get_service_types (self, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	{
		gchar** service_type_collection = NULL;
		gint service_type_collection_length1 = 0;
		gint _service_type_collection_size_ = 0;
		gint service_type_it = 0;
		service_type_collection = _tmp8_;
		service_type_collection_length1 = _tmp8__length1;
		for (service_type_it = 0; service_type_it < service_type_collection_length1; service_type_it = service_type_it + 1) {
			gchar* _tmp9_;
			gchar* service_type = NULL;
			_tmp9_ = g_strdup (service_type_collection[service_type_it]);
			service_type = _tmp9_;
			{
				gchar* service_type_v1 = NULL;
				GRegex* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				RygelDescriptionFile* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp10_ = self->priv->service_type_regex;
				_tmp11_ = service_type;
				_tmp12_ = g_regex_replace_literal (_tmp10_, _tmp11_, (gssize) -1, 0, ":1", 0, &_inner_error0_);
				service_type_v1 = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (service_type);
					_g_object_unref0 (description_file);
					return;
				}
				_tmp13_ = description_file;
				_tmp14_ = service_type;
				_tmp15_ = service_type_v1;
				rygel_description_file_modify_service_type (_tmp13_, _tmp14_, _tmp15_);
				_g_free0 (service_type_v1);
				_g_free0 (service_type);
			}
		}
	}
	_tmp16_ = string_replace (template_path, ".xml", "-v1.xml");
	_g_free0 (self->description_path);
	self->description_path = _tmp16_;
	_tmp17_ = description_file;
	_tmp18_ = self->description_path;
	rygel_description_file_save (_tmp17_, _tmp18_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (description_file);
		return;
	}
	_tmp19_ = gupnp_root_device_get_description_document_name ((GUPnPRootDevice*) device);
	_tmp20_ = g_strconcat ("/", _tmp19_, NULL);
	server_path = _tmp20_;
	_tmp21_ = rygel_v1_hacks_agent_matcher;
	_tmp22_ = rygel_agent_matcher_get_agent_regex (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_regex_get_pattern (_tmp23_);
	if (g_strcmp0 (_tmp24_, "") != 0) {
		GUPnPContext* _tmp25_;
		GUPnPContext* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		RygelAgentMatcher* _tmp29_;
		GRegex* _tmp30_;
		GRegex* _tmp31_;
		_tmp25_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) device);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->description_path;
		_tmp28_ = server_path;
		_tmp29_ = rygel_v1_hacks_agent_matcher;
		_tmp30_ = rygel_agent_matcher_get_agent_regex (_tmp29_);
		_tmp31_ = _tmp30_;
		gupnp_context_host_path_for_agent (_tmp26_, _tmp27_, _tmp28_, _tmp31_);
	}
	_g_free0 (server_path);
	_g_object_unref0 (description_file);
}

const gchar*
rygel_v1_hacks_get_device_type (RygelV1Hacks* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device_type;
	result = _tmp0_;
	return result;
}

void
rygel_v1_hacks_set_device_type (RygelV1Hacks* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_device_type);
	self->priv->_device_type = _tmp0_;
	_tmp1_ = g_strconcat (value, ":1", NULL);
	_g_free0 (self->priv->device_type_v1);
	self->priv->device_type_v1 = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, rygel_v1_hacks_properties[RYGEL_V1_HACKS_DEVICE_TYPE_PROPERTY]);
}

gchar**
rygel_v1_hacks_get_service_types (RygelV1Hacks* self,
                                  gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_service_types;
	_tmp0__length1 = self->priv->_service_types_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
rygel_v1_hacks_set_service_types (RygelV1Hacks* self,
                                  gchar** value,
                                  gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = rygel_v1_hacks_get_service_types (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_service_types = (_vala_array_free (self->priv->_service_types, self->priv->_service_types_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_service_types = _tmp0_;
		self->priv->_service_types_length1 = _tmp0__length1;
		self->priv->__service_types_size_ = self->priv->_service_types_length1;
		g_object_notify_by_pspec ((GObject *) self, rygel_v1_hacks_properties[RYGEL_V1_HACKS_SERVICE_TYPES_PROPERTY]);
	}
}

static void
rygel_v1_hacks_class_init (RygelV1HacksClass * klass,
                           gpointer klass_data)
{
	rygel_v1_hacks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelV1Hacks_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_v1_hacks_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_v1_hacks_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_v1_hacks_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_v1_hacks_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_V1_HACKS_DEVICE_TYPE_PROPERTY, rygel_v1_hacks_properties[RYGEL_V1_HACKS_DEVICE_TYPE_PROPERTY] = g_param_spec_string ("device-type", "device-type", "device-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_V1_HACKS_SERVICE_TYPES_PROPERTY, rygel_v1_hacks_properties[RYGEL_V1_HACKS_SERVICE_TYPES_PROPERTY] = g_param_spec_boxed ("service-types", "service-types", "service-types", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
rygel_v1_hacks_instance_init (RygelV1Hacks * self,
                              gpointer klass)
{
	self->priv = rygel_v1_hacks_get_instance_private (self);
}

static void
rygel_v1_hacks_finalize (GObject * obj)
{
	RygelV1Hacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_V1_HACKS, RygelV1Hacks);
	_g_free0 (self->priv->_device_type);
	_g_free0 (self->priv->device_type_v1);
	self->priv->_service_types = (_vala_array_free (self->priv->_service_types, self->priv->_service_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->description_path);
	_g_regex_unref0 (self->priv->service_type_regex);
	G_OBJECT_CLASS (rygel_v1_hacks_parent_class)->finalize (obj);
}

/**
 * Various devices that need a downgrade to MediaServer:1 and
 * ContentDirectory:1 because they ignore that higher versions are
 * required to be backwards-compatible.
 */
 G_GNUC_NO_INLINE static GType
rygel_v1_hacks_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelV1HacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_v1_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelV1Hacks), 0, (GInstanceInitFunc) rygel_v1_hacks_instance_init, NULL };
	GType rygel_v1_hacks_type_id;
	rygel_v1_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelV1Hacks", &g_define_type_info, 0);
	RygelV1Hacks_private_offset = g_type_add_instance_private (rygel_v1_hacks_type_id, sizeof (RygelV1HacksPrivate));
	return rygel_v1_hacks_type_id;
}

GType
rygel_v1_hacks_get_type (void)
{
	static volatile gsize rygel_v1_hacks_type_id__once = 0;
	if (g_once_init_enter (&rygel_v1_hacks_type_id__once)) {
		GType rygel_v1_hacks_type_id;
		rygel_v1_hacks_type_id = rygel_v1_hacks_get_type_once ();
		g_once_init_leave (&rygel_v1_hacks_type_id__once, rygel_v1_hacks_type_id);
	}
	return rygel_v1_hacks_type_id__once;
}

static void
_vala_rygel_v1_hacks_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	RygelV1Hacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_V1_HACKS, RygelV1Hacks);
	switch (property_id) {
		case RYGEL_V1_HACKS_DEVICE_TYPE_PROPERTY:
		g_value_set_string (value, rygel_v1_hacks_get_device_type (self));
		break;
		case RYGEL_V1_HACKS_SERVICE_TYPES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, rygel_v1_hacks_get_service_types (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_v1_hacks_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	RygelV1Hacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_V1_HACKS, RygelV1Hacks);
	switch (property_id) {
		case RYGEL_V1_HACKS_DEVICE_TYPE_PROPERTY:
		rygel_v1_hacks_set_device_type (self, g_value_get_string (value));
		break;
		case RYGEL_V1_HACKS_SERVICE_TYPES_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			rygel_v1_hacks_set_service_types (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

