// third_party/blink/public/mojom/page_state/page_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/page_state/page_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page_state/page_state.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ScrollRestorationTypeToStringHelper(ScrollRestorationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollRestorationType::kAuto:
      return "kAuto";
    case ScrollRestorationType::kManual:
      return "kManual";
    default:
      return nullptr;
  }
}

std::string ScrollRestorationTypeToString(ScrollRestorationType value) {
  const char *str = ScrollRestorationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollRestorationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollRestorationType value) {
  return os << ScrollRestorationTypeToString(value);
}

namespace internal {
// static
bool Element_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Element_Data* object = static_cast<const Element_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Element_Tag::kBlobUuid: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_blob_uuid, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& blob_uuid_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_blob_uuid, validation_context,
                                             &blob_uuid_validate_params)) {
        return false;
      }
      return true;
    }
    case Element_Tag::kBytes: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bytes, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_bytes, validation_context,
                                             &bytes_validate_params)) {
        return false;
      }
      return true;
    }
    case Element_Tag::kFile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file, validation_context))
        return false;
      return true;
    }
    case Element_Tag::kDeprecatedFileSystemFile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_DEPRECATED_file_system_file, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_DEPRECATED_file_system_file, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Element");
      return false;
    }
  }
}


// static
bool DEPRECATED_FileSystemFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DEPRECATED_FileSystemFile_Data* object =
      static_cast<const DEPRECATED_FileSystemFile_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filesystem_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filesystem_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modification_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->modification_time, validation_context))
    return false;

  return true;
}

DEPRECATED_FileSystemFile_Data::DEPRECATED_FileSystemFile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool File_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const File_Data* object =
      static_cast<const File_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modification_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->modification_time, validation_context))
    return false;

  return true;
}

File_Data::File_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequestBody_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RequestBody_Data* object =
      static_cast<const RequestBody_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elements, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->elements, validation_context,
                                         &elements_validate_params)) {
    return false;
  }

  return true;
}

RequestBody_Data::RequestBody_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HttpBody_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HttpBody_Data* object =
      static_cast<const HttpBody_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->http_content_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request_body, validation_context))
    return false;

  return true;
}

HttpBody_Data::HttpBody_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 32 },
    { 1, 56 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewState_Data* object =
      static_cast<const ViewState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visual_viewport_scroll_offset, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visual_viewport_scroll_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_offset, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_offset, validation_context))
    return false;
  if (object->header_.version < 1)
    return true;

  if (!mojo::internal::ValidateStruct(object->scroll_anchor_selector, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scroll_anchor_offset, validation_context))
    return false;

  return true;
}

ViewState_Data::ViewState_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool FrameState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 96 },
    { 2, 104 },
    { 3, 120 },
    { 4, 128 },
    { 5, 136 },
    { 6, 144 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameState_Data* object =
      static_cast<const FrameState_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->url_string, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->target, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->state_object, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_state, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& document_state_validate_params =
      mojo::internal::GetArrayValidator<0, true, nullptr>();
  if (!mojo::internal::ValidateContainer(object->document_state, validation_context,
                                         &document_state_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ScrollRestorationType_Data
        ::Validate(object->scroll_restoration_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->view_state, validation_context))
    return false;


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_body, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_body, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }
  if (object->header_.version < 2)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& initiator_origin_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->initiator_origin, validation_context,
                                         &initiator_origin_validate_params)) {
    return false;
  }
  if (object->header_.version < 3)
    return true;

  if (!mojo::internal::ValidateStruct(object->navigation_api_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->navigation_api_id, validation_context))
    return false;
  if (object->header_.version < 4)
    return true;

  if (!mojo::internal::ValidateStruct(object->navigation_api_state, validation_context))
    return false;
  if (object->header_.version < 6)
    return true;

  if (!mojo::internal::ValidateStruct(object->initiator_base_url_string, validation_context))
    return false;

  return true;
}

FrameState_Data::FrameState_Data()
    : header_({sizeof(*this), 6}) {}


// static
bool PageState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageState_Data* object =
      static_cast<const PageState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referenced_files, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& referenced_files_validate_params =
      mojo::internal::GetArrayValidator<0, true, nullptr>();
  if (!mojo::internal::ValidateContainer(object->referenced_files, validation_context,
                                         &referenced_files_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top, validation_context))
    return false;

  return true;
}

PageState_Data::PageState_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ScrollRestorationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ScrollRestorationType value) {
  return std::move(context).WriteString(::blink::mojom::ScrollRestorationTypeToString(value));
}

} // namespace perfetto