// services/service_manager/public/mojom/service_filter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_SHARED_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/service_filter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"



#include "base/component_export.h"




namespace service_manager::mojom {
class ServiceFilterDataView;



}  // service_manager::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::service_manager::mojom::ServiceFilterDataView> {
  using Data = ::service_manager::mojom::internal::ServiceFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace service_manager::mojom {


class ServiceFilterDataView {
 public:
  ServiceFilterDataView() = default;

  ServiceFilterDataView(
      internal::ServiceFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServiceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceName(UserType* output) {
    
    auto* pointer = data_->service_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInstanceGroupDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceGroup(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `instance_group` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInstanceGroup` instead "
    "of `ReadInstanceGroup if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->instance_group.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetInstanceIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `instance_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInstanceId` instead "
    "of `ReadInstanceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetGloballyUniqueIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGloballyUniqueId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `globally_unique_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGloballyUniqueId` instead "
    "of `ReadGloballyUniqueId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->globally_unique_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // service_manager::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::service_manager::mojom::ServiceFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::service_manager::mojom::ServiceFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::service_manager::mojom::internal::ServiceFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::service_name(input)) in_service_name = Traits::service_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_name)::BaseType> service_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_service_name, service_name_fragment);
    fragment->service_name.Set(
        service_name_fragment.is_null() ? nullptr : service_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_name in ServiceFilter struct");
    decltype(Traits::instance_group(input)) in_instance_group = Traits::instance_group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_group)::BaseType> instance_group_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
        in_instance_group, instance_group_fragment);
    fragment->instance_group.Set(
        instance_group_fragment.is_null() ? nullptr : instance_group_fragment.data());
    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
        in_instance_id, instance_id_fragment);
    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());
    decltype(Traits::globally_unique_id(input)) in_globally_unique_id = Traits::globally_unique_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->globally_unique_id)::BaseType> globally_unique_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
        in_globally_unique_id, globally_unique_id_fragment);
    fragment->globally_unique_id.Set(
        globally_unique_id_fragment.is_null() ? nullptr : globally_unique_id_fragment.data());
  }

  static bool Deserialize(::service_manager::mojom::internal::ServiceFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::service_manager::mojom::ServiceFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace service_manager::mojom {

inline void ServiceFilterDataView::GetServiceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->service_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ServiceFilterDataView::GetInstanceGroupDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->instance_group.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void ServiceFilterDataView::GetInstanceIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void ServiceFilterDataView::GetGloballyUniqueIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->globally_unique_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}



}  // service_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_SHARED_H_