// media/mojo/mojom/display_media_information.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/display_media_information.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/display_media_information.mojom-params-data.h"
#include "media/mojo/mojom/display_media_information.mojom-shared-message-ids.h"

#include "media/mojo/mojom/display_media_information.mojom-blink-import-headers.h"
#include "media/mojo/mojom/display_media_information.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
DisplayMediaInformation::DisplayMediaInformation()
    : display_surface(),
      logical_surface(),
      cursor(),
      capture_handle(),
      initial_zoom_level() {}

DisplayMediaInformation::DisplayMediaInformation(
    DisplayCaptureSurfaceType display_surface_in,
    bool logical_surface_in,
    CursorCaptureType cursor_in,
    ::media::mojom::blink::CaptureHandlePtr capture_handle_in,
    int32_t initial_zoom_level_in)
    : display_surface(std::move(display_surface_in)),
      logical_surface(std::move(logical_surface_in)),
      cursor(std::move(cursor_in)),
      capture_handle(std::move(capture_handle_in)),
      initial_zoom_level(std::move(initial_zoom_level_in)) {}

DisplayMediaInformation::~DisplayMediaInformation() = default;

void DisplayMediaInformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_surface"), this->display_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DisplayCaptureSurfaceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_surface"), this->logical_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cursor"), this->cursor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CursorCaptureType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_handle"), this->capture_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::CaptureHandlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_zoom_level"), this->initial_zoom_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplayMediaInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::DisplayMediaInformation::DataView, ::media::mojom::blink::DisplayMediaInformationPtr>::Read(
    ::media::mojom::blink::DisplayMediaInformation::DataView input,
    ::media::mojom::blink::DisplayMediaInformationPtr* output) {
  bool success = true;
  ::media::mojom::blink::DisplayMediaInformationPtr result(::media::mojom::blink::DisplayMediaInformation::New());
  
      if (success && !input.ReadDisplaySurface(&result->display_surface))
        success = false;
      if (success)
        result->logical_surface = input.logical_surface();
      if (success && !input.ReadCursor(&result->cursor))
        success = false;
      if (success && !input.ReadCaptureHandle(&result->capture_handle))
        success = false;
      if (success)
        result->initial_zoom_level = input.initial_zoom_level();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {




}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif