// gpu/ipc/common/shared_image_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_H_
#define GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/shared_image_metadata.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/shared_image_metadata.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/shared_image_format.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include "skia/public/mojom/surface_origin.mojom.h"
#include "skia/public/mojom/image_info.mojom.h"
#include <string>
#include <vector>




#include "gpu/ipc/common/shared_image_metadata_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {








class GPU_EXPORT SharedImageMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedImageMetadata, T>::value>;
  using DataView = SharedImageMetadataDataView;
  using Data_ = internal::SharedImageMetadata_Data;

  template <typename... Args>
  static SharedImageMetadataPtr New(Args&&... args) {
    return SharedImageMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedImageMetadataPtr From(const U& u) {
    return mojo::TypeConverter<SharedImageMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedImageMetadata>::Convert(*this);
  }


  SharedImageMetadata();

  SharedImageMetadata(
      const ::viz::SharedImageFormat& format,
      const ::gfx::Size& size,
      const ::gfx::ColorSpace& color_space,
      ::GrSurfaceOrigin surface_origin,
      ::SkAlphaType alpha_type,
      uint32_t usage);


  ~SharedImageMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedImageMetadataPtr>
  SharedImageMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedImageMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedImageMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedImageMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedImageMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedImageMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedImageMetadata_UnserializedMessageContext<
            UserType, SharedImageMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedImageMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedImageMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedImageMetadata_UnserializedMessageContext<
            UserType, SharedImageMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedImageMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::SharedImageFormat format;
  
  ::gfx::Size size;
  
  ::gfx::ColorSpace color_space;
  
  ::GrSurfaceOrigin surface_origin;
  
  ::SkAlphaType alpha_type;
  
  uint32_t usage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedImageMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedImageMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedImageMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedImageMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedImageMetadataPtr SharedImageMetadata::Clone() const {
  return New(
      mojo::Clone(format),
      mojo::Clone(size),
      mojo::Clone(color_space),
      mojo::Clone(surface_origin),
      mojo::Clone(alpha_type),
      mojo::Clone(usage)
  );
}

template <typename T, SharedImageMetadata::EnableIfSame<T>*>
bool SharedImageMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->surface_origin, other_struct.surface_origin))
    return false;
  if (!mojo::Equals(this->alpha_type, other_struct.alpha_type))
    return false;
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  return true;
}

template <typename T, SharedImageMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.color_space < rhs.color_space)
    return true;
  if (rhs.color_space < lhs.color_space)
    return false;
  if (lhs.surface_origin < rhs.surface_origin)
    return true;
  if (rhs.surface_origin < lhs.surface_origin)
    return false;
  if (lhs.alpha_type < rhs.alpha_type)
    return true;
  if (rhs.alpha_type < lhs.alpha_type)
    return false;
  if (lhs.usage < rhs.usage)
    return true;
  if (rhs.usage < lhs.usage)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::SharedImageMetadata::DataView,
                                         ::gpu::mojom::SharedImageMetadataPtr> {
  static bool IsNull(const ::gpu::mojom::SharedImageMetadataPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::SharedImageMetadataPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::SharedImageMetadata::format)& format(
      const ::gpu::mojom::SharedImageMetadataPtr& input) {
    return input->format;
  }

  static const decltype(::gpu::mojom::SharedImageMetadata::size)& size(
      const ::gpu::mojom::SharedImageMetadataPtr& input) {
    return input->size;
  }

  static const decltype(::gpu::mojom::SharedImageMetadata::color_space)& color_space(
      const ::gpu::mojom::SharedImageMetadataPtr& input) {
    return input->color_space;
  }

  static decltype(::gpu::mojom::SharedImageMetadata::surface_origin) surface_origin(
      const ::gpu::mojom::SharedImageMetadataPtr& input) {
    return input->surface_origin;
  }

  static decltype(::gpu::mojom::SharedImageMetadata::alpha_type) alpha_type(
      const ::gpu::mojom::SharedImageMetadataPtr& input) {
    return input->alpha_type;
  }

  static decltype(::gpu::mojom::SharedImageMetadata::usage) usage(
      const ::gpu::mojom::SharedImageMetadataPtr& input) {
    return input->usage;
  }

  static bool Read(::gpu::mojom::SharedImageMetadata::DataView input, ::gpu::mojom::SharedImageMetadataPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_H_