// components/services/storage/public/mojom/service_worker_database.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/service_worker_database.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-params-data.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-import-headers.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-test-utils.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"


namespace storage::mojom {
ServiceWorkerRegistrationData::ServiceWorkerRegistrationData()
    : registration_id(::blink::mojom::kInvalidServiceWorkerRegistrationId),
      scope(),
      key(),
      script(),
      script_type(::blink::mojom::ScriptType::kClassic),
      update_via_cache(::blink::mojom::ServiceWorkerUpdateViaCache::kImports),
      version_id(::blink::mojom::kInvalidServiceWorkerVersionId),
      is_active(false),
      fetch_handler_type(::blink::mojom::ServiceWorkerFetchHandlerType::kNoHandler),
      last_update_check(),
      script_response_time(),
      origin_trial_tokens(),
      navigation_preload_state(),
      used_features(),
      resources_total_size_bytes(0),
      policy_container_policies(),
      ancestor_frame_type(),
      router_rules(),
      has_hid_event_handlers(),
      has_usb_event_handlers() {}

ServiceWorkerRegistrationData::ServiceWorkerRegistrationData(
    int64_t registration_id_in,
    const ::GURL& scope_in,
    const ::blink::StorageKey& key_in,
    const ::GURL& script_in,
    ::blink::mojom::ScriptType script_type_in,
    ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache_in,
    int64_t version_id_in,
    bool is_active_in,
    ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type_in,
    ::base::Time last_update_check_in,
    ::base::Time script_response_time_in,
    const std::optional<base::flat_map<std::string, std::vector<std::string>>>& origin_trial_tokens_in,
    ::blink::mojom::NavigationPreloadStatePtr navigation_preload_state_in,
    std::vector<::blink::mojom::WebFeature> used_features_in,
    int64_t resources_total_size_bytes_in,
    ::blink::mojom::PolicyContainerPoliciesPtr policy_container_policies_in,
    ::blink::mojom::AncestorFrameType ancestor_frame_type_in,
    const std::optional<::blink::ServiceWorkerRouterRules>& router_rules_in,
    bool has_hid_event_handlers_in,
    bool has_usb_event_handlers_in)
    : registration_id(std::move(registration_id_in)),
      scope(std::move(scope_in)),
      key(std::move(key_in)),
      script(std::move(script_in)),
      script_type(std::move(script_type_in)),
      update_via_cache(std::move(update_via_cache_in)),
      version_id(std::move(version_id_in)),
      is_active(std::move(is_active_in)),
      fetch_handler_type(std::move(fetch_handler_type_in)),
      last_update_check(std::move(last_update_check_in)),
      script_response_time(std::move(script_response_time_in)),
      origin_trial_tokens(std::move(origin_trial_tokens_in)),
      navigation_preload_state(std::move(navigation_preload_state_in)),
      used_features(std::move(used_features_in)),
      resources_total_size_bytes(std::move(resources_total_size_bytes_in)),
      policy_container_policies(std::move(policy_container_policies_in)),
      ancestor_frame_type(std::move(ancestor_frame_type_in)),
      router_rules(std::move(router_rules_in)),
      has_hid_event_handlers(std::move(has_hid_event_handlers_in)),
      has_usb_event_handlers(std::move(has_usb_event_handlers_in)) {}

ServiceWorkerRegistrationData::~ServiceWorkerRegistrationData() = default;

void ServiceWorkerRegistrationData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_id"), this->registration_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::StorageKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script"), this->script,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_type"), this->script_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ScriptType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_via_cache"), this->update_via_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerUpdateViaCache>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_id"), this->version_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_active"), this->is_active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_handler_type"), this->fetch_handler_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerFetchHandlerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_update_check"), this->last_update_check,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_response_time"), this->script_response_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_trial_tokens"), this->origin_trial_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, std::vector<std::string>>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_preload_state"), this->navigation_preload_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::NavigationPreloadStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "used_features"), this->used_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::mojom::WebFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources_total_size_bytes"), this->resources_total_size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container_policies"), this->policy_container_policies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PolicyContainerPoliciesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ancestor_frame_type"), this->ancestor_frame_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::AncestorFrameType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "router_rules"), this->router_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::ServiceWorkerRouterRules>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_hid_event_handlers"), this->has_hid_event_handlers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_usb_event_handlers"), this->has_usb_event_handlers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRegistrationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerResourceRecord::ServiceWorkerResourceRecord()
    : resource_id(::blink::mojom::kInvalidServiceWorkerResourceId),
      url(),
      size_bytes(0),
      sha256_checksum() {}

ServiceWorkerResourceRecord::ServiceWorkerResourceRecord(
    int64_t resource_id_in,
    const ::GURL& url_in,
    int64_t size_bytes_in,
    const std::optional<std::string>& sha256_checksum_in)
    : resource_id(std::move(resource_id_in)),
      url(std::move(url_in)),
      size_bytes(std::move(size_bytes_in)),
      sha256_checksum(std::move(sha256_checksum_in)) {}

ServiceWorkerResourceRecord::~ServiceWorkerResourceRecord() = default;

void ServiceWorkerResourceRecord::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_id"), this->resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_bytes"), this->size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sha256_checksum"), this->sha256_checksum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerResourceRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::ServiceWorkerRegistrationData::DataView, ::storage::mojom::ServiceWorkerRegistrationDataPtr>::Read(
    ::storage::mojom::ServiceWorkerRegistrationData::DataView input,
    ::storage::mojom::ServiceWorkerRegistrationDataPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerRegistrationDataPtr result(::storage::mojom::ServiceWorkerRegistrationData::New());
  
      if (success)
        result->registration_id = input.registration_id();
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadScript(&result->script))
        success = false;
      if (success && !input.ReadScriptType(&result->script_type))
        success = false;
      if (success && !input.ReadUpdateViaCache(&result->update_via_cache))
        success = false;
      if (success)
        result->version_id = input.version_id();
      if (success)
        result->is_active = input.is_active();
      if (success && !input.ReadFetchHandlerType(&result->fetch_handler_type))
        success = false;
      if (success && !input.ReadLastUpdateCheck(&result->last_update_check))
        success = false;
      if (success && !input.ReadScriptResponseTime(&result->script_response_time))
        success = false;
      if (success && !input.ReadOriginTrialTokens(&result->origin_trial_tokens))
        success = false;
      if (success && !input.ReadNavigationPreloadState(&result->navigation_preload_state))
        success = false;
      if (success && !input.ReadUsedFeatures(&result->used_features))
        success = false;
      if (success)
        result->resources_total_size_bytes = input.resources_total_size_bytes();
      if (success && !input.ReadPolicyContainerPolicies(&result->policy_container_policies))
        success = false;
      if (success && !input.ReadAncestorFrameType(&result->ancestor_frame_type))
        success = false;
      if (success && !input.ReadRouterRules(&result->router_rules))
        success = false;
      if (success)
        result->has_hid_event_handlers = input.has_hid_event_handlers();
      if (success)
        result->has_usb_event_handlers = input.has_usb_event_handlers();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::ServiceWorkerResourceRecord::DataView, ::storage::mojom::ServiceWorkerResourceRecordPtr>::Read(
    ::storage::mojom::ServiceWorkerResourceRecord::DataView input,
    ::storage::mojom::ServiceWorkerResourceRecordPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerResourceRecordPtr result(::storage::mojom::ServiceWorkerResourceRecord::New());
  
      if (success)
        result->resource_id = input.resource_id();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->size_bytes = input.size_bytes();
      if (success && !input.ReadSha256Checksum(&result->sha256_checksum))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {




}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif