/* DeviceListBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DeviceListBox.vala, do not modify */

/* DeviceListBox.vala
 *
 * Copyright 2020 elementary, Inc (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_DEVICE_LIST_BOX (sidebar_device_list_box_get_type ())
#define SIDEBAR_DEVICE_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBox))
#define SIDEBAR_DEVICE_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBoxClass))
#define SIDEBAR_IS_DEVICE_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_DEVICE_LIST_BOX))
#define SIDEBAR_IS_DEVICE_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_DEVICE_LIST_BOX))
#define SIDEBAR_DEVICE_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBoxClass))

typedef struct _SidebarDeviceListBox SidebarDeviceListBox;
typedef struct _SidebarDeviceListBoxClass SidebarDeviceListBoxClass;
typedef struct _SidebarDeviceListBoxPrivate SidebarDeviceListBoxPrivate;
enum  {
	SIDEBAR_DEVICE_LIST_BOX_0_PROPERTY,
	SIDEBAR_DEVICE_LIST_BOX_SIDEBAR_PROPERTY,
	SIDEBAR_DEVICE_LIST_BOX_LIST_BOX_PROPERTY,
	SIDEBAR_DEVICE_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* sidebar_device_list_box_properties[SIDEBAR_DEVICE_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;

#define SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW (sidebar_abstract_mountable_row_get_type ())
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))

typedef struct _SidebarAbstractMountableRow SidebarAbstractMountableRow;
typedef struct _SidebarAbstractMountableRowClass SidebarAbstractMountableRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SIDEBAR_TYPE_DRIVE_ROW (sidebar_drive_row_get_type ())
#define SIDEBAR_DRIVE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRow))
#define SIDEBAR_DRIVE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRowClass))
#define SIDEBAR_IS_DRIVE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_DRIVE_ROW))
#define SIDEBAR_IS_DRIVE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_DRIVE_ROW))
#define SIDEBAR_DRIVE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRowClass))

typedef struct _SidebarDriveRow SidebarDriveRow;
typedef struct _SidebarDriveRowClass SidebarDriveRowClass;

#define SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW (sidebar_volumeless_mount_row_get_type ())
#define SIDEBAR_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRow))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))

typedef struct _SidebarVolumelessMountRow SidebarVolumelessMountRow;
typedef struct _SidebarVolumelessMountRowClass SidebarVolumelessMountRowClass;

#define SIDEBAR_TYPE_VOLUME_ROW (sidebar_volume_row_get_type ())
#define SIDEBAR_VOLUME_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRow))
#define SIDEBAR_VOLUME_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRowClass))
#define SIDEBAR_IS_VOLUME_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_VOLUME_ROW))
#define SIDEBAR_IS_VOLUME_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_VOLUME_ROW))
#define SIDEBAR_VOLUME_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRowClass))

typedef struct _SidebarVolumeRow SidebarVolumeRow;
typedef struct _SidebarVolumeRowClass SidebarVolumeRowClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SidebarDeviceListBox {
	GtkBox parent_instance;
	SidebarDeviceListBoxPrivate * priv;
};

struct _SidebarDeviceListBoxClass {
	GtkBoxClass parent_class;
};

struct _SidebarDeviceListBoxPrivate {
	FilesSidebarInterface* _sidebar;
	GtkListBox* _list_box;
	GVolumeMonitor* volume_monitor;
};

static gint SidebarDeviceListBox_private_offset;
static gpointer sidebar_device_list_box_parent_class = NULL;
static SidebarSidebarListInterfaceIface * sidebar_device_list_box_sidebar_sidebar_list_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_device_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarDeviceListBox, g_object_unref)
VALA_EXTERN SidebarDeviceListBox* sidebar_device_list_box_new (FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarDeviceListBox* sidebar_device_list_box_construct (GType object_type,
                                                         FilesSidebarInterface* sidebar);
static gint sidebar_device_list_box_device_sort_func (SidebarDeviceListBox* self,
                                               GtkListBoxRow* row1,
                                               GtkListBoxRow* row2);
VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN GType sidebar_abstract_mountable_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarAbstractMountableRow, g_object_unref)
VALA_EXTERN const gchar* sidebar_abstract_mountable_row_get_sort_key (SidebarAbstractMountableRow* self);
static SidebarAbstractMountableRow* sidebar_device_list_box_add_bookmark (SidebarDeviceListBox* self,
                                                                   const gchar* label,
                                                                   const gchar* uri,
                                                                   GIcon* gicon,
                                                                   const gchar* uuid,
                                                                   GDrive* drive,
                                                                   GVolume* volume,
                                                                   GMount* mount,
                                                                   gboolean pinned,
                                                                   gboolean permanent);
static gboolean sidebar_device_list_box_has_uuid (SidebarDeviceListBox* self,
                                           const gchar* uuid,
                                           const gchar* fallback,
                                           SidebarAbstractMountableRow** row);
VALA_EXTERN SidebarDriveRow* sidebar_drive_row_new (const gchar* name,
                                        const gchar* uri,
                                        GIcon* gicon,
                                        SidebarSidebarListInterface* list,
                                        gboolean pinned,
                                        gboolean permanent,
                                        const gchar* _uuid,
                                        GDrive* _drive);
VALA_EXTERN SidebarDriveRow* sidebar_drive_row_construct (GType object_type,
                                              const gchar* name,
                                              const gchar* uri,
                                              GIcon* gicon,
                                              SidebarSidebarListInterface* list,
                                              gboolean pinned,
                                              gboolean permanent,
                                              const gchar* _uuid,
                                              GDrive* _drive);
VALA_EXTERN GType sidebar_drive_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarDriveRow, g_object_unref)
VALA_EXTERN SidebarVolumelessMountRow* sidebar_volumeless_mount_row_new (const gchar* name,
                                                             const gchar* uri,
                                                             GIcon* gicon,
                                                             SidebarSidebarListInterface* list,
                                                             gboolean pinned,
                                                             gboolean permanent,
                                                             const gchar* _uuid,
                                                             GMount* _mount);
VALA_EXTERN SidebarVolumelessMountRow* sidebar_volumeless_mount_row_construct (GType object_type,
                                                                   const gchar* name,
                                                                   const gchar* uri,
                                                                   GIcon* gicon,
                                                                   SidebarSidebarListInterface* list,
                                                                   gboolean pinned,
                                                                   gboolean permanent,
                                                                   const gchar* _uuid,
                                                                   GMount* _mount);
VALA_EXTERN GType sidebar_volumeless_mount_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarVolumelessMountRow, g_object_unref)
VALA_EXTERN SidebarVolumeRow* sidebar_volume_row_new (const gchar* name,
                                          const gchar* uri,
                                          GIcon* gicon,
                                          SidebarSidebarListInterface* list,
                                          gboolean pinned,
                                          gboolean permanent,
                                          const gchar* _uuid,
                                          GVolume* _volume);
VALA_EXTERN SidebarVolumeRow* sidebar_volume_row_construct (GType object_type,
                                                const gchar* name,
                                                const gchar* uri,
                                                GIcon* gicon,
                                                SidebarSidebarListInterface* list,
                                                gboolean pinned,
                                                gboolean permanent,
                                                const gchar* _uuid,
                                                GVolume* _volume);
VALA_EXTERN GType sidebar_volume_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarVolumeRow, g_object_unref)
VALA_EXTERN void sidebar_abstract_mountable_row_update_free_space (SidebarAbstractMountableRow* self);
static guint32 sidebar_device_list_box_real_add_plugin_item (SidebarSidebarListInterface* base,
                                                      FilesSidebarPluginItem* plugin_item);
static void sidebar_device_list_box_real_refresh (SidebarSidebarListInterface* base);
static void sidebar_device_list_box_bookmark_volume (SidebarDeviceListBox* self,
                                              GVolume* volume);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void sidebar_device_list_box_bookmark_drive (SidebarDeviceListBox* self,
                                             GDrive* drive);
static void sidebar_device_list_box_bookmark_mount_without_volume (SidebarDeviceListBox* self,
                                                            GMount* mount);
static void sidebar_device_list_box_real_refresh_info (SidebarSidebarListInterface* base);
VALA_EXTERN const gchar* sidebar_abstract_mountable_row_get_uuid (SidebarAbstractMountableRow* self);
VALA_EXTERN SidebarBookmarkRow* sidebar_device_list_box_add_sidebar_row (SidebarDeviceListBox* self,
                                                             const gchar* label,
                                                             const gchar* uri,
                                                             GIcon* gicon);
static void sidebar_device_list_box_real_unselect_all_items (SidebarSidebarListInterface* base);
static void sidebar_device_list_box_real_select_item (SidebarSidebarListInterface* base,
                                               GtkListBoxRow* item);
static GObject * sidebar_device_list_box_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _sidebar_device_list_box_bookmark_drive_g_volume_monitor_drive_connected (GVolumeMonitor* _sender,
                                                                               GDrive* drive,
                                                                               gpointer self);
static void _sidebar_device_list_box_bookmark_mount_without_volume_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                                          GMount* mount,
                                                                                          gpointer self);
static void _sidebar_device_list_box_bookmark_volume_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                             GVolume* volume,
                                                                             gpointer self);
static void _sidebar_device_list_box___lambda183_ (SidebarDeviceListBox* self,
                                            GtkListBoxRow* row);
static void __sidebar_device_list_box___lambda183__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self);
static void _sidebar_device_list_box___lambda184_ (SidebarDeviceListBox* self,
                                            GtkListBoxRow* row);
static void __sidebar_device_list_box___lambda184__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self);
static gint _sidebar_device_list_box_device_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                       GtkListBoxRow* row2,
                                                                       gpointer self);
static void sidebar_device_list_box_finalize (GObject * obj);
static GType sidebar_device_list_box_get_type_once (void);
static void _vala_sidebar_device_list_box_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_sidebar_device_list_box_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sidebar_device_list_box_get_instance_private (SidebarDeviceListBox* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarDeviceListBox_private_offset);
}

SidebarDeviceListBox*
sidebar_device_list_box_construct (GType object_type,
                                   FilesSidebarInterface* sidebar)
{
	SidebarDeviceListBox * self = NULL;
	g_return_val_if_fail (sidebar != NULL, NULL);
	self = (SidebarDeviceListBox*) g_object_new (object_type, "sidebar", sidebar, NULL);
	return self;
}

SidebarDeviceListBox*
sidebar_device_list_box_new (FilesSidebarInterface* sidebar)
{
	return sidebar_device_list_box_construct (SIDEBAR_TYPE_DEVICE_LIST_BOX, sidebar);
}

static gint
sidebar_device_list_box_device_sort_func (SidebarDeviceListBox* self,
                                          GtkListBoxRow* row1,
                                          GtkListBoxRow* row2)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* key1 = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* key2 = NULL;
	gchar* _tmp9_;
	GCompareFunc _tmp10_;
	const gchar* _tmp11_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (row1 != NULL) {
		_tmp1_ = SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (row1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = sidebar_abstract_mountable_row_get_sort_key (G_TYPE_CHECK_INSTANCE_CAST (row1, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow));
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = "";
	}
	_tmp4_ = g_strdup (_tmp0_);
	key1 = _tmp4_;
	if (row2 != NULL) {
		_tmp6_ = SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (row2);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = sidebar_abstract_mountable_row_get_sort_key (G_TYPE_CHECK_INSTANCE_CAST (row2, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow));
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = "";
	}
	_tmp9_ = g_strdup (_tmp5_);
	key2 = _tmp9_;
	_tmp10_ = ((GCompareFunc) g_strcmp0);
	_tmp11_ = key1;
	result = _tmp10_ (_tmp11_, key2);
	_g_free0 (key2);
	_g_free0 (key1);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static SidebarAbstractMountableRow*
sidebar_device_list_box_add_bookmark (SidebarDeviceListBox* self,
                                      const gchar* label,
                                      const gchar* uri,
                                      GIcon* gicon,
                                      const gchar* uuid,
                                      GDrive* drive,
                                      GVolume* volume,
                                      GMount* mount,
                                      gboolean pinned,
                                      gboolean permanent)
{
	SidebarAbstractMountableRow* bm = NULL;
	gboolean _tmp0_ = FALSE;
	SidebarAbstractMountableRow* _tmp1_ = NULL;
	gboolean _tmp2_;
	SidebarAbstractMountableRow* _tmp37_;
	SidebarAbstractMountableRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	bm = NULL;
	_tmp2_ = sidebar_device_list_box_has_uuid (self, uuid, uri, &_tmp1_);
	_g_object_unref0 (bm);
	bm = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		SidebarAbstractMountableRow* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = bm;
		_tmp4_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = g_strcmp0 (_tmp5_, label) != 0;
	}
	if (_tmp0_) {
		SidebarAbstractMountableRow* new_bm = NULL;
		gboolean _tmp6_ = FALSE;
		GtkListBox* _tmp31_;
		GtkListBox* _tmp32_;
		SidebarAbstractMountableRow* _tmp33_;
		SidebarAbstractMountableRow* _tmp34_;
		SidebarAbstractMountableRow* _tmp35_;
		SidebarAbstractMountableRow* _tmp36_;
		if (drive != NULL) {
			_tmp6_ = volume == NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gboolean _tmp7_ = FALSE;
			const gchar* _tmp13_ = NULL;
			SidebarDriveRow* _tmp14_;
			if (permanent) {
				_tmp7_ = TRUE;
			} else {
				gboolean _tmp8_ = FALSE;
				SidebarAbstractMountableRow* _tmp9_;
				_tmp9_ = bm;
				if (_tmp9_ != NULL) {
					SidebarAbstractMountableRow* _tmp10_;
					gboolean _tmp11_;
					gboolean _tmp12_;
					_tmp10_ = bm;
					_tmp11_ = sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp8_ = _tmp12_;
				} else {
					_tmp8_ = FALSE;
				}
				_tmp7_ = _tmp8_;
			}
			if (uuid != NULL) {
				_tmp13_ = uuid;
			} else {
				_tmp13_ = uri;
			}
			_tmp14_ = sidebar_drive_row_new (label, uri, gicon, (SidebarSidebarListInterface*) self, pinned, _tmp7_, _tmp13_, drive);
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (new_bm);
			new_bm = (SidebarAbstractMountableRow*) _tmp14_;
		} else {
			if (volume == NULL) {
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp21_ = NULL;
				SidebarVolumelessMountRow* _tmp22_;
				if (permanent) {
					_tmp15_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					SidebarAbstractMountableRow* _tmp17_;
					_tmp17_ = bm;
					if (_tmp17_ != NULL) {
						SidebarAbstractMountableRow* _tmp18_;
						gboolean _tmp19_;
						gboolean _tmp20_;
						_tmp18_ = bm;
						_tmp19_ = sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) _tmp18_);
						_tmp20_ = _tmp19_;
						_tmp16_ = _tmp20_;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp15_ = _tmp16_;
				}
				if (uuid != NULL) {
					_tmp21_ = uuid;
				} else {
					_tmp21_ = uri;
				}
				_tmp22_ = sidebar_volumeless_mount_row_new (label, uri, gicon, (SidebarSidebarListInterface*) self, pinned, _tmp15_, _tmp21_, mount);
				g_object_ref_sink (_tmp22_);
				_g_object_unref0 (new_bm);
				new_bm = (SidebarAbstractMountableRow*) _tmp22_;
			} else {
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp29_ = NULL;
				SidebarVolumeRow* _tmp30_;
				if (permanent) {
					_tmp23_ = TRUE;
				} else {
					gboolean _tmp24_ = FALSE;
					SidebarAbstractMountableRow* _tmp25_;
					_tmp25_ = bm;
					if (_tmp25_ != NULL) {
						SidebarAbstractMountableRow* _tmp26_;
						gboolean _tmp27_;
						gboolean _tmp28_;
						_tmp26_ = bm;
						_tmp27_ = sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) _tmp26_);
						_tmp28_ = _tmp27_;
						_tmp24_ = _tmp28_;
					} else {
						_tmp24_ = FALSE;
					}
					_tmp23_ = _tmp24_;
				}
				if (uuid != NULL) {
					_tmp29_ = uuid;
				} else {
					_tmp29_ = uri;
				}
				_tmp30_ = sidebar_volume_row_new (label, uri, gicon, (SidebarSidebarListInterface*) self, pinned, _tmp23_, _tmp29_, volume);
				g_object_ref_sink (_tmp30_);
				_g_object_unref0 (new_bm);
				new_bm = (SidebarAbstractMountableRow*) _tmp30_;
			}
		}
		_tmp31_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp32_ = _tmp31_;
		_tmp33_ = new_bm;
		gtk_list_box_insert (_tmp32_, (GtkWidget*) _tmp33_, -1);
		gtk_widget_show_all ((GtkWidget*) self);
		_tmp34_ = new_bm;
		_tmp35_ = _g_object_ref0 (_tmp34_);
		_g_object_unref0 (bm);
		bm = _tmp35_;
		_tmp36_ = bm;
		sidebar_abstract_mountable_row_update_free_space (_tmp36_);
		_g_object_unref0 (new_bm);
	}
	_tmp37_ = bm;
	_vala_assert (_tmp37_ != NULL, "bm != null");
	result = bm;
	return result;
}

static guint32
sidebar_device_list_box_real_add_plugin_item (SidebarSidebarListInterface* base,
                                              FilesSidebarPluginItem* plugin_item)
{
	SidebarDeviceListBox * self;
	SidebarAbstractMountableRow* row = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GDrive* _tmp6_;
	GDrive* _tmp7_;
	GVolume* _tmp8_;
	GVolume* _tmp9_;
	GMount* _tmp10_;
	GMount* _tmp11_;
	SidebarAbstractMountableRow* _tmp12_;
	guint32 _tmp13_;
	guint32 _tmp14_;
	guint32 result;
	self = (SidebarDeviceListBox*) base;
	g_return_val_if_fail (plugin_item != NULL, 0U);
	_tmp0_ = files_sidebar_plugin_item_get_name (plugin_item);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_sidebar_plugin_item_get_uri (plugin_item);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_sidebar_plugin_item_get_icon (plugin_item);
	_tmp5_ = _tmp4_;
	_tmp6_ = files_sidebar_plugin_item_get_drive (plugin_item);
	_tmp7_ = _tmp6_;
	_tmp8_ = files_sidebar_plugin_item_get_volume (plugin_item);
	_tmp9_ = _tmp8_;
	_tmp10_ = files_sidebar_plugin_item_get_mount (plugin_item);
	_tmp11_ = _tmp10_;
	_tmp12_ = sidebar_device_list_box_add_bookmark (self, _tmp1_, _tmp3_, _tmp5_, NULL, _tmp7_, _tmp9_, _tmp11_, TRUE, TRUE);
	row = _tmp12_;
	sidebar_sidebar_item_interface_update_plugin_data ((SidebarSidebarItemInterface*) row, plugin_item);
	_tmp13_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) row);
	_tmp14_ = _tmp13_;
	result = _tmp14_;
	_g_object_unref0 (row);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
sidebar_device_list_box_real_refresh (SidebarSidebarListInterface* base)
{
	SidebarDeviceListBox * self;
	gchar* root_uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GVolumeMonitor* _tmp13_;
	GList* _tmp14_;
	GVolumeMonitor* _tmp17_;
	GList* _tmp18_;
	GVolumeMonitor* _tmp21_;
	GList* _tmp22_;
	self = (SidebarDeviceListBox*) base;
	sidebar_sidebar_list_interface_clear ((SidebarSidebarListInterface*) self);
	_tmp0_ = g_strdup (_ (FILES_ROOT_FS_URI));
	root_uri = _tmp0_;
	_tmp1_ = root_uri;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		SidebarAbstractMountableRow* row = NULL;
		const gchar* _tmp2_;
		GThemedIcon* _tmp3_;
		GThemedIcon* _tmp4_;
		SidebarAbstractMountableRow* _tmp5_;
		SidebarAbstractMountableRow* _tmp6_;
		SidebarAbstractMountableRow* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp2_ = root_uri;
		_tmp3_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks (FILES_ICON_FILESYSTEM);
		_tmp4_ = _tmp3_;
		_tmp5_ = sidebar_device_list_box_add_bookmark (self, _ ("File System"), _tmp2_, (GIcon*) _tmp4_, NULL, NULL, NULL, NULL, TRUE, TRUE);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		row = _tmp6_;
		_tmp7_ = row;
		_tmp8_ = g_strdup ("<Alt>slash");
		_tmp9_ = g_new0 (gchar*, 1 + 1);
		_tmp9_[0] = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 1;
		_tmp11_ = granite_markup_accel_tooltip (_tmp10_, (gint) 1, _ ("View the root of the local filesystem"));
		_tmp12_ = _tmp11_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp7_, _tmp12_);
		_g_free0 (_tmp12_);
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (row);
	}
	_tmp13_ = self->priv->volume_monitor;
	_tmp14_ = g_volume_monitor_get_volumes (_tmp13_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp14_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp15_;
			GVolume* volume = NULL;
			_tmp15_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp15_;
			{
				GVolume* _tmp16_;
				_tmp16_ = volume;
				sidebar_device_list_box_bookmark_volume (self, _tmp16_);
				_g_object_unref0 (volume);
			}
		}
		(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
	}
	_tmp17_ = self->priv->volume_monitor;
	_tmp18_ = g_volume_monitor_get_connected_drives (_tmp17_);
	{
		GList* drive_collection = NULL;
		GList* drive_it = NULL;
		drive_collection = _tmp18_;
		for (drive_it = drive_collection; drive_it != NULL; drive_it = drive_it->next) {
			GDrive* _tmp19_;
			GDrive* drive = NULL;
			_tmp19_ = _g_object_ref0 ((GDrive*) drive_it->data);
			drive = _tmp19_;
			{
				GDrive* _tmp20_;
				_tmp20_ = drive;
				sidebar_device_list_box_bookmark_drive (self, _tmp20_);
				_g_object_unref0 (drive);
			}
		}
		(drive_collection == NULL) ? NULL : (drive_collection = (_g_list_free__g_object_unref0_ (drive_collection), NULL));
	}
	_tmp21_ = self->priv->volume_monitor;
	_tmp22_ = g_volume_monitor_get_mounts (_tmp21_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp22_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* _tmp23_;
			GMount* mount = NULL;
			_tmp23_ = _g_object_ref0 ((GMount*) mount_it->data);
			mount = _tmp23_;
			{
				GMount* _tmp24_;
				_tmp24_ = mount;
				sidebar_device_list_box_bookmark_mount_without_volume (self, _tmp24_);
				_g_object_unref0 (mount);
			}
		}
		(mount_collection == NULL) ? NULL : (mount_collection = (_g_list_free__g_object_unref0_ (mount_collection), NULL));
	}
	_g_free0 (root_uri);
}

static void
sidebar_device_list_box_real_refresh_info (SidebarSidebarListInterface* base)
{
	SidebarDeviceListBox * self;
	gint index = 0;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	self = (SidebarDeviceListBox*) base;
	index = 0;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, index);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	row = _tmp3_;
	while (TRUE) {
		GtkListBoxRow* _tmp4_;
		GtkListBoxRow* _tmp5_;
		GtkListBox* _tmp7_;
		GtkListBox* _tmp8_;
		gint _tmp9_;
		GtkListBoxRow* _tmp10_;
		GtkListBoxRow* _tmp11_;
		_tmp4_ = row;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = row;
		if (SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (_tmp5_)) {
			GtkListBoxRow* _tmp6_;
			_tmp6_ = row;
			sidebar_abstract_mountable_row_update_free_space (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow));
		}
		_tmp7_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp8_ = _tmp7_;
		index = index + 1;
		_tmp9_ = index;
		_tmp10_ = gtk_list_box_get_row_at_index (_tmp8_, _tmp9_);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (row);
		row = _tmp11_;
	}
	_g_object_unref0 (row);
}

static void
sidebar_device_list_box_bookmark_drive (SidebarDeviceListBox* self,
                                        GDrive* drive)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SidebarAbstractMountableRow* _tmp6_;
	SidebarAbstractMountableRow* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drive != NULL);
	_tmp0_ = g_drive_get_name (drive);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_drive_get_icon (drive);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_drive_get_name (drive);
	_tmp5_ = _tmp4_;
	_tmp6_ = sidebar_device_list_box_add_bookmark (self, _tmp1_, "", _tmp3_, _tmp5_, drive, NULL, NULL, TRUE, FALSE);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static void
sidebar_device_list_box_bookmark_volume (SidebarDeviceListBox* self,
                                         GVolume* volume)
{
	GMount* mount = NULL;
	GMount* _tmp0_;
	gchar* _tmp1_ = NULL;
	GMount* _tmp2_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GIcon* _tmp10_;
	GIcon* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	SidebarAbstractMountableRow* _tmp14_;
	SidebarAbstractMountableRow* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = g_volume_get_mount (volume);
	mount = _tmp0_;
	_tmp2_ = mount;
	if (_tmp2_ != NULL) {
		GMount* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = mount;
		_tmp4_ = g_mount_get_default_location (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_uri (_tmp5_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp7_;
	}
	_tmp8_ = g_volume_get_name (volume);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_volume_get_icon (volume);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_volume_get_uuid (volume);
	_tmp13_ = _tmp12_;
	_tmp14_ = sidebar_device_list_box_add_bookmark (self, _tmp9_, _tmp1_, _tmp11_, _tmp13_, NULL, volume, NULL, TRUE, FALSE);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_object_unref0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp1_);
	_g_object_unref0 (mount);
}

static void
sidebar_device_list_box_bookmark_mount_without_volume (SidebarDeviceListBox* self,
                                                       GMount* mount)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* uuid = NULL;
	gchar* _tmp6_;
	gchar* path = NULL;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GIcon* _tmp19_;
	GIcon* _tmp20_;
	const gchar* _tmp21_;
	SidebarAbstractMountableRow* _tmp22_;
	SidebarAbstractMountableRow* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	if (g_mount_is_shadowed (mount)) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp2_ = g_mount_get_root (mount);
		_tmp3_ = _tmp2_;
		_tmp1_ = !g_file_is_native (_tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GVolume* _tmp4_;
		GVolume* _tmp5_;
		_tmp4_ = g_mount_get_volume (mount);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ != NULL;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = g_mount_get_uuid (mount);
	uuid = _tmp6_;
	_tmp7_ = g_mount_get_default_location (mount);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_file_get_uri (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	path = _tmp10_;
	_tmp12_ = uuid;
	if (_tmp12_ == NULL) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = uuid;
		_tmp11_ = g_strcmp0 (_tmp13_, "") == 0;
	}
	if (_tmp11_) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = path;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (uuid);
		uuid = _tmp15_;
	}
	_tmp16_ = g_mount_get_name (mount);
	_tmp17_ = _tmp16_;
	_tmp18_ = path;
	_tmp19_ = g_mount_get_icon (mount);
	_tmp20_ = _tmp19_;
	_tmp21_ = uuid;
	_tmp22_ = sidebar_device_list_box_add_bookmark (self, _tmp17_, _tmp18_, _tmp20_, _tmp21_, NULL, NULL, mount, TRUE, FALSE);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp23_);
	_g_object_unref0 (_tmp20_);
	_g_free0 (_tmp17_);
	_g_free0 (path);
	_g_free0 (uuid);
}

static gboolean
sidebar_device_list_box_has_uuid (SidebarDeviceListBox* self,
                                  const gchar* uuid,
                                  const gchar* fallback,
                                  SidebarAbstractMountableRow** row)
{
	SidebarAbstractMountableRow* _vala_row = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* searched_uuid = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (uuid != NULL) {
		_tmp0_ = uuid;
	} else {
		_tmp0_ = fallback;
	}
	_tmp1_ = g_strdup (_tmp0_);
	searched_uuid = _tmp1_;
	_tmp2_ = searched_uuid;
	if (_tmp2_ != NULL) {
		gint index = 0;
		GtkListBoxRow* child = NULL;
		GtkListBox* _tmp3_;
		GtkListBox* _tmp4_;
		GtkListBoxRow* _tmp5_;
		GtkListBoxRow* _tmp6_;
		index = 0;
		_tmp3_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_list_box_get_row_at_index (_tmp4_, index);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		child = _tmp6_;
		while (TRUE) {
			GtkListBoxRow* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GtkListBoxRow* _tmp9_;
			GtkListBox* _tmp16_;
			GtkListBox* _tmp17_;
			gint _tmp18_;
			GtkListBoxRow* _tmp19_;
			GtkListBoxRow* _tmp20_;
			_tmp7_ = child;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp9_ = child;
			if (SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (_tmp9_)) {
				GtkListBoxRow* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = child;
				_tmp11_ = sidebar_abstract_mountable_row_get_uuid (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow));
				_tmp12_ = _tmp11_;
				_tmp13_ = searched_uuid;
				_tmp8_ = g_strcmp0 (_tmp12_, _tmp13_) == 0;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GtkListBoxRow* _tmp14_;
				SidebarAbstractMountableRow* _tmp15_;
				_tmp14_ = child;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow));
				_g_object_unref0 (_vala_row);
				_vala_row = _tmp15_;
				result = TRUE;
				_g_object_unref0 (child);
				_g_free0 (searched_uuid);
				if (row) {
					*row = _vala_row;
				} else {
					_g_object_unref0 (_vala_row);
				}
				return result;
			}
			_tmp16_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
			_tmp17_ = _tmp16_;
			index = index + 1;
			_tmp18_ = index;
			_tmp19_ = gtk_list_box_get_row_at_index (_tmp17_, _tmp18_);
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (child);
			child = _tmp20_;
		}
		_g_object_unref0 (child);
	}
	_g_object_unref0 (_vala_row);
	_vala_row = NULL;
	result = FALSE;
	_g_free0 (searched_uuid);
	if (row) {
		*row = _vala_row;
	} else {
		_g_object_unref0 (_vala_row);
	}
	return result;
}

SidebarBookmarkRow*
sidebar_device_list_box_add_sidebar_row (SidebarDeviceListBox* self,
                                         const gchar* label,
                                         const gchar* uri,
                                         GIcon* gicon)
{
	SidebarBookmarkRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	result = NULL;
	return result;
}

static void
sidebar_device_list_box_real_unselect_all_items (SidebarSidebarListInterface* base)
{
	SidebarDeviceListBox * self;
	gint index = 0;
	GtkListBoxRow* child = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	self = (SidebarDeviceListBox*) base;
	index = 0;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, index);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	child = _tmp3_;
	while (TRUE) {
		GtkListBoxRow* _tmp4_;
		GtkListBoxRow* _tmp5_;
		GtkListBox* _tmp9_;
		GtkListBox* _tmp10_;
		gint _tmp11_;
		GtkListBoxRow* _tmp12_;
		GtkListBoxRow* _tmp13_;
		_tmp4_ = child;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = child;
		if (SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (_tmp5_)) {
			GtkListBox* _tmp6_;
			GtkListBox* _tmp7_;
			GtkListBoxRow* _tmp8_;
			_tmp6_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = child;
			gtk_list_box_unselect_row (_tmp7_, _tmp8_);
		}
		_tmp9_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp10_ = _tmp9_;
		index = index + 1;
		_tmp11_ = index;
		_tmp12_ = gtk_list_box_get_row_at_index (_tmp10_, _tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (child);
		child = _tmp13_;
	}
	_g_object_unref0 (child);
}

static void
sidebar_device_list_box_real_select_item (SidebarSidebarListInterface* base,
                                          GtkListBoxRow* item)
{
	SidebarDeviceListBox * self;
	gboolean _tmp0_ = FALSE;
	self = (SidebarDeviceListBox*) base;
	if (item != NULL) {
		_tmp0_ = SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (item);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp1_;
		GtkListBox* _tmp2_;
		_tmp1_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp2_ = _tmp1_;
		gtk_list_box_select_row (_tmp2_, item);
	} else {
		sidebar_sidebar_list_interface_unselect_all_items ((SidebarSidebarListInterface*) self);
	}
}

static FilesSidebarInterface*
sidebar_device_list_box_real_get_sidebar (SidebarSidebarListInterface* base)
{
	FilesSidebarInterface* result;
	SidebarDeviceListBox* self;
	FilesSidebarInterface* _tmp0_;
	self = (SidebarDeviceListBox*) base;
	_tmp0_ = self->priv->_sidebar;
	result = _tmp0_;
	return result;
}

static void
sidebar_device_list_box_real_set_sidebar (SidebarSidebarListInterface* base,
                                          FilesSidebarInterface* value)
{
	SidebarDeviceListBox* self;
	FilesSidebarInterface* old_value;
	self = (SidebarDeviceListBox*) base;
	old_value = sidebar_device_list_box_real_get_sidebar (base);
	if (old_value != value) {
		FilesSidebarInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sidebar);
		self->priv->_sidebar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_device_list_box_properties[SIDEBAR_DEVICE_LIST_BOX_SIDEBAR_PROPERTY]);
	}
}

static GtkListBox*
sidebar_device_list_box_real_get_list_box (SidebarSidebarListInterface* base)
{
	GtkListBox* result;
	SidebarDeviceListBox* self;
	GtkListBox* _tmp0_;
	self = (SidebarDeviceListBox*) base;
	_tmp0_ = self->priv->_list_box;
	result = _tmp0_;
	return result;
}

static void
sidebar_device_list_box_real_set_list_box (SidebarSidebarListInterface* base,
                                           GtkListBox* value)
{
	SidebarDeviceListBox* self;
	GtkListBox* old_value;
	self = (SidebarDeviceListBox*) base;
	old_value = sidebar_device_list_box_real_get_list_box (base);
	if (old_value != value) {
		GtkListBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list_box);
		self->priv->_list_box = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_device_list_box_properties[SIDEBAR_DEVICE_LIST_BOX_LIST_BOX_PROPERTY]);
	}
}

static void
_sidebar_device_list_box_bookmark_drive_g_volume_monitor_drive_connected (GVolumeMonitor* _sender,
                                                                          GDrive* drive,
                                                                          gpointer self)
{
	sidebar_device_list_box_bookmark_drive ((SidebarDeviceListBox*) self, drive);
}

static void
_sidebar_device_list_box_bookmark_mount_without_volume_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                                     GMount* mount,
                                                                                     gpointer self)
{
	sidebar_device_list_box_bookmark_mount_without_volume ((SidebarDeviceListBox*) self, mount);
}

static void
_sidebar_device_list_box_bookmark_volume_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                        GVolume* volume,
                                                                        gpointer self)
{
	sidebar_device_list_box_bookmark_volume ((SidebarDeviceListBox*) self, volume);
}

static void
_sidebar_device_list_box___lambda183_ (SidebarDeviceListBox* self,
                                       GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	if (SIDEBAR_IS_BOOKMARK_ROW (row)) {
		sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) G_TYPE_CHECK_INSTANCE_CAST (row, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow), FILES_OPEN_FLAG_DEFAULT);
	}
}

static void
__sidebar_device_list_box___lambda183__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self)
{
	_sidebar_device_list_box___lambda183_ ((SidebarDeviceListBox*) self, row);
}

static void
_sidebar_device_list_box___lambda184_ (SidebarDeviceListBox* self,
                                       GtkListBoxRow* row)
{
	if (SIDEBAR_IS_BOOKMARK_ROW (row)) {
		sidebar_sidebar_list_interface_select_item ((SidebarSidebarListInterface*) self, row);
	}
}

static void
__sidebar_device_list_box___lambda184__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self)
{
	_sidebar_device_list_box___lambda184_ ((SidebarDeviceListBox*) self, row);
}

static gint
_sidebar_device_list_box_device_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                  GtkListBoxRow* row2,
                                                                  gpointer self)
{
	gint result;
	result = sidebar_device_list_box_device_sort_func ((SidebarDeviceListBox*) self, row1, row2);
	return result;
}

static GObject *
sidebar_device_list_box_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarDeviceListBox * self;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GVolumeMonitor* _tmp4_;
	GVolumeMonitor* _tmp5_;
	GVolumeMonitor* _tmp6_;
	GVolumeMonitor* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	parent_class = G_OBJECT_CLASS (sidebar_device_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBox);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	sidebar_sidebar_list_interface_set_list_box ((SidebarSidebarListInterface*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp3_ = _tmp2_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp4_;
	_tmp5_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp5_, "drive-connected", (GCallback) _sidebar_device_list_box_bookmark_drive_g_volume_monitor_drive_connected, self, 0);
	_tmp6_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp6_, "mount-added", (GCallback) _sidebar_device_list_box_bookmark_mount_without_volume_g_volume_monitor_mount_added, self, 0);
	_tmp7_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp7_, "volume-added", (GCallback) _sidebar_device_list_box_bookmark_volume_g_volume_monitor_volume_added, self, 0);
	_tmp8_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "row-activated", (GCallback) __sidebar_device_list_box___lambda183__gtk_list_box_row_activated, self, 0);
	_tmp10_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "row-selected", (GCallback) __sidebar_device_list_box___lambda184__gtk_list_box_row_selected, self, 0);
	_tmp12_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp13_ = _tmp12_;
	gtk_list_box_set_sort_func (_tmp13_, _sidebar_device_list_box_device_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
sidebar_device_list_box_class_init (SidebarDeviceListBoxClass * klass,
                                    gpointer klass_data)
{
	sidebar_device_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarDeviceListBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_device_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sidebar_device_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_device_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_device_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_DEVICE_LIST_BOX_SIDEBAR_PROPERTY, sidebar_device_list_box_properties[SIDEBAR_DEVICE_LIST_BOX_SIDEBAR_PROPERTY] = g_param_spec_object ("sidebar", "sidebar", "sidebar", FILES_TYPE_SIDEBAR_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_DEVICE_LIST_BOX_LIST_BOX_PROPERTY, sidebar_device_list_box_properties[SIDEBAR_DEVICE_LIST_BOX_LIST_BOX_PROPERTY] = g_param_spec_object ("list-box", "list-box", "list-box", gtk_list_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
sidebar_device_list_box_sidebar_sidebar_list_interface_interface_init (SidebarSidebarListInterfaceIface * iface,
                                                                       gpointer iface_data)
{
	sidebar_device_list_box_sidebar_sidebar_list_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_plugin_item = (guint32 (*) (SidebarSidebarListInterface*, FilesSidebarPluginItem*)) sidebar_device_list_box_real_add_plugin_item;
	iface->refresh = (void (*) (SidebarSidebarListInterface*)) sidebar_device_list_box_real_refresh;
	iface->refresh_info = (void (*) (SidebarSidebarListInterface*)) sidebar_device_list_box_real_refresh_info;
	iface->unselect_all_items = (void (*) (SidebarSidebarListInterface*)) sidebar_device_list_box_real_unselect_all_items;
	iface->select_item = (void (*) (SidebarSidebarListInterface*, GtkListBoxRow*)) sidebar_device_list_box_real_select_item;
	iface->get_sidebar = sidebar_device_list_box_real_get_sidebar;
	iface->set_sidebar = sidebar_device_list_box_real_set_sidebar;
	iface->get_list_box = sidebar_device_list_box_real_get_list_box;
	iface->set_list_box = sidebar_device_list_box_real_set_list_box;
}

static void
sidebar_device_list_box_instance_init (SidebarDeviceListBox * self,
                                       gpointer klass)
{
	self->priv = sidebar_device_list_box_get_instance_private (self);
}

static void
sidebar_device_list_box_finalize (GObject * obj)
{
	SidebarDeviceListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBox);
	_g_object_unref0 (self->priv->_sidebar);
	_g_object_unref0 (self->priv->_list_box);
	_g_object_unref0 (self->priv->volume_monitor);
	G_OBJECT_CLASS (sidebar_device_list_box_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_device_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarDeviceListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_device_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarDeviceListBox), 0, (GInstanceInitFunc) sidebar_device_list_box_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_list_interface_info = { (GInterfaceInitFunc) sidebar_device_list_box_sidebar_sidebar_list_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_device_list_box_type_id;
	sidebar_device_list_box_type_id = g_type_register_static (gtk_box_get_type (), "SidebarDeviceListBox", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_device_list_box_type_id, SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE, &sidebar_sidebar_list_interface_info);
	SidebarDeviceListBox_private_offset = g_type_add_instance_private (sidebar_device_list_box_type_id, sizeof (SidebarDeviceListBoxPrivate));
	return sidebar_device_list_box_type_id;
}

GType
sidebar_device_list_box_get_type (void)
{
	static volatile gsize sidebar_device_list_box_type_id__once = 0;
	if (g_once_init_enter (&sidebar_device_list_box_type_id__once)) {
		GType sidebar_device_list_box_type_id;
		sidebar_device_list_box_type_id = sidebar_device_list_box_get_type_once ();
		g_once_init_leave (&sidebar_device_list_box_type_id__once, sidebar_device_list_box_type_id);
	}
	return sidebar_device_list_box_type_id__once;
}

static void
_vala_sidebar_device_list_box_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	SidebarDeviceListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBox);
	switch (property_id) {
		case SIDEBAR_DEVICE_LIST_BOX_SIDEBAR_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_list_interface_get_sidebar ((SidebarSidebarListInterface*) self));
		break;
		case SIDEBAR_DEVICE_LIST_BOX_LIST_BOX_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sidebar_device_list_box_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	SidebarDeviceListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBox);
	switch (property_id) {
		case SIDEBAR_DEVICE_LIST_BOX_SIDEBAR_PROPERTY:
		sidebar_sidebar_list_interface_set_sidebar ((SidebarSidebarListInterface*) self, g_value_get_object (value));
		break;
		case SIDEBAR_DEVICE_LIST_BOX_LIST_BOX_PROPERTY:
		sidebar_sidebar_list_interface_set_list_box ((SidebarSidebarListInterface*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

