/* ShellClientsManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ShellClientsManager.vala, do not modify */

/*
 * Copyright 2024-2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/meta-plugin.h>
#include <glib.h>
#include <meta/window.h>
#include <gio/gio.h>
#include <meta/display.h>
#include <stdlib.h>
#include <string.h>
#include <meta/util.h>
#include <meta/meta-wayland-client.h>
#include <meta/meta-x11-display.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <errno.h>
#include <meta/common.h>
#include <clutter/clutter.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER (greeter_compositor_shell_clients_manager_get_type ())
#define GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManager))
#define GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManagerClass))
#define GREETER_COMPOSITOR_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER))
#define GREETER_COMPOSITOR_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER))
#define GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManagerClass))

typedef struct _GreeterCompositorShellClientsManager GreeterCompositorShellClientsManager;
typedef struct _GreeterCompositorShellClientsManagerClass GreeterCompositorShellClientsManagerClass;
typedef struct _GreeterCompositorShellClientsManagerPrivate GreeterCompositorShellClientsManagerPrivate;

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;

#define GREETER_COMPOSITOR_TYPE_NOTIFICATIONS_CLIENT (greeter_compositor_notifications_client_get_type ())
#define GREETER_COMPOSITOR_NOTIFICATIONS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_NOTIFICATIONS_CLIENT, GreeterCompositorNotificationsClient))
#define GREETER_COMPOSITOR_NOTIFICATIONS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_NOTIFICATIONS_CLIENT, GreeterCompositorNotificationsClientClass))
#define GREETER_COMPOSITOR_IS_NOTIFICATIONS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_NOTIFICATIONS_CLIENT))
#define GREETER_COMPOSITOR_IS_NOTIFICATIONS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_NOTIFICATIONS_CLIENT))
#define GREETER_COMPOSITOR_NOTIFICATIONS_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_NOTIFICATIONS_CLIENT, GreeterCompositorNotificationsClientClass))

typedef struct _GreeterCompositorNotificationsClient GreeterCompositorNotificationsClient;
typedef struct _GreeterCompositorNotificationsClientClass GreeterCompositorNotificationsClientClass;

#define GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT (greeter_compositor_managed_client_get_type ())
#define GREETER_COMPOSITOR_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClient))
#define GREETER_COMPOSITOR_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClientClass))
#define GREETER_COMPOSITOR_IS_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT))
#define GREETER_COMPOSITOR_IS_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT))
#define GREETER_COMPOSITOR_MANAGED_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_MANAGED_CLIENT, GreeterCompositorManagedClientClass))

typedef struct _GreeterCompositorManagedClient GreeterCompositorManagedClient;
typedef struct _GreeterCompositorManagedClientClass GreeterCompositorManagedClientClass;

#define GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW (greeter_compositor_positioned_window_get_type ())
#define GREETER_COMPOSITOR_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindow))
#define GREETER_COMPOSITOR_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindowClass))
#define GREETER_COMPOSITOR_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW))
#define GREETER_COMPOSITOR_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW))
#define GREETER_COMPOSITOR_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_POSITIONED_WINDOW, GreeterCompositorPositionedWindowClass))

typedef struct _GreeterCompositorPositionedWindow GreeterCompositorPositionedWindow;
typedef struct _GreeterCompositorPositionedWindowClass GreeterCompositorPositionedWindowClass;

#define GREETER_COMPOSITOR_TYPE_SHELL_WINDOW (greeter_compositor_shell_window_get_type ())
#define GREETER_COMPOSITOR_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_SHELL_WINDOW, GreeterCompositorShellWindow))
#define GREETER_COMPOSITOR_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_SHELL_WINDOW, GreeterCompositorShellWindowClass))
#define GREETER_COMPOSITOR_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_SHELL_WINDOW))
#define GREETER_COMPOSITOR_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_SHELL_WINDOW))
#define GREETER_COMPOSITOR_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_SHELL_WINDOW, GreeterCompositorShellWindowClass))

typedef struct _GreeterCompositorShellWindow GreeterCompositorShellWindow;
typedef struct _GreeterCompositorShellWindowClass GreeterCompositorShellWindowClass;

#define GREETER_COMPOSITOR_TYPE_PANEL_WINDOW (greeter_compositor_panel_window_get_type ())
#define GREETER_COMPOSITOR_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindow))
#define GREETER_COMPOSITOR_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindowClass))
#define GREETER_COMPOSITOR_IS_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW))
#define GREETER_COMPOSITOR_IS_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW))
#define GREETER_COMPOSITOR_PANEL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindowClass))

typedef struct _GreeterCompositorPanelWindow GreeterCompositorPanelWindow;
typedef struct _GreeterCompositorPanelWindowClass GreeterCompositorPanelWindowClass;
enum  {
	GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_ACTOR_PROPERTY,
	GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_WM_PROPERTY,
	GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_shell_clients_manager_properties[GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _GreeterCompositorShellClientsManagerStartClientsData GreeterCompositorShellClientsManagerStartClientsData;
typedef enum  {
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_TOP,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_BOTTOM,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_CENTER,
	GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_FULLSCREEN
} GreeterCompositorPositionedWindowPosition;

#define GREETER_COMPOSITOR_POSITIONED_WINDOW_TYPE_POSITION (greeter_compositor_positioned_window_position_get_type ())
typedef struct _Block16Data Block16Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GreeterCompositorShellClientsManager {
	GObject parent_instance;
	GreeterCompositorShellClientsManagerPrivate * priv;
};

struct _GreeterCompositorShellClientsManagerClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorShellClientsManagerPrivate {
	GreeterCompositorWindowManager* _wm;
	GreeterCompositorNotificationsClient* notifications_client;
	GreeterCompositorManagedClient** protocol_clients;
	gint protocol_clients_length1;
	gint _protocol_clients_size_;
	GHashTable* panel_windows;
	GHashTable* positioned_windows;
};

struct _GreeterCompositorShellClientsManagerStartClientsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorShellClientsManager* self;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GreeterCompositorManagedClient* _tmp6_;
};

struct _Block16Data {
	int _ref_count_;
	GreeterCompositorShellClientsManager* self;
	gboolean positioned;
};

static gint GreeterCompositorShellClientsManager_private_offset;
static gpointer greeter_compositor_shell_clients_manager_parent_class = NULL;
static GreeterCompositorShellClientsManager* greeter_compositor_shell_clients_manager_instance;
static GreeterCompositorShellClientsManager* greeter_compositor_shell_clients_manager_instance = NULL;

VALA_EXTERN GType greeter_compositor_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorShellClientsManager, g_object_unref)
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN GType greeter_compositor_notifications_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorNotificationsClient, g_object_unref)
VALA_EXTERN GType greeter_compositor_managed_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorManagedClient, g_object_unref)
VALA_EXTERN GType greeter_compositor_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorPositionedWindow, g_object_unref)
VALA_EXTERN GType greeter_compositor_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorShellWindow, g_object_unref)
VALA_EXTERN GType greeter_compositor_panel_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorPanelWindow, g_object_unref)
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void greeter_compositor_shell_clients_manager_init (GreeterCompositorWindowManager* wm);
static GreeterCompositorShellClientsManager* greeter_compositor_shell_clients_manager_new (GreeterCompositorWindowManager* wm);
static GreeterCompositorShellClientsManager* greeter_compositor_shell_clients_manager_construct (GType object_type,
                                                                                          GreeterCompositorWindowManager* wm);
VALA_EXTERN GreeterCompositorShellClientsManager* greeter_compositor_shell_clients_manager_get_instance (void);
static void greeter_compositor_shell_clients_manager_start_clients_data_free (gpointer _data);
static void greeter_compositor_shell_clients_manager_start_clients (GreeterCompositorShellClientsManager* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void greeter_compositor_shell_clients_manager_start_clients_finish (GreeterCompositorShellClientsManager* self,
                                                                    GAsyncResult* _res_);
static gboolean greeter_compositor_shell_clients_manager_start_clients_co (GreeterCompositorShellClientsManagerStartClientsData* _data_);
VALA_EXTERN GreeterCompositorWindowManager* greeter_compositor_shell_clients_manager_get_wm (GreeterCompositorShellClientsManager* self);
VALA_EXTERN GreeterCompositorManagedClient* greeter_compositor_managed_client_new (MetaDisplay* display,
                                                                       gchar** args,
                                                                       gint args_length1);
VALA_EXTERN GreeterCompositorManagedClient* greeter_compositor_managed_client_construct (GType object_type,
                                                                             MetaDisplay* display,
                                                                             gchar** args,
                                                                             gint args_length1);
static void _vala_array_add3 (GreeterCompositorManagedClient** * array,
                       gint* length,
                       gint* size,
                       GreeterCompositorManagedClient* value);
VALA_EXTERN void greeter_compositor_shell_clients_manager_make_dock (GreeterCompositorShellClientsManager* self,
                                                         MetaWindow* window);
static void greeter_compositor_shell_clients_manager_make_dock_wayland (GreeterCompositorShellClientsManager* self,
                                                                 MetaWindow* window);
static void greeter_compositor_shell_clients_manager_make_dock_x11 (GreeterCompositorShellClientsManager* self,
                                                             MetaWindow* window);
VALA_EXTERN MetaWaylandClient* greeter_compositor_managed_client_get_wayland_client (GreeterCompositorManagedClient* self);
VALA_EXTERN void greeter_compositor_shell_clients_manager_make_desktop (GreeterCompositorShellClientsManager* self,
                                                            MetaWindow* window);
static void greeter_compositor_shell_clients_manager_make_desktop_wayland (GreeterCompositorShellClientsManager* self,
                                                                    MetaWindow* window);
static void greeter_compositor_shell_clients_manager_make_desktop_x11 (GreeterCompositorShellClientsManager* self,
                                                                MetaWindow* window);
VALA_EXTERN void greeter_compositor_shell_clients_manager_set_anchor (GreeterCompositorShellClientsManager* self,
                                                          MetaWindow* window,
                                                          enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN void greeter_compositor_panel_window_set_anchor (GreeterCompositorPanelWindow* self,
                                                 enum io_elementary_pantheon_panel_v1_anchor value);
VALA_EXTERN GreeterCompositorPanelWindow* greeter_compositor_panel_window_new (GreeterCompositorWindowManager* wm,
                                                                   MetaWindow* window,
                                                                   enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN GreeterCompositorPanelWindow* greeter_compositor_panel_window_construct (GType object_type,
                                                                         GreeterCompositorWindowManager* wm,
                                                                         MetaWindow* window,
                                                                         enum io_elementary_pantheon_panel_v1_anchor anchor);
static void __lambda88_ (GreeterCompositorShellClientsManager* self,
                  MetaWindow* _window);
static void ___lambda88__meta_window_unmanaging (MetaWindow* _sender,
                                          gpointer self);
VALA_EXTERN void greeter_compositor_shell_clients_manager_set_size (GreeterCompositorShellClientsManager* self,
                                                        MetaWindow* window,
                                                        gint width,
                                                        gint height);
VALA_EXTERN void greeter_compositor_panel_window_set_size (GreeterCompositorPanelWindow* self,
                                               gint width,
                                               gint height);
VALA_EXTERN void greeter_compositor_shell_clients_manager_set_hide_mode (GreeterCompositorShellClientsManager* self,
                                                             MetaWindow* window,
                                                             enum io_elementary_pantheon_panel_v1_hide_mode hide_mode);
VALA_EXTERN void greeter_compositor_shell_clients_manager_init_greeter (GreeterCompositorShellClientsManager* self,
                                                            MetaWindow* window);
VALA_EXTERN GType greeter_compositor_positioned_window_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterCompositorShellWindow* greeter_compositor_shell_window_new (MetaWindow* window,
                                                                   GreeterCompositorPositionedWindowPosition position,
                                                                   GVariant* position_data);
VALA_EXTERN GreeterCompositorShellWindow* greeter_compositor_shell_window_construct (GType object_type,
                                                                         MetaWindow* window,
                                                                         GreeterCompositorPositionedWindowPosition position,
                                                                         GVariant* position_data);
static void __lambda89_ (GreeterCompositorShellClientsManager* self,
                  MetaWindow* _window);
static void ___lambda89__meta_window_unmanaging (MetaWindow* _sender,
                                          gpointer self);
VALA_EXTERN void greeter_compositor_shell_clients_manager_make_centered (GreeterCompositorShellClientsManager* self,
                                                             MetaWindow* window);
VALA_EXTERN gboolean greeter_compositor_shell_clients_manager_is_itself_positioned (GreeterCompositorShellClientsManager* self,
                                                                        MetaWindow* window);
static void __lambda90_ (GreeterCompositorShellClientsManager* self,
                  MetaWindow* _window);
static void ___lambda90__meta_window_unmanaging (MetaWindow* _sender,
                                          gpointer self);
VALA_EXTERN gboolean greeter_compositor_notification_stack_is_notification (MetaWindow* window);
VALA_EXTERN gboolean greeter_compositor_shell_clients_manager_is_positioned_window (GreeterCompositorShellClientsManager* self,
                                                                        MetaWindow* window);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean __lambda91_ (Block16Data* _data16_,
                      MetaWindow* ancestor);
static gboolean ___lambda91__meta_window_foreach_func (MetaWindow* window,
                                                gpointer self);
static void greeter_compositor_shell_clients_manager_parse_mutter_hints (GreeterCompositorShellClientsManager* self,
                                                                  MetaWindow* window);
static void greeter_compositor_shell_clients_manager_set_restore_previous_x11_region (GreeterCompositorShellClientsManager* self,
                                                                               MetaWindow* window);
VALA_EXTERN ClutterActor* greeter_compositor_shell_clients_manager_get_actor (GreeterCompositorShellClientsManager* self);
VALA_EXTERN ClutterStage* greeter_compositor_window_manager_get_stage (GreeterCompositorWindowManager* self);
static void greeter_compositor_shell_clients_manager_set_wm (GreeterCompositorShellClientsManager* self,
                                                      GreeterCompositorWindowManager* value);
static GObject * greeter_compositor_shell_clients_manager_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
VALA_EXTERN GreeterCompositorNotificationsClient* greeter_compositor_notifications_client_new (MetaDisplay* display);
VALA_EXTERN GreeterCompositorNotificationsClient* greeter_compositor_notifications_client_construct (GType object_type,
                                                                                         MetaDisplay* display);
static void _greeter_compositor_shell_clients_manager____lambda92_ (GreeterCompositorShellClientsManager* self,
                                                             MetaWindow* window);
static void __lambda93_ (GreeterCompositorShellClientsManager* self,
                  GObject* obj,
                  GParamSpec* pspec);
static void ___lambda93__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __greeter_compositor_shell_clients_manager____lambda92__meta_display_window_created (MetaDisplay* _sender,
                                                                                          MetaWindow* object,
                                                                                          gpointer self);
static void greeter_compositor_shell_clients_manager_finalize (GObject * obj);
static GType greeter_compositor_shell_clients_manager_get_type_once (void);
static void _vala_greeter_compositor_shell_clients_manager_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_greeter_compositor_shell_clients_manager_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
greeter_compositor_shell_clients_manager_get_instance_private (GreeterCompositorShellClientsManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorShellClientsManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

void
greeter_compositor_shell_clients_manager_init (GreeterCompositorWindowManager* wm)
{
	GreeterCompositorShellClientsManager* _tmp0_;
	GreeterCompositorShellClientsManager* _tmp1_;
	g_return_if_fail (wm != NULL);
	_tmp0_ = greeter_compositor_shell_clients_manager_instance;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = greeter_compositor_shell_clients_manager_new (wm);
	_g_object_unref0 (greeter_compositor_shell_clients_manager_instance);
	greeter_compositor_shell_clients_manager_instance = _tmp1_;
}

GreeterCompositorShellClientsManager*
greeter_compositor_shell_clients_manager_get_instance (void)
{
	GreeterCompositorShellClientsManager* _tmp0_;
	GreeterCompositorShellClientsManager* result;
	_tmp0_ = greeter_compositor_shell_clients_manager_instance;
	result = _tmp0_;
	return result;
}

static GreeterCompositorShellClientsManager*
greeter_compositor_shell_clients_manager_construct (GType object_type,
                                                    GreeterCompositorWindowManager* wm)
{
	GreeterCompositorShellClientsManager * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GreeterCompositorShellClientsManager*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

static GreeterCompositorShellClientsManager*
greeter_compositor_shell_clients_manager_new (GreeterCompositorWindowManager* wm)
{
	return greeter_compositor_shell_clients_manager_construct (GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, wm);
}

static void
greeter_compositor_shell_clients_manager_start_clients_data_free (gpointer _data)
{
	GreeterCompositorShellClientsManagerStartClientsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterCompositorShellClientsManagerStartClientsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_compositor_shell_clients_manager_start_clients (GreeterCompositorShellClientsManager* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GreeterCompositorShellClientsManagerStartClientsData* _data_;
	GreeterCompositorShellClientsManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GreeterCompositorShellClientsManagerStartClientsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_shell_clients_manager_start_clients_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	greeter_compositor_shell_clients_manager_start_clients_co (_data_);
}

static void
greeter_compositor_shell_clients_manager_start_clients_finish (GreeterCompositorShellClientsManager* self,
                                                               GAsyncResult* _res_)
{
	GreeterCompositorShellClientsManagerStartClientsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_vala_array_add3 (GreeterCompositorManagedClient** * array,
                  gint* length,
                  gint* size,
                  GreeterCompositorManagedClient* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GreeterCompositorManagedClient*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
greeter_compositor_shell_clients_manager_start_clients_co (GreeterCompositorShellClientsManagerStartClientsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_wm;
	_data_->_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _data_->_tmp0_);
	_data_->_tmp2_ = g_strdup ("io.elementary.wingpanel");
	_data_->_tmp3_ = g_strdup ("-g");
	_data_->_tmp4_ = g_new0 (gchar*, 2 + 1);
	_data_->_tmp4_[0] = _data_->_tmp2_;
	_data_->_tmp4_[1] = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp5__length1 = 2;
	_data_->_tmp6_ = greeter_compositor_managed_client_new (_data_->_tmp1_, _data_->_tmp5_, 2);
	_vala_array_add3 (&_data_->self->priv->protocol_clients, &_data_->self->priv->protocol_clients_length1, &_data_->self->priv->_protocol_clients_size_, _data_->_tmp6_);
	_data_->_tmp5_ = (_vala_array_free (_data_->_tmp5_, _data_->_tmp5__length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
greeter_compositor_shell_clients_manager_make_dock (GreeterCompositorShellClientsManager* self,
                                                    MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (meta_is_wayland_compositor ()) {
		greeter_compositor_shell_clients_manager_make_dock_wayland (self, window);
	} else {
		greeter_compositor_shell_clients_manager_make_dock_x11 (self, window);
	}
}

static void
greeter_compositor_shell_clients_manager_make_dock_wayland (GreeterCompositorShellClientsManager* self,
                                                            MetaWindow* window)
{
	GreeterCompositorManagedClient** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (meta_is_wayland_compositor (), "Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->protocol_clients;
	_tmp0__length1 = self->priv->protocol_clients_length1;
	{
		GreeterCompositorManagedClient** client_collection = NULL;
		gint client_collection_length1 = 0;
		gint _client_collection_size_ = 0;
		gint client_it = 0;
		client_collection = _tmp0_;
		client_collection_length1 = _tmp0__length1;
		for (client_it = 0; client_it < client_collection_length1; client_it = client_it + 1) {
			GreeterCompositorManagedClient* _tmp1_;
			GreeterCompositorManagedClient* client = NULL;
			_tmp1_ = _g_object_ref0 (client_collection[client_it]);
			client = _tmp1_;
			{
				GreeterCompositorManagedClient* _tmp2_;
				MetaWaylandClient* _tmp3_;
				MetaWaylandClient* _tmp4_;
				_tmp2_ = client;
				_tmp3_ = greeter_compositor_managed_client_get_wayland_client (_tmp2_);
				_tmp4_ = _tmp3_;
				if (meta_wayland_client_owns_window (_tmp4_, window)) {
					GreeterCompositorManagedClient* _tmp5_;
					MetaWaylandClient* _tmp6_;
					MetaWaylandClient* _tmp7_;
					_tmp5_ = client;
					_tmp6_ = greeter_compositor_managed_client_get_wayland_client (_tmp5_);
					_tmp7_ = _tmp6_;
					meta_wayland_client_make_dock (_tmp7_, window);
					_g_object_unref0 (client);
					break;
				}
				_g_object_unref0 (client);
			}
		}
	}
}

static void
greeter_compositor_shell_clients_manager_make_dock_x11 (GreeterCompositorShellClientsManager* self,
                                                        MetaWindow* window)
{
	MetaX11Display* x11_display = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaX11Display* _tmp2_;
	Window x_window = 0;
	Display* xdisplay = NULL;
	Display* _tmp3_;
	Atom atom = {0};
	Atom dock_atom = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!meta_is_wayland_compositor (), "!Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_x11_display (_tmp1_);
	x11_display = _tmp2_;
	x_window = meta_x11_display_lookup_xwindow (x11_display, window);
	_tmp3_ = meta_x11_display_get_xdisplay (x11_display);
	xdisplay = _tmp3_;
	atom = XInternAtom (xdisplay, "_NET_WM_WINDOW_TYPE", FALSE);
	dock_atom = XInternAtom (xdisplay, "_NET_WM_WINDOW_TYPE_DOCK", FALSE);
	XChangeProperty (xdisplay, x_window, atom, (Atom) 4, 32, 0, (guchar*) (&dock_atom), 1);
}

void
greeter_compositor_shell_clients_manager_make_desktop (GreeterCompositorShellClientsManager* self,
                                                       MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (meta_is_wayland_compositor ()) {
		greeter_compositor_shell_clients_manager_make_desktop_wayland (self, window);
	} else {
		greeter_compositor_shell_clients_manager_make_desktop_x11 (self, window);
	}
}

static void
greeter_compositor_shell_clients_manager_make_desktop_wayland (GreeterCompositorShellClientsManager* self,
                                                               MetaWindow* window)
{
	GreeterCompositorManagedClient** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (meta_is_wayland_compositor (), "Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->protocol_clients;
	_tmp0__length1 = self->priv->protocol_clients_length1;
	{
		GreeterCompositorManagedClient** client_collection = NULL;
		gint client_collection_length1 = 0;
		gint _client_collection_size_ = 0;
		gint client_it = 0;
		client_collection = _tmp0_;
		client_collection_length1 = _tmp0__length1;
		for (client_it = 0; client_it < client_collection_length1; client_it = client_it + 1) {
			GreeterCompositorManagedClient* _tmp1_;
			GreeterCompositorManagedClient* client = NULL;
			_tmp1_ = _g_object_ref0 (client_collection[client_it]);
			client = _tmp1_;
			{
				GreeterCompositorManagedClient* _tmp2_;
				MetaWaylandClient* _tmp3_;
				MetaWaylandClient* _tmp4_;
				_tmp2_ = client;
				_tmp3_ = greeter_compositor_managed_client_get_wayland_client (_tmp2_);
				_tmp4_ = _tmp3_;
				if (meta_wayland_client_owns_window (_tmp4_, window)) {
					GreeterCompositorManagedClient* _tmp5_;
					MetaWaylandClient* _tmp6_;
					MetaWaylandClient* _tmp7_;
					_tmp5_ = client;
					_tmp6_ = greeter_compositor_managed_client_get_wayland_client (_tmp5_);
					_tmp7_ = _tmp6_;
					meta_wayland_client_make_desktop (_tmp7_, window);
					_g_object_unref0 (client);
					break;
				}
				_g_object_unref0 (client);
			}
		}
	}
}

static void
greeter_compositor_shell_clients_manager_make_desktop_x11 (GreeterCompositorShellClientsManager* self,
                                                           MetaWindow* window)
{
	MetaX11Display* x11_display = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaX11Display* _tmp2_;
	Window x_window = 0;
	Display* xdisplay = NULL;
	Display* _tmp3_;
	Atom atom = {0};
	Atom dock_atom = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!meta_is_wayland_compositor (), "!Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_x11_display (_tmp1_);
	x11_display = _tmp2_;
	x_window = meta_x11_display_lookup_xwindow (x11_display, window);
	_tmp3_ = meta_x11_display_get_xdisplay (x11_display);
	xdisplay = _tmp3_;
	atom = XInternAtom (xdisplay, "_NET_WM_WINDOW_TYPE", FALSE);
	dock_atom = XInternAtom (xdisplay, "_NET_WM_WINDOW_TYPE_DESKTOP", FALSE);
	XChangeProperty (xdisplay, x_window, atom, (Atom) 4, 32, 0, (guchar*) (&dock_atom), 1);
}

static void
__lambda88_ (GreeterCompositorShellClientsManager* self,
             MetaWindow* _window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (_window != NULL);
	_tmp0_ = self->priv->panel_windows;
	g_hash_table_remove (_tmp0_, _window);
}

static void
___lambda88__meta_window_unmanaging (MetaWindow* _sender,
                                     gpointer self)
{
	__lambda88_ ((GreeterCompositorShellClientsManager*) self, _sender);
}

void
greeter_compositor_shell_clients_manager_set_anchor (GreeterCompositorShellClientsManager* self,
                                                     MetaWindow* window,
                                                     enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	MetaWindow* _tmp4_;
	GreeterCompositorWindowManager* _tmp5_;
	GreeterCompositorPanelWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->panel_windows;
	if (g_hash_table_contains (_tmp0_, window)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->panel_windows;
		_tmp2_ = g_hash_table_lookup (_tmp1_, window);
		greeter_compositor_panel_window_set_anchor ((GreeterCompositorPanelWindow*) _tmp2_, anchor);
		return;
	}
	greeter_compositor_shell_clients_manager_make_dock (self, window);
	_tmp3_ = self->priv->panel_windows;
	_tmp4_ = _g_object_ref0 (window);
	_tmp5_ = self->priv->_wm;
	_tmp6_ = greeter_compositor_panel_window_new (_tmp5_, window, anchor);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp6_);
	g_signal_connect_object (window, "unmanaging", (GCallback) ___lambda88__meta_window_unmanaging, self, G_CONNECT_AFTER);
}

/**
     * The size given here is only used for the hide mode. I.e. struts
     * and collision detection with other windows use this size. By default
     * or if set to -1 the size of the window is used.
     *
     * TODO: Maybe use for strut only?
     */
void
greeter_compositor_shell_clients_manager_set_size (GreeterCompositorShellClientsManager* self,
                                                   MetaWindow* window,
                                                   gint width,
                                                   gint height)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->panel_windows;
	if (!g_hash_table_contains (_tmp0_, window)) {
		g_warning ("ShellClientsManager.vala:153: Set anchor for window before size.");
		return;
	}
	_tmp1_ = self->priv->panel_windows;
	_tmp2_ = g_hash_table_lookup (_tmp1_, window);
	greeter_compositor_panel_window_set_size ((GreeterCompositorPanelWindow*) _tmp2_, width, height);
}

void
greeter_compositor_shell_clients_manager_set_hide_mode (GreeterCompositorShellClientsManager* self,
                                                        MetaWindow* window,
                                                        enum io_elementary_pantheon_panel_v1_hide_mode hide_mode)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_debug ("ShellClientsManager.vala:161: Hide mode is unsupported in greeter-comp" \
"ositor");
}

static void
__lambda89_ (GreeterCompositorShellClientsManager* self,
             MetaWindow* _window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (_window != NULL);
	_tmp0_ = self->priv->positioned_windows;
	g_hash_table_remove (_tmp0_, _window);
}

static void
___lambda89__meta_window_unmanaging (MetaWindow* _sender,
                                     gpointer self)
{
	__lambda89_ ((GreeterCompositorShellClientsManager*) self, _sender);
}

void
greeter_compositor_shell_clients_manager_init_greeter (GreeterCompositorShellClientsManager* self,
                                                       MetaWindow* window)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	GreeterCompositorShellWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	greeter_compositor_shell_clients_manager_make_desktop (self, window);
	_tmp0_ = self->priv->positioned_windows;
	_tmp1_ = _g_object_ref0 (window);
	_tmp2_ = greeter_compositor_shell_window_new (window, GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_FULLSCREEN, NULL);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_signal_connect_object (window, "unmanaging", (GCallback) ___lambda89__meta_window_unmanaging, self, G_CONNECT_AFTER);
}

static void
__lambda90_ (GreeterCompositorShellClientsManager* self,
             MetaWindow* _window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (_window != NULL);
	_tmp0_ = self->priv->positioned_windows;
	g_hash_table_remove (_tmp0_, _window);
}

static void
___lambda90__meta_window_unmanaging (MetaWindow* _sender,
                                     gpointer self)
{
	__lambda90_ ((GreeterCompositorShellClientsManager*) self, _sender);
}

void
greeter_compositor_shell_clients_manager_make_centered (GreeterCompositorShellClientsManager* self,
                                                        MetaWindow* window)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	GreeterCompositorShellWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!greeter_compositor_shell_clients_manager_is_itself_positioned (self, window), "!is_itself_positioned (window)");
	_tmp0_ = self->priv->positioned_windows;
	_tmp1_ = _g_object_ref0 (window);
	_tmp2_ = greeter_compositor_shell_window_new (window, GREETER_COMPOSITOR_POSITIONED_WINDOW_POSITION_CENTER, NULL);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_signal_connect_object (window, "unmanaging", (GCallback) ___lambda90__meta_window_unmanaging, self, G_CONNECT_AFTER);
}

gboolean
greeter_compositor_shell_clients_manager_is_itself_positioned (GreeterCompositorShellClientsManager* self,
                                                               MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GHashTable* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp2_ = self->priv->positioned_windows;
	if (g_hash_table_contains (_tmp2_, window)) {
		_tmp1_ = TRUE;
	} else {
		GHashTable* _tmp3_;
		_tmp3_ = self->priv->panel_windows;
		_tmp1_ = g_hash_table_contains (_tmp3_, window);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = greeter_compositor_notification_stack_is_notification (window);
	}
	result = _tmp0_;
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		GreeterCompositorShellClientsManager* self;
		self = _data16_->self;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
__lambda91_ (Block16Data* _data16_,
             MetaWindow* ancestor)
{
	GreeterCompositorShellClientsManager* self;
	gboolean result;
	self = _data16_->self;
	g_return_val_if_fail (ancestor != NULL, FALSE);
	if (greeter_compositor_shell_clients_manager_is_itself_positioned (self, ancestor)) {
		_data16_->positioned = TRUE;
	}
	result = !_data16_->positioned;
	return result;
}

static gboolean
___lambda91__meta_window_foreach_func (MetaWindow* window,
                                       gpointer self)
{
	gboolean result;
	result = __lambda91_ (self, window);
	return result;
}

gboolean
greeter_compositor_shell_clients_manager_is_positioned_window (GreeterCompositorShellClientsManager* self,
                                                               MetaWindow* window)
{
	Block16Data* _data16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->positioned = greeter_compositor_shell_clients_manager_is_itself_positioned (self, window);
	meta_window_foreach_ancestor (window, ___lambda91__meta_window_foreach_func, _data16_);
	result = _data16_->positioned;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
greeter_compositor_shell_clients_manager_parse_mutter_hints (GreeterCompositorShellClientsManager* self,
                                                             MetaWindow* window)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** mutter_hints = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint mutter_hints_length1;
	gint _mutter_hints_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!meta_is_wayland_compositor (), "!Meta.Util.is_wayland_compositor ()");
	_tmp0_ = meta_window_get_mutter_hints (window);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = meta_window_get_mutter_hints (window);
	_tmp3_ = _tmp2_;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
	mutter_hints = _tmp5_;
	mutter_hints_length1 = _vala_array_length (_tmp4_);
	_mutter_hints_size_ = mutter_hints_length1;
	_tmp6_ = mutter_hints;
	_tmp6__length1 = mutter_hints_length1;
	{
		gchar** mutter_hint_collection = NULL;
		gint mutter_hint_collection_length1 = 0;
		gint _mutter_hint_collection_size_ = 0;
		gint mutter_hint_it = 0;
		mutter_hint_collection = _tmp6_;
		mutter_hint_collection_length1 = _tmp6__length1;
		for (mutter_hint_it = 0; mutter_hint_it < mutter_hint_collection_length1; mutter_hint_it = mutter_hint_it + 1) {
			gchar* _tmp7_;
			gchar* mutter_hint = NULL;
			_tmp7_ = g_strdup (mutter_hint_collection[mutter_hint_it]);
			mutter_hint = _tmp7_;
			{
				gchar** split = NULL;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* key = NULL;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* val = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GQuark _tmp21_ = 0U;
				static GQuark _tmp20_label0 = 0;
				static GQuark _tmp20_label1 = 0;
				static GQuark _tmp20_label2 = 0;
				static GQuark _tmp20_label3 = 0;
				static GQuark _tmp20_label4 = 0;
				static GQuark _tmp20_label5 = 0;
				_tmp8_ = mutter_hint;
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 0);
				split = _tmp10_;
				split_length1 = _vala_array_length (_tmp9_);
				_split_size_ = split_length1;
				_tmp11_ = split;
				_tmp11__length1 = split_length1;
				if (_tmp11__length1 != 2) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (mutter_hint);
					continue;
				}
				_tmp12_ = split;
				_tmp12__length1 = split_length1;
				_tmp13_ = _tmp12_[0];
				_tmp14_ = g_strdup (_tmp13_);
				key = _tmp14_;
				_tmp15_ = split;
				_tmp15__length1 = split_length1;
				_tmp16_ = _tmp15_[1];
				_tmp17_ = g_strdup (_tmp16_);
				val = _tmp17_;
				_tmp18_ = key;
				_tmp19_ = _tmp18_;
				_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
				if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("anchor")))) {
					switch (0) {
						default:
						{
							gint meta_side_parsed = 0;
							gboolean _tmp22_ = FALSE;
							gboolean _tmp23_ = FALSE;
							const gchar* _tmp24_;
							gint _tmp25_ = 0;
							gboolean _tmp26_;
							_tmp24_ = val;
							_tmp26_ = int_try_parse (_tmp24_, &_tmp25_, NULL, (guint) 0);
							meta_side_parsed = _tmp25_;
							if (_tmp26_) {
								_tmp23_ = 0 <= meta_side_parsed;
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								_tmp22_ = meta_side_parsed <= 15;
							} else {
								_tmp22_ = FALSE;
							}
							if (_tmp22_) {
								enum io_elementary_pantheon_panel_v1_anchor parsed = 0;
								parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP;
								switch ((MetaSide) meta_side_parsed) {
									case META_SIDE_BOTTOM:
									{
										parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM;
										break;
									}
									case META_SIDE_LEFT:
									{
										parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT;
										break;
									}
									case META_SIDE_RIGHT:
									{
										parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT;
										break;
									}
									default:
									{
										break;
									}
								}
								greeter_compositor_shell_clients_manager_set_anchor (self, window, parsed);
								greeter_compositor_shell_clients_manager_set_anchor (self, window, parsed);
							} else {
								const gchar* _tmp27_;
								_tmp27_ = val;
								g_warning ("ShellClientsManager.vala:242: Failed to parse %s as anchor", _tmp27_);
							}
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hide-mode")))) {
					switch (0) {
						default:
						{
							gint parsed = 0;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							const gchar* _tmp30_;
							gint _tmp31_ = 0;
							gboolean _tmp32_;
							_tmp30_ = val;
							_tmp32_ = int_try_parse (_tmp30_, &_tmp31_, NULL, (guint) 0);
							parsed = _tmp31_;
							if (_tmp32_) {
								_tmp29_ = 0 <= parsed;
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								_tmp28_ = parsed <= 4;
							} else {
								_tmp28_ = FALSE;
							}
							if (_tmp28_) {
								greeter_compositor_shell_clients_manager_set_hide_mode (self, window, parsed);
							} else {
								const gchar* _tmp33_;
								_tmp33_ = val;
								g_warning ("ShellClientsManager.vala:251: Failed to parse %s as hide mode", _tmp33_);
							}
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label2) ? _tmp20_label2 : (_tmp20_label2 = g_quark_from_static_string ("size")))) {
					switch (0) {
						default:
						{
							gchar** split_val = NULL;
							const gchar* _tmp34_;
							gchar** _tmp35_;
							gchar** _tmp36_;
							gint split_val_length1;
							gint _split_val_size_;
							gchar** _tmp37_;
							gint _tmp37__length1;
							gint parsed_width = 0;
							gint parsed_height = 0;
							gboolean _tmp38_ = FALSE;
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							gint _tmp41_ = 0;
							gboolean _tmp42_;
							_tmp34_ = val;
							_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, ",", 0);
							split_val = _tmp36_;
							split_val_length1 = _vala_array_length (_tmp35_);
							_split_val_size_ = split_val_length1;
							_tmp37_ = split_val;
							_tmp37__length1 = split_val_length1;
							if (_tmp37__length1 != 2) {
								split_val = (_vala_array_free (split_val, split_val_length1, (GDestroyNotify) g_free), NULL);
								break;
							}
							parsed_height = 0;
							_tmp39_ = split_val;
							_tmp39__length1 = split_val_length1;
							_tmp40_ = _tmp39_[0];
							_tmp42_ = int_try_parse (_tmp40_, &_tmp41_, NULL, (guint) 0);
							parsed_width = _tmp41_;
							if (_tmp42_) {
								gchar** _tmp43_;
								gint _tmp43__length1;
								const gchar* _tmp44_;
								gint _tmp45_ = 0;
								gboolean _tmp46_;
								_tmp43_ = split_val;
								_tmp43__length1 = split_val_length1;
								_tmp44_ = _tmp43_[1];
								_tmp46_ = int_try_parse (_tmp44_, &_tmp45_, NULL, (guint) 0);
								parsed_height = _tmp45_;
								_tmp38_ = _tmp46_;
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								greeter_compositor_shell_clients_manager_set_size (self, window, parsed_width, parsed_height);
							} else {
								const gchar* _tmp47_;
								_tmp47_ = val;
								g_warning ("ShellClientsManager.vala:264: Failed to parse %s as width and height", _tmp47_);
							}
							split_val = (_vala_array_free (split_val, split_val_length1, (GDestroyNotify) g_free), NULL);
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label3) ? _tmp20_label3 : (_tmp20_label3 = g_quark_from_static_string ("greeter")))) {
					switch (0) {
						default:
						{
							greeter_compositor_shell_clients_manager_init_greeter (self, window);
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label4) ? _tmp20_label4 : (_tmp20_label4 = g_quark_from_static_string ("centered")))) {
					switch (0) {
						default:
						{
							greeter_compositor_shell_clients_manager_make_centered (self, window);
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label5) ? _tmp20_label5 : (_tmp20_label5 = g_quark_from_static_string ("restore-previous-region")))) {
					switch (0) {
						default:
						{
							greeter_compositor_shell_clients_manager_set_restore_previous_x11_region (self, window);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
				_g_free0 (val);
				_g_free0 (key);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (mutter_hint);
			}
		}
	}
	mutter_hints = (_vala_array_free (mutter_hints, mutter_hints_length1, (GDestroyNotify) g_free), NULL);
}

static void
greeter_compositor_shell_clients_manager_set_restore_previous_x11_region (GreeterCompositorShellClientsManager* self,
                                                                          MetaWindow* window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!meta_is_wayland_compositor (), "!Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->panel_windows;
	_vala_return_if_fail (g_hash_table_contains (_tmp0_, window), "window in panel_windows");
	g_debug ("ShellClientsManager.vala:289: restore-previous-region is unsupported i" \
"n greeter-compositor");
}

ClutterActor*
greeter_compositor_shell_clients_manager_get_actor (GreeterCompositorShellClientsManager* self)
{
	ClutterActor* result;
	GreeterCompositorWindowManager* _tmp0_;
	ClutterStage* _tmp1_;
	ClutterStage* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = greeter_compositor_window_manager_get_stage (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (ClutterActor*) _tmp2_;
	return result;
}

GreeterCompositorWindowManager*
greeter_compositor_shell_clients_manager_get_wm (GreeterCompositorShellClientsManager* self)
{
	GreeterCompositorWindowManager* result;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_shell_clients_manager_set_wm (GreeterCompositorShellClientsManager* self,
                                                 GreeterCompositorWindowManager* value)
{
	GreeterCompositorWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_shell_clients_manager_get_wm (self);
	if (old_value != value) {
		GreeterCompositorWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_shell_clients_manager_properties[GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_WM_PROPERTY]);
	}
}

static void
__lambda93_ (GreeterCompositorShellClientsManager* self,
             GObject* obj,
             GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	greeter_compositor_shell_clients_manager_parse_mutter_hints (self, G_TYPE_CHECK_INSTANCE_CAST (obj, meta_window_get_type (), MetaWindow));
}

static void
___lambda93__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda93_ ((GreeterCompositorShellClientsManager*) self, _sender, pspec);
}

static void
_greeter_compositor_shell_clients_manager____lambda92_ (GreeterCompositorShellClientsManager* self,
                                                        MetaWindow* window)
{
	g_return_if_fail (window != NULL);
	g_signal_connect_object ((GObject*) window, "notify::mutter-hints", (GCallback) ___lambda93__g_object_notify, self, 0);
	greeter_compositor_shell_clients_manager_parse_mutter_hints (self, window);
}

static void
__greeter_compositor_shell_clients_manager____lambda92__meta_display_window_created (MetaDisplay* _sender,
                                                                                     MetaWindow* object,
                                                                                     gpointer self)
{
	_greeter_compositor_shell_clients_manager____lambda92_ ((GreeterCompositorShellClientsManager*) self, object);
}

static GObject *
greeter_compositor_shell_clients_manager_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorShellClientsManager * self;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GreeterCompositorNotificationsClient* _tmp2_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_shell_clients_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManager);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = greeter_compositor_notifications_client_new (_tmp1_);
	_g_object_unref0 (self->priv->notifications_client);
	self->priv->notifications_client = _tmp2_;
	greeter_compositor_shell_clients_manager_start_clients (self, NULL, NULL);
	if (!meta_is_wayland_compositor ()) {
		GreeterCompositorWindowManager* _tmp3_;
		MetaDisplay* _tmp4_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
		g_signal_connect_object (_tmp4_, "window-created", (GCallback) __greeter_compositor_shell_clients_manager____lambda92__meta_display_window_created, self, 0);
	}
	return obj;
}

static void
greeter_compositor_shell_clients_manager_class_init (GreeterCompositorShellClientsManagerClass * klass,
                                                     gpointer klass_data)
{
	greeter_compositor_shell_clients_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorShellClientsManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_shell_clients_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_shell_clients_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_shell_clients_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_shell_clients_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_ACTOR_PROPERTY, greeter_compositor_shell_clients_manager_properties[GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_WM_PROPERTY, greeter_compositor_shell_clients_manager_properties[GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
greeter_compositor_shell_clients_manager_instance_init (GreeterCompositorShellClientsManager * self,
                                                        gpointer klass)
{
	GreeterCompositorManagedClient** _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self->priv = greeter_compositor_shell_clients_manager_get_instance_private (self);
	_tmp0_ = g_new0 (GreeterCompositorManagedClient*, 0 + 1);
	self->priv->protocol_clients = _tmp0_;
	self->priv->protocol_clients_length1 = 0;
	self->priv->_protocol_clients_size_ = self->priv->protocol_clients_length1;
	_tmp1_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
	self->priv->panel_windows = _tmp1_;
	_tmp2_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
	self->priv->positioned_windows = _tmp2_;
}

static void
greeter_compositor_shell_clients_manager_finalize (GObject * obj)
{
	GreeterCompositorShellClientsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManager);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->notifications_client);
	self->priv->protocol_clients = (_vala_array_free (self->priv->protocol_clients, self->priv->protocol_clients_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->panel_windows);
	_g_hash_table_unref0 (self->priv->positioned_windows);
	G_OBJECT_CLASS (greeter_compositor_shell_clients_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_shell_clients_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorShellClientsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_shell_clients_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorShellClientsManager), 0, (GInstanceInitFunc) greeter_compositor_shell_clients_manager_instance_init, NULL };
	GType greeter_compositor_shell_clients_manager_type_id;
	greeter_compositor_shell_clients_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorShellClientsManager", &g_define_type_info, 0);
	GreeterCompositorShellClientsManager_private_offset = g_type_add_instance_private (greeter_compositor_shell_clients_manager_type_id, sizeof (GreeterCompositorShellClientsManagerPrivate));
	return greeter_compositor_shell_clients_manager_type_id;
}

GType
greeter_compositor_shell_clients_manager_get_type (void)
{
	static volatile gsize greeter_compositor_shell_clients_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_shell_clients_manager_type_id__once)) {
		GType greeter_compositor_shell_clients_manager_type_id;
		greeter_compositor_shell_clients_manager_type_id = greeter_compositor_shell_clients_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_shell_clients_manager_type_id__once, greeter_compositor_shell_clients_manager_type_id);
	}
	return greeter_compositor_shell_clients_manager_type_id__once;
}

static void
_vala_greeter_compositor_shell_clients_manager_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	GreeterCompositorShellClientsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_ACTOR_PROPERTY:
		g_value_set_object (value, greeter_compositor_shell_clients_manager_get_actor (self));
		break;
		case GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_WM_PROPERTY:
		g_value_set_object (value, greeter_compositor_shell_clients_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_shell_clients_manager_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	GreeterCompositorShellClientsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_SHELL_CLIENTS_MANAGER, GreeterCompositorShellClientsManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_SHELL_CLIENTS_MANAGER_WM_PROPERTY:
		greeter_compositor_shell_clients_manager_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

