/* Generated by wayland-scanner 1.24.0 */

#ifndef EXT_DATA_CONTROL_V1_SERVER_PROTOCOL_H
#define EXT_DATA_CONTROL_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_ext_data_control_v1 The ext_data_control_v1 protocol
 * control data devices
 *
 * @section page_desc_ext_data_control_v1 Description
 *
 * This protocol allows a privileged client to control data devices. In
 * particular, the client will be able to manage the current selection and take
 * the role of a clipboard manager.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_ext_data_control_v1 Interfaces
 * - @subpage page_iface_ext_data_control_manager_v1 - manager to control data devices
 * - @subpage page_iface_ext_data_control_device_v1 - manage a data device for a seat
 * - @subpage page_iface_ext_data_control_source_v1 - offer to transfer data
 * - @subpage page_iface_ext_data_control_offer_v1 - offer to transfer data
 * @section page_copyright_ext_data_control_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 Simon Ser
 * Copyright © 2019 Ivan Molodetskikh
 * Copyright © 2024 Neal Gompa
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct ext_data_control_device_v1;
struct ext_data_control_manager_v1;
struct ext_data_control_offer_v1;
struct ext_data_control_source_v1;
struct wl_seat;

#ifndef EXT_DATA_CONTROL_MANAGER_V1_INTERFACE
#define EXT_DATA_CONTROL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_data_control_manager_v1 ext_data_control_manager_v1
 * @section page_iface_ext_data_control_manager_v1_desc Description
 *
 * This interface is a manager that allows creating per-seat data device
 * controls.
 * @section page_iface_ext_data_control_manager_v1_api API
 * See @ref iface_ext_data_control_manager_v1.
 */
/**
 * @defgroup iface_ext_data_control_manager_v1 The ext_data_control_manager_v1 interface
 *
 * This interface is a manager that allows creating per-seat data device
 * controls.
 */
extern const struct wl_interface ext_data_control_manager_v1_interface;
#endif
#ifndef EXT_DATA_CONTROL_DEVICE_V1_INTERFACE
#define EXT_DATA_CONTROL_DEVICE_V1_INTERFACE
/**
 * @page page_iface_ext_data_control_device_v1 ext_data_control_device_v1
 * @section page_iface_ext_data_control_device_v1_desc Description
 *
 * This interface allows a client to manage a seat's selection.
 *
 * When the seat is destroyed, this object becomes inert.
 * @section page_iface_ext_data_control_device_v1_api API
 * See @ref iface_ext_data_control_device_v1.
 */
/**
 * @defgroup iface_ext_data_control_device_v1 The ext_data_control_device_v1 interface
 *
 * This interface allows a client to manage a seat's selection.
 *
 * When the seat is destroyed, this object becomes inert.
 */
extern const struct wl_interface ext_data_control_device_v1_interface;
#endif
#ifndef EXT_DATA_CONTROL_SOURCE_V1_INTERFACE
#define EXT_DATA_CONTROL_SOURCE_V1_INTERFACE
/**
 * @page page_iface_ext_data_control_source_v1 ext_data_control_source_v1
 * @section page_iface_ext_data_control_source_v1_desc Description
 *
 * The ext_data_control_source object is the source side of a
 * ext_data_control_offer. It is created by the source client in a data
 * transfer and provides a way to describe the offered data and a way to
 * respond to requests to transfer the data.
 * @section page_iface_ext_data_control_source_v1_api API
 * See @ref iface_ext_data_control_source_v1.
 */
/**
 * @defgroup iface_ext_data_control_source_v1 The ext_data_control_source_v1 interface
 *
 * The ext_data_control_source object is the source side of a
 * ext_data_control_offer. It is created by the source client in a data
 * transfer and provides a way to describe the offered data and a way to
 * respond to requests to transfer the data.
 */
extern const struct wl_interface ext_data_control_source_v1_interface;
#endif
#ifndef EXT_DATA_CONTROL_OFFER_V1_INTERFACE
#define EXT_DATA_CONTROL_OFFER_V1_INTERFACE
/**
 * @page page_iface_ext_data_control_offer_v1 ext_data_control_offer_v1
 * @section page_iface_ext_data_control_offer_v1_desc Description
 *
 * A ext_data_control_offer represents a piece of data offered for transfer
 * by another client (the source client). The offer describes the different
 * MIME types that the data can be converted to and provides the mechanism
 * for transferring the data directly from the source client.
 * @section page_iface_ext_data_control_offer_v1_api API
 * See @ref iface_ext_data_control_offer_v1.
 */
/**
 * @defgroup iface_ext_data_control_offer_v1 The ext_data_control_offer_v1 interface
 *
 * A ext_data_control_offer represents a piece of data offered for transfer
 * by another client (the source client). The offer describes the different
 * MIME types that the data can be converted to and provides the mechanism
 * for transferring the data directly from the source client.
 */
extern const struct wl_interface ext_data_control_offer_v1_interface;
#endif

/**
 * @ingroup iface_ext_data_control_manager_v1
 * @struct ext_data_control_manager_v1_interface
 */
struct ext_data_control_manager_v1_interface {
	/**
	 * create a new data source
	 *
	 * Create a new data source.
	 * @param id data source to create
	 */
	void (*create_data_source)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t id);
	/**
	 * get a data device for a seat
	 *
	 * Create a data device that can be used to manage a seat's
	 * selection.
	 */
	void (*get_data_device)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t id,
				struct wl_resource *seat);
	/**
	 * destroy the manager
	 *
	 * All objects created by the manager will still remain valid,
	 * until their appropriate destroy request has been called.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_ext_data_control_manager_v1
 */
#define EXT_DATA_CONTROL_MANAGER_V1_CREATE_DATA_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_manager_v1
 */
#define EXT_DATA_CONTROL_MANAGER_V1_GET_DATA_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_manager_v1
 */
#define EXT_DATA_CONTROL_MANAGER_V1_DESTROY_SINCE_VERSION 1

#ifndef EXT_DATA_CONTROL_DEVICE_V1_ERROR_ENUM
#define EXT_DATA_CONTROL_DEVICE_V1_ERROR_ENUM
enum ext_data_control_device_v1_error {
	/**
	 * source given to set_selection or set_primary_selection was already used before
	 */
	EXT_DATA_CONTROL_DEVICE_V1_ERROR_USED_SOURCE = 1,
};
#endif /* EXT_DATA_CONTROL_DEVICE_V1_ERROR_ENUM */

#ifndef EXT_DATA_CONTROL_DEVICE_V1_ERROR_ENUM_IS_VALID
#define EXT_DATA_CONTROL_DEVICE_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_ext_data_control_device_v1
 * Validate a ext_data_control_device_v1 error value.
 *
 * @return true on success, false on error.
 * @ref ext_data_control_device_v1_error
 */
static inline bool
ext_data_control_device_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EXT_DATA_CONTROL_DEVICE_V1_ERROR_USED_SOURCE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EXT_DATA_CONTROL_DEVICE_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_data_control_device_v1
 * @struct ext_data_control_device_v1_interface
 */
struct ext_data_control_device_v1_interface {
	/**
	 * copy data to the selection
	 *
	 * This request asks the compositor to set the selection to the
	 * data from the source on behalf of the client.
	 *
	 * The given source may not be used in any further set_selection or
	 * set_primary_selection requests. Attempting to use a previously
	 * used source triggers the used_source protocol error.
	 *
	 * To unset the selection, set the source to NULL.
	 */
	void (*set_selection)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *source);
	/**
	 * destroy this data device
	 *
	 * Destroys the data device object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * copy data to the primary selection
	 *
	 * This request asks the compositor to set the primary selection
	 * to the data from the source on behalf of the client.
	 *
	 * The given source may not be used in any further set_selection or
	 * set_primary_selection requests. Attempting to use a previously
	 * used source triggers the used_source protocol error.
	 *
	 * To unset the primary selection, set the source to NULL.
	 *
	 * The compositor will ignore this request if it does not support
	 * primary selection.
	 */
	void (*set_primary_selection)(struct wl_client *client,
				      struct wl_resource *resource,
				      struct wl_resource *source);
};

#define EXT_DATA_CONTROL_DEVICE_V1_DATA_OFFER 0
#define EXT_DATA_CONTROL_DEVICE_V1_SELECTION 1
#define EXT_DATA_CONTROL_DEVICE_V1_FINISHED 2
#define EXT_DATA_CONTROL_DEVICE_V1_PRIMARY_SELECTION 3

/**
 * @ingroup iface_ext_data_control_device_v1
 */
#define EXT_DATA_CONTROL_DEVICE_V1_DATA_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_device_v1
 */
#define EXT_DATA_CONTROL_DEVICE_V1_SELECTION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_device_v1
 */
#define EXT_DATA_CONTROL_DEVICE_V1_FINISHED_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_device_v1
 */
#define EXT_DATA_CONTROL_DEVICE_V1_PRIMARY_SELECTION_SINCE_VERSION 1

/**
 * @ingroup iface_ext_data_control_device_v1
 */
#define EXT_DATA_CONTROL_DEVICE_V1_SET_SELECTION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_device_v1
 */
#define EXT_DATA_CONTROL_DEVICE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_device_v1
 */
#define EXT_DATA_CONTROL_DEVICE_V1_SET_PRIMARY_SELECTION_SINCE_VERSION 1

/**
 * @ingroup iface_ext_data_control_device_v1
 * Sends an data_offer event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_data_control_device_v1_send_data_offer(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, EXT_DATA_CONTROL_DEVICE_V1_DATA_OFFER, id);
}

/**
 * @ingroup iface_ext_data_control_device_v1
 * Sends an selection event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_data_control_device_v1_send_selection(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, EXT_DATA_CONTROL_DEVICE_V1_SELECTION, id);
}

/**
 * @ingroup iface_ext_data_control_device_v1
 * Sends an finished event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_data_control_device_v1_send_finished(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_DATA_CONTROL_DEVICE_V1_FINISHED);
}

/**
 * @ingroup iface_ext_data_control_device_v1
 * Sends an primary_selection event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_data_control_device_v1_send_primary_selection(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, EXT_DATA_CONTROL_DEVICE_V1_PRIMARY_SELECTION, id);
}

#ifndef EXT_DATA_CONTROL_SOURCE_V1_ERROR_ENUM
#define EXT_DATA_CONTROL_SOURCE_V1_ERROR_ENUM
enum ext_data_control_source_v1_error {
	/**
	 * offer sent after ext_data_control_device.set_selection
	 */
	EXT_DATA_CONTROL_SOURCE_V1_ERROR_INVALID_OFFER = 1,
};
#endif /* EXT_DATA_CONTROL_SOURCE_V1_ERROR_ENUM */

#ifndef EXT_DATA_CONTROL_SOURCE_V1_ERROR_ENUM_IS_VALID
#define EXT_DATA_CONTROL_SOURCE_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_ext_data_control_source_v1
 * Validate a ext_data_control_source_v1 error value.
 *
 * @return true on success, false on error.
 * @ref ext_data_control_source_v1_error
 */
static inline bool
ext_data_control_source_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EXT_DATA_CONTROL_SOURCE_V1_ERROR_INVALID_OFFER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EXT_DATA_CONTROL_SOURCE_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_data_control_source_v1
 * @struct ext_data_control_source_v1_interface
 */
struct ext_data_control_source_v1_interface {
	/**
	 * add an offered MIME type
	 *
	 * This request adds a MIME type to the set of MIME types
	 * advertised to targets. Can be called several times to offer
	 * multiple types.
	 *
	 * Calling this after ext_data_control_device.set_selection is a
	 * protocol error.
	 * @param mime_type MIME type offered by the data source
	 */
	void (*offer)(struct wl_client *client,
		      struct wl_resource *resource,
		      const char *mime_type);
	/**
	 * destroy this source
	 *
	 * Destroys the data source object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_DATA_CONTROL_SOURCE_V1_SEND 0
#define EXT_DATA_CONTROL_SOURCE_V1_CANCELLED 1

/**
 * @ingroup iface_ext_data_control_source_v1
 */
#define EXT_DATA_CONTROL_SOURCE_V1_SEND_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_source_v1
 */
#define EXT_DATA_CONTROL_SOURCE_V1_CANCELLED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_data_control_source_v1
 */
#define EXT_DATA_CONTROL_SOURCE_V1_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_source_v1
 */
#define EXT_DATA_CONTROL_SOURCE_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_data_control_source_v1
 * Sends an send event to the client owning the resource.
 * @param resource_ The client's resource
 * @param mime_type MIME type for the data
 * @param fd file descriptor for the data
 */
static inline void
ext_data_control_source_v1_send_send(struct wl_resource *resource_, const char *mime_type, int32_t fd)
{
	wl_resource_post_event(resource_, EXT_DATA_CONTROL_SOURCE_V1_SEND, mime_type, fd);
}

/**
 * @ingroup iface_ext_data_control_source_v1
 * Sends an cancelled event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_data_control_source_v1_send_cancelled(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_DATA_CONTROL_SOURCE_V1_CANCELLED);
}

/**
 * @ingroup iface_ext_data_control_offer_v1
 * @struct ext_data_control_offer_v1_interface
 */
struct ext_data_control_offer_v1_interface {
	/**
	 * request that the data is transferred
	 *
	 * To transfer the offered data, the client issues this request
	 * and indicates the MIME type it wants to receive. The transfer
	 * happens through the passed file descriptor (typically created
	 * with the pipe system call). The source client writes the data in
	 * the MIME type representation requested and then closes the file
	 * descriptor.
	 *
	 * The receiving client reads from the read end of the pipe until
	 * EOF and then closes its end, at which point the transfer is
	 * complete.
	 *
	 * This request may happen multiple times for different MIME types.
	 * @param mime_type MIME type desired by receiver
	 * @param fd file descriptor for data transfer
	 */
	void (*receive)(struct wl_client *client,
			struct wl_resource *resource,
			const char *mime_type,
			int32_t fd);
	/**
	 * destroy this offer
	 *
	 * Destroys the data offer object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_DATA_CONTROL_OFFER_V1_OFFER 0

/**
 * @ingroup iface_ext_data_control_offer_v1
 */
#define EXT_DATA_CONTROL_OFFER_V1_OFFER_SINCE_VERSION 1

/**
 * @ingroup iface_ext_data_control_offer_v1
 */
#define EXT_DATA_CONTROL_OFFER_V1_RECEIVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_data_control_offer_v1
 */
#define EXT_DATA_CONTROL_OFFER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_data_control_offer_v1
 * Sends an offer event to the client owning the resource.
 * @param resource_ The client's resource
 * @param mime_type offered MIME type
 */
static inline void
ext_data_control_offer_v1_send_offer(struct wl_resource *resource_, const char *mime_type)
{
	wl_resource_post_event(resource_, EXT_DATA_CONTROL_OFFER_V1_OFFER, mime_type);
}

#ifdef  __cplusplus
}
#endif

#endif
