// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/dde-seat.xml

#include "qwayland-server-dde-seat.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int dde_seat::deferred_destroy_global_func(void *data) {
        auto object = static_cast<dde_seat *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->dde_seat_destroy_global();
        return 0;
    }

    dde_seat::dde_seat(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    dde_seat::dde_seat(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    dde_seat::dde_seat(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    dde_seat::dde_seat()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    dde_seat::~dde_seat()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->dde_seat_object = nullptr;

        if (m_resource)
            m_resource->dde_seat_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void dde_seat::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void dde_seat::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    dde_seat::Resource *dde_seat::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    dde_seat::Resource *dde_seat::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void dde_seat::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::dde_seat_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = dde_seat::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *dde_seat::interface()
    {
        return &::dde_seat_interface;
    }

    dde_seat::Resource *dde_seat::dde_seat_allocate()
    {
        return new Resource;
    }

    void dde_seat::dde_seat_destroy_global()
    {
    }

    void dde_seat::dde_seat_bind_resource(Resource *)
    {
    }

    void dde_seat::dde_seat_destroy_resource(Resource *)
    {
    }

    void dde_seat::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        dde_seat *that = static_cast<dde_seat *>(data);
        that->add(client, id, version);
    }

    void dde_seat::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        dde_seat *that = static_cast<dde_seat::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void dde_seat::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        dde_seat *that = resource->dde_seat_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->dde_seat_destroy_resource(resource);

            that = resource->dde_seat_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void dde_seat::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    dde_seat::Resource *dde_seat::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::dde_seat_interface, version, id);
        return bind(handle);
    }

    dde_seat::Resource *dde_seat::bind(struct ::wl_resource *handle)
    {
        Resource *resource = dde_seat_allocate();
        resource->dde_seat_object = this;

        wl_resource_set_implementation(handle, &m_dde_seat_interface, resource, destroy_func);
        resource->handle = handle;
        dde_seat_bind_resource(resource);
        return resource;
    }
    dde_seat::Resource *dde_seat::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::dde_seat_interface, &m_dde_seat_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::dde_seat_interface dde_seat::m_dde_seat_interface = {
        dde_seat::handle_get_dde_pointer,
        dde_seat::handle_get_dde_keyboard,
        dde_seat::handle_get_dde_touch
    };

    void dde_seat::dde_seat_get_dde_pointer(Resource *, uint32_t)
    {
    }

    void dde_seat::dde_seat_get_dde_keyboard(Resource *, uint32_t)
    {
    }

    void dde_seat::dde_seat_get_dde_touch(Resource *, uint32_t)
    {
    }


    void dde_seat::handle_get_dde_pointer(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_seat_object)) {
            return;
        }
        static_cast<dde_seat *>(r->dde_seat_object)->dde_seat_get_dde_pointer(
            r,
            id);
    }

    void dde_seat::handle_get_dde_keyboard(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_seat_object)) {
            return;
        }
        static_cast<dde_seat *>(r->dde_seat_object)->dde_seat_get_dde_keyboard(
            r,
            id);
    }

    void dde_seat::handle_get_dde_touch(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_seat_object)) {
            return;
        }
        static_cast<dde_seat *>(r->dde_seat_object)->dde_seat_get_dde_touch(
            r,
            id);
    }


    int dde_pointer::deferred_destroy_global_func(void *data) {
        auto object = static_cast<dde_pointer *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->dde_pointer_destroy_global();
        return 0;
    }

    dde_pointer::dde_pointer(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    dde_pointer::dde_pointer(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    dde_pointer::dde_pointer(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    dde_pointer::dde_pointer()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    dde_pointer::~dde_pointer()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->dde_pointer_object = nullptr;

        if (m_resource)
            m_resource->dde_pointer_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void dde_pointer::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void dde_pointer::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    dde_pointer::Resource *dde_pointer::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    dde_pointer::Resource *dde_pointer::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void dde_pointer::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::dde_pointer_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = dde_pointer::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *dde_pointer::interface()
    {
        return &::dde_pointer_interface;
    }

    dde_pointer::Resource *dde_pointer::dde_pointer_allocate()
    {
        return new Resource;
    }

    void dde_pointer::dde_pointer_destroy_global()
    {
    }

    void dde_pointer::dde_pointer_bind_resource(Resource *)
    {
    }

    void dde_pointer::dde_pointer_destroy_resource(Resource *)
    {
    }

    void dde_pointer::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        dde_pointer *that = static_cast<dde_pointer *>(data);
        that->add(client, id, version);
    }

    void dde_pointer::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        dde_pointer *that = static_cast<dde_pointer::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void dde_pointer::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        dde_pointer *that = resource->dde_pointer_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->dde_pointer_destroy_resource(resource);

            that = resource->dde_pointer_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void dde_pointer::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    dde_pointer::Resource *dde_pointer::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::dde_pointer_interface, version, id);
        return bind(handle);
    }

    dde_pointer::Resource *dde_pointer::bind(struct ::wl_resource *handle)
    {
        Resource *resource = dde_pointer_allocate();
        resource->dde_pointer_object = this;

        wl_resource_set_implementation(handle, &m_dde_pointer_interface, resource, destroy_func);
        resource->handle = handle;
        dde_pointer_bind_resource(resource);
        return resource;
    }
    dde_pointer::Resource *dde_pointer::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::dde_pointer_interface, &m_dde_pointer_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::dde_pointer_interface dde_pointer::m_dde_pointer_interface = {
        dde_pointer::handle_get_motion
    };

    void dde_pointer::dde_pointer_get_motion(Resource *)
    {
    }


    void dde_pointer::handle_get_motion(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_pointer_object)) {
            return;
        }
        static_cast<dde_pointer *>(r->dde_pointer_object)->dde_pointer_get_motion(
            r);
    }

    void dde_pointer::send_motion(wl_fixed_t x, wl_fixed_t y)
    {
        Q_ASSERT_X(m_resource, "dde_pointer::motion", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_pointer::motion as it's not initialised");
            return;
        }
        send_motion(
            m_resource->handle,
            x,
            y);
    }

    void dde_pointer::send_motion(struct ::wl_resource *resource, wl_fixed_t x, wl_fixed_t y)
    {
        dde_pointer_send_motion(
            resource,
            x,
            y);
    }


    void dde_pointer::send_button(wl_fixed_t x, wl_fixed_t y, uint32_t button, uint32_t state)
    {
        Q_ASSERT_X(m_resource, "dde_pointer::button", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_pointer::button as it's not initialised");
            return;
        }
        send_button(
            m_resource->handle,
            x,
            y,
            button,
            state);
    }

    void dde_pointer::send_button(struct ::wl_resource *resource, wl_fixed_t x, wl_fixed_t y, uint32_t button, uint32_t state)
    {
        dde_pointer_send_button(
            resource,
            x,
            y,
            button,
            state);
    }


    void dde_pointer::send_axis(uint32_t time, uint32_t axis, wl_fixed_t value)
    {
        Q_ASSERT_X(m_resource, "dde_pointer::axis", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_pointer::axis as it's not initialised");
            return;
        }
        send_axis(
            m_resource->handle,
            time,
            axis,
            value);
    }

    void dde_pointer::send_axis(struct ::wl_resource *resource, uint32_t time, uint32_t axis, wl_fixed_t value)
    {
        dde_pointer_send_axis(
            resource,
            time,
            axis,
            value);
    }



    int dde_keyboard::deferred_destroy_global_func(void *data) {
        auto object = static_cast<dde_keyboard *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->dde_keyboard_destroy_global();
        return 0;
    }

    dde_keyboard::dde_keyboard(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    dde_keyboard::dde_keyboard(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    dde_keyboard::dde_keyboard(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    dde_keyboard::dde_keyboard()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    dde_keyboard::~dde_keyboard()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->dde_keyboard_object = nullptr;

        if (m_resource)
            m_resource->dde_keyboard_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void dde_keyboard::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void dde_keyboard::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    dde_keyboard::Resource *dde_keyboard::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    dde_keyboard::Resource *dde_keyboard::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void dde_keyboard::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::dde_keyboard_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = dde_keyboard::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *dde_keyboard::interface()
    {
        return &::dde_keyboard_interface;
    }

    dde_keyboard::Resource *dde_keyboard::dde_keyboard_allocate()
    {
        return new Resource;
    }

    void dde_keyboard::dde_keyboard_destroy_global()
    {
    }

    void dde_keyboard::dde_keyboard_bind_resource(Resource *)
    {
    }

    void dde_keyboard::dde_keyboard_destroy_resource(Resource *)
    {
    }

    void dde_keyboard::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        dde_keyboard *that = static_cast<dde_keyboard *>(data);
        that->add(client, id, version);
    }

    void dde_keyboard::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        dde_keyboard *that = static_cast<dde_keyboard::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void dde_keyboard::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        dde_keyboard *that = resource->dde_keyboard_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->dde_keyboard_destroy_resource(resource);

            that = resource->dde_keyboard_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void dde_keyboard::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    dde_keyboard::Resource *dde_keyboard::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::dde_keyboard_interface, version, id);
        return bind(handle);
    }

    dde_keyboard::Resource *dde_keyboard::bind(struct ::wl_resource *handle)
    {
        Resource *resource = dde_keyboard_allocate();
        resource->dde_keyboard_object = this;

        wl_resource_set_implementation(handle, &m_dde_keyboard_interface, resource, destroy_func);
        resource->handle = handle;
        dde_keyboard_bind_resource(resource);
        return resource;
    }
    dde_keyboard::Resource *dde_keyboard::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::dde_keyboard_interface, &m_dde_keyboard_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::dde_keyboard_interface dde_keyboard::m_dde_keyboard_interface = {
        dde_keyboard::handle_release
    };

    void dde_keyboard::dde_keyboard_release(Resource *)
    {
    }


    void dde_keyboard::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_keyboard_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<dde_keyboard *>(r->dde_keyboard_object)->dde_keyboard_release(
            r);
    }

    void dde_keyboard::send_keymap(uint32_t format, int32_t fd, uint32_t size)
    {
        Q_ASSERT_X(m_resource, "dde_keyboard::keymap", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_keyboard::keymap as it's not initialised");
            return;
        }
        send_keymap(
            m_resource->handle,
            format,
            fd,
            size);
    }

    void dde_keyboard::send_keymap(struct ::wl_resource *resource, uint32_t format, int32_t fd, uint32_t size)
    {
        dde_keyboard_send_keymap(
            resource,
            format,
            fd,
            size);
    }


    void dde_keyboard::send_enter(uint32_t serial, struct ::wl_resource *surface, const QByteArray &keys)
    {
        Q_ASSERT_X(m_resource, "dde_keyboard::enter", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_keyboard::enter as it's not initialised");
            return;
        }
        send_enter(
            m_resource->handle,
            serial,
            surface,
            keys);
    }

    void dde_keyboard::send_enter(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface, const QByteArray &keys)
    {
        struct wl_array keys_data;
        keys_data.size = keys.size();
        keys_data.data = static_cast<void *>(const_cast<char *>(keys.constData()));
        keys_data.alloc = 0;

        dde_keyboard_send_enter(
            resource,
            serial,
            surface,
            &keys_data);
    }


    void dde_keyboard::send_leave(uint32_t serial, struct ::wl_resource *surface)
    {
        Q_ASSERT_X(m_resource, "dde_keyboard::leave", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_keyboard::leave as it's not initialised");
            return;
        }
        send_leave(
            m_resource->handle,
            serial,
            surface);
    }

    void dde_keyboard::send_leave(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface)
    {
        dde_keyboard_send_leave(
            resource,
            serial,
            surface);
    }


    void dde_keyboard::send_key(uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
    {
        Q_ASSERT_X(m_resource, "dde_keyboard::key", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_keyboard::key as it's not initialised");
            return;
        }
        send_key(
            m_resource->handle,
            serial,
            time,
            key,
            state);
    }

    void dde_keyboard::send_key(struct ::wl_resource *resource, uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
    {
        dde_keyboard_send_key(
            resource,
            serial,
            time,
            key,
            state);
    }


    void dde_keyboard::send_modifiers(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
    {
        Q_ASSERT_X(m_resource, "dde_keyboard::modifiers", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_keyboard::modifiers as it's not initialised");
            return;
        }
        send_modifiers(
            m_resource->handle,
            serial,
            mods_depressed,
            mods_latched,
            mods_locked,
            group);
    }

    void dde_keyboard::send_modifiers(struct ::wl_resource *resource, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
    {
        dde_keyboard_send_modifiers(
            resource,
            serial,
            mods_depressed,
            mods_latched,
            mods_locked,
            group);
    }


    void dde_keyboard::send_repeat_info(int32_t rate, int32_t delay)
    {
        Q_ASSERT_X(m_resource, "dde_keyboard::repeat_info", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_keyboard::repeat_info as it's not initialised");
            return;
        }
        send_repeat_info(
            m_resource->handle,
            rate,
            delay);
    }

    void dde_keyboard::send_repeat_info(struct ::wl_resource *resource, int32_t rate, int32_t delay)
    {
        dde_keyboard_send_repeat_info(
            resource,
            rate,
            delay);
    }



    int dde_touch::deferred_destroy_global_func(void *data) {
        auto object = static_cast<dde_touch *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->dde_touch_destroy_global();
        return 0;
    }

    dde_touch::dde_touch(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    dde_touch::dde_touch(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    dde_touch::dde_touch(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    dde_touch::dde_touch()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    dde_touch::~dde_touch()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->dde_touch_object = nullptr;

        if (m_resource)
            m_resource->dde_touch_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void dde_touch::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void dde_touch::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    dde_touch::Resource *dde_touch::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    dde_touch::Resource *dde_touch::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void dde_touch::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::dde_touch_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = dde_touch::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *dde_touch::interface()
    {
        return &::dde_touch_interface;
    }

    dde_touch::Resource *dde_touch::dde_touch_allocate()
    {
        return new Resource;
    }

    void dde_touch::dde_touch_destroy_global()
    {
    }

    void dde_touch::dde_touch_bind_resource(Resource *)
    {
    }

    void dde_touch::dde_touch_destroy_resource(Resource *)
    {
    }

    void dde_touch::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        dde_touch *that = static_cast<dde_touch *>(data);
        that->add(client, id, version);
    }

    void dde_touch::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        dde_touch *that = static_cast<dde_touch::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void dde_touch::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        dde_touch *that = resource->dde_touch_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->dde_touch_destroy_resource(resource);

            that = resource->dde_touch_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void dde_touch::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    dde_touch::Resource *dde_touch::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::dde_touch_interface, version, id);
        return bind(handle);
    }

    dde_touch::Resource *dde_touch::bind(struct ::wl_resource *handle)
    {
        Resource *resource = dde_touch_allocate();
        resource->dde_touch_object = this;

        wl_resource_set_implementation(handle, &m_dde_touch_interface, resource, destroy_func);
        resource->handle = handle;
        dde_touch_bind_resource(resource);
        return resource;
    }
    dde_touch::Resource *dde_touch::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::dde_touch_interface, &m_dde_touch_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::dde_touch_interface dde_touch::m_dde_touch_interface = {
        dde_touch::handle_release
    };

    void dde_touch::dde_touch_release(Resource *)
    {
    }


    void dde_touch::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_touch_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<dde_touch *>(r->dde_touch_object)->dde_touch_release(
            r);
    }

    void dde_touch::send_down(int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y)
    {
        Q_ASSERT_X(m_resource, "dde_touch::down", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_touch::down as it's not initialised");
            return;
        }
        send_down(
            m_resource->handle,
            id,
            time,
            x,
            y);
    }

    void dde_touch::send_down(struct ::wl_resource *resource, int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y)
    {
        dde_touch_send_down(
            resource,
            id,
            time,
            x,
            y);
    }


    void dde_touch::send_up(int32_t id, uint32_t time)
    {
        Q_ASSERT_X(m_resource, "dde_touch::up", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_touch::up as it's not initialised");
            return;
        }
        send_up(
            m_resource->handle,
            id,
            time);
    }

    void dde_touch::send_up(struct ::wl_resource *resource, int32_t id, uint32_t time)
    {
        dde_touch_send_up(
            resource,
            id,
            time);
    }


    void dde_touch::send_motion(int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y)
    {
        Q_ASSERT_X(m_resource, "dde_touch::motion", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_touch::motion as it's not initialised");
            return;
        }
        send_motion(
            m_resource->handle,
            id,
            time,
            x,
            y);
    }

    void dde_touch::send_motion(struct ::wl_resource *resource, int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y)
    {
        dde_touch_send_motion(
            resource,
            id,
            time,
            x,
            y);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
