/* Generated by wayland-scanner 1.23.0 */

#ifndef DDE_SHELL_CLIENT_PROTOCOL_H
#define DDE_SHELL_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_dde_shell The dde_shell protocol
 * @section page_ifaces_dde_shell Interfaces
 * - @subpage page_iface_dde_shell - get window info
 * - @subpage page_iface_dde_shell_surface - dde shell surface
 * @section page_copyright_dde_shell Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_shell;
struct dde_shell_surface;
struct wl_surface;

#ifndef DDE_SHELL_INTERFACE
#define DDE_SHELL_INTERFACE
/**
 * @page page_iface_dde_shell dde_shell
 * @section page_iface_dde_shell_desc Description
 *
 * Eg: window position.
 * @section page_iface_dde_shell_api API
 * See @ref iface_dde_shell.
 */
/**
 * @defgroup iface_dde_shell The dde_shell interface
 *
 * Eg: window position.
 */
extern const struct wl_interface dde_shell_interface;
#endif
#ifndef DDE_SHELL_SURFACE_INTERFACE
#define DDE_SHELL_SURFACE_INTERFACE
/**
 * @page page_iface_dde_shell_surface dde_shell_surface
 * @section page_iface_dde_shell_surface_desc Description
 *
 *
 * @section page_iface_dde_shell_surface_api API
 * See @ref iface_dde_shell_surface.
 */
/**
 * @defgroup iface_dde_shell_surface The dde_shell_surface interface
 *
 *
 */
extern const struct wl_interface dde_shell_surface_interface;
#endif

#ifndef DDE_SHELL_STATE_ENUM
#define DDE_SHELL_STATE_ENUM
enum dde_shell_state {
	DDE_SHELL_STATE_ACTIVE = 1 << 0,
	DDE_SHELL_STATE_MINIMIZED = 1 << 1,
	DDE_SHELL_STATE_MAXIMIZED = 1 << 2,
	DDE_SHELL_STATE_FULLSCREEN = 1 << 3,
	DDE_SHELL_STATE_KEEP_ABOVE = 1 << 4,
	DDE_SHELL_STATE_KEEP_BELOW = 1 << 5,
	DDE_SHELL_STATE_ON_ALL_DESKTOPS = 1 << 6,
	DDE_SHELL_STATE_DEMANDS_ATTENTION = 1 << 7,
	DDE_SHELL_STATE_CLOSEABLE = 1 << 8,
	DDE_SHELL_STATE_MINIMIZABLE = 1 << 9,
	DDE_SHELL_STATE_MAXIMIZABLE = 1 << 10,
	DDE_SHELL_STATE_FULLSCREENABLE = 1 << 11,
	DDE_SHELL_STATE_SKIPTASKBAR = 1 << 12,
	DDE_SHELL_STATE_SHADEABLE = 1 << 13,
	DDE_SHELL_STATE_SHADED = 1 << 14,
	DDE_SHELL_STATE_MOVABLE = 1 << 15,
	DDE_SHELL_STATE_RESIZABLE = 1 << 16,
	DDE_SHELL_STATE_VIRTUAL_DESKTOP_CHANGEABLE = 1 << 17,
	DDE_SHELL_STATE_SKIPSWITCHER = 1 << 18,
	DDE_SHELL_STATE_ACCEPT_FOCUS = 1 << 19,
	DDE_SHELL_STATE_MODALITY = 1 << 20,
	DDE_SHELL_STATE_TWO_SPLIT = 1 << 21,
	DDE_SHELL_STATE_FOUR_SPLIT = 1 << 22,
	DDE_SHELL_STATE_NO_SPLIT = 1 << 23,
};
#endif /* DDE_SHELL_STATE_ENUM */

#ifndef DDE_SHELL_PROPERTY_ENUM
#define DDE_SHELL_PROPERTY_ENUM
enum dde_shell_property {
	DDE_SHELL_PROPERTY_NOTITLEBAR = 1 << 0,
	DDE_SHELL_PROPERTY_THEME = 1 << 1,
	DDE_SHELL_PROPERTY_WINDOWRADIUS = 1 << 2,
	DDE_SHELL_PROPERTY_BORDERWIDTH = 1 << 3,
	DDE_SHELL_PROPERTY_BORDERCOLOR = 1 << 4,
	DDE_SHELL_PROPERTY_SHADOWRADIUS = 1 << 5,
	DDE_SHELL_PROPERTY_SHADOWOFFSET = 1 << 6,
	DDE_SHELL_PROPERTY_SHADOWCOLOR = 1 << 7,
	DDE_SHELL_PROPERTY_MOUSEINPUTAREAMARGINS = 1 << 8,
	DDE_SHELL_PROPERTY_WINDOWPIXELRATIO = 1 << 9,
	DDE_SHELL_PROPERTY_QUICKTILE = 1 << 10,
};
#endif /* DDE_SHELL_PROPERTY_ENUM */

#define DDE_SHELL_GET_SHELL_SURFACE 0


/**
 * @ingroup iface_dde_shell
 */
#define DDE_SHELL_GET_SHELL_SURFACE_SINCE_VERSION 1

/** @ingroup iface_dde_shell */
static inline void
dde_shell_set_user_data(struct dde_shell *dde_shell, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) dde_shell, user_data);
}

/** @ingroup iface_dde_shell */
static inline void *
dde_shell_get_user_data(struct dde_shell *dde_shell)
{
	return wl_proxy_get_user_data((struct wl_proxy *) dde_shell);
}

static inline uint32_t
dde_shell_get_version(struct dde_shell *dde_shell)
{
	return wl_proxy_get_version((struct wl_proxy *) dde_shell);
}

/** @ingroup iface_dde_shell */
static inline void
dde_shell_destroy(struct dde_shell *dde_shell)
{
	wl_proxy_destroy((struct wl_proxy *) dde_shell);
}

/**
 * @ingroup iface_dde_shell
 *
 */
static inline struct dde_shell_surface *
dde_shell_get_shell_surface(struct dde_shell *dde_shell, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) dde_shell,
			 DDE_SHELL_GET_SHELL_SURFACE, &dde_shell_surface_interface, wl_proxy_get_version((struct wl_proxy *) dde_shell), 0, NULL, surface);

	return (struct dde_shell_surface *) id;
}

/**
 * @ingroup iface_dde_shell_surface
 * @struct dde_shell_surface_listener
 */
struct dde_shell_surface_listener {
	/**
	 * notify geometry changed
	 *
	 * Send geometry to client everytime the window geometry changed
	 * @param x x pos
	 * @param y y pos
	 * @param w width
	 * @param h height
	 */
	void (*geometry)(void *data,
			 struct dde_shell_surface *dde_shell_surface,
			 int32_t x,
			 int32_t y,
			 uint32_t w,
			 uint32_t h);
	/**
	 * window state has been changed
	 *
	 * This event will be sent as soon as the window state changes.
	 *
	 * Values for state argument are described by dde_shell.state.
	 * @param flags bitfield of state flags
	 */
	void (*state_changed)(void *data,
			      struct dde_shell_surface *dde_shell_surface,
			      uint32_t flags);
};

/**
 * @ingroup iface_dde_shell_surface
 */
static inline int
dde_shell_surface_add_listener(struct dde_shell_surface *dde_shell_surface,
			       const struct dde_shell_surface_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) dde_shell_surface,
				     (void (**)(void)) listener, data);
}

#define DDE_SHELL_SURFACE_GET_GEOMETRY 0
#define DDE_SHELL_SURFACE_REQUEST_ACTIVE 1
#define DDE_SHELL_SURFACE_SET_STATE 2
#define DDE_SHELL_SURFACE_SET_PROPERTY 3

/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_STATE_CHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_GET_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_REQUEST_ACTIVE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_SET_PROPERTY_SINCE_VERSION 1

/** @ingroup iface_dde_shell_surface */
static inline void
dde_shell_surface_set_user_data(struct dde_shell_surface *dde_shell_surface, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) dde_shell_surface, user_data);
}

/** @ingroup iface_dde_shell_surface */
static inline void *
dde_shell_surface_get_user_data(struct dde_shell_surface *dde_shell_surface)
{
	return wl_proxy_get_user_data((struct wl_proxy *) dde_shell_surface);
}

static inline uint32_t
dde_shell_surface_get_version(struct dde_shell_surface *dde_shell_surface)
{
	return wl_proxy_get_version((struct wl_proxy *) dde_shell_surface);
}

/** @ingroup iface_dde_shell_surface */
static inline void
dde_shell_surface_destroy(struct dde_shell_surface *dde_shell_surface)
{
	wl_proxy_destroy((struct wl_proxy *) dde_shell_surface);
}

/**
 * @ingroup iface_dde_shell_surface
 *
 * reques windo geometry, will notify by "geometry" event.
 */
static inline void
dde_shell_surface_get_geometry(struct dde_shell_surface *dde_shell_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) dde_shell_surface,
			 DDE_SHELL_SURFACE_GET_GEOMETRY, NULL, wl_proxy_get_version((struct wl_proxy *) dde_shell_surface), 0);
}

/**
 * @ingroup iface_dde_shell_surface
 *
 * request to activate current shell if it's not active
 */
static inline void
dde_shell_surface_request_active(struct dde_shell_surface *dde_shell_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) dde_shell_surface,
			 DDE_SHELL_SURFACE_REQUEST_ACTIVE, NULL, wl_proxy_get_version((struct wl_proxy *) dde_shell_surface), 0);
}

/**
 * @ingroup iface_dde_shell_surface
 *
 * Set window state.
 *
 * Values for state argument are described by dde_shell.state
 * and can be used together in a bitfield. The flags bitfield describes which flags are
 * supposed to be set, the state bitfield the value for the set flags
 */
static inline void
dde_shell_surface_set_state(struct dde_shell_surface *dde_shell_surface, uint32_t flags, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) dde_shell_surface,
			 DDE_SHELL_SURFACE_SET_STATE, NULL, wl_proxy_get_version((struct wl_proxy *) dde_shell_surface), 0, flags, state);
}

/**
 * @ingroup iface_dde_shell_surface
 *
 * Set window property.
 *
 * Values for property argument are described by dde_shell.property
 * and can be used together in a bitfield. The flags bitfield describes which property are
 * supposed to be set.
 */
static inline void
dde_shell_surface_set_property(struct dde_shell_surface *dde_shell_surface, uint32_t property, struct wl_array *dataArr)
{
	wl_proxy_marshal_flags((struct wl_proxy *) dde_shell_surface,
			 DDE_SHELL_SURFACE_SET_PROPERTY, NULL, wl_proxy_get_version((struct wl_proxy *) dde_shell_surface), 0, property, dataArr);
}

#ifdef  __cplusplus
}
#endif

#endif
