/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class DelegatingInvocationHandler<T>
implements InvocationHandler {
    private volatile boolean initialized;
    private T delegate;

    DelegatingInvocationHandler() {
    }

    @Override
    public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
        try {
            Preconditions.checkState((boolean)this.initialized, (Object)"This is a proxy used to support circular references. The object we're proxying is not constructed yet. Please wait until after injection has completed to use this object.");
            Preconditions.checkNotNull(this.delegate, (Object)"This is a proxy used to support circular references. The object we're  proxying is initialized to null. No methods can be called.");
            return method.invoke(this.delegate, args);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalArgumentException e3) {
            throw new RuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            throw e4.getTargetException();
        }
    }

    void setDelegate(T delegate) {
        this.delegate = delegate;
        this.initialized = true;
    }
}

