/*
 Copyright (c) 2015 Thomas Klausner
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.
*/
#include <sys/types.h>
#include <sys/stat.h>
#include <fts.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

time_t
get_newest(char * const *path) {
	FTS *dh;
	FTSENT *entry;
	time_t newest = 0;
	dh = fts_open(path, FTS_PHYSICAL, NULL);
	if (dh == NULL) {
		return 0;
	}
	while ((entry=fts_read(dh)) != NULL) {
		if ((entry->fts_info != FTS_F) || (entry->fts_statp == NULL)) {
			continue;
		}
		if (entry->fts_statp->st_mtime > newest) {
			newest = entry->fts_statp->st_mtime;
		}
	}

	if (fts_close(dh) != 0) {
		return 0;
	}

	return newest;
}


int
main(int argc, char * const *argv)
{
	time_t newest = 0;

	if (argc < 2 || (newest=get_newest(argv+1)) == 0) {
		fprintf(stderr, "no files found\n");
		exit(1);
	}

	printf("%lld\n", (long long)newest);
	exit(0);
}
