/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre12Compat
extends Jre9Compat {
    private static final Log log = LogFactory.getLog(Jre12Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre12Compat.class);
    private static final boolean supported;

    static boolean isSupported() {
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanonCachesDisabled() {
        if (canonCachesDisabled != null) {
            return canonCachesDisabled;
        }
        Object object = canonCachesDisabledLock;
        synchronized (object) {
            if (canonCachesDisabled != null) {
                return canonCachesDisabled;
            }
            List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String string : list) {
                String string2;
                boolean bl;
                if (!string.startsWith("-Dsun.io.useCanonCaches=") || !(bl = Boolean.valueOf(string2 = string.substring("-Dsun.io.useCanonCaches=".length())).booleanValue())) continue;
                canonCachesDisabled = Boolean.FALSE;
                return false;
            }
            canonCachesDisabled = Boolean.TRUE;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureUseCanonCachesFieldIsPopulated() {
        if (useCanonCachesField != null) {
            return;
        }
        Object object = useCanonCachesFieldLock;
        synchronized (object) {
            if (useCanonCachesField != null) {
                return;
            }
            Field field = null;
            try {
                Class<?> clazz = Class.forName("java.io.FileSystem");
                field = clazz.getDeclaredField("useCanonCaches");
                field.setAccessible(true);
                Method method = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                Method method2 = MethodHandles.Lookup.class.getDeclaredMethod("findVarHandle", Class.class, String.class, Class.class);
                clazz = Class.forName("java.lang.invoke.VarHandle");
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)method.invoke(null, Field.class, MethodHandles.lookup());
                Object object2 = method2.invoke((Object)lookup, Field.class, "modifiers", Integer.TYPE);
                Method method3 = null;
                try {
                    method3 = object2.getClass().getDeclaredMethod("set", object2.getClass(), Object.class, Integer.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method3 = object2.getClass().getDeclaredMethod("set", clazz, Object.class, Integer.TYPE);
                }
                method3.setAccessible(true);
                method3.invoke(null, object2, field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                field = null;
                log.warn((Object)sm.getString("jreCompat.useCanonCaches.java18"), (Throwable)noSuchMethodException);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                field = null;
                log.warn((Object)sm.getString("jreCompat.useCanonCaches.init"), throwable);
            }
            useCanonCachesField = field == null ? Optional.empty() : Optional.of(field);
        }
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.text.CompactNumberFormat");
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            log.debug((Object)sm.getString("jre12Compat.javaPre12"), (Throwable)reflectiveOperationException);
        }
        supported = clazz != null;
    }
}

