/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class MultFunction {
    public static final String name = "mult";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The mult function requires parameters.");
        }
        if (params.length == 1) {
            if (params[0] instanceof DoubleValueStream) {
                return LambdaFunction.createDoubleLambdaFunction(name, (a, b) -> a * b, (DoubleValueStream)params[0]);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The mult function requires numeric parameters. Incorrect param: " + params[0].getExpressionStr());
        }
        if (params.length == 2) {
            AnalyticsValueStream param1 = params[0];
            AnalyticsValueStream param2 = params[1];
            if (param1 instanceof DoubleValueStream && param2 instanceof DoubleValueStream) {
                return LambdaFunction.createDoubleLambdaFunction(name, (a, b) -> a * b, (DoubleValueStream)param1, (DoubleValueStream)param2);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The mult function requires numeric parameters.");
        }
        DoubleValue[] castedParams = new DoubleValue[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof DoubleValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The mult function requires that all parameters be single-valued if more than 2 are given.");
            }
            castedParams[i] = (DoubleValue)params[i];
        }
        return LambdaFunction.createDoubleLambdaFunction(name, (a, b) -> a * b, castedParams);
    };
}

