/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRecentProjectCachedBranch;
import git4idea.repo.GitRecentProjectsBranchesService;
import git4idea.repo.GitRefUtil;
import git4idea.repo.RecentProjectsShowBranchMode;
import git4idea.util.CaffeineUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/repo/GitRecentProjectsBranchesService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "updateRecentProjectsSignal", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "cache", "Lcom/github/benmanes/caffeine/cache/AsyncLoadingCache;", "", "Lgit4idea/repo/GitRecentProjectCachedBranch;", "getCurrentBranch", "projectPath", "nameIsDistinct", "", "BranchesLoader", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRecentProjectsBranchesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRecentProjectsBranchesProvider.kt\ngit4idea/repo/GitRecentProjectsBranchesService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n23#2:183\n*S KotlinDebug\n*F\n+ 1 GitRecentProjectsBranchesProvider.kt\ngit4idea/repo/GitRecentProjectsBranchesService\n*L\n133#1:183\n*E\n"})
public final class GitRecentProjectsBranchesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableSharedFlow<Unit> updateRecentProjectsSignal;
    @NotNull
    private final AsyncLoadingCache<String, GitRecentProjectCachedBranch> cache;
    private static final Duration REFRESH_IN = Duration.ofSeconds(30L);
    private static final Duration EXPIRE_IN = Duration.ofSeconds(60L);
    @NotNull
    private static final Logger LOG;

    public GitRecentProjectsBranchesService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.updateRecentProjectsSignal = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        AsyncLoadingCache asyncLoadingCache = CaffeineUtil.INSTANCE.withIoExecutor().refreshAfterWrite(REFRESH_IN).expireAfterAccess(EXPIRE_IN).buildAsync((AsyncCacheLoader)new BranchesLoader());
        Intrinsics.checkNotNullExpressionValue((Object)asyncLoadingCache, (String)"buildAsync(...)");
        this.cache = asyncLoadingCache;
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationKt.getApplication().getMessageBus().connect(this.coroutineScope);
        Topic topic = ApplicationActivationListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new ApplicationActivationListener(){

            public void applicationActivated(IdeFrame ideFrame) {
                Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                Project project = ideFrame.getProject();
                boolean bl = project != null ? project.isDefault() : false;
                if (bl) {
                    cache.synchronous().refreshAll((Iterable)cache.asMap().keySet());
                }
            }
        });
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ GitRecentProjectsBranchesService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        RecentProjectsManager.RecentProjectsChange recentProjectsTopic = (RecentProjectsManager.RecentProjectsChange)ApplicationKt.getApplication().getMessageBus().syncPublisher(RecentProjectsManager.Companion.getRECENT_PROJECTS_CHANGE_TOPIC());
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)recentProjectsTopic);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce((Flow)((Flow)this.this$0.updateRecentProjectsSignal), (long)50L), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(recentProjectsTopic, null){
                            int label;
                            final /* synthetic */ RecentProjectsManager.RecentProjectsChange $recentProjectsTopic;
                            {
                                this.$recentProjectsTopic = $recentProjectsTopic;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$recentProjectsTopic, null){
                                            int label;
                                            final /* synthetic */ RecentProjectsManager.RecentProjectsChange $recentProjectsTopic;
                                            {
                                                this.$recentProjectsTopic = $recentProjectsTopic;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.$recentProjectsTopic.change();
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        RecentProjectsManager.RecentProjectsChange recentProjectsTopic = (RecentProjectsManager.RecentProjectsChange)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final String getCurrentBranch(@NotNull String projectPath, boolean nameIsDistinct) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        RecentProjectsShowBranchMode showBranchMode = (RecentProjectsShowBranchMode)AdvancedSettings.Companion.getEnum("git.recent.projects.show.branch", RecentProjectsShowBranchMode.class);
        if (!showBranchMode.shouldShow(nameIsDistinct)) {
            return null;
        }
        Path path = Paths.get(projectPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        if (!Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)path), (Object)LocalEelDescriptor.INSTANCE)) {
            return null;
        }
        CompletableFuture completableFuture = this.cache.get((Object)projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"get(...)");
        CompletableFuture branchFuture = completableFuture;
        GitRecentProjectCachedBranch.Unknown unknown = branchFuture.getNow(GitRecentProjectCachedBranch.Unknown.INSTANCE);
        GitRecentProjectCachedBranch.KnownBranch knownBranch = unknown instanceof GitRecentProjectCachedBranch.KnownBranch ? (GitRecentProjectCachedBranch.KnownBranch)((Object)unknown) : null;
        return knownBranch != null ? knownBranch.getBranchName() : null;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lgit4idea/repo/GitRecentProjectsBranchesService$BranchesLoader;", "Lcom/github/benmanes/caffeine/cache/AsyncCacheLoader;", "", "Lgit4idea/repo/GitRecentProjectCachedBranch;", "<init>", "(Lgit4idea/repo/GitRecentProjectsBranchesService;)V", "asyncLoad", "Ljava/util/concurrent/CompletableFuture;", "key", "executor", "Ljava/util/concurrent/Executor;", "asyncReload", "oldValue", "loadBranch", "projectPath", "previousValue", "intellij.vcs.git"})
    private final class BranchesLoader
    implements AsyncCacheLoader<String, GitRecentProjectCachedBranch> {
        @NotNull
        public CompletableFuture<GitRecentProjectCachedBranch> asyncLoad(@NotNull String key, @NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return this.loadBranch(key, null, executor);
        }

        @NotNull
        public CompletableFuture<GitRecentProjectCachedBranch> asyncReload(@NotNull String key, @NotNull GitRecentProjectCachedBranch oldValue, @NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return this.loadBranch(key, oldValue, executor);
        }

        private final CompletableFuture<GitRecentProjectCachedBranch> loadBranch(String projectPath, GitRecentProjectCachedBranch previousValue, Executor executor) {
            CompletionStage completionStage = FutureKt.future$default((CoroutineScope)GitRecentProjectsBranchesService.this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitRecentProjectCachedBranch>, Object>(previousValue, projectPath, null){
                int label;
                final /* synthetic */ GitRecentProjectCachedBranch $previousValue;
                final /* synthetic */ String $projectPath;
                {
                    this.$previousValue = $previousValue;
                    this.$projectPath = $projectPath;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = GitRecentProjectsBranchesService.Companion.loadBranch$intellij_vcs_git(this.$previousValue, this.$projectPath, (Continuation<? super GitRecentProjectCachedBranch>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super GitRecentProjectCachedBranch> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null).whenCompleteAsync((arg_0, arg_1) -> BranchesLoader.loadBranch$lambda$1((arg_0, arg_1) -> BranchesLoader.loadBranch$lambda$0(previousValue, GitRecentProjectsBranchesService.this, arg_0, arg_1), arg_0, arg_1), executor);
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenCompleteAsync(...)");
            return completionStage;
        }

        private static final Unit loadBranch$lambda$0(GitRecentProjectCachedBranch $previousValue, GitRecentProjectsBranchesService this$0, GitRecentProjectCachedBranch branch, Throwable throwable) {
            if (branch != null && !Intrinsics.areEqual((Object)branch, (Object)$previousValue)) {
                this$0.updateRecentProjectsSignal.tryEmit((Object)Unit.INSTANCE);
            }
            return Unit.INSTANCE;
        }

        private static final void loadBranch$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0081@\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0082@\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/repo/GitRecentProjectsBranchesService$Companion;", "", "<init>", "()V", "REFRESH_IN", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "EXPIRE_IN", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "loadBranch", "Lgit4idea/repo/GitRecentProjectCachedBranch;", "previousValue", "projectPath", "", "loadBranch$intellij_vcs_git", "(Lgit4idea/repo/GitRecentProjectCachedBranch;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBranch", "headFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findGitHead", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findGitDir", "path", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRecentProjectsBranchesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRecentProjectsBranchesProvider.kt\ngit4idea/repo/GitRecentProjectsBranchesService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @VisibleForTesting
        @Nullable
        public final Object loadBranch$intellij_vcs_git(@Nullable GitRecentProjectCachedBranch previousValue, @NotNull String projectPath, @NotNull Continuation<? super GitRecentProjectCachedBranch> $completion) {
            if (!($completion instanceof loadBranch.1)) ** GOTO lbl-1000
            var9_4 = $completion;
            if ((var9_4.label & -2147483648) != 0) {
                var9_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.loadBranch$intellij_vcs_git(null, null, (Continuation<? super GitRecentProjectCachedBranch>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (Intrinsics.areEqual((Object)previousValue, (Object)GitRecentProjectCachedBranch.Unknown.INSTANCE)) {
                        return previousValue;
                    }
                    v0 = previousValue;
                    if (v0 == null || (v0 = v0.getHeadFilePath()) == null) ** GOTO lbl24
                    p0 = v0;
                    $i$a$-let-GitRecentProjectsBranchesService$Companion$loadBranch$headFile$1 = false;
                    v1 = Path.of((String)p0, new String[0]);
                    v0 = v1;
                    if (v1 != null) ** GOTO lbl39
lbl24:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)previousValue);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectPath);
                    $continuation.label = 1;
                    v2 = this.findGitHead(projectPath, (Continuation<? super Path>)$continuation);
                    ** if (v2 != var10_6) goto lbl30
lbl29:
                    // 1 sources

                    return var10_6;
lbl30:
                    // 1 sources

                    ** GOTO lbl38
                }
                case 1: {
                    projectPath = (String)$continuation.L$1;
                    previousValue = (GitRecentProjectCachedBranch)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl38:
                    // 2 sources

                    v0 = (Path)v2;
lbl39:
                    // 2 sources

                    headFile = v0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)previousValue);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectPath);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)headFile);
                    $continuation.label = 2;
                    v3 = this.getBranch((Path)headFile, (Continuation<? super GitRecentProjectCachedBranch>)$continuation);
                    ** if (v3 != var10_6) goto lbl47
lbl46:
                    // 1 sources

                    return var10_6;
lbl47:
                    // 1 sources

                    ** GOTO lbl56
                }
                case 2: {
                    headFile = (Path)$continuation.L$2;
                    projectPath = (String)$continuation.L$1;
                    previousValue = (GitRecentProjectCachedBranch)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl56:
                        // 2 sources

                        var4_9 = (GitRecentProjectCachedBranch)v3;
                    }
                    catch (Exception e) {
                        GitRecentProjectsBranchesService.access$getLOG$cp().warn("Failed to detect git branch", (Throwable)e);
                        var4_9 = GitRecentProjectCachedBranch.Unknown.INSTANCE;
                    }
                    return var4_9;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object getBranch(Path headFile, Continuation<? super GitRecentProjectCachedBranch> $completion) {
            if (!($completion instanceof getBranch.1)) ** GOTO lbl-1000
            var6_3 = $completion;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return git4idea.repo.GitRecentProjectsBranchesService$Companion.access$getBranch(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (headFile == null) {
                        return GitRecentProjectCachedBranch.Unknown.INSTANCE;
                    }
                    $continuation.L$0 = headFile;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(headFile, null){
                        int label;
                        final /* synthetic */ Path $headFile;
                        {
                            this.$headFile = $headFile;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    return Files.exists(this.$headFile, new LinkOption[0]) ? ((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)this.$headFile, null, (int)1, null))).toString() : null;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    headFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    v1 = (String)v0;
                    if (v1 == null) {
                        return GitRecentProjectCachedBranch.Unknown.INSTANCE;
                    }
                    headFileContent = v1;
                    v2 = GitRefUtil.parseHash(headFileContent) == null ? GitRefUtil.getTarget(headFileContent) : null;
                    if (v2 == null) {
                        return new GitRecentProjectCachedBranch.NotOnBranch(headFile.toAbsolutePath().toString());
                    }
                    targetRef = v2;
                    v3 = GitBranchUtil.stripRefsPrefix(targetRef);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"stripRefsPrefix(...)");
                    return new GitRecentProjectCachedBranch.KnownBranch(v3, headFile.toAbsolutePath().toString());
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object findGitHead(String projectPath, Continuation<? super Path> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(projectPath, null){
                int label;
                final /* synthetic */ String $projectPath;
                {
                    this.$projectPath = $projectPath;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Path path;
                            ResultKt.throwOnFailure((Object)$result);
                            Path path2 = Paths.get(this.$projectPath, new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                            Path path3 = git4idea.repo.GitRecentProjectsBranchesService$Companion.access$findGitDir(GitRecentProjectsBranchesService.Companion, path2);
                            if (path3 != null && (path3 = path3.resolve("HEAD")) != null) {
                                Path path4;
                                Path it = path4 = path3;
                                boolean bl = false;
                                path = Files.exists(it, new LinkOption[0]) ? path4 : null;
                            } else {
                                path = null;
                            }
                            return path;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final Path findGitDir(Path path) {
            return (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)path, Companion::findGitDir$lambda$0), Companion::findGitDir$lambda$1));
        }

        private static final Path findGitDir$lambda$0(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getParent();
        }

        private static final Path findGitDir$lambda$1(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return GitUtil.findGitDir(it);
        }

        public static final /* synthetic */ Object access$getBranch(Companion $this, Path headFile, Continuation $completion) {
            return $this.getBranch(headFile, (Continuation<? super GitRecentProjectCachedBranch>)$completion);
        }

        public static final /* synthetic */ Object access$findGitHead(Companion $this, String projectPath, Continuation $completion) {
            return $this.findGitHead(projectPath, (Continuation<? super Path>)$completion);
        }

        public static final /* synthetic */ Path access$findGitDir(Companion $this, Path path) {
            return $this.findGitDir(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

