/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class CachedIconLoader {
    private static final Map<String, Icon> icons = new ConcurrentHashMap<String, Icon>();

    private CachedIconLoader() {
    }

    public static Icon getIcon(URL url) {
        if (url != null) {
            String key = url.toString();
            if (!icons.containsKey(key)) {
                ImageIcon i = new ImageIcon(url);
                icons.put(key, i);
            }
            return icons.get(key);
        }
        return null;
    }

    public static Icon getIcon(String urlString) {
        if (urlString != null) {
            if (!icons.containsKey(urlString)) {
                try {
                    URL url = new URL(urlString);
                    ImageIcon i = new ImageIcon(url);
                    icons.put(urlString, i);
                }
                catch (MalformedURLException e1) {
                    return null;
                }
            }
            return icons.get(urlString);
        }
        return null;
    }
}

