/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.IOException;
import org.apache.tika.parser.wordperfect.WPInputStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

abstract class WPDocumentAreaExtractor {
    boolean startedP = false;

    WPDocumentAreaExtractor() {
    }

    public void extract(WPInputStream in, XHTMLContentHandler xhtml) throws IOException, SAXException {
        int c;
        int chunk = 4096;
        StringBuilder out = new StringBuilder(chunk);
        while ((c = in.read()) != -1) {
            this.extract(c, in, out, xhtml);
            if (out.length() < chunk) continue;
            xhtml.characters(out.toString());
            out.setLength(0);
        }
        this.endParagraph(out, xhtml);
    }

    protected abstract void extract(int var1, WPInputStream var2, StringBuilder var3, XHTMLContentHandler var4) throws IOException, SAXException;

    protected void lazilyStartParagraph(XHTMLContentHandler xhtml) throws SAXException {
        if (!this.startedP) {
            xhtml.startElement("p");
        }
        this.startedP = true;
    }

    protected void endParagraph(StringBuilder buffer, XHTMLContentHandler xhtml) throws SAXException {
        this.lazilyStartParagraph(xhtml);
        xhtml.characters(buffer.toString());
        buffer.setLength(0);
        xhtml.endElement("p");
        this.startedP = false;
    }

    protected int skipUntilChar(WPInputStream in, int targetChar) throws IOException {
        int c;
        int count = 0;
        while ((c = in.read()) != -1) {
            ++count;
            if (c != targetChar) continue;
            return count;
        }
        return count;
    }
}

