/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.admin.cluster.wlm.WlmStatsRequest;
import org.opensearch.action.admin.cluster.wlm.WlmStatsResponse;
import org.opensearch.action.pagination.PageToken;
import org.opensearch.action.pagination.WlmPaginationStrategy;
import org.opensearch.common.Table;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.RestTable;
import org.opensearch.transport.client.node.NodeClient;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.stats.SortBy;
import org.opensearch.wlm.stats.SortOrder;
import org.opensearch.wlm.stats.WlmStats;
import org.opensearch.wlm.stats.WorkloadGroupStats;

public class RestWlmStatsAction
extends BaseRestHandler {
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final int MAX_PAGE_SIZE = 100;
    private static final Logger logger = LogManager.getLogger(RestWlmStatsAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "_wlm/stats"), new RestHandler.Route(RestRequest.Method.GET, "_wlm/{nodeId}/stats"), new RestHandler.Route(RestRequest.Method.GET, "_wlm/stats/{workloadGroupId}"), new RestHandler.Route(RestRequest.Method.GET, "_wlm/{nodeId}/stats/{workloadGroupId}"), new RestHandler.Route(RestRequest.Method.GET, "_list/wlm_stats"), new RestHandler.Route(RestRequest.Method.GET, "_list/wlm_stats/{nodeId}/stats"), new RestHandler.Route(RestRequest.Method.GET, "_list/wlm_stats/stats/{workloadGroupId}"), new RestHandler.Route(RestRequest.Method.GET, "_list/wlm_stats/{nodeId}/stats/{workloadGroupId}")));
    }

    @Override
    public String getName() {
        return "wlm_stats_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        Set workloadGroupIds = Strings.tokenizeByCommaToSet((String)request.param("workloadGroupId", "_all"));
        Boolean breach = request.hasParam("breach") ? Boolean.valueOf(Boolean.parseBoolean(request.param("boolean"))) : null;
        WlmStatsRequest wlmStatsRequest = new WlmStatsRequest(nodesIds, workloadGroupIds, breach);
        int pageSize = this.parsePageSize(request);
        String nextToken = request.param("next_token");
        SortBy sortBy = this.parseSortBy(request.param("sort", "node_id"));
        SortOrder sortOrder = this.parseSortOrder(request.param("order", "asc"));
        String path = request.rawPath();
        if (path.startsWith("/_list/wlm_stats")) {
            return this.handleTabularRequest(request, client, wlmStatsRequest, pageSize, nextToken, sortBy, sortOrder);
        }
        return channel -> client.admin().cluster().wlmStats(wlmStatsRequest, new RestActions.NodesResponseRestListener<WlmStatsResponse>((RestChannel)channel));
    }

    private BaseRestHandler.RestChannelConsumer handleTabularRequest(RestRequest request, NodeClient client, WlmStatsRequest wlmStatsRequest, final int pageSize, final String nextToken, final SortBy sortBy, final SortOrder sortOrder) {
        final boolean verbose = request.paramAsBoolean("v", false);
        return channel -> client.admin().cluster().wlmStats(wlmStatsRequest, (ActionListener<WlmStatsResponse>)new RestResponseListener<WlmStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(WlmStatsResponse response) throws Exception {
                try {
                    WlmPaginationStrategy paginationStrategy = new WlmPaginationStrategy(pageSize, nextToken, sortBy, sortOrder, response);
                    List<WlmStats> paginatedStats = paginationStrategy.getRequestedEntities();
                    PageToken nextPageToken = paginationStrategy.getResponseToken();
                    Table paginatedTable = RestWlmStatsAction.this.createTableWithHeaders(nextPageToken, verbose);
                    RestWlmStatsAction.this.buildTable(paginatedTable, paginatedStats, paginationStrategy);
                    return RestTable.buildResponse(paginatedTable, this.channel);
                }
                catch (OpenSearchParseException e) {
                    RestWlmStatsAction.this.handlePaginationError(this.channel, nextToken, pageSize, sortBy, sortOrder, e);
                    return null;
                }
            }
        });
    }

    protected SortBy parseSortBy(String sortByParam) throws OpenSearchParseException {
        try {
            return SortBy.fromString(sortByParam);
        }
        catch (IllegalArgumentException e) {
            throw new OpenSearchParseException("Invalid value for 'sort'. Allowed: 'node_id', 'workload_group'", (Throwable)e, new Object[0]);
        }
    }

    protected SortOrder parseSortOrder(String sortOrderParam) throws OpenSearchParseException {
        try {
            return SortOrder.fromString(sortOrderParam);
        }
        catch (IllegalArgumentException e) {
            throw new OpenSearchParseException("Invalid value for 'order'. Allowed: 'asc', 'desc'", (Throwable)e, new Object[0]);
        }
    }

    protected int parsePageSize(RestRequest request) {
        int pageSize = request.paramAsInt("size", 10);
        if (pageSize <= 0 || pageSize > 100) {
            throw new OpenSearchParseException("Invalid value for 'size'. Allowed range: 1 to 100", new Object[0]);
        }
        return pageSize;
    }

    protected void handlePaginationError(RestChannel channel, String nextToken, int pageSize, SortBy sortBy, SortOrder sortOrder, OpenSearchParseException e) throws IOException {
        String userMessage = "Pagination state has changed (e.g., new workload groups added or removed). Please restart pagination from the beginning by omitting the 'next_token' parameter.";
        logger.error("Failed to paginate WLM stats: next_token={}, pageSize={}, sortBy={}, sortOrder={}", (Object)nextToken, (Object)pageSize, (Object)sortBy, (Object)sortOrder);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("error", userMessage);
        builder.field("details", e.getMessage());
        builder.endObject();
        channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
    }

    protected Table createTableWithHeaders(PageToken pageToken, boolean verbose) {
        Table table = new Table(pageToken);
        table.startHeaders();
        table.addCell("NODE_ID", verbose ? "desc:Node ID" : "");
        table.addCell("|");
        table.addCell("WORKLOAD_GROUP_ID", verbose ? "desc:Workload Group" : "");
        table.addCell("|");
        table.addCell("TOTAL_COMPLETIONS", verbose ? "desc:Total Completed Queries" : "");
        table.addCell("|");
        table.addCell("TOTAL_REJECTIONS", verbose ? "desc:Total Rejected Queries" : "");
        table.addCell("|");
        table.addCell("TOTAL_CANCELLATIONS", verbose ? "desc:Total Canceled Queries" : "");
        table.addCell("|");
        table.addCell("CPU_USAGE", verbose ? "desc:CPU Usage" : "");
        table.addCell("|");
        table.addCell("MEMORY_USAGE", verbose ? "desc:Memory Usage" : "");
        table.endHeaders();
        return table;
    }

    protected void addRow(Table table, String nodeId, String workloadGroupId, WorkloadGroupStats.WorkloadGroupStatsHolder statsHolder) {
        String PLACEHOLDER = "NA";
        table.startRow();
        table.addCell(nodeId);
        table.addCell("|");
        table.addCell(workloadGroupId);
        table.addCell("|");
        table.addCell(statsHolder.getCompletions());
        table.addCell("|");
        table.addCell(statsHolder.getRejections());
        table.addCell("|");
        table.addCell(statsHolder.getCancellations());
        table.addCell("|");
        WorkloadGroupStats.ResourceStats cpuStats = statsHolder.getResourceStats().get((Object)ResourceType.CPU);
        WorkloadGroupStats.ResourceStats memoryStats = statsHolder.getResourceStats().get((Object)ResourceType.MEMORY);
        table.addCell(cpuStats != null ? Double.valueOf(cpuStats.getCurrentUsage()) : "NA");
        table.addCell("|");
        table.addCell(memoryStats != null ? Double.valueOf(memoryStats.getCurrentUsage()) : "NA");
        table.endRow();
    }

    protected void addFooterRow(Table table, int COLUMN_COUNT) {
        table.startRow();
        table.addCell("No more pages available");
        for (int i = 1; i < COLUMN_COUNT; ++i) {
            table.addCell("-");
        }
        table.endRow();
    }

    protected void buildTable(Table table, List<WlmStats> paginatedStats, WlmPaginationStrategy paginationStrategy) {
        int COLUMN_COUNT = 13;
        for (WlmStats wlmStats : paginatedStats) {
            String nodeId = wlmStats.getNode().getId();
            WorkloadGroupStats workloadGroupStats = wlmStats.getWorkloadGroupStats();
            for (Map.Entry<String, WorkloadGroupStats.WorkloadGroupStatsHolder> entry : workloadGroupStats.getStats().entrySet()) {
                String workloadGroupId = entry.getKey();
                WorkloadGroupStats.WorkloadGroupStatsHolder statsHolder = entry.getValue();
                this.addRow(table, nodeId, workloadGroupId, statsHolder);
            }
        }
        if (paginationStrategy.getResponseToken() == null) {
            this.addFooterRow(table, 13);
        }
    }
}

