/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.MultivaluedMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.par.clientpolicy.context.PushedAuthorizationRequestContext;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class RejectImplicitGrantExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private final KeycloakSession session;
    private Configuration configuration;

    public RejectImplicitGrantExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "reject-implicit-grant";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            case PUSHED_AUTHORIZATION_REQUEST: {
                PushedAuthorizationRequestContext pushedAuthorizationRequestContext = (PushedAuthorizationRequestContext)context;
                this.executeOnPushedAuthorizationRequest(pushedAuthorizationRequestContext.getRequest(), pushedAuthorizationRequestContext.getRequestParameters());
                break;
            }
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri());
                return;
            }
            default: {
                return;
            }
        }
    }

    private void autoConfigure(ClientRepresentation rep) {
        if (this.configuration.isAutoConfigure().booleanValue()) {
            rep.setImplicitFlowEnabled(Boolean.FALSE);
        }
    }

    private void validate(ClientRepresentation rep) throws ClientPolicyException {
        boolean isImplicitFlowEnabled = rep.isImplicitFlowEnabled();
        if (!isImplicitFlowEnabled) {
            return;
        }
        throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: implicit flow enabled");
    }

    private void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri) throws ClientPolicyException {
        if (parsedResponseType.isImplicitOrHybridFlow()) {
            throw new ClientPolicyException("invalid_request", "Implicit/Hybrid flow is prohibited.");
        }
    }

    private void executeOnPushedAuthorizationRequest(AuthorizationEndpointRequest request, MultivaluedMap<String, String> requestParameters) throws ClientPolicyException {
        if (request.getResponseType() == null || request.getResponseType().isEmpty()) {
            throw new ClientPolicyException("invalid_request", "No response type.");
        }
        if (!"code".equals(request.getResponseType())) {
            throw new ClientPolicyException("invalid_request", "Implicit/Hybrid flow is prohibited.");
        }
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auto-configure")
        protected Boolean autoConfigure;

        public Boolean isAutoConfigure() {
            return this.autoConfigure;
        }

        public void setAutoConfigure(Boolean autoConfigure) {
            this.autoConfigure = autoConfigure;
        }
    }
}

