/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    private final List<ImageryInfo> layers = new ArrayList<ImageryInfo>();
    private final Map<String, ImageryInfo> layerIds = new HashMap<String, ImageryInfo>();
    static final List<ImageryInfo> defaultLayers = new ArrayList<ImageryInfo>();
    static final List<ImageryInfo> allDefaultLayers = new ArrayList<ImageryInfo>();
    static final Map<String, ImageryInfo> defaultLayerIds = new HashMap<String, ImageryInfo>();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{Config.getUrls().getJOSMWebsite() + "/maps%<?ids=>"};

    public static Collection<String> getImageryLayersSites() {
        return Config.getPref().getList("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES));
    }

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo info) {
        this.layers.addAll(info.layers);
    }

    public void clear() {
        this.layers.clear();
        this.layerIds.clear();
    }

    public void load(boolean fastFail) {
        this.clear();
        List<ImageryInfo.ImageryPreferenceEntry> entries = StructUtils.getListOfStructs(Config.getPref(), "imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (entries != null) {
            for (ImageryInfo.ImageryPreferenceEntry prefEntry : entries) {
                try {
                    ImageryInfo i = new ImageryInfo(prefEntry);
                    this.add(i);
                }
                catch (IllegalArgumentException e) {
                    Logging.warn("Unable to load imagery preference entry:" + String.valueOf(e));
                }
            }
            Collections.sort(this.layers);
        }
        this.loadDefaults(false, null, fastFail);
    }

    public void loadDefaults(boolean clearCache, ExecutorService worker, boolean fastFail) {
        DefaultEntryLoader loader = new DefaultEntryLoader(clearCache, fastFail);
        if (worker == null) {
            loader.realRun();
            loader.finish();
        } else {
            worker.execute(loader);
        }
    }

    private static void buildIdMap(List<ImageryInfo> lst, Map<String, ImageryInfo> idMap) {
        idMap.clear();
        HashSet<String> notUnique = new HashSet<String>();
        for (ImageryInfo imageryInfo : lst) {
            if (imageryInfo.getId() == null) continue;
            if (idMap.containsKey(imageryInfo.getId())) {
                notUnique.add(imageryInfo.getId());
                Logging.error("Id ''{0}'' is not unique - used by ''{1}'' and ''{2}''!", imageryInfo.getId(), imageryInfo.getName(), idMap.get(imageryInfo.getId()).getName());
                continue;
            }
            idMap.put(imageryInfo.getId(), imageryInfo);
            Collection<String> old = imageryInfo.getOldIds();
            if (old == null) continue;
            for (String id : old) {
                if (idMap.containsKey(id)) {
                    Logging.error("Old Id ''{0}'' is not unique - used by ''{1}'' and ''{2}''!", imageryInfo.getId(), imageryInfo.getName(), idMap.get(imageryInfo.getId()).getName());
                    continue;
                }
                idMap.put(id, imageryInfo);
            }
        }
        for (String string : notUnique) {
            idMap.remove(string);
        }
    }

    public void updateEntriesFromDefaults(boolean dropold) {
        boolean changed = false;
        TreeSet<String> knownDefaults = new TreeSet<String>(Config.getPref().getList("imagery.layers.default"));
        TreeSet<String> newKnownDefaults = new TreeSet<String>();
        for (ImageryInfo def : defaultLayers) {
            if (!def.isDefaultEntry()) continue;
            boolean isKnownDefault = false;
            for (String entry : knownDefaults) {
                if (entry.equals(def.getId())) {
                    isKnownDefault = true;
                    newKnownDefaults.add(entry);
                    knownDefaults.remove(entry);
                    break;
                }
                if (!ImageryLayerInfo.isSimilar(entry, def.getUrl())) continue;
                isKnownDefault = true;
                if (def.getId() != null) {
                    newKnownDefaults.add(def.getId());
                }
                knownDefaults.remove(entry);
                break;
            }
            boolean isInUserList = false;
            if (!isKnownDefault) {
                if (def.getId() != null) {
                    newKnownDefaults.add(def.getId());
                    isInUserList = this.layers.stream().anyMatch(i -> ImageryLayerInfo.isSimilar(def, i));
                } else {
                    Logging.error("Default imagery ''{0}'' has no id. Skipping.", def.getName());
                }
            }
            if (isKnownDefault || isInUserList) continue;
            this.add(new ImageryInfo(def));
            changed = true;
        }
        if (!dropold && !knownDefaults.isEmpty()) {
            newKnownDefaults.addAll(knownDefaults);
        }
        Config.getPref().putList("imagery.layers.default", new ArrayList<String>(newKnownDefaults));
        for (int i2 = 0; i2 < this.layers.size(); ++i2) {
            ImageryInfo matchingDefault;
            ImageryInfo info = this.layers.get(i2);
            if (info.getId() == null || (matchingDefault = defaultLayerIds.get(info.getId())) == null || matchingDefault.equalsPref(info)) continue;
            this.layers.set(i2, matchingDefault);
            Logging.info(I18n.tr("Update imagery ''{0}''", info.getName()));
            changed = true;
        }
        if (changed) {
            this.save();
        }
    }

    public void dropOldEntries() {
        ArrayList<String> drop = new ArrayList<String>();
        for (Map.Entry<String, ImageryInfo> info : this.layerIds.entrySet()) {
            if (defaultLayerIds.containsKey(info.getKey())) continue;
            this.remove(info.getValue());
            drop.add(info.getKey());
            Logging.info(I18n.tr("Drop old imagery ''{0}''", info.getValue().getName()));
        }
        if (!drop.isEmpty()) {
            for (String id : drop) {
                this.layerIds.remove(id);
            }
            this.save();
        }
    }

    private static boolean isSimilar(ImageryInfo iiA, ImageryInfo iiB) {
        if (iiA == null || iiA.getImageryType() != iiB.getImageryType()) {
            return false;
        }
        if (iiA.getId() != null && iiB.getId() != null) {
            return iiA.getId().equals(iiB.getId());
        }
        return ImageryLayerInfo.isSimilar(iiA.getUrl(), iiB.getUrl());
    }

    private static boolean isSimilar(String a, String b) {
        return Objects.equals(a, b) || !Utils.isEmpty(a) && !Utils.isEmpty(b) && (a.contains(b) || b.contains(a));
    }

    public void add(ImageryInfo info) {
        this.layers.add(info);
    }

    public void remove(ImageryInfo info) {
        this.layers.remove(info);
    }

    public void save() {
        List entries = this.layers.stream().map(ImageryInfo.ImageryPreferenceEntry::new).collect(Collectors.toList());
        StructUtils.putListOfStructs(Config.getPref(), "imagery.entries", entries, ImageryInfo.ImageryPreferenceEntry.class);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public List<ImageryInfo> getAllDefaultLayers() {
        return Collections.unmodifiableList(allDefaultLayers);
    }

    public static void addLayer(ImageryInfo info) {
        instance.add(info);
        instance.save();
    }

    public static void addLayers(Collection<ImageryInfo> infos) {
        for (ImageryInfo i : infos) {
            instance.add(i);
        }
        instance.save();
        Collections.sort(ImageryLayerInfo.instance.layers);
    }

    public String getUniqueId(ImageryInfo info) {
        if (info.getId() != null && this.layerIds.get(info.getId()) == info) {
            return info.getId();
        }
        return null;
    }

    public ImageryInfo getLayer(String id) {
        return this.layerIds.get(id);
    }

    class DefaultEntryLoader
    extends PleaseWaitRunnable {
        private final boolean clearCache;
        private final boolean fastFail;
        private final List<ImageryInfo> newLayers;
        private ImageryReader reader;
        private boolean canceled;
        private boolean loadError;

        DefaultEntryLoader(boolean clearCache, boolean fastFail) {
            super(I18n.tr("Update default entries", new Object[0]));
            this.newLayers = new ArrayList<ImageryInfo>();
            this.clearCache = clearCache;
            this.fastFail = fastFail;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            Utils.close(this.reader);
        }

        @Override
        protected void realRun() {
            for (String source : ImageryLayerInfo.getImageryLayersSites()) {
                if (this.canceled) {
                    return;
                }
                this.loadSource(source);
            }
        }

        protected void loadSource(String source) {
            boolean online;
            boolean bl = online = !NetworkManager.isOffline(source);
            if (this.clearCache && online) {
                CachedFile.cleanup(source);
            }
            try {
                this.reader = new ImageryReader(source);
                this.reader.setFastFail(this.fastFail);
                List<ImageryInfo> result = this.reader.parse();
                result.stream().filter(Predicate.not(ImageryInfo::isValid)).forEach(info -> Logging.error("Not adding invalid imagery: {0}", info));
                result.removeIf(Predicate.not(ImageryInfo::isValid));
                this.newLayers.addAll(result);
            }
            catch (IOException ex) {
                this.loadError = true;
                Logging.log(Logging.LEVEL_ERROR, ex);
            }
            catch (SAXException ex) {
                this.loadError = true;
                Logging.error(ex);
            }
        }

        @Override
        protected void finish() {
            defaultLayers.clear();
            allDefaultLayers.clear();
            defaultLayers.addAll(this.newLayers);
            for (ImageryInfo layer : this.newLayers) {
                allDefaultLayers.add(layer);
                allDefaultLayers.addAll(layer.getMirrors());
            }
            defaultLayerIds.clear();
            Collections.sort(defaultLayers);
            Collections.sort(allDefaultLayers);
            ImageryLayerInfo.buildIdMap(allDefaultLayers, defaultLayerIds);
            ImageryLayerInfo.this.updateEntriesFromDefaults(!this.loadError);
            ImageryLayerInfo.buildIdMap(ImageryLayerInfo.this.layers, ImageryLayerInfo.this.layerIds);
            if (!this.loadError && !defaultLayerIds.isEmpty()) {
                ImageryLayerInfo.this.dropOldEntries();
            }
        }
    }
}

