/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapTypeFromNamedArgs;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapTypeImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public abstract class GrMapType
extends GrLiteralClassType {
    private final NotNullLazyValue<PsiType[]> myParameters;

    protected GrMapType(JavaPsiFacade facade, GlobalSearchScope scope) {
        this(facade, scope, LanguageLevel.JDK_1_5);
    }

    protected GrMapType(JavaPsiFacade facade, GlobalSearchScope scope, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrMapType.$$$reportNull$$$0(0);
        }
        super(languageLevel, scope, facade);
        this.myParameters = NotNullLazyValue.volatileLazy(() -> {
            PsiType[] keyTypes = this.getAllKeyTypes();
            PsiType[] valueTypes = this.getAllValueTypes();
            if (keyTypes.length == 0 && valueTypes.length == 0) {
                return EMPTY_ARRAY;
            }
            return new PsiType[]{this.getLeastUpperBound(keyTypes), this.getLeastUpperBound(valueTypes)};
        });
    }

    protected GrMapType(@NotNull PsiElement context) {
        if (context == null) {
            GrMapType.$$$reportNull$$$0(1);
        }
        super(LanguageLevel.JDK_1_5, context);
        this.myParameters = NotNullLazyValue.volatileLazy(() -> {
            PsiType[] keyTypes = this.getAllKeyTypes();
            PsiType[] valueTypes = this.getAllValueTypes();
            if (keyTypes.length == 0 && valueTypes.length == 0) {
                return EMPTY_ARRAY;
            }
            return new PsiType[]{this.getLeastUpperBound(keyTypes), this.getLeastUpperBound(valueTypes)};
        });
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "java.util.LinkedHashMap";
    }

    @Nullable
    public abstract PsiType getTypeByStringKey(String var1);

    @NotNull
    public abstract Set<String> getStringKeys();

    public abstract boolean isEmpty();

    protected PsiType @NotNull [] getAllKeyTypes() {
        HashSet<Object> result2 = new HashSet<Object>();
        if (!this.getStringEntries().isEmpty()) {
            result2.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Couple<PsiType> entry : this.getOtherEntries()) {
            result2.add((PsiType)entry.first);
        }
        result2.remove(null);
        PsiType[] psiTypeArray = result2.toArray(GrMapType.createArray((int)result2.size()));
        if (psiTypeArray == null) {
            GrMapType.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    protected PsiType @NotNull [] getAllValueTypes() {
        HashSet<PsiType> result2 = new HashSet<PsiType>(this.getStringEntries().values());
        for (Couple<PsiType> entry : this.getOtherEntries()) {
            result2.add((PsiType)entry.second);
        }
        result2.remove(null);
        PsiType[] psiTypeArray = result2.toArray(GrMapType.createArray((int)result2.size()));
        if (psiTypeArray == null) {
            GrMapType.$$$reportNull$$$0(3);
        }
        return psiTypeArray;
    }

    @NotNull
    protected abstract List<Couple<PsiType>> getOtherEntries();

    @NotNull
    protected abstract LinkedHashMap<String, PsiType> getStringEntries();

    public @Nullable PsiType @NotNull [] getParameters() {
        PsiType[] psiTypeArray = (PsiType[])this.myParameters.getValue();
        if (psiTypeArray == null) {
            GrMapType.$$$reportNull$$$0(4);
        }
        return psiTypeArray;
    }

    @NlsSafe
    @NotNull
    public String getInternalCanonicalText() {
        Set<String> stringKeys = this.getStringKeys();
        List<Couple<PsiType>> otherEntries = this.getOtherEntries();
        if (stringKeys.isEmpty()) {
            if (otherEntries.isEmpty()) {
                return "[:]";
            }
            String name = this.getJavaClassName();
            PsiType[] params = this.getParameters();
            if (params.length == 2) {
                String string = name + "<" + GrMapType.getInternalText(params[0]) + ", " + GrMapType.getInternalText(params[1]) + ">";
                if (string == null) {
                    GrMapType.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = name;
            if (string == null) {
                GrMapType.$$$reportNull$$$0(6);
            }
            return string;
        }
        ArrayList<CallSite> components = new ArrayList<CallSite>();
        for (String string : stringKeys) {
            components.add((CallSite)((Object)("'" + string + "':" + GrMapType.getInternalCanonicalText(this.getTypeByStringKey(string)))));
        }
        for (Couple couple : otherEntries) {
            components.add((CallSite)((Object)(GrMapType.getInternalCanonicalText((PsiType)couple.first) + ":" + GrMapType.getInternalCanonicalText((PsiType)couple.second))));
        }
        boolean tooMany = components.size() > 2;
        List list = ContainerUtil.getFirstItems(components, (int)2);
        String string = "[" + StringUtil.join((Collection)list, (String)", ") + (tooMany ? ",..." : "") + "]";
        if (string == null) {
            GrMapType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String getInternalText(@Nullable PsiType param) {
        String string = param == null ? "null" : param.getInternalCanonicalText();
        if (string == null) {
            GrMapType.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            GrMapType.$$$reportNull$$$0(9);
        }
        return type instanceof GrMapType || super.isAssignableFrom(type);
    }

    public static GrMapType merge(GrMapType l, GrMapType r) {
        GlobalSearchScope scope = l.getResolveScope().intersectWith(r.getResolveScope());
        LinkedHashMap<String, PsiType> strings = new LinkedHashMap<String, PsiType>();
        strings.putAll(l.getStringEntries());
        strings.putAll(r.getStringEntries());
        ArrayList<Couple<PsiType>> other = new ArrayList<Couple<PsiType>>();
        other.addAll(l.getOtherEntries());
        other.addAll(r.getOtherEntries());
        return GrMapType.create(l.myFacade, scope, strings, other);
    }

    public static GrMapType create(JavaPsiFacade facade, GlobalSearchScope scope, @NotNull LinkedHashMap<String, PsiType> stringEntries, @NotNull List<Couple<PsiType>> otherEntries) {
        if (stringEntries == null) {
            GrMapType.$$$reportNull$$$0(10);
        }
        if (otherEntries == null) {
            GrMapType.$$$reportNull$$$0(11);
        }
        return new GrMapTypeImpl(facade, scope, stringEntries, otherEntries, LanguageLevel.JDK_1_5);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrMapType.$$$reportNull$$$0(12);
        }
        return new GrMapTypeImpl(this.myFacade, this.getResolveScope(), this.getStringEntries(), this.getOtherEntries(), languageLevel);
    }

    public static GrMapType createFromNamedArgs(PsiElement context, GrNamedArgument[] args) {
        return new GrMapTypeFromNamedArgs(context, args);
    }

    @NonNls
    public String toString() {
        return "map type";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringEntries";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeyTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValueTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

