/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.ConnectMultipleMediaCmd;
import tim.prune.cmd.MediaLinkType;
import tim.prune.cmd.PointAndMedia;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.RemoveMediaCmd;
import tim.prune.cmd.ShuffleAndCropCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaObject;
import tim.prune.data.Track;
import tim.prune.function.media.PopupResponse;

public abstract class DeleteBitOfTrackFunction
extends GenericFunction {
    protected DeleteBitOfTrackFunction(App app) {
        super(app);
    }

    protected PopupResponse chooseMediaAction(int n) {
        if (n <= 0) {
            return PopupResponse.MEDIA_NOT_CONNECTED;
        }
        String string = I18nManager.getTextWithNumber("dialog.deletepoints.deletemedia", n);
        int n2 = JOptionPane.showConfirmDialog(this._app.getFrame(), string, I18nManager.getText("dialog.deletepoints.title"), 1);
        if (n2 == 2 || n2 == -1) {
            return PopupResponse.CANCEL;
        }
        return n2 == 0 ? PopupResponse.DELETE : PopupResponse.UNLINK;
    }

    protected int fillLists(List<Integer> list, List<Integer> list2, PointToKeepCriterion pointToKeepCriterion) {
        Track track = this._app.getTrackInfo().getTrack();
        int n = 0;
        int n2 = track.getNumPoints();
        int n3 = 0;
        while (n3 < n2) {
            if (pointToKeepCriterion.keepIndex(n3)) {
                list.add(n3);
            } else {
                list2.add(n3);
                if (track.getPoint(n3).hasMedia()) {
                    ++n;
                }
            }
            ++n3;
        }
        return n;
    }

    protected CompoundCommand createCommand(List<Integer> list, List<Integer> list2, List<PointFlag> list3, int n) {
        PopupResponse popupResponse = this.chooseMediaAction(n);
        if (popupResponse == PopupResponse.CANCEL) {
            return null;
        }
        ShuffleAndCropCmd shuffleAndCropCmd = new ShuffleAndCropCmd(list, list2, list3);
        switch (popupResponse) {
            case DELETE: {
                shuffleAndCropCmd.addCommand(this.makeDeleteMediaCommand(list2));
                break;
            }
            case UNLINK: {
                shuffleAndCropCmd.addCommand(this.makeUnlinkMediaCommand(list2));
                break;
            }
        }
        return shuffleAndCropCmd;
    }

    private Command makeUnlinkMediaCommand(List<Integer> list) {
        ArrayList<PointAndMedia> arrayList = new ArrayList<PointAndMedia>();
        for (int n : list) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n);
            if (!dataPoint.hasMedia()) continue;
            arrayList.add(new PointAndMedia(dataPoint, null, null));
        }
        return new ConnectMultipleMediaCmd(MediaLinkType.LINK_BOTH, arrayList);
    }

    private Command makeDeleteMediaCommand(List<Integer> list) {
        ArrayList<MediaObject> arrayList = new ArrayList<MediaObject>();
        for (int n : list) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n);
            if (dataPoint.getPhoto() != null) {
                arrayList.add(dataPoint.getPhoto());
            }
            if (dataPoint.getAudio() == null) continue;
            arrayList.add(dataPoint.getAudio());
        }
        return new RemoveMediaCmd(arrayList);
    }

    static interface PointToKeepCriterion {
        public boolean keepIndex(int var1);
    }
}

