#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-CVFxntJqdGHIyPAKUsTvZc
key:                  glirc-2.40.1-CVFxntJqdGHIyPAKUsTvZc
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  d30cd8e41e3afc1f1d345d91a236ed09
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-CVFxntJqdGHIyPAKUsTvZc
include-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-DVVzYu8NEij8DW0blP29
    async-2.2.5-A7cw4gHfrNnBMjsgvHD8kq
    attoparsec-0.14.4-K96akOPZKYDKXaMIGNQXgm base-4.18.2.1
    base64-bytestring-1.2.1.0-B0w0hfBZVmq3UW6lmjr7G bytestring-0.11.5.3
    config-schema-1.3.0.0-LborCMFkDFXBWtS3Q3vOWw
    config-value-0.8.3-IWIlPmbx9u07ZPnTUBDeDU containers-0.6.7
    curve25519-0.2.8.1-1vA8IkNSpAWKdPvUECLe7r directory-1.3.8.5
    filepath-1.4.300.1 free-5.2-EBunlMu5kTDAA7fY5q6wdt
    githash-0.1.6.3-1Ht0cPVU7ZGKXTqeGDFgaK
    hashable-1.4.7.0-L2Cc1YdcpYH9U2sZW5osde
    hookup-0.8-BrR1HNCpg6A3rNkwd0wgEy
    irc-core-2.12-18eSxMESa1w6QGMRBceiMS
    kan-extensions-5.2.7-362Pwp0mpTIB9yqyGUMynZ
    lens-5.3.3-6yFfjYmjPBKuNNVCwyEN9
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    psqueues-0.2.8.2-5uYAbSvTTX4LgkiMPVXkjM
    random-1.2.1.3-AnjXBTm5XaC2u12cWBrzsX
    regex-tdfa-1.3.2.5-qZoXOptISAJcpXFSPLOTl
    semigroupoids-6.0.1-1pXSejaOiy34O3TvRgPPUk
    split-0.2.5-LIo01L9HFTI75RwsLzYVkn stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2 time-1.12.2
    transformers-0.6.1.0 typed-process-0.2.13.0-EPUkCrQoI0W1g2Dd9OPs5
    unix-2.8.4.0 unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI
    vty-6.2-INuzoHGEuLa5SMM40Z8Lln

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

