// SPDX-FileCopyrightText: 2017 - 2024 The Ginkgo authors
//
// SPDX-License-Identifier: BSD-3-Clause

#ifndef GKO_INCLUDE_CONFIG_H
#define GKO_INCLUDE_CONFIG_H

// clang-format off
#define GKO_VERSION_MAJOR 1
#define GKO_VERSION_MINOR 10
#define GKO_VERSION_PATCH 0
#define GKO_VERSION_TAG "main"
#define GKO_VERSION_STR 1, 10, 0
// clang-format on


// clang-format off
#define GINKGO_VERSION_TAG_DEPRECATED 0
#if GINKGO_VERSION_TAG_DEPRECATED
#pragma message ("The branch " GKO_VERSION_TAG " is deprecated and will stop receiving updates after 2025. " \
 "Please use the main branch for the latest release, or the develop branch for the latest development updates.")
#endif
// clang-format on


/*
 * Controls the amount of messages output by Ginkgo.
 * 0 disables all output (except for test, benchmarks and examples).
 * 1 activates important messages.
 */
// clang-format off
#define GKO_VERBOSE_LEVEL 1
// clang-format on


/* Is Itanium ABI available? */
#define GKO_HAVE_CXXABI_H


/* Is std::size_t the same type as std::uint64_t? */
#define GKO_SIZE_T_IS_UINT64_T


/* Should we use all optimizations for Jacobi? */
/* #undef GINKGO_JACOBI_FULL_OPTIMIZATIONS */


/* Should we compile Ginkgo specifically to tune values? */
/* #undef GINKGO_BENCHMARK_ENABLE_TUNING */


/* Should we compile mixed-precision kernels for Ginkgo? */
/* #undef GINKGO_MIXED_PRECISION */


/* What is HIP compiled for, hcc or nvcc? */
// clang-format off
#define GINKGO_HIP_PLATFORM_HCC 1


#define GINKGO_HIP_PLATFORM_NVCC 0
// clang-format on


/* What is the major version of dpcpp compiler */
// clang-format off
#define GINKGO_DPCPP_MAJOR_VERSION 0
#define GINKGO_DPCPP_MINOR_VERSION 0
// clang-format on


/* Is PAPI SDE available for Logging? */
// clang-format off
#define GKO_HAVE_PAPI_SDE 0
// clang-format on


/* Is TAU available for Profiling? */
// clang-format off
#define GKO_HAVE_TAU 0
// clang-format on


/* Is VTune ITT available for Profiling? */
// clang-format off
#define GKO_HAVE_VTUNE 0
// clang-format on


/* Is METIS available for Reordering? */
// clang-format off
#define GKO_HAVE_METIS 0
// clang-format on

#if GKO_HAVE_METIS
// clang-format off
#define GKO_METIS_HEADER <>
// clang-format on
#endif

/* Is ROCTX available for Profiling? */
// clang-format off
#define GKO_HAVE_ROCTX 1
// clang-format on


/* Is MPI available ? */
// clang-format off
#define GINKGO_BUILD_MPI 1
// clang-format on

/* Is the MPI implementation GPU aware? */
// clang-format off
#define GINKGO_HAVE_GPU_AWARE_MPI 0
// clang-format on


/* Is HWLOC available ? */
// clang-format off
#define GKO_HAVE_HWLOC 0
// clang-format on

/* Is half operation available ? */
// clang-format off
#define GINKGO_ENABLE_HALF 1
// clang-format on

/* Is bfloat16 operation available ? */
// clang-format off
#define GINKGO_ENABLE_BFLOAT16 1
// clang-format on


/* Do we need to use blocking communication in our SpMV? */
// clang-format off
#define GINKGO_HAVE_OPENMPI_PRE_4_1_X 0
// clang-format on


#endif  // GKO_INCLUDE_CONFIG_H
