/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.formatters;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.model.data.DBDDataFormatterSample;

public class NumberFormatSample
implements DBDDataFormatterSample {
    public static final String PROP_USE_GROUPING = "useGrouping";
    public static final String PROP_GROUPING_SIZE = "groupingSize";
    public static final String PROP_MAX_INT_DIGITS = "maxIntegerDigits";
    public static final String PROP_MIN_INT_DIGITS = "minIntegerDigits";
    public static final String PROP_MAX_FRACT_DIGITS = "maxFractionDigits";
    public static final String PROP_MIN_FRACT_DIGITS = "minFractionDigits";
    public static final String PROP_USE_TYPE_SCALE = "useTypeScale";
    public static final String PROP_ROUNDING_MODE = "roundingMode";
    public static final String PROP_NATIVE_SPECIAL_VALUES = "nativeSpecialValues";

    @Override
    public Map<String, Object> getDefaultProperties(Locale locale) {
        DecimalFormat tmp = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_USE_GROUPING, tmp.isGroupingUsed());
        props.put(PROP_GROUPING_SIZE, tmp.getGroupingSize());
        props.put(PROP_MAX_INT_DIGITS, tmp.getMaximumIntegerDigits());
        props.put(PROP_MIN_INT_DIGITS, tmp.getMinimumIntegerDigits());
        props.put(PROP_MAX_FRACT_DIGITS, Math.max(tmp.getMaximumFractionDigits(), 10));
        props.put(PROP_MIN_FRACT_DIGITS, tmp.getMinimumFractionDigits());
        props.put(PROP_USE_TYPE_SCALE, false);
        props.put(PROP_NATIVE_SPECIAL_VALUES, false);
        return props;
    }

    @Override
    public Object getSampleValue() {
        return 1.234567890012345E9;
    }
}

