﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediaconnect/MediaConnect_EXPORTS.h>
#include <aws/mediaconnect/model/BridgeOutput.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MediaConnect {
namespace Model {
class UpdateBridgeOutputResult {
 public:
  AWS_MEDIACONNECT_API UpdateBridgeOutputResult() = default;
  AWS_MEDIACONNECT_API UpdateBridgeOutputResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDIACONNECT_API UpdateBridgeOutputResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The ARN of the bridge that was updated. </p>
   */
  inline const Aws::String& GetBridgeArn() const { return m_bridgeArn; }
  template <typename BridgeArnT = Aws::String>
  void SetBridgeArn(BridgeArnT&& value) {
    m_bridgeArnHasBeenSet = true;
    m_bridgeArn = std::forward<BridgeArnT>(value);
  }
  template <typename BridgeArnT = Aws::String>
  UpdateBridgeOutputResult& WithBridgeArn(BridgeArnT&& value) {
    SetBridgeArn(std::forward<BridgeArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The bridge output that was updated. </p>
   */
  inline const BridgeOutput& GetOutput() const { return m_output; }
  template <typename OutputT = BridgeOutput>
  void SetOutput(OutputT&& value) {
    m_outputHasBeenSet = true;
    m_output = std::forward<OutputT>(value);
  }
  template <typename OutputT = BridgeOutput>
  UpdateBridgeOutputResult& WithOutput(OutputT&& value) {
    SetOutput(std::forward<OutputT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateBridgeOutputResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_bridgeArn;
  bool m_bridgeArnHasBeenSet = false;

  BridgeOutput m_output;
  bool m_outputHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaConnect
}  // namespace Aws
