/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 *
 * (c) ZeroTier, Inc.
 * https://www.zerotier.com/
 */

#ifndef ZT_ETHERNETTAP_HPP
#define ZT_ETHERNETTAP_HPP

#include "../node/Constants.hpp"
#include "../node/InetAddress.hpp"
#include "../node/MAC.hpp"
#include "../node/MulticastGroup.hpp"

#include <memory>
#include <string>
#include <vector>

#define GETIFADDRS_CACHE_TIME 1000

namespace ZeroTier {

class EthernetTap {
  public:
	static std::shared_ptr<EthernetTap> newInstance(
		const char* tapDeviceType,	 // OS-specific, NULL for default
		unsigned int concurrency,
		bool pinning,
		const char* homePath,
		const MAC& mac,
		unsigned int mtu,
		unsigned int metric,
		uint64_t nwid,
		const char* friendlyName,
		void (*handler)(void*, void*, uint64_t, const MAC&, const MAC&, unsigned int, unsigned int, const void*, unsigned int),
		void* arg);

	EthernetTap();
	virtual ~EthernetTap();

	virtual void setEnabled(bool en) = 0;
	virtual bool enabled() const = 0;
	virtual bool addIp(const InetAddress& ip) = 0;
	virtual bool addIps(std::vector<InetAddress> ips);	 // uses addIp() unless overridden
	virtual bool removeIp(const InetAddress& ip) = 0;
	virtual std::vector<InetAddress> ips() const = 0;
	virtual void put(const MAC& from, const MAC& to, unsigned int etherType, const void* data, unsigned int len) = 0;
	virtual std::string deviceName() const = 0;
	virtual void setFriendlyName(const char* friendlyName) = 0;
	virtual std::string friendlyName() const;
	virtual void scanMulticastGroups(std::vector<MulticastGroup>& added, std::vector<MulticastGroup>& removed) = 0;
	virtual void setMtu(unsigned int mtu) = 0;
	virtual void setDns(const char* domain, const std::vector<InetAddress>& servers) = 0;
};

}	// namespace ZeroTier

#endif
