/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequestDestination.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchRequestDestination enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 22> values {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("audio"),
        MAKE_STATIC_STRING_IMPL("audioworklet"),
        MAKE_STATIC_STRING_IMPL("document"),
        MAKE_STATIC_STRING_IMPL("embed"),
        MAKE_STATIC_STRING_IMPL("environmentmap"),
        MAKE_STATIC_STRING_IMPL("font"),
        MAKE_STATIC_STRING_IMPL("image"),
        MAKE_STATIC_STRING_IMPL("iframe"),
        MAKE_STATIC_STRING_IMPL("manifest"),
        MAKE_STATIC_STRING_IMPL("model"),
        MAKE_STATIC_STRING_IMPL("object"),
        MAKE_STATIC_STRING_IMPL("paintworklet"),
        MAKE_STATIC_STRING_IMPL("report"),
        MAKE_STATIC_STRING_IMPL("script"),
        MAKE_STATIC_STRING_IMPL("serviceworker"),
        MAKE_STATIC_STRING_IMPL("sharedworker"),
        MAKE_STATIC_STRING_IMPL("style"),
        MAKE_STATIC_STRING_IMPL("track"),
        MAKE_STATIC_STRING_IMPL("video"),
        MAKE_STATIC_STRING_IMPL("worker"),
        MAKE_STATIC_STRING_IMPL("xslt"),
    };
    static_assert(static_cast<size_t>(FetchRequestDestination::EmptyString) == 0, "FetchRequestDestination::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Audio) == 1, "FetchRequestDestination::Audio is not 1 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Audioworklet) == 2, "FetchRequestDestination::Audioworklet is not 2 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Document) == 3, "FetchRequestDestination::Document is not 3 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Embed) == 4, "FetchRequestDestination::Embed is not 4 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Environmentmap) == 5, "FetchRequestDestination::Environmentmap is not 5 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Font) == 6, "FetchRequestDestination::Font is not 6 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Image) == 7, "FetchRequestDestination::Image is not 7 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Iframe) == 8, "FetchRequestDestination::Iframe is not 8 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Manifest) == 9, "FetchRequestDestination::Manifest is not 9 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Model) == 10, "FetchRequestDestination::Model is not 10 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Object) == 11, "FetchRequestDestination::Object is not 11 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Paintworklet) == 12, "FetchRequestDestination::Paintworklet is not 12 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Report) == 13, "FetchRequestDestination::Report is not 13 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Script) == 14, "FetchRequestDestination::Script is not 14 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Serviceworker) == 15, "FetchRequestDestination::Serviceworker is not 15 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Sharedworker) == 16, "FetchRequestDestination::Sharedworker is not 16 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Style) == 17, "FetchRequestDestination::Style is not 17 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Track) == 18, "FetchRequestDestination::Track is not 18 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Video) == 19, "FetchRequestDestination::Video is not 19 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Worker) == 20, "FetchRequestDestination::Worker is not 20 as expected");
    static_assert(static_cast<size_t>(FetchRequestDestination::Xslt) == 21, "FetchRequestDestination::Xslt is not 21 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FetchRequestDestination enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FetchRequestDestination> parseEnumerationFromString<FetchRequestDestination>(const String& stringValue)
{
    if (stringValue.isEmpty())
        return FetchRequestDestination::EmptyString;
    static constexpr std::array<std::pair<ComparableASCIILiteral, FetchRequestDestination>, 21> mappings {
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "audio"_s, FetchRequestDestination::Audio },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "audioworklet"_s, FetchRequestDestination::Audioworklet },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "document"_s, FetchRequestDestination::Document },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "embed"_s, FetchRequestDestination::Embed },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "environmentmap"_s, FetchRequestDestination::Environmentmap },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "font"_s, FetchRequestDestination::Font },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "iframe"_s, FetchRequestDestination::Iframe },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "image"_s, FetchRequestDestination::Image },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "manifest"_s, FetchRequestDestination::Manifest },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "model"_s, FetchRequestDestination::Model },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "object"_s, FetchRequestDestination::Object },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "paintworklet"_s, FetchRequestDestination::Paintworklet },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "report"_s, FetchRequestDestination::Report },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "script"_s, FetchRequestDestination::Script },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "serviceworker"_s, FetchRequestDestination::Serviceworker },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "sharedworker"_s, FetchRequestDestination::Sharedworker },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "style"_s, FetchRequestDestination::Style },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "track"_s, FetchRequestDestination::Track },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "video"_s, FetchRequestDestination::Video },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "worker"_s, FetchRequestDestination::Worker },
        std::pair<ComparableASCIILiteral, FetchRequestDestination> { "xslt"_s, FetchRequestDestination::Xslt },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FetchRequestDestination> parseEnumeration<FetchRequestDestination>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FetchRequestDestination>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FetchRequestDestination>()
{
    return "\"\", \"audio\", \"audioworklet\", \"document\", \"embed\", \"environmentmap\", \"font\", \"image\", \"iframe\", \"manifest\", \"model\", \"object\", \"paintworklet\", \"report\", \"script\", \"serviceworker\", \"sharedworker\", \"style\", \"track\", \"video\", \"worker\", \"xslt\""_s;
}

} // namespace WebCore

