/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMRectInit.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<DOMRectInit>> convertDictionary<DOMRectInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    DOMRectInit result;
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto heightConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, heightValue, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (heightConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.height = heightConversionResult.releaseReturnValue();
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto widthConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, widthValue, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (widthConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.width = widthConversionResult.releaseReturnValue();
    JSValue xValue;
    if (isNullOrUndefined)
        xValue = jsUndefined();
    else {
        xValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "x"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto xConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, xValue, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.x = xConversionResult.releaseReturnValue();
    JSValue yValue;
    if (isNullOrUndefined)
        yValue = jsUndefined();
    else {
        yValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "y"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto yConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, yValue, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.y = yConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

