// java wrapper for vtkHDRReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHDRReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReader_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHDRReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHDRReader",dType)) { return me; }
  if ((res= vtkImageReader_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDRReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDRReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDRReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHDRReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDRReader_GetFormat_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFormat();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHDRReader_GetGamma_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGamma();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHDRReader_GetExposure_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExposure();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHDRReader_GetPixelAspect_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelAspect();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHDRReader_CanReadFile_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHDRReader_GetFileExtensions_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHDRReader_GetDescriptiveName_110(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkHDRReader* op = static_cast<vtkHDRReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHDRReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHDRReader::New());
}
