// java wrapper for vtkArrayDataWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkArrayDataWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkArrayDataWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkArrayDataWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayDataWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayDataWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayDataWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayDataWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataWriter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayDataWriter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataWriter_SetBinary_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBinary(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayDataWriter_GetBinary_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBinary();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataWriter_BinaryOn_18(JNIEnv* env, jobject obj)
{

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->BinaryOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataWriter_BinaryOff_19(JNIEnv* env, jobject obj)
{

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->BinaryOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayDataWriter_GetOutputString_110(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputString();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataWriter_SetWriteToOutputString_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteToOutputString(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayDataWriter_GetWriteToOutputString_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteToOutputString();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataWriter_WriteToOutputStringOn_113(JNIEnv* env, jobject obj)
{

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayDataWriter_WriteToOutputStringOff_114(JNIEnv* env, jobject obj)
{

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayDataWriter_Write_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Write();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayDataWriter_Write_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  vtkStdString temp0;
  bool   temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Write(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayDataWriter_Write_117(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jboolean id2)
{
  vtkArrayData * temp0;
  vtkStdString temp1;
  bool   temp2;
  bool   temp20;
  temp0 = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = (id2 != 0) ? true : false;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Write(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayDataWriter_Write_118(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  vtkStdString   temp20;
  temp0 = (id0 != 0) ? true : false;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Write(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayDataWriter_Write_119(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkArrayData * temp0;
  bool   temp1;
  vtkStdString   temp20;
  temp0 = static_cast<vtkArrayData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkArrayDataWriter* op = static_cast<vtkArrayDataWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Write(temp0,temp1);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkArrayDataWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkArrayDataWriter::New());
}
