// java wrapper for vtkADIOS2CoreImageReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkADIOS2CoreImageReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObjectAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkADIOS2CoreImageReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkADIOS2CoreImageReader",dType)) { return me; }
  if ((res= vtkDataObjectAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkADIOS2CoreImageReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkADIOS2CoreImageReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkADIOS2CoreImageReader_CanReadFile_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetFileName_16(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetOrigin_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetOrigin_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetOrigin_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetSpacing_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetSpacing_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetSpacing_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetAllDimensionArrays_113(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllDimensionArrays();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetDimensionArray_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensionArray(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetDimensionArray_115(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionArray();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetDimensionArrayAsCell_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensionArrayAsCell(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetDimensionArrayAsCell_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionArrayAsCell();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_DimensionArrayAsCellOn_118(JNIEnv* env, jobject obj)
{

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DimensionArrayAsCellOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_DimensionArrayAsCellOff_119(JNIEnv* env, jobject obj)
{

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DimensionArrayAsCellOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetAllTimeStepArrays_120(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllTimeStepArrays();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetTimeStepArray_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepArray(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetTimeStepArray_122(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepArray();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetNumberOfArrays_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetArrayName_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetArrayStatus_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetArrayStatus_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetMTime_127(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetIsColumnMajor_128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIsColumnMajor(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkADIOS2CoreImageReader_GetIsColumnMajor_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIsColumnMajor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_IsColumnMajorOn_130(JNIEnv* env, jobject obj)
{

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IsColumnMajorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_IsColumnMajorOff_131(JNIEnv* env, jobject obj)
{

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IsColumnMajorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkADIOS2CoreImageReader_SetController_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkADIOS2CoreImageReader* op = static_cast<vtkADIOS2CoreImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkADIOS2CoreImageReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkADIOS2CoreImageReader::New());
}
