// java wrapper for vtkTextSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTextSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTextSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTextSource",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_SetText_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetText(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextSource_GetText_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_SetBacking_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBacking(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextSource_GetBacking_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBacking();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_BackingOn_18(JNIEnv* env, jobject obj)
{

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_BackingOff_19(JNIEnv* env, jobject obj)
{

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_SetForegroundColor_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_SetForegroundColor_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTextSource_GetForegroundColor_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForegroundColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_SetBackgroundColor_113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_SetBackgroundColor_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTextSource_GetBackgroundColor_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextSource_SetOutputPointsPrecision_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextSource_GetOutputPointsPrecision_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextSource* op = static_cast<vtkTextSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTextSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTextSource::New());
}
