// java wrapper for vtkLinearTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLinearTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHomogeneousTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLinearTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLinearTransform",dType)) { return me; }
  if ((res= vtkHomogeneousTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLinearTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLinearTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLinearTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLinearTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_TransformNormal_14(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformNormal(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_TransformNormal_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformNormal(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformNormal_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformNormal(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformNormal_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformNormal(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkLinearTransform_TransformFloatNormal_18(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatNormal(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkLinearTransform_TransformFloatNormal_19(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  float * temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatNormal(temp0);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformDoubleNormal_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoubleNormal(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformDoubleNormal_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoubleNormal(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformVector_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformVector(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformVector_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformVector(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_TransformVector_114(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformVector(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_TransformVector_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformVector(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkLinearTransform_TransformFloatVector_116(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatVector(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkLinearTransform_TransformFloatVector_117(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  float * temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformFloatVector(temp0);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformDoubleVector_118(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoubleVector(temp0,temp1,temp2);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLinearTransform_TransformDoubleVector_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TransformDoubleVector(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_TransformPoints_120(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPoints * temp0;
  vtkPoints * temp1;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_TransformNormals_121(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformNormals(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_TransformVectors_122(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformVectors(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLinearTransform_GetLinearInverse_123(JNIEnv* env, jobject obj)
{
  vtkLinearTransform * temp20;

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinearInverse();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_InternalTransformPoint_124(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_InternalTransformPoint_125(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_InternalTransformNormal_126(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformNormal(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_InternalTransformNormal_127(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformNormal(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_InternalTransformVector_128(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformVector(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLinearTransform_InternalTransformVector_129(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLinearTransform* op = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformVector(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}
