// java wrapper for vtkPentagonalPrism object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPentagonalPrism.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPentagonalPrism_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPentagonalPrism",dType)) { return me; }
  if ((res= vtkCell3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPentagonalPrism_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPentagonalPrism_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPentagonalPrism_GetCentroid_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCentroid(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPentagonalPrism_IsInsideOut_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsideOut();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_GetCellType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_GetCellDimension_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_GetNumberOfEdges_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_GetNumberOfFaces_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPentagonalPrism_GetEdge_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPentagonalPrism_GetFace_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_CellBoundary_112(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_TriangulateLocalIds_113(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPentagonalPrism_GetParametricCenter_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPentagonalPrism_InterpolationFunctions_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[10];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 10, &temp1[0]);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 10, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPentagonalPrism_InterpolationDerivs_116(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[30];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 30, &temp1[0]);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 30, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPentagonalPrism_InterpolateFunctions_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[10];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 10, &temp1[0]);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 10, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPentagonalPrism_InterpolateDerivs_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[30];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 30, &temp1[0]);

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 30, &temp1[0]);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkPentagonalPrism_GetEdgeToAdjacentFacesArray_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 2);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkPentagonalPrism_GetFaceToAdjacentFacesArray_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 5);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkPentagonalPrism_GetPointToIncidentEdgesArray_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentEdgesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkPentagonalPrism_GetPointToIncidentFacesArray_122(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkPentagonalPrism_GetPointToOneRingPointsArray_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkPentagonalPrism* op = static_cast<vtkPentagonalPrism*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToOneRingPointsArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPentagonalPrism_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPentagonalPrism::New());
}
